/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.settings;

import com.intellij.cidr.cpp.lexer.CidrLexerUtils;
import com.intellij.cidr.cpp.lexer.OCLexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.CidrLog;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Cpp20Module;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.CppModulesState;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CppModulesStateUtil {
    private static final List<String> ALL_STD_CORE_HEADERS = List.of("cstddef", "limits", "cfloat", "cstdint", "new", "typeinfo", "exception", "initializer_list", "csignal", "cstdlib", "stdexcept", "system_error", "utility", "tuple", "optional", "variant", "any", "bitset", "type_traits", "ratio", "chrono", "ctime", "atomic", "typeindex", "array", "list", "forward_list", "vector", "deque", "queue", "stack", "map", "set", "unordered_map", "unordered_set", "iterator", "algorithm", "execution", "functional", "string_view", "string", "cctype", "cwctype", "cwchar", "cstdlib", "cuchar", "locale", "codecvt", "clocale", "iosfwd", "iostream", "ios", "streambuf", "istream", "ostream", "iomanip", "sstream", "fstream", "cstdio", "complex", "numeric", "valarray", "random", "cmath");
    @NotNull
    private static final TokenSet myStopTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.andNot((TokenSet)OCLexerTokenTypes.CPP_KEYWORDS, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{OCLexerTokenTypes.EXPORT_MODULE_KEYWORD, OCLexerTokenTypes.IMPORT_MODULE_KEYWORD, OCLexerTokenTypes.MODULE_KEYWORD})), TokenSet.create((IElementType[])new IElementType[]{OCLexerTokenTypes.LBRACE, OCLexerTokenTypes.RBRACE, OCLexerTokenTypes.RETURN_KEYWORD})});

    public static boolean areCpp20ModulesEnabled() {
        return Registry.is((String)"clion.clang.clangd.enable.cpp20.modules");
    }

    public static boolean isCpp20ModuleFile(@NotNull String fileName) {
        if (fileName == null) {
            CppModulesStateUtil.$$$reportNull$$$0(0);
        }
        return fileName.endsWith(".ixx") || fileName.endsWith(".cppm") || fileName.endsWith(".mxx");
    }

    public static boolean maybeCpp20ModuleFile(@NotNull String filePath) {
        if (filePath == null) {
            CppModulesStateUtil.$$$reportNull$$$0(1);
        }
        return CppModulesStateUtil.isCpp20ModuleFile(filePath) || filePath.endsWith(".cpp") || filePath.endsWith(".cc") || filePath.endsWith(".cxx");
    }

    @Nullable
    public static String getModuleName(@NotNull DocumentEvent event, @NotNull Ref<Boolean> isImpl) {
        if (event == null) {
            CppModulesStateUtil.$$$reportNull$$$0(2);
        }
        if (isImpl == null) {
            CppModulesStateUtil.$$$reportNull$$$0(3);
        }
        CharSequence text = event.getDocument().getImmutableCharSequence();
        return CppModulesStateUtil.getModuleName(text, isImpl);
    }

    @Nullable
    public static String getModuleName(@NotNull VirtualFile moduleVFile, @NotNull Ref<Boolean> isImpl) {
        CharSequence text;
        if (moduleVFile == null) {
            CppModulesStateUtil.$$$reportNull$$$0(4);
        }
        if (isImpl == null) {
            CppModulesStateUtil.$$$reportNull$$$0(5);
        }
        if ((text = (CharSequence)ReadAction.compute(() -> {
            Document document = FileDocumentManager.getInstance().getDocument(moduleVFile);
            if (document == null) {
                return null;
            }
            return document.getImmutableCharSequence();
        })) == null) {
            return null;
        }
        return CppModulesStateUtil.getModuleName(text, isImpl);
    }

    @Nullable
    public static String getModuleName(@NotNull CharSequence text, @NotNull Ref<Boolean> isImpl) {
        if (text == null) {
            CppModulesStateUtil.$$$reportNull$$$0(6);
        }
        if (isImpl == null) {
            CppModulesStateUtil.$$$reportNull$$$0(7);
        }
        OCLexer lexer = new OCLexer(OCLexerSettings.forLanguage((OCLanguageKind)CLanguageKind.CPP).allowAvailabilityExpression().allowGccAutoType().allowMsvcExtensions().allowNullabilityKeywords().setLanguageStandard(OCLanguageStandard.latestCpp()).build());
        lexer.start(text);
        IElementType tt = lexer.getTokenType();
        boolean hadExport = false;
        while (tt != null) {
            if (tt == OCLexerTokenTypes.EXPORT_MODULE_KEYWORD) {
                hadExport = true;
                tt = CidrLexerUtils.goToNextSignificantToken((OCLexer)lexer);
                continue;
            }
            if (CppModulesStateUtil.isAtModuleKeyword(lexer)) {
                String moduleName = CppModulesStateUtil.parseModuleName(lexer);
                tt = lexer.getTokenType();
                if (moduleName == null || tt != OCLexerTokenTypes.SEMICOLON) continue;
                isImpl.set((Object)(!hadExport ? 1 : 0));
                return moduleName;
            }
            if (myStopTokens.contains(tt)) {
                return null;
            }
            hadExport = false;
            tt = CidrLexerUtils.goToNextSignificantToken((OCLexer)lexer);
        }
        return null;
    }

    private static boolean isAtModuleKeyword(@NotNull OCLexer lexer) {
        IElementType tt;
        if (lexer == null) {
            CppModulesStateUtil.$$$reportNull$$$0(8);
        }
        return (tt = lexer.getTokenType()) == OCLexerTokenTypes.MODULE_KEYWORD || tt == OCLexerTokenTypes.IDENTIFIER && OCLexerTokenTypes.MODULE_KEYWORD.getName().equals(lexer.getTokenText());
    }

    @Nullable
    private static String parseModuleName(@NotNull OCLexer lexer) {
        if (lexer == null) {
            CppModulesStateUtil.$$$reportNull$$$0(9);
        }
        assert (CppModulesStateUtil.isAtModuleKeyword(lexer));
        CidrLexerUtils.goToNextSignificantToken((OCLexer)lexer);
        StringBuilder sb = new StringBuilder();
        if (!CppModulesStateUtil.parseNamePart(lexer, sb)) {
            return null;
        }
        if (!CppModulesStateUtil.parseColonPart(lexer, sb)) {
            return null;
        }
        if (!CidrLexerUtils.isAtSignificantToken((OCLexer)lexer)) {
            CidrLexerUtils.goToNextSignificantToken((OCLexer)lexer);
        }
        return sb.toString();
    }

    private static boolean parseColonPart(@NotNull OCLexer lexer, @NotNull StringBuilder sb) {
        IElementType tt;
        if (lexer == null) {
            CppModulesStateUtil.$$$reportNull$$$0(10);
        }
        if (sb == null) {
            CppModulesStateUtil.$$$reportNull$$$0(11);
        }
        if ((tt = lexer.getTokenType()) == OCLexerTokenTypes.COLON) {
            sb.append(lexer.getTokenText());
            lexer.advance();
            if (!CppModulesStateUtil.parseNamePart(lexer, sb)) {
                return false;
            }
        }
        return true;
    }

    private static boolean parseNamePart(@NotNull OCLexer lexer, @NotNull StringBuilder sb) {
        if (lexer == null) {
            CppModulesStateUtil.$$$reportNull$$$0(12);
        }
        if (sb == null) {
            CppModulesStateUtil.$$$reportNull$$$0(13);
        }
        if (lexer.getTokenType() != OCLexerTokenTypes.IDENTIFIER) {
            return false;
        }
        IElementType tt = lexer.getTokenType();
        while (tt == OCLexerTokenTypes.IDENTIFIER || tt == OCLexerTokenTypes.DOT) {
            sb.append(lexer.getTokenText());
            lexer.advance();
            tt = lexer.getTokenType();
        }
        return true;
    }

    public static void updateModuleMap(@NotNull CppModulesState state, @NotNull Project project) {
        if (state == null) {
            CppModulesStateUtil.$$$reportNull$$$0(14);
        }
        if (project == null) {
            CppModulesStateUtil.$$$reportNull$$$0(15);
        }
        if (project.isDisposed()) {
            return;
        }
        @Nullable ClangLanguageServiceProvider provider2 = ClangLanguageServiceProvider.getProvider(project);
        if (provider2 == null) {
            return;
        }
        @Nullable ClangLanguageService service = provider2.getIfStarted();
        if (service == null) {
            return;
        }
        @NotNull ClangUrlConverter converter = service.getUrlConverter();
        ArrayList<String> moduleNames = new ArrayList<String>();
        ArrayList<ClionCompileCommandParams> moduleCCParams = new ArrayList<ClionCompileCommandParams>();
        ArrayList<String> modulePPDefines = new ArrayList<String>();
        List modules = state.byPath(modmap -> new ArrayList(modmap.values()));
        modules.sort(Comparator.comparing(Cpp20Module::getName));
        for (Cpp20Module cppModule : modules) {
            @Nullable ClionCompileCommandParams ccParams = cppModule.getCompileCommand();
            if (ccParams == null) continue;
            moduleNames.add(cppModule.getName());
            moduleCCParams.add(ccParams);
            modulePPDefines.add(cppModule.getPPDefines());
        }
        service.notifyModuleMappingChanged(moduleNames, moduleCCParams, modulePPDefines);
        service.notifyDocumentChanged(VirtualFileManager.constructUrl((String)"file", (String)service.getContext().getCpp20ModuleMapPath()), CppModulesStateUtil.getAsCpp20ModuleMapImpl(converter, modules));
        service.notifyDocumentChanged(VirtualFileManager.constructUrl((String)"file", (String)service.getContext().getModuleMapPath()), CppModulesStateUtil.getModuleMapImpl(project));
        service.getContext().setCpp20ModulesEnabled(true);
        ApplicationManager.getApplication().invokeLater(() -> ClangdSettings.rehighlight());
    }

    public static void tryAddModuleWithoutCompileCommand(@NotNull CppModulesState state, @NotNull File moduleFile) {
        VirtualFile srcFile;
        if (state == null) {
            CppModulesStateUtil.$$$reportNull$$$0(16);
        }
        if (moduleFile == null) {
            CppModulesStateUtil.$$$reportNull$$$0(17);
        }
        if ((srcFile = VfsUtil.findFileByIoFile((File)moduleFile, (boolean)false)) != null) {
            CppModulesStateUtil.tryAddModuleWithoutCompileCommand(state, srcFile);
        }
    }

    public static void tryAddModuleWithoutCompileCommand(@NotNull CppModulesState state, @NotNull VirtualFile moduleVFile) {
        Ref isImpl;
        String modName;
        if (state == null) {
            CppModulesStateUtil.$$$reportNull$$$0(18);
        }
        if (moduleVFile == null) {
            CppModulesStateUtil.$$$reportNull$$$0(19);
        }
        if ((modName = CppModulesStateUtil.getModuleName(moduleVFile, (Ref<Boolean>)(isImpl = new Ref()))) != null) {
            state.addCppModule(new Cpp20Module(modName, null, null, moduleVFile.getPath(), (Boolean)isImpl.get()));
        }
    }

    @NotNull
    private static String getModuleMapImpl(@NotNull Project project) {
        if (project == null) {
            CppModulesStateUtil.$$$reportNull$$$0(20);
        }
        StringBuilder sb = new StringBuilder();
        List<HeadersSearchPath> headersSearchPaths = ClangUtils.headerSearchPathsForProject(project);
        if (headersSearchPaths != null) {
            boolean hasStdModules = false;
            if (SystemInfo.isWindows) {
                for (HeadersSearchPath headerSearchPath : headersSearchPaths) {
                    Path ifcPath;
                    if (!headerSearchPath.isBuiltInHeaders() || !headerSearchPath.getPath().endsWith("include") || !Files.exists(ifcPath = Paths.get(new File(headerSearchPath.getPath()).getParentFile().getAbsolutePath(), "ifc"), new LinkOption[0]) || !CppModulesStateUtil.hasStdCoreIfc(ifcPath)) continue;
                    hasStdModules = true;
                    String includePath = FileUtil.toSystemIndependentName((String)headerSearchPath.getPath());
                    CppModulesStateUtil.appendStdModule(sb, includePath, "std.regex", List.of("regex"));
                    CppModulesStateUtil.appendStdModule(sb, includePath, "std.filesystem", List.of("filesystem"));
                    CppModulesStateUtil.appendStdModule(sb, includePath, "std.memory", List.of("memory"));
                    CppModulesStateUtil.appendStdModule(sb, includePath, "std.threading", List.of("atomic", "condition_variable", "future", "mutex", "shared_mutex", "thread"));
                    CppModulesStateUtil.appendStdModule(sb, includePath, "std.core", ALL_STD_CORE_HEADERS);
                }
            }
            if (!hasStdModules) {
                HashSet<String> uniqueIncludes = new HashSet<String>();
                for (HeadersSearchPath headerSearchPath : headersSearchPaths) {
                    File[] files;
                    if (!headerSearchPath.isBuiltInHeaders() || (files = new File(headerSearchPath.getPath()).listFiles()) == null) continue;
                    String includePath = FileUtil.toSystemIndependentName((String)headerSearchPath.getPath());
                    for (File child : files) {
                        if (child.isDirectory() || child.getName().contains(".") || uniqueIncludes.contains(child.getName())) continue;
                        String name = child.getName();
                        uniqueIncludes.add(name);
                        CppModulesStateUtil.appendStdModule(sb, includePath, "std.clionInternalModule." + name, List.of(name));
                    }
                }
            }
        }
        String string = sb.toString();
        if (string == null) {
            CppModulesStateUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    static String getAsCpp20ModuleMapImpl(@NotNull ClangUrlConverter converter, @NotNull List<Cpp20Module> modules) {
        if (converter == null) {
            CppModulesStateUtil.$$$reportNull$$$0(22);
        }
        if (modules == null) {
            CppModulesStateUtil.$$$reportNull$$$0(23);
        }
        StringBuilder sb = new StringBuilder();
        modules.sort((lhs, rhs) -> {
            if (lhs.getName().equals(rhs.getName())) {
                return Boolean.compare(lhs.isImpl(), rhs.isImpl());
            }
            return lhs.getName().compareTo(rhs.getName());
        });
        HashMap<String, List> processedModules = new HashMap<String, List>();
        for (Cpp20Module cppModule : modules) {
            List prevModules = processedModules.computeIfAbsent(cppModule.getName(), key -> new ArrayList());
            prevModules.add(cppModule);
            if (prevModules.size() != 1) continue;
            sb.append("module ").append(cppModule.getName()).append(" {\n");
            String modulePath = converter.fixWslPathWhenRequired(cppModule.getSourcePath());
            sb.append("  header \"").append(modulePath).append("\"\n");
            sb.append("}\n");
        }
        StringBuilder warningBuilder = new StringBuilder();
        for (List similarModules : processedModules.values()) {
            if (similarModules.size() <= 1) continue;
            if (!warningBuilder.isEmpty()) {
                warningBuilder.append("\n");
            }
            warningBuilder.append("Module '").append(((Cpp20Module)similarModules.get(0)).getName()).append("': ").append(similarModules.size()).append(" duplicates in ");
            for (int i = 0; i < 2; ++i) {
                if (i > 0) {
                    warningBuilder.append(", ");
                }
                warningBuilder.append(new File(((Cpp20Module)similarModules.get(i)).getSourcePath()).getName());
            }
            if (similarModules.size() <= 2) continue;
            warningBuilder.append(" and ").append(similarModules.size() - 2).append(" more");
        }
        if (!warningBuilder.isEmpty()) {
            CidrLog.LOG.warn(warningBuilder.toString());
        }
        String string = sb.toString();
        if (string == null) {
            CppModulesStateUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static boolean hasStdCoreIfc(@NotNull Path ifcPath) {
        if (ifcPath == null) {
            CppModulesStateUtil.$$$reportNull$$$0(25);
        }
        return Files.exists(Paths.get(ifcPath.toString(), "x64", "Release", "std.core.ifc"), new LinkOption[0]) || Files.exists(Paths.get(ifcPath.toString(), "x86", "Release", "std.core.ifc"), new LinkOption[0]);
    }

    private static void appendStdModule(@NotNull StringBuilder sb, @NotNull String includePath, @NotNull String moduleName, @NotNull List<String> headers) {
        if (sb == null) {
            CppModulesStateUtil.$$$reportNull$$$0(26);
        }
        if (includePath == null) {
            CppModulesStateUtil.$$$reportNull$$$0(27);
        }
        if (moduleName == null) {
            CppModulesStateUtil.$$$reportNull$$$0(28);
        }
        if (headers == null) {
            CppModulesStateUtil.$$$reportNull$$$0(29);
        }
        sb.append("module ").append(moduleName).append(" {\n");
        for (String header : headers) {
            sb.append("  header \"").append(includePath).append("/").append(header).append("\"\n");
        }
        sb.append("}\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 21, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isImpl";
                break;
            }
            case 4: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleVFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 11: 
            case 13: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFile";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/settings/CppModulesStateUtil";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifcPath";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includePath";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/settings/CppModulesStateUtil";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleMapImpl";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsCpp20ModuleMapImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isCpp20ModuleFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "maybeCpp20ModuleFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAtModuleKeyword";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseModuleName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseColonPart";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseNamePart";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateModuleMap";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "tryAddModuleWithoutCompileCommand";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getModuleMapImpl";
                break;
            }
            case 21: 
            case 24: {
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAsCpp20ModuleMapImpl";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasStdCoreIfc";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "appendStdModule";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 21, 24 -> new IllegalStateException(string);
        };
    }
}

