/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.settings;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.RegistryBooleanOptionDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.options.advanced.AdvancedSettingsChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiManager;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import com.jetbrains.cidr.lang.workspace.compiler.ClangFeatures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

@State(name="ClangdSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ClangdSettings
implements PersistentStateComponent<StoredState> {
    private static final String GLOBAL_COMPLETION_CACHE_ID = "clangd.use.global.completion.cache";
    private static final String CLANGD_INDEXER_ID = "clangd.use.indexer";
    private static final String CLANGD_KEEP_OBSOLETE_AST = "clangd.keep.obsolete.ast";
    private static final List<ClangFeatures.Warning> DISABLE_FOR_UnusedInspections = Collections.singletonList(ClangFeatures.Warnings.UNUSED_VARIABLE);
    private static final List<ClangFeatures.Warning> DISABLE_FOR_InfiniteRecursion = Collections.singletonList(ClangFeatures.Warnings.INFINITE_RECURSION);
    private static final List<ClangFeatures.Warning> DISABLE_FOR_ArrayIndexOufOfBounds = Collections.singletonList(ClangFeatures.Warnings.ARRAY_BOUNDS);
    private static final List<ClangFeatures.Warning> DISABLE_FOR_EscapeAnalysis = Collections.singletonList(ClangFeatures.Warnings.RETURN_STACK_ADDRESS);
    private static final List<ClangFeatures.Warning> ENABLE_FOR_HidesUpperScope = Collections.singletonList(ClangFeatures.Warnings.SHADOW);
    private static final List<ClangFeatures.Warning> DISABLE_FOR_FunctionImplicitDeclarationInspection = Collections.singletonList(ClangFeatures.Warnings.IMPLICIT_FUNCTION_DECLARATION);
    @NlsSafe
    private static final String DEFAULT_DISABLED_WARNINGS = ClangdSettings.makeWarningsDisabled(DISABLE_FOR_UnusedInspections, DISABLE_FOR_InfiniteRecursion, DISABLE_FOR_ArrayIndexOufOfBounds, DISABLE_FOR_EscapeAnalysis);
    @NlsSafe
    private static final String DEFAULT_ENABLED_WARNINGS = ClangdSettings.makeWarningsEnabled(ENABLE_FOR_HidesUpperScope, Collections.singletonList(ClangFeatures.Warnings.UNINITIALIZED), Collections.singletonList(ClangFeatures.Warnings.UNUSED_LABEL), Collections.singletonList(ClangFeatures.Warnings.UNUSED_LAMBDA_CAPTURE));
    @NlsSafe
    private static final String DEFAULT_DISABLED_ERRORS = ClangdSettings.makeWarningsAsErrors(DISABLE_FOR_FunctionImplicitDeclarationInspection);
    @NlsSafe
    private static final String DEFAULT_MESSAGE_FILTERS = PluginManagerCore.isRunningFromSources() ? "<-- clionDefinition\n--> reply:clionDefinition\n--> telemetry/event\n<-- clionDebugDumpMemoryStat\n--> reply:clionDebugDumpMemoryStat\nclion-method:clionDefinition\nclion-method:clionDebugDumpMemoryStat\nclion-method:telemetry/event" : "<-- clionDefinition\n--> reply:clionDefinition\n--> telemetry/event\n<-- clionDebugDumpMemoryStat\n--> reply:clionDebugDumpMemoryStat";
    @NotNull
    private final Project myProject;
    @NotNull
    private final StoredState myState;

    public ClangdSettings(@NotNull Project project) {
        if (project == null) {
            ClangdSettings.$$$reportNull$$$0(0);
        }
        this.myState = new StoredState();
        this.myProject = project;
        final ClangLanguageServiceProvider provider2 = ClangLanguageServiceProvider.getProvider(project);
        if (provider2 != null) {
            Registry.get((String)"clion.clang.clangd.on").addListener(new RegistryValueListener(){

                public void afterValueChanged(@NotNull RegistryValue value) {
                    if (value == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ClangdSettings.this.setClangdEnabledImpl(value.asBoolean());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/lang/daemon/clang/clangd/settings/ClangdSettings$1", "afterValueChanged"));
                }
            }, (Disposable)provider2);
            ApplicationManager.getApplication().getMessageBus().connect((Disposable)provider2).subscribe(AdvancedSettingsChangeListener.TOPIC, (Object)new AdvancedSettingsChangeListener(){

                public void advancedSettingChanged(@NotNull String id, @NotNull Object oldValue, @NotNull Object newValue) {
                    ClangLanguageService service;
                    if (id == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (oldValue == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (newValue == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (id.equals(ClangdSettings.CLANGD_INDEXER_ID)) {
                        ApplicationManager.getApplication().invokeLater(() -> RegistryBooleanOptionDescriptor.suggestRestart(null), ModalityState.nonModal());
                    } else if (id.equals(ClangdSettings.CLANGD_KEEP_OBSOLETE_AST) && (service = provider2.getIfStarted()) != null) {
                        service.shutDownServer();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "id";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "oldValue";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "newValue";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/settings/ClangdSettings$2";
                    objectArray[2] = "advancedSettingChanged";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            Registry.get((String)"clang.parameter.info").addListener(new RegistryValueListener(){

                public void afterValueChanged(@NotNull RegistryValue registryValue) {
                    if (registryValue == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    boolean newValue = registryValue.asBoolean();
                    ClangdSettings.this.setProperty(value -> {
                        ClangdSettings.this.myState.parameterInfoViaClangd = value;
                    }, ClangdSettingsListener::onParameterInfoViaClangdChanged, ClangdSettings.this.myState.parameterInfoViaClangd, newValue);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registryValue", "com/jetbrains/cidr/lang/daemon/clang/clangd/settings/ClangdSettings$3", "afterValueChanged"));
                }
            }, (Disposable)provider2);
        }
    }

    public static ClangdSettings getInstance(@NotNull Project project) {
        if (project == null) {
            ClangdSettings.$$$reportNull$$$0(1);
        }
        return (ClangdSettings)project.getService(ClangdSettings.class);
    }

    public synchronized boolean isClangdOn() {
        return this.myState.clangdEnabled && (this.myState.clangdShowErrors || this.myState.clangTidyViaClangd || this.myState.navigationViaClangd || this.myState.parameterInfoViaClangd || this.myState.formatViaClangd || this.myState.completionType != CompletionType.Builtin || this.myState.indexerOn);
    }

    public synchronized boolean isClangdShowErrors() {
        return this.myState.clangdShowErrors;
    }

    public synchronized void setClangdShowErrors(boolean clangdShowErrors) {
        this.setProperty(value -> {
            this.myState.clangdShowErrors = value;
        }, ClangdSettingsListener::onClangdShowErrorsChanged, this.myState.clangdShowErrors, clangdShowErrors);
    }

    public synchronized boolean isClangTidyViaClangd() {
        return this.myState.clangTidyViaClangd;
    }

    public synchronized void setClangTidyViaClangd(boolean clangTidyViaClangd) {
        this.setProperty(value -> {
            this.myState.clangTidyViaClangd = value;
        }, ClangdSettingsListener::onClangTidyViaClangdChanged, this.myState.clangTidyViaClangd, clangTidyViaClangd);
    }

    public synchronized boolean isNavigationViaClangd() {
        return this.myState.navigationViaClangd;
    }

    public synchronized boolean isParameterInfoViaClangd() {
        return this.myState.parameterInfoViaClangd;
    }

    public synchronized void setNavigationViaClangd(boolean navigationViaClangd) {
        this.setProperty(value -> {
            this.myState.navigationViaClangd = value;
        }, ClangdSettingsListener::onNavigationViaClangdChanged, this.myState.navigationViaClangd, navigationViaClangd);
    }

    public synchronized void setParameterInfoViaClangd(boolean parameterInfoViaClangd) {
        this.setProperty(value -> {
            this.myState.parameterInfoViaClangd = value;
        }, ClangdSettingsListener::onParameterInfoViaClangdChanged, this.myState.parameterInfoViaClangd, parameterInfoViaClangd);
        Registry.get((String)"clang.parameter.info").setValue(parameterInfoViaClangd);
    }

    public synchronized boolean isFormatViaClangd() {
        return this.myState.formatViaClangd;
    }

    public synchronized void setFormatViaClangd(boolean formatViaClangd) {
        this.setProperty(value -> {
            this.myState.formatViaClangd = value;
        }, ClangdSettingsListener::onFormatViaClangdChanged, this.myState.formatViaClangd, formatViaClangd);
    }

    public synchronized CompletionType getCompletionType() {
        return this.myState.completionType;
    }

    public synchronized void setCompletionType(CompletionType completionType) {
        this.setProperty(value -> {
            this.myState.completionType = completionType;
        }, ClangdSettingsListener::onCompletionTypeChanged, this.myState.completionType, completionType);
    }

    public synchronized boolean isCompleteInNamespacesByDefault() {
        return this.myState.completeInNamespacesByDefault;
    }

    public synchronized void setCompleteInNamespacesByDefault(boolean enable) {
        this.setProperty(value -> {
            this.myState.completeInNamespacesByDefault = enable;
        }, ClangdSettingsListener::onCompletionInNamespacesByDefaultChanged, this.myState.completeInNamespacesByDefault, enable);
    }

    public synchronized boolean isClangdEnabled() {
        return this.myState.clangdEnabled;
    }

    public synchronized void setClangdEnabled(boolean clangdEnabled) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            CidrLogService.LOG.error("Enabling clangd in production programmatically? It is allowed from Registry only.");
        }
        this.setClangdEnabledImpl(clangdEnabled);
    }

    private synchronized void setClangdEnabledImpl(boolean clangdEnabled) {
        this.setProperty(value -> {
            this.myState.clangdEnabled = value;
        }, ClangdSettingsListener::onClangdEnabled, this.myState.clangdEnabled, clangdEnabled);
    }

    @NotNull
    @NlsSafe
    public synchronized String getClangdMessagesFilters() {
        String string = StringUtil.notNullize((String)this.myState.clangdMessagesFilters);
        if (string == null) {
            ClangdSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    public synchronized void setClangdMessagesFilters(@NlsSafe @NotNull String clangdMessagesFilters) {
        if (clangdMessagesFilters == null) {
            ClangdSettings.$$$reportNull$$$0(3);
        }
        this.setProperty(value -> {
            this.myState.clangdMessagesFilters = value;
        }, ClangdSettingsListener::onClangdMessagesFiltersChanged, this.myState.clangdMessagesFilters, clangdMessagesFilters);
    }

    public boolean getKeepObsoleteAst() {
        return AdvancedSettings.getBoolean((String)CLANGD_KEEP_OBSOLETE_AST);
    }

    public synchronized boolean isIndexerOn() {
        return this.myState.indexerOn;
    }

    public synchronized void setIndexerOn(boolean value) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            CidrLogService.LOG.error("Enabling clangd-indexer in production programmatically? It is allowed from AdvancedSettings only.");
        }
        this.myState.indexerOn = value;
    }

    public synchronized boolean getIndexerShowProgress() {
        return this.myState.indexerShowProgress;
    }

    public synchronized void setIndexerShowProgress(boolean value) {
        this.myState.indexerShowProgress = value;
    }

    public synchronized boolean getIndexerSkipBodies() {
        return this.myState.indexerSkipBodies;
    }

    public synchronized void setIndexerSkipBodies(boolean skipBodies) {
        this.myState.indexerSkipBodies = skipBodies;
    }

    public synchronized boolean getIndexerSkipImplicitInstantiations() {
        return this.myState.indexerSkipImplicitInstantiations;
    }

    public synchronized void setIndexerSkipImplicitInstantiations(boolean skipImplicitInstantiations) {
        this.myState.indexerSkipImplicitInstantiations = skipImplicitInstantiations;
    }

    public synchronized int getIndexerModulesCacheMb() {
        return this.myState.indexerModulesCacheMb;
    }

    public synchronized void setIndexerModulesCacheMb(int modulesCacheMb) {
        this.myState.indexerModulesCacheMb = modulesCacheMb;
    }

    public synchronized int getIndexingThreadsNum() {
        return this.myState.indexingThreadsNum;
    }

    public synchronized void setIndexingThreadsNum(int threadsNum) {
        this.myState.indexingThreadsNum = threadsNum;
    }

    public synchronized boolean getIndexerShowDebugMessages() {
        return this.myState.indexerShowDebugMessages;
    }

    public synchronized void setIndexerShowDebugMessages(boolean showDebugMessages) {
        this.myState.indexerShowDebugMessages = showDebugMessages;
    }

    public synchronized boolean getIndexerStaticOnly() {
        return this.myState.indexerStaticOnly;
    }

    public synchronized void setIndexerStaticOnly(boolean staticOnly) {
        this.myState.indexerStaticOnly = staticOnly;
    }

    public synchronized boolean getIndexerUseModules() {
        return this.myState.indexerUseModules;
    }

    public synchronized void setIndexerUseModules(boolean useModules) {
        this.setProperty(value -> {
            this.myState.indexerUseModules = value;
        }, ClangdSettingsListener::onIndexerUseModulesChanged, this.myState.indexerUseModules, useModules);
    }

    public synchronized boolean getIndexerOptimizeIncludeGraph() {
        return this.myState.indexerOptimizeIncludeGraph;
    }

    public synchronized void setIndexerOptimizeIncludeGraph(boolean optimize) {
        this.setProperty(value -> {
            this.myState.indexerOptimizeIncludeGraph = value;
        }, ClangdSettingsListener::onIndexerOptimizeIncludeGraphChanged, this.myState.indexerOptimizeIncludeGraph, optimize);
    }

    public synchronized boolean getIndexerRestrictUpdatingThreads() {
        return this.myState.restrictUpdatingThreads;
    }

    public synchronized void setIndexerRestrictUpdatingThreads(boolean restrictUpdatingThreads) {
        this.myState.restrictUpdatingThreads = restrictUpdatingThreads;
    }

    @NotNull
    public synchronized String getClangFlags() {
        String string = StringUtil.notNullize((String)this.myState.clangWarnings);
        if (string == null) {
            ClangdSettings.$$$reportNull$$$0(4);
        }
        return string;
    }

    public synchronized void setClangFlags(@NlsSafe @NotNull String clangWarnings) {
        if (clangWarnings == null) {
            ClangdSettings.$$$reportNull$$$0(5);
        }
        this.myState.clangWarnings = clangWarnings;
    }

    @NotNull
    public synchronized StoredState getState() {
        return new StoredState(this.myState);
    }

    public synchronized void loadState(@NotNull StoredState state) {
        if (state == null) {
            ClangdSettings.$$$reportNull$$$0(6);
        }
        this.setClangdShowErrors(state.clangdShowErrors);
        this.setClangTidyViaClangd(state.clangTidyViaClangd);
        this.setNavigationViaClangd(state.navigationViaClangd);
        this.setParameterInfoViaClangd(state.parameterInfoViaClangd);
        this.setFormatViaClangd(state.formatViaClangd);
        this.setCompletionType(state.completionType != null ? state.completionType : new StoredState().completionType);
        this.setCompleteInNamespacesByDefault(state.completeInNamespacesByDefault);
        this.setClangFlags(state.clangWarnings);
        this.setClangdMessagesFilters(state.clangdMessagesFilters);
        this.setIndexerShowProgress(state.indexerShowProgress);
        this.setIndexerSkipBodies(state.indexerSkipBodies);
        this.setIndexerSkipImplicitInstantiations(state.indexerSkipImplicitInstantiations);
        this.setIndexerModulesCacheMb(state.indexerModulesCacheMb);
        this.setIndexingThreadsNum(state.indexingThreadsNum);
        this.setIndexerRestrictUpdatingThreads(state.restrictUpdatingThreads);
        this.setIndexerShowDebugMessages(state.indexerShowDebugMessages);
        this.setIndexerStaticOnly(state.indexerStaticOnly);
        this.setIndexerUseModules(state.indexerUseModules);
    }

    @NotNull
    private ClangdSettingsListener getPublisher() {
        ClangdSettingsListener clangdSettingsListener = (ClangdSettingsListener)this.myProject.getMessageBus().syncPublisher(ClangdSettingsListener.TOPIC);
        if (clangdSettingsListener == null) {
            ClangdSettings.$$$reportNull$$$0(7);
        }
        return clangdSettingsListener;
    }

    public static void rehighlight() {
        Project[] openProjects;
        for (Project project : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            PsiManager.getInstance((Project)project).dropPsiCaches();
        }
    }

    @SafeVarargs
    @NlsSafe
    @NotNull
    private static String makeWarningsDisabled(List<ClangFeatures.Warning> ... warningSets) {
        ArrayList args = new ArrayList();
        for (List<ClangFeatures.Warning> warnings : warningSets) {
            for (ClangFeatures.Warning warning : warnings) {
                args.addAll(warning.getDisabledOnlyThis());
            }
        }
        String string = StringUtil.join(args, (String)",");
        if (string == null) {
            ClangdSettings.$$$reportNull$$$0(8);
        }
        return string;
    }

    @SafeVarargs
    @NotNull
    private static String makeWarningsEnabled(List<ClangFeatures.Warning> ... warningSets) {
        ArrayList args = new ArrayList();
        for (List<ClangFeatures.Warning> warnings : warningSets) {
            for (ClangFeatures.Warning warning : warnings) {
                args.addAll(warning.getEnabledOnlyThis(false));
            }
        }
        String string = StringUtil.join(args, (String)",");
        if (string == null) {
            ClangdSettings.$$$reportNull$$$0(9);
        }
        return string;
    }

    @SafeVarargs
    @NotNull
    private static String makeWarningsAsErrors(List<ClangFeatures.Warning> ... warningSets) {
        ArrayList args = new ArrayList();
        for (List<ClangFeatures.Warning> warnings : warningSets) {
            for (ClangFeatures.Warning warning : warnings) {
                args.addAll(warning.getEnabledOnlyThis(true));
            }
        }
        String string = StringUtil.join(args, (String)",");
        if (string == null) {
            ClangdSettings.$$$reportNull$$$0(10);
        }
        return string;
    }

    private <Type> void setProperty(@NotNull Consumer<Type> propertySetter, @NotNull BiConsumer<ClangdSettingsListener, Type> propertyListener, Type oldValue, Type newValue) {
        if (propertySetter == null) {
            ClangdSettings.$$$reportNull$$$0(11);
        }
        if (propertyListener == null) {
            ClangdSettings.$$$reportNull$$$0(12);
        }
        if (!Objects.equals(newValue, oldValue)) {
            boolean oldClangdOn = this.isClangdOn();
            propertySetter.accept(newValue);
            propertyListener.accept(this.getPublisher(), newValue);
            boolean newClangOn = this.isClangdOn();
            if (oldClangdOn != newClangOn) {
                this.getPublisher().onClangdOnChanged(newClangOn);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/settings/ClangdSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangdMessagesFilters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangWarnings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySetter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/settings/ClangdSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangdMessagesFilters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangFlags";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublisher";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "makeWarningsDisabled";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "makeWarningsEnabled";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "makeWarningsAsErrors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setClangdMessagesFilters";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setClangFlags";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setProperty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    static class StoredState {
        public boolean clangdShowErrors;
        public boolean clangTidyViaClangd;
        public boolean navigationViaClangd;
        public boolean parameterInfoViaClangd;
        public boolean formatViaClangd;
        public CompletionType completionType;
        public boolean completeInNamespacesByDefault;
        public boolean clangdEnabled;
        @NlsSafe
        public String clangWarnings;
        @NlsSafe
        public String clangdMessagesFilters;
        public boolean indexerOn;
        public boolean indexerShowProgress;
        public boolean indexerSkipBodies;
        public boolean indexerSkipImplicitInstantiations;
        public int indexerModulesCacheMb;
        public int indexingThreadsNum;
        public boolean indexerShowDebugMessages;
        public boolean restrictUpdatingThreads;
        public boolean indexerStaticOnly;
        public boolean indexerUseModules;
        public boolean indexerOptimizeIncludeGraph;

        StoredState() {
            this.clangdShowErrors = !ApplicationManager.getApplication().isUnitTestMode();
            this.clangTidyViaClangd = true;
            this.navigationViaClangd = true;
            this.parameterInfoViaClangd = true;
            this.formatViaClangd = true;
            this.completionType = ApplicationManager.getApplication().isUnitTestMode() ? CompletionType.Builtin : CompletionType.Clangd;
            this.completeInNamespacesByDefault = false;
            this.clangdEnabled = Registry.is((String)"clion.clang.clangd.on");
            this.clangWarnings = StringUtil.join(Arrays.asList(DEFAULT_DISABLED_WARNINGS, DEFAULT_DISABLED_ERRORS, DEFAULT_ENABLED_WARNINGS, ApplicationManager.getApplication().isUnitTestMode() ? "-Wconversion" : null), (String)",");
            this.clangdMessagesFilters = DEFAULT_MESSAGE_FILTERS;
            this.indexerOn = AdvancedSettings.getBoolean((String)ClangdSettings.CLANGD_INDEXER_ID);
            this.indexerShowProgress = false;
            this.indexerSkipBodies = false;
            this.indexerSkipImplicitInstantiations = false;
            this.indexerModulesCacheMb = 0;
            this.indexingThreadsNum = 0;
            this.indexerShowDebugMessages = false;
            this.restrictUpdatingThreads = true;
            this.indexerStaticOnly = true;
            this.indexerUseModules = true;
            this.indexerOptimizeIncludeGraph = true;
        }

        StoredState(@NotNull StoredState other) {
            if (other == null) {
                StoredState.$$$reportNull$$$0(0);
            }
            this.clangdShowErrors = !ApplicationManager.getApplication().isUnitTestMode();
            this.clangTidyViaClangd = true;
            this.navigationViaClangd = true;
            this.parameterInfoViaClangd = true;
            this.formatViaClangd = true;
            this.completionType = ApplicationManager.getApplication().isUnitTestMode() ? CompletionType.Builtin : CompletionType.Clangd;
            this.completeInNamespacesByDefault = false;
            this.clangdEnabled = Registry.is((String)"clion.clang.clangd.on");
            this.clangWarnings = StringUtil.join(Arrays.asList(DEFAULT_DISABLED_WARNINGS, DEFAULT_DISABLED_ERRORS, DEFAULT_ENABLED_WARNINGS, ApplicationManager.getApplication().isUnitTestMode() ? "-Wconversion" : null), (String)",");
            this.clangdMessagesFilters = DEFAULT_MESSAGE_FILTERS;
            this.indexerOn = AdvancedSettings.getBoolean((String)ClangdSettings.CLANGD_INDEXER_ID);
            this.indexerShowProgress = false;
            this.indexerSkipBodies = false;
            this.indexerSkipImplicitInstantiations = false;
            this.indexerModulesCacheMb = 0;
            this.indexingThreadsNum = 0;
            this.indexerShowDebugMessages = false;
            this.restrictUpdatingThreads = true;
            this.indexerStaticOnly = true;
            this.indexerUseModules = true;
            this.indexerOptimizeIncludeGraph = true;
            this.clangdShowErrors = other.clangdShowErrors;
            this.clangTidyViaClangd = other.clangTidyViaClangd;
            this.navigationViaClangd = other.navigationViaClangd;
            this.parameterInfoViaClangd = other.parameterInfoViaClangd;
            this.formatViaClangd = other.formatViaClangd;
            this.completionType = other.completionType;
            this.completeInNamespacesByDefault = other.completeInNamespacesByDefault;
            this.clangdEnabled = other.clangdEnabled;
            this.clangWarnings = other.clangWarnings;
            this.clangdMessagesFilters = other.clangdMessagesFilters;
            this.indexerOn = other.indexerOn;
            this.indexerShowProgress = other.indexerShowProgress;
            this.indexerSkipBodies = other.indexerSkipBodies;
            this.indexerSkipImplicitInstantiations = other.indexerSkipImplicitInstantiations;
            this.indexerModulesCacheMb = other.indexerModulesCacheMb;
            this.indexingThreadsNum = other.indexingThreadsNum;
            this.restrictUpdatingThreads = other.restrictUpdatingThreads;
            this.indexerShowDebugMessages = other.indexerShowDebugMessages;
            this.indexerStaticOnly = other.indexerStaticOnly;
            this.indexerUseModules = other.indexerUseModules;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/jetbrains/cidr/lang/daemon/clang/clangd/settings/ClangdSettings$StoredState", "<init>"));
        }
    }

    public static enum CompletionType {
        Builtin(0),
        Clangd(1);

        private final int value;

        private CompletionType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static CompletionType forValue(int value) {
            CompletionType[] allValues = CompletionType.values();
            if (value < 0 || value >= allValues.length) {
                return Clangd;
            }
            return allValues[value];
        }
    }
}

