/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnection;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.ClangClient;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.ClangClientImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionInlayHintFragment;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.RawClionInlayHintFragment;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangClientServerProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCrashHandler;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAdapter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.signaturehelp.ClionSignatureInformation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.JsonRpcException;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.json.StreamMessageProducer;
import org.eclipse.lsp4j.jsonrpc.messages.IdentifiableMessage;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangClientServerProviderImpl
implements ClangClientServerProvider {
    private static final Logger LOG = Logger.getInstance((String)ClangClientServerProviderImpl.class.getName());

    @Override
    @Nullable
    public ClangClientServerProvider.ClientServerEndpoints bind(final @NotNull ClangDaemonContext cdc, final @NotNull ServerConnection connection, @NotNull Consumer<String> errorsHandler, @NotNull MessageConsumer outgoingLogger, @NotNull MessageConsumer incomingLogger) {
        if (cdc == null) {
            ClangClientServerProviderImpl.$$$reportNull$$$0(0);
        }
        if (connection == null) {
            ClangClientServerProviderImpl.$$$reportNull$$$0(1);
        }
        if (errorsHandler == null) {
            ClangClientServerProviderImpl.$$$reportNull$$$0(2);
        }
        if (outgoingLogger == null) {
            ClangClientServerProviderImpl.$$$reportNull$$$0(3);
        }
        if (incomingLogger == null) {
            ClangClientServerProviderImpl.$$$reportNull$$$0(4);
        }
        ProxyExecutorService ioService = new ProxyExecutorService(cdc.getDescriptor(), Executors.newCachedThreadPool());
        InputStream errorStream = connection.getErrorStream();
        if (errorStream != null) {
            ioService.execute(new ConnectionErrorsLogger(errorStream, errorsHandler));
        }
        InputStream inputStream = connection.getInputStream();
        OutputStream outputStream = connection.getOutputStream();
        if (inputStream == null || outputStream == null) {
            assert (!connection.isActive());
            ioService.shutdown();
            return null;
        }
        ClangCrashHandler guard = cdc.getCrashHandler();
        ClangClient client = guard.spyOn(new ClangClientImpl(cdc));
        ProxyMessageConsumer outgoing = new ProxyMessageConsumer();
        outgoing.addConsumer(outgoingLogger);
        ProxyMessageConsumer incoming = new ProxyMessageConsumer();
        incoming.addConsumer(incomingLogger);
        Consumer<GsonBuilder> gsonConfigurer = gsonBuilder -> {
            gsonBuilder.registerTypeAdapter(SignatureInformation.class, (Object)new JsonDeserializer<SignatureInformation>(){

                public SignatureInformation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                    return (SignatureInformation)context.deserialize(json, ClionSignatureInformation.class);
                }
            });
            gsonBuilder.registerTypeAdapter(ClionInlayHintFragment.class, (Object)new JsonDeserializer<ClionInlayHintFragment>(){

                public ClionInlayHintFragment deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                    Object deserialized = context.deserialize(json, RawClionInlayHintFragment.class);
                    if (deserialized instanceof RawClionInlayHintFragment) {
                        return ((RawClionInlayHintFragment)deserialized).toClionInlayHintFragment(cdc.getUrlConverter());
                    }
                    return null;
                }
            });
        };
        Launcher launcher = Launcher.createIoLauncher((Object)client, ClangServer.class, (InputStream)inputStream, (OutputStream)outputStream, (ExecutorService)ioService, (Function)new ConsumersProvider(outgoing, incoming), gsonConfigurer);
        ClangServer server = (ClangServer)launcher.getRemoteProxy();
        RemoteEndpoint remoteEndpoint = launcher.getRemoteEndpoint();
        server = (ClangServer)ReflectionUtil.proxy((ClassLoader)this.getClass().getClassLoader(), ClangServer.class, (InvocationHandler)new ClangServerProtector(server));
        server = guard.spyOn(new ClangServerEx(server, remoteEndpoint, outgoing));
        java.util.logging.Logger lsp4jLogger = java.util.logging.Logger.getLogger(StreamMessageProducer.class.getName());
        Handler myKillHandler = new Handler(){

            @Override
            public void publish(LogRecord record) {
                if (record.getLevel() == Level.SEVERE) {
                    connection.stop();
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
        lsp4jLogger.addHandler(myKillHandler);
        try {
            Disposer.register((Disposable)cdc, () -> lsp4jLogger.removeHandler(myKillHandler));
        }
        catch (IncorrectOperationException ex) {
            LOG.info((Throwable)ex);
            ioService.shutdown();
            return null;
        }
        launcher.startListening();
        return new DefaultClientServerEndpoints(ioService, server, client);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "cdc";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "errorsHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "outgoingLogger";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "incomingLogger";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangClientServerProviderImpl";
        objectArray[2] = "bind";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ProxyExecutorService
    implements ExecutorService {
        private boolean hadFirstSubmission;
        private boolean hadSecondSubmission;
        @NotNull
        private String myDescriptor;
        @NotNull
        private final ExecutorService myDelegate;

        private ProxyExecutorService(@NotNull String descriptor, @NotNull ExecutorService delegate) {
            if (descriptor == null) {
                ProxyExecutorService.$$$reportNull$$$0(0);
            }
            if (delegate == null) {
                ProxyExecutorService.$$$reportNull$$$0(1);
            }
            this.myDescriptor = descriptor;
            this.myDelegate = delegate;
        }

        @Override
        public void shutdown() {
            this.myDelegate.shutdown();
        }

        @Override
        @NotNull
        public List<Runnable> shutdownNow() {
            List<Runnable> list = this.myDelegate.shutdownNow();
            if (list == null) {
                ProxyExecutorService.$$$reportNull$$$0(2);
            }
            return list;
        }

        @Override
        public boolean isShutdown() {
            return this.myDelegate.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.myDelegate.isTerminated();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean awaitTermination(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
            void unit;
            if (timeUnit == null) {
                ProxyExecutorService.$$$reportNull$$$0(3);
            }
            return this.myDelegate.awaitTermination(timeout, (TimeUnit)unit);
        }

        @Override
        @NotNull
        public <T> Future<T> submit(@NotNull Callable<T> task) {
            if (task == null) {
                ProxyExecutorService.$$$reportNull$$$0(4);
            }
            Future<T> future = this.myDelegate.submit(task);
            if (future == null) {
                ProxyExecutorService.$$$reportNull$$$0(5);
            }
            return future;
        }

        @Override
        @NotNull
        public <T> Future<T> submit(@NotNull Runnable task, T result) {
            if (task == null) {
                ProxyExecutorService.$$$reportNull$$$0(6);
            }
            Future<T> future = this.myDelegate.submit(this.wrapRunnable(task), result);
            if (future == null) {
                ProxyExecutorService.$$$reportNull$$$0(7);
            }
            return future;
        }

        @Override
        @NotNull
        public Future<?> submit(@NotNull Runnable task) {
            if (task == null) {
                ProxyExecutorService.$$$reportNull$$$0(8);
            }
            Future<?> future = this.myDelegate.submit(this.wrapRunnable(task));
            if (future == null) {
                ProxyExecutorService.$$$reportNull$$$0(9);
            }
            return future;
        }

        @Override
        @NotNull
        public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
            if (tasks == null) {
                ProxyExecutorService.$$$reportNull$$$0(10);
            }
            List list = this.myDelegate.invokeAll(tasks);
            if (list == null) {
                ProxyExecutorService.$$$reportNull$$$0(11);
            }
            return list;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
            void unit;
            if (tasks == null) {
                ProxyExecutorService.$$$reportNull$$$0(12);
            }
            if (timeUnit == null) {
                ProxyExecutorService.$$$reportNull$$$0(13);
            }
            List list = this.myDelegate.invokeAll(tasks, timeout, (TimeUnit)unit);
            if (list == null) {
                ProxyExecutorService.$$$reportNull$$$0(14);
            }
            return list;
        }

        @Override
        @NotNull
        public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            if (tasks == null) {
                ProxyExecutorService.$$$reportNull$$$0(15);
            }
            Object t = this.myDelegate.invokeAny(tasks);
            if (t == null) {
                ProxyExecutorService.$$$reportNull$$$0(16);
            }
            return t;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> tasks, long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            void unit;
            if (tasks == null) {
                ProxyExecutorService.$$$reportNull$$$0(17);
            }
            if (timeUnit == null) {
                ProxyExecutorService.$$$reportNull$$$0(18);
            }
            return this.myDelegate.invokeAny(tasks, timeout, (TimeUnit)unit);
        }

        @Override
        public void execute(@NotNull Runnable command) {
            if (command == null) {
                ProxyExecutorService.$$$reportNull$$$0(19);
            }
            this.myDelegate.execute(this.wrapRunnable(command));
        }

        @NotNull
        private Runnable wrapRunnable(@NotNull Runnable runnable) {
            if (runnable == null) {
                ProxyExecutorService.$$$reportNull$$$0(20);
            }
            Runnable runnable2 = ConcurrencyUtil.underThreadNameRunnable((String)this.getThreadName(), () -> {
                try {
                    runnable.run();
                }
                catch (JsonRpcException ex) {
                    if (!(ex.getCause() instanceof IOException) || !StringUtil.notNullize((String)ex.getCause().getMessage()).contains("Stream closed:")) {
                        LOG.error((Throwable)ex);
                        throw ex;
                    }
                }
                catch (Throwable ex) {
                    LOG.error(ex);
                    throw ex;
                }
            });
            if (runnable2 == null) {
                ProxyExecutorService.$$$reportNull$$$0(21);
            }
            return runnable2;
        }

        @NotNull
        private String getThreadName() {
            if (!this.hadFirstSubmission) {
                this.hadFirstSubmission = true;
                String string = "Clangd errors reader [" + this.myDescriptor + "]";
                if (string == null) {
                    ProxyExecutorService.$$$reportNull$$$0(22);
                }
                return string;
            }
            if (!this.hadSecondSubmission) {
                this.hadSecondSubmission = true;
                String string = "Clangd output reader [" + this.myDescriptor + "]";
                if (string == null) {
                    ProxyExecutorService.$$$reportNull$$$0(23);
                }
                return string;
            }
            LOG.error("Unexpected I/O task!");
            return "Clangd reader";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5, 7, 9, 11, 14, 16, 21, 22, 23 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 2: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 14: 
                case 16: 
                case 21: 
                case 22: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangClientServerProviderImpl$ProxyExecutorService";
                    break;
                }
                case 3: 
                case 13: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
                case 4: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 10: 
                case 12: 
                case 15: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tasks";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangClientServerProviderImpl$ProxyExecutorService";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shutdownNow";
                    break;
                }
                case 5: 
                case 7: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "submit";
                    break;
                }
                case 11: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "invokeAll";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "invokeAny";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "wrapRunnable";
                    break;
                }
                case 22: 
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getThreadName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 5: 
                case 7: 
                case 9: 
                case 11: 
                case 14: 
                case 16: 
                case 21: 
                case 22: 
                case 23: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "awaitTermination";
                    break;
                }
                case 4: 
                case 6: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "submit";
                    break;
                }
                case 10: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "invokeAll";
                    break;
                }
                case 15: 
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "invokeAny";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "wrapRunnable";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5, 7, 9, 11, 14, 16, 21, 22, 23 -> new IllegalStateException(string);
            };
        }
    }

    private static class ConnectionErrorsLogger
    implements Runnable {
        @NotNull
        private final BufferedReader myErrorsReader;
        @NotNull
        private final Consumer<String> myErrorsHandler;

        ConnectionErrorsLogger(@NotNull InputStream errorStream, @NotNull Consumer<String> errorsHandler) {
            if (errorStream == null) {
                ConnectionErrorsLogger.$$$reportNull$$$0(0);
            }
            if (errorsHandler == null) {
                ConnectionErrorsLogger.$$$reportNull$$$0(1);
            }
            this.myErrorsReader = new BufferedReader(new InputStreamReader(errorStream, StandardCharsets.UTF_8));
            this.myErrorsHandler = errorsHandler;
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.myErrorsReader.readLine()) != null) {
                    this.myErrorsHandler.accept(line);
                }
            }
            catch (InterruptedIOException line) {
            }
            catch (ClosedChannelException line) {
            }
            catch (IOException ex) {
                LOG.info((Throwable)ex);
            }
            catch (Throwable thr) {
                LOG.error(thr);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "errorStream";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "errorsHandler";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangClientServerProviderImpl$ConnectionErrorsLogger";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ProxyMessageConsumer
    implements MessageConsumer {
        @NotNull
        private final List<MessageConsumer> myDelegates = new ArrayList<MessageConsumer>();

        private ProxyMessageConsumer() {
        }

        public void addConsumer(@NotNull MessageConsumer consumer) {
            if (consumer == null) {
                ProxyMessageConsumer.$$$reportNull$$$0(0);
            }
            this.myDelegates.add(consumer);
        }

        public void consume(Message message) {
            for (MessageConsumer consumer : this.myDelegates) {
                consumer.consume(message);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangClientServerProviderImpl$ProxyMessageConsumer", "addConsumer"));
        }
    }

    private static class ConsumersProvider
    implements Function<MessageConsumer, MessageConsumer> {
        private final Stack<ProxyMessageConsumer> myConsumers;

        ConsumersProvider(@NotNull ProxyMessageConsumer outgoing, @NotNull ProxyMessageConsumer incoming) {
            if (outgoing == null) {
                ConsumersProvider.$$$reportNull$$$0(0);
            }
            if (incoming == null) {
                ConsumersProvider.$$$reportNull$$$0(1);
            }
            this.myConsumers = new Stack();
            this.myConsumers.push((Object)incoming);
            this.myConsumers.push((Object)outgoing);
        }

        @Override
        public MessageConsumer apply(MessageConsumer consumer) {
            ProxyMessageConsumer proxy = (ProxyMessageConsumer)this.myConsumers.pop();
            proxy.addConsumer(consumer);
            return proxy;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outgoing";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "incoming";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangClientServerProviderImpl$ConsumersProvider";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ClangServerProtector
    implements InvocationHandler {
        @NotNull
        private final ClangServer myServer;

        private ClangServerProtector(@NotNull ClangServer server) {
            if (server == null) {
                ClangServerProtector.$$$reportNull$$$0(0);
            }
            this.myServer = server;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Method m = ClangServerProtector.findMethod(this.myServer.getClass(), method);
            assert (m != null);
            if (ClangServerProtector.isProtectionOn(m)) {
                assert (!ApplicationManager.getApplication().isWriteAccessAllowed()) : "I/O operation under write lock?";
                assert (!ApplicationManager.getApplication().isReadAccessAllowed()) : "I/O operation under read lock?";
            }
            return m.invoke((Object)this.myServer, args);
        }

        @Nullable
        private static Method findMethod(Class<?> clazz, Method method) {
            try {
                return clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }

        private static boolean isProtectionOn(@NotNull Method m) {
            if (m == null) {
                ClangServerProtector.$$$reportNull$$$0(1);
            }
            return !m.getName().equals("shutdown") && !m.getName().equals("exit");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "server";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "m";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangClientServerProviderImpl$ClangServerProtector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isProtectionOn";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClangServerEx
    extends ClangServerAdapter {
        @NotNull
        private final RemoteEndpoint myRemoteEndpoint;
        @NotNull
        private final CopyOnWriteArrayList<Consumer<String>> myRequestIdsConsumers;

        ClangServerEx(@NotNull ClangServer myServer, @NotNull RemoteEndpoint remoteEndpoint, @NotNull ProxyMessageConsumer outgoing) {
            if (myServer == null) {
                ClangServerEx.$$$reportNull$$$0(0);
            }
            if (remoteEndpoint == null) {
                ClangServerEx.$$$reportNull$$$0(1);
            }
            if (outgoing == null) {
                ClangServerEx.$$$reportNull$$$0(2);
            }
            super(myServer);
            this.myRequestIdsConsumers = new CopyOnWriteArrayList();
            this.myRemoteEndpoint = remoteEndpoint;
            outgoing.addConsumer(message -> {
                if (message instanceof IdentifiableMessage) {
                    String id = ((IdentifiableMessage)message).getId();
                    for (Consumer<String> consumer : this.myRequestIdsConsumers) {
                        consumer.accept(id);
                    }
                }
            });
        }

        @Override
        @NotNull
        public Endpoint getRemoteEndpoint() {
            RemoteEndpoint remoteEndpoint = this.myRemoteEndpoint;
            if (remoteEndpoint == null) {
                ClangServerEx.$$$reportNull$$$0(3);
            }
            return remoteEndpoint;
        }

        @Override
        public void attachRequestsListener(@NotNull Consumer<String> idConsumer) {
            if (idConsumer == null) {
                ClangServerEx.$$$reportNull$$$0(4);
            }
            this.myRequestIdsConsumers.add(idConsumer);
        }

        @Override
        public void detachRequestsListener(@NotNull Consumer<String> idConsumer) {
            if (idConsumer == null) {
                ClangServerEx.$$$reportNull$$$0(5);
            }
            this.myRequestIdsConsumers.remove(idConsumer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "myServer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remoteEndpoint";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outgoing";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangClientServerProviderImpl$ClangServerEx";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "idConsumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangClientServerProviderImpl$ClangServerEx";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRemoteEndpoint";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "attachRequestsListener";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "detachRequestsListener";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class DefaultClientServerEndpoints
    implements ClangClientServerProvider.ClientServerEndpoints {
        @NotNull
        private final ExecutorService myIoService;
        @NotNull
        private final ClangServer myServer;
        @NotNull
        private final ClangClient myClient;

        DefaultClientServerEndpoints(@NotNull ExecutorService ioService, @NotNull ClangServer server, @NotNull ClangClient client) {
            if (ioService == null) {
                DefaultClientServerEndpoints.$$$reportNull$$$0(0);
            }
            if (server == null) {
                DefaultClientServerEndpoints.$$$reportNull$$$0(1);
            }
            if (client == null) {
                DefaultClientServerEndpoints.$$$reportNull$$$0(2);
            }
            this.myIoService = ioService;
            this.myServer = server;
            this.myClient = client;
        }

        @Override
        @NotNull
        public ClangServer getServer() {
            ClangServer clangServer = this.myServer;
            if (clangServer == null) {
                DefaultClientServerEndpoints.$$$reportNull$$$0(3);
            }
            return clangServer;
        }

        @Override
        @NotNull
        public ClangClient getClient() {
            ClangClient clangClient = this.myClient;
            if (clangClient == null) {
                DefaultClientServerEndpoints.$$$reportNull$$$0(4);
            }
            return clangClient;
        }

        public void dispose() {
            this.myIoService.shutdown();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ioService";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "server";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "client";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangClientServerProviderImpl$DefaultClientServerEndpoints";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangClientServerProviderImpl$DefaultClientServerEndpoints";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getServer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClient";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

