/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.reports;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.reports.ClangCrashReporter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.reports.ClangReportUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangCrashReporterImpl
implements ClangCrashReporter {
    private static final Logger LOG = Logger.getInstance(ClangCrashReporterImpl.class);

    @Override
    public void report(@NotNull ClangDaemonContext context, @NotNull String message, @Nullable List<String> fileUrls) {
        if (context == null) {
            ClangCrashReporterImpl.$$$reportNull$$$0(0);
        }
        if (message == null) {
            ClangCrashReporterImpl.$$$reportNull$$$0(1);
        }
        if (fileUrls != null && !fileUrls.isEmpty() && Registry.is((String)"clion.clang.clangd.crash_reports")) {
            this.doAdvancedCrashReport(context, message, fileUrls);
        } else {
            this.sendReport(message, null);
        }
    }

    protected void sendReport(@NotNull String message, @Nullable List<Attachment> attachments) {
        if (message == null) {
            ClangCrashReporterImpl.$$$reportNull$$$0(2);
        }
        if (attachments != null) {
            LOG.error(message, attachments.toArray(Attachment.EMPTY_ARRAY));
        } else if (ApplicationManager.getApplication().isInternal()) {
            LOG.error(message);
        } else {
            LOG.warn(message);
        }
    }

    private void doAdvancedCrashReport(@NotNull ClangDaemonContext context, @NotNull String message, @NotNull List<String> fileUrls) {
        if (context == null) {
            ClangCrashReporterImpl.$$$reportNull$$$0(3);
        }
        if (message == null) {
            ClangCrashReporterImpl.$$$reportNull$$$0(4);
        }
        if (fileUrls == null) {
            ClangCrashReporterImpl.$$$reportNull$$$0(5);
        }
        Ref reportWasSent = Ref.create((Object)false);
        ClangReportUtils.withCrashLanguageService(context, crashService -> {
            long startTime = System.nanoTime();
            try {
                boolean obfuscate = !PluginManagerCore.isRunningFromSources() && !ApplicationManager.getApplication().isUnitTestMode();
                Map<String, String> file2Content = ClangReportUtils.preparePreprocessedReport(crashService, fileUrls, obfuscate);
                ArrayList<Attachment> attachments = new ArrayList<Attachment>();
                for (Map.Entry<String, String> entry : file2Content.entrySet()) {
                    attachments.add(new Attachment(entry.getKey(), entry.getValue()));
                }
                reportWasSent.set((Object)true);
                this.sendReport(message, attachments);
            }
            catch (IOException ex) {
                LOG.warn("Error while making crash report: " + ex.getMessage(), (Throwable)ex);
            }
            finally {
                long reportTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
                LOG.warn("Making crash report took " + reportTime + "ms");
            }
        });
        if (!((Boolean)reportWasSent.get()).booleanValue()) {
            this.sendReport(message, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrls";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/reports/ClangCrashReporterImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "report";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "sendReport";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doAdvancedCrashReport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

