/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions.ClangdReportBugAction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions.ClangdReportIndexerBugActionKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions.ClangdReportIndexerBugDialog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions.FailedUsageInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.reports.ClangReportUtils;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.Position;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdReportIndexerBugAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "intellij.c.clangd"})
@SourceDebugExtension(value={"SMAP\nClangdReportIndexerBugAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangdReportIndexerBugAction.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdReportIndexerBugAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1#2:145\n1#2:156\n1611#3,9:146\n1863#3:155\n1864#3:157\n1620#3:158\n1557#3:159\n1628#3,3:160\n*S KotlinDebug\n*F\n+ 1 ClangdReportIndexerBugAction.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdReportIndexerBugAction\n*L\n77#1:156\n77#1:146,9\n77#1:155\n77#1:157\n77#1:158\n87#1:159\n87#1:160,3\n*E\n"})
public final class ClangdReportIndexerBugAction
extends AnAction {
    /*
     * WARNING - void declaration
     */
    public void update(@NotNull AnActionEvent e) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project != null) {
            void it;
            Project project2 = project;
            Presentation presentation2 = presentation;
            boolean bl2 = false;
            boolean bl3 = ClangUtils.isClangdIndexerOn((Project)it);
            presentation = presentation2;
            bl = bl3;
        } else {
            bl = false;
        }
        presentation.setVisible(bl);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        ClangLanguageService service;
        ClangLanguageServiceProvider provider2;
        Position pos;
        Object identRange;
        FailedUsageInfo failedUsageInfo;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Caret caret = (Caret)e.getData(CommonDataKeys.CARET);
        if (caret != null) {
            Caret it = caret;
            boolean bl = false;
            VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            if (virtualFile == null) {
                failedUsageInfo = null;
            } else {
                VirtualFile curFile = virtualFile;
                CharSequence charSequence = it.getEditor().getDocument().getImmutableCharSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
                CharSequence text = charSequence;
                if (it.getOffset() >= text.length()) {
                    failedUsageInfo = null;
                } else if (Character.isWhitespace(text.charAt(it.getOffset())) && (it.getOffset() == 0 || Character.isWhitespace(text.charAt(it.getOffset() - 1)))) {
                    failedUsageInfo = null;
                } else {
                    TextRange textRange = identRange = Character.isWhitespace(text.charAt(it.getOffset())) ? ClangUtils.findIdentifierRange(text, it.getOffset() - 1) : ClangUtils.findIdentifierRange(text, it.getOffset());
                    String identText = identRange != null ? ((Object)text.subSequence(identRange.getStartOffset(), identRange.getEndOffset())).toString() : (!Character.isWhitespace(text.charAt(it.getOffset())) ? ((Object)text.subSequence(it.getOffset(), it.getOffset() + 1)).toString() : ((Object)text.subSequence(it.getOffset() - 1, it.getOffset())).toString());
                    Position position = ClangLanguageServiceUtils.offset2LspPos(it.getEditor().getDocument(), it.getOffset());
                    Intrinsics.checkNotNullExpressionValue((Object)position, (String)"offset2LspPos(...)");
                    pos = position;
                    failedUsageInfo = new FailedUsageInfo(curFile, pos.getLine() + 1, pos.getCharacter() + 1, identText);
                }
            }
        } else {
            failedUsageInfo = null;
        }
        FailedUsageInfo failedUsageInfo2 = failedUsageInfo;
        ClangLanguageServiceProvider clangLanguageServiceProvider = provider2 = ClangLanguageServiceProvider.getProvider(project2);
        ClangLanguageService clangLanguageService = service = clangLanguageServiceProvider != null ? clangLanguageServiceProvider.getOrStart() : null;
        if (service == null) {
            ClangUtils.LOG.warn("Failed to getOrStart() ClangLanguageService");
            return;
        }
        ClangdIndexerService indexer = provider2.getIfStartedIndexer();
        if (indexer == null) {
            ClangUtils.LOG.warn("Cannot collect an indexer report because it is not started");
            return;
        }
        Set<String> set = indexer.getCopyOfDangerousFiles();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getCopyOfDangerousFiles(...)");
        List dangerousPaths = CollectionsKt.sortedDescending((Iterable)set);
        ClangdReportIndexerBugDialog dialog = new ClangdReportIndexerBugDialog(project2, failedUsageInfo2, dangerousPaths);
        dialog.show();
        if (dialog.isOK()) {
            FailedUsageInfo usageToReport;
            ArrayList<VirtualFile> dangerousFiles = new ArrayList<VirtualFile>();
            if (dialog.getReportDangerousFiles()) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                identRange = dangerousPaths;
                ArrayList<VirtualFile> arrayList = dangerousFiles;
                boolean $i$f$mapNotNull = false;
                pos = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    VirtualFile it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    String path = (String)element$iv$iv;
                    boolean bl2 = false;
                    if (VirtualFileManager.getInstance().findFileByNioPath(new File(path).toPath()) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                arrayList.addAll((List)destination$iv$iv);
            }
            FailedUsageInfo failedUsageInfo3 = usageToReport = dialog.getReportFindUsageFailure() ? failedUsageInfo2 : null;
            if (usageToReport != null && !dangerousFiles.contains(usageToReport.getPath())) {
                dangerousFiles.add(usageToReport.getPath());
            }
            try {
                String string = ClangdBundle.message("clangd.report.bug.collecting.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                Map file2Content = (Map)CidrConcurrentUtilsKt.computeUnderProgress((String)string, (Project)project2, () -> ClangdReportIndexerBugAction.actionPerformed$lambda$4(service, dangerousFiles));
                if (file2Content != null) {
                    ClangdReportIndexerBugActionKt.access$collectIndexerFiles(file2Content, indexer, failedUsageInfo2, dangerousFiles);
                    if (dialog.getSendAsException()) {
                        ClangdReportBugAction.reportZipAsException(project2, file2Content);
                    } else {
                        ClangdReportBugAction.saveZip(project2, file2Content, "_indexer_report");
                    }
                }
            }
            catch (IOException ex) {
                ClangUtils.LOG.error((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Map actionPerformed$lambda$4(ClangLanguageService $service, ArrayList $dangerousFiles) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $dangerousFiles;
        ClangLanguageService clangLanguageService = $service;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUrl());
        }
        return ClangReportUtils.prepareAsIsReport(clangLanguageService, (List)destination$iv$iv);
    }
}

