/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions.ClangdDumpIndexerCDBKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions.IndexerCDB;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J,\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000eH&J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\t\u001a\u00020\nH\u0002\u0082\u0001\u0002\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdIndexerCDB;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "onCDBReady", "project", "Lcom/intellij/openapi/project/Project;", "jsonCDB", "", "macros2File", "", "getProjectRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdDumpIndexerCDB;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdShowIndexerCDB;", "intellij.c.clangd"})
public abstract class ClangdIndexerCDB
extends DumbAwareAction {
    private ClangdIndexerCDB() {
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Object object = ClangLanguageServiceProvider.getProvider(project2);
        if (object == null || (object = object.getIfStartedIndexer()) == null) {
            return;
        }
        Object indexer = object;
        IndexerCDB indexerCDB = ClangdDumpIndexerCDBKt.prepareIndexerCDB((ClangLanguageService)indexer, (Iterable<? extends VirtualFile>)this.getProjectRoots(project2));
        String serialized = indexerCDB.component1();
        Map<String, String> macros2File = indexerCDB.component2();
        this.onCDBReady(project2, serialized, macros2File);
    }

    public abstract void onCDBReady(@NotNull Project var1, @NotNull String var2, @NotNull Map<String, String> var3);

    private final Set<VirtualFile> getProjectRoots(Project project) {
        Set sources = new HashSet();
        for (OCResolveConfiguration config : OCWorkspace.getInstance((Project)project).getConfigurations()) {
            Collection collection = config.getSources();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSources(...)");
            sources.addAll(collection);
        }
        return sources;
    }

    public /* synthetic */ ClangdIndexerCDB(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

