/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions.ClangdIndexerCDB;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.reports.ClangReportUtils;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdDumpIndexerCDB;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdIndexerCDB;", "<init>", "()V", "onCDBReady", "", "project", "Lcom/intellij/openapi/project/Project;", "jsonCDB", "", "macros2File", "", "getSavePath", "Ljava/io/File;", "intellij.c.clangd"})
public final class ClangdDumpIndexerCDB
extends ClangdIndexerCDB {
    public ClangdDumpIndexerCDB() {
        super(null);
    }

    @Override
    public void onCDBReady(@NotNull Project project, @NotNull String jsonCDB, @NotNull Map<String, String> macros2File) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)jsonCDB, (String)"jsonCDB");
            Intrinsics.checkNotNullParameter(macros2File, (String)"macros2File");
            Map file2Content = new LinkedHashMap();
            file2Content.put("compile_commands.json", jsonCDB);
            for (Map.Entry<String, String> entry : macros2File.entrySet()) {
                String content = entry.getKey();
                String fileName = entry.getValue();
                file2Content.put(fileName, content);
            }
            File file = this.getSavePath(project);
            if (file == null) break block1;
            File it = file;
            boolean bl = false;
            byte[] byArray = ClangReportUtils.makeZipArchive(file2Content);
            Intrinsics.checkNotNull((Object)byArray);
            byte[] zipBytes = byArray;
            FileUtil.writeToFile((File)it, (byte[])zipBytes);
        }
    }

    private final File getSavePath(Project project) {
        VirtualFileWrapper saved;
        VirtualFileWrapper virtualFileWrapper = saved = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Save CDB", "Save CDB", new String[0]), project).save("compile_commands.zip");
        return virtualFileWrapper != null ? virtualFileWrapper.getFile() : null;
    }
}

