/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.CustomRequest;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\f0\u000b\"\u0004\b\u0000\u0010\fJ\u001e\u0010\r\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H\f\u0018\u00010\t\"\u0004\b\u0000\u0010\f2\u0006\u0010\u000e\u001a\u00020\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangCustomRequestsManager;", "", "<init>", "()V", "idGenerator", "Ljava/util/concurrent/atomic/AtomicInteger;", "responses", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/concurrent/CompletableFuture;", "newRequest", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/CustomRequest;", "T", "takeResponse", "id", "completeAllRequestsOnCrash", "", "toString", "", "intellij.c.clangd"})
public final class ClangCustomRequestsManager {
    @NotNull
    private final AtomicInteger idGenerator = new AtomicInteger(0);
    @NotNull
    private final ConcurrentHashMap<Integer, CompletableFuture<Object>> responses = new ConcurrentHashMap();

    @NotNull
    public final <T> CustomRequest<T> newRequest() {
        int id = this.idGenerator.incrementAndGet();
        CompletableFuture response = new CompletableFuture();
        CustomRequest request = new CustomRequest(id, response);
        Integer n = id;
        ((Map)this.responses).put(n, response);
        return request;
    }

    @Nullable
    public final <T> CompletableFuture<T> takeResponse(int id) {
        CompletableFuture<Object> completableFuture = this.responses.remove(id);
        return completableFuture instanceof CompletableFuture ? completableFuture : null;
    }

    public final void completeAllRequestsOnCrash() {
        Iterator<CompletableFuture<Object>> iterator = this.responses.values().iterator();
        while (iterator.hasNext()) {
            CompletableFuture<Object> response;
            Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
            response.complete(null);
        }
    }

    @NotNull
    public String toString() {
        return "ClangCustomRequestsManager(idGenerator=" + this.idGenerator + ", number of stored responses=" + this.responses.size() + ")";
    }
}

