/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.inspections;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.options.OptDropdown;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.inspections.ClangdMeasureResolveInspectionKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIndexerCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangLanguageServiceUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdIndexerService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.IndexerState;
import com.jetbrains.cidr.lang.tests.ClangdTestUtilBase;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001)B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J0\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\b\u0010'\u001a\u00020(H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/inspections/ClangdMeasureResolveInspection;", "Lcom/intellij/codeInspection/GlobalInspectionTool;", "<init>", "()V", "isEnabled", "", "ROOTS", "", "indexingStrategy", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/inspections/ClangdMeasureResolveInspection$IndexingStrategy;", "threadNumber", "", "customScopePath", "getGroupDisplayName", "getDisplayName", "getStaticDescription", "isReadActionNeeded", "isEnabledByDefault", "isGraphNeeded", "runInspection", "", "scope", "Lcom/intellij/analysis/AnalysisScope;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "globalContext", "Lcom/intellij/codeInspection/GlobalInspectionContext;", "problemDescriptionsProcessor", "Lcom/intellij/codeInspection/ProblemDescriptionsProcessor;", "measure", "service", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangdIndexerService;", "scopeFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "logResultsPath", "Ljava/nio/file/Path;", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "IndexingStrategy", "intellij.c.clangd"})
@SourceDebugExtension(value={"SMAP\nClangdMeasureResolveInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangdMeasureResolveInspection.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/inspections/ClangdMeasureResolveInspection\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,321:1\n18#2,4:322\n50#2,7:326\n*S KotlinDebug\n*F\n+ 1 ClangdMeasureResolveInspection.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/inspections/ClangdMeasureResolveInspection\n*L\n182#1:322,4\n182#1:326,7\n*E\n"})
public final class ClangdMeasureResolveInspection
extends GlobalInspectionTool {
    private final boolean isEnabled = Intrinsics.areEqual((Object)System.getProperty("clangd.measurement.enabled", "false"), (Object)"true");
    @NotNull
    private final String ROOTS;
    @NotNull
    private IndexingStrategy indexingStrategy = IndexingStrategy.LightModules;
    private int threadNumber = 16;
    @NotNull
    private String customScopePath = "";

    public ClangdMeasureResolveInspection() {
        this.ROOTS = "ROOTS";
    }

    @NotNull
    public String getGroupDisplayName() {
        return "Clangd Inspections";
    }

    @NotNull
    public String getDisplayName() {
        return "Measure resolve via clangd-indexer";
    }

    @NotNull
    public String getStaticDescription() {
        return "Measures time needed to parse all files in the given scope";
    }

    public boolean isReadActionNeeded() {
        return false;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    public boolean isGraphNeeded() {
        return false;
    }

    public void runInspection(@NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)globalContext, (String)"globalContext");
        Intrinsics.checkNotNullParameter((Object)problemDescriptionsProcessor, (String)"problemDescriptionsProcessor");
        if (!this.isEnabled) {
            ClangdMeasureResolveInspectionKt.access$getLog$p().warn(((Object)((Object)this)).getClass().getSimpleName() + " is disabled by default. Forgot to add -Dclangd.measurement.enabled=true to the VM options?");
            return;
        }
        String commandIndexingStrategy = System.getProperty("clangd.measurement.indexing.strategy", "");
        boolean commandUseRootsScope = Intrinsics.areEqual((Object)System.getProperty("clangd.measurement.use.roots.scope", "false"), (Object)"true");
        String string = System.getProperty("clangd.measurement.log.results.dir", "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String commandLogResultsDirectory = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String string2 = System.getProperty("clangd.measurement.log.results.name", "");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        String commandLogResultsName = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (!StringsKt.isBlank((CharSequence)commandLogResultsDirectory) && !StringsKt.isBlank((CharSequence)commandLogResultsName)) {
            Path path2 = Paths.get(commandLogResultsDirectory, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            Path path3 = path2.resolve(commandLogResultsName);
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        } else {
            path = null;
        }
        Path commandLogResultsPath = path;
        Intrinsics.checkNotNull((Object)commandIndexingStrategy);
        if (!StringsKt.isBlank((CharSequence)commandIndexingStrategy)) {
            this.indexingStrategy = IndexingStrategy.valueOf(commandIndexingStrategy);
        }
        if (commandUseRootsScope) {
            this.customScopePath = this.ROOTS;
        }
        List scopeFiles = null;
        if (StringsKt.isBlank((CharSequence)this.customScopePath)) {
            CommonProcessors.CollectProcessor<VirtualFile> collector2 = new CommonProcessors.CollectProcessor<VirtualFile>(globalContext){
                final /* synthetic */ GlobalInspectionContext $globalContext;
                {
                    this.$globalContext = $globalContext;
                }

                protected boolean accept(VirtualFile file) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    return ClangdBridge.isSourceFile(this.$globalContext.getProject(), file) || ClangdBridge.isHeaderFile(this.$globalContext.getProject(), file);
                }
            };
            scope.accept((Processor)collector2);
            Collection collection = collector2.getResults();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getResults(...)");
            scopeFiles = CollectionsKt.toList((Iterable)collection);
        } else if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)this.customScopePath)).toString(), (Object)this.ROOTS)) {
            Set<VirtualFile> set = ClangLanguageServiceUtils.getProjectRoots(globalContext.getProject());
            Intrinsics.checkNotNullExpressionValue(set, (String)"getProjectRoots(...)");
            scopeFiles = CollectionsKt.toList((Iterable)set);
        } else {
            ArrayList targetFiles = new ArrayList();
            FilesKt.forEachLine$default((File)new File(this.customScopePath), null, arg_0 -> ClangdMeasureResolveInspection.runInspection$lambda$2(targetFiles, arg_0), (int)1, null);
            scopeFiles = targetFiles;
        }
        Project project = globalContext.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ClangdMeasureResolveInspectionKt.access$withTempIndexer(project, arg_0 -> ClangdMeasureResolveInspection.runInspection$lambda$3(this, scopeFiles, globalContext, commandLogResultsPath, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void measure(ClangdIndexerService service, List<? extends VirtualFile> scopeFiles, Project project, Path logResultsPath) {
        block14: {
            Notifications.Bus.notify((Notification)new Notification(((Object)((Object)this)).getClass().getSimpleName(), "Measurement started", "Indexer pid: " + service.getServerPid(), NotificationType.WARNING), (Project)project);
            ClangdMeasureResolveInspectionKt.access$executeCommandAndWait(service, ClangIndexerCommand.Companion.getCANCEL());
            service.waitUntilIdle(Duration.toInt-impl((long)DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.MINUTES), (DurationUnit)DurationUnit.MILLISECONDS));
            ClangdMeasureResolveInspectionKt.access$executeCommandAndWait(service, ClangIndexerCommand.Companion.SET_PP_THREADS(this.threadNumber));
            ClangdMeasureResolveInspectionKt.access$executeCommandAndWait(service, ClangIndexerCommand.Companion.SET_INDEXING_THREADS(this.threadNumber));
            ClangdMeasureResolveInspectionKt.access$executeCommandAndWait(service, ClangIndexerCommand.Companion.SET_INDEXING_STRATEGY(this.indexingStrategy.getOption()));
            ClangdMeasureResolveInspectionKt.access$executeCommandAndWait(service, ClangIndexerCommand.Companion.getCLEAR_CACHES());
            ClangdMeasureResolveInspectionKt.access$executeCommandAndWait(service, ClangIndexerCommand.Companion.getCLEAR_STATE());
            CompletableFuture<String> completableFuture = service.requestServerState();
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"requestServerState(...)");
            String state = (String)CidrConcurrentUtilsKt.waitCancelAware((Future)completableFuture, (long)Duration.toLong-impl((long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), (DurationUnit)DurationUnit.MILLISECONDS), (String)"requestServerState");
            ClangdMeasureResolveInspectionKt.access$getLog$p().info(state);
            CompletableFuture started = new CompletableFuture();
            Consumer<IndexerState> startedListener = arg_0 -> ClangdMeasureResolveInspection.measure$lambda$4(started, arg_0);
            service.addStateListener(startedListener);
            CompletableFuture finished = new CompletableFuture();
            Consumer<IndexerState> finishedListener = arg_0 -> ClangdMeasureResolveInspection.measure$lambda$5(started, finished, arg_0);
            service.addStateListener(finishedListener);
            try {
                if (this.indexingStrategy == IndexingStrategy.NoModules) {
                    ClangdMeasureResolveInspectionKt.access$executeCommandAndWait(service, ClangIndexerCommand.Companion.INDEX(scopeFiles));
                } else {
                    ClangdMeasureResolveInspectionKt.access$executeCommandAndWait(service, ClangIndexerCommand.Companion.UPDATE(scopeFiles));
                }
                CidrConcurrentUtilsKt.waitCancelAware((Future)started, (long)Duration.toLong-impl((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), (DurationUnit)DurationUnit.MILLISECONDS), (String)"indexer to start the update");
                boolean $i$f$measureTime = false;
                TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
                boolean $i$f$measureTime2 = false;
                long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
                boolean bl = false;
                CidrConcurrentUtilsKt.waitCancelAware((Future)finished, (long)Duration.toLong-impl((long)DurationKt.toDuration((int)15, (DurationUnit)DurationUnit.MINUTES), (DurationUnit)DurationUnit.MILLISECONDS), (String)"indexer to finish the update");
                long totalTime = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
                long totalMemory = service.getMemoryUsageWatchDog().getUsedMaxMemory();
                String measurements = "TotalTime = " + Duration.toLong-impl((long)totalTime, (DurationUnit)DurationUnit.SECONDS) + "s\nTotalMemory = " + totalMemory / (long)1024 / (long)1024 + " MB";
                ClangdMeasureResolveInspectionKt.access$getLog$p().info(((Object)((Object)this)).getClass().getSimpleName() + ": " + measurements);
                Notifications.Bus.notify((Notification)new Notification(((Object)((Object)this)).getClass().getSimpleName(), "Measurement " + (service.hadCrashes() ? "failed" : "finished"), StringsKt.replace$default((String)measurements, (String)"\n", (String)"<br/>", (boolean)false, (int)4, null), NotificationType.WARNING), (Project)project);
                if (logResultsPath == null) break block14;
                Closeable closeable = new FileWriter(logResultsPath.toFile());
                Throwable throwable = null;
                try {
                    FileWriter resultsWriter = (FileWriter)closeable;
                    boolean bl2 = false;
                    resultsWriter.write("TotalTime = " + Duration.toLong-impl((long)totalTime, (DurationUnit)DurationUnit.SECONDS) + "\n");
                    resultsWriter.write("TotalMemory = " + totalMemory + "\n");
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (TimeoutException ex) {
                Object object;
                String[] stringArray = this;
                try {
                    ClangdMeasureResolveInspection $this$measure_u24lambda_u248 = stringArray;
                    boolean bl = false;
                    CompletableFuture<String> completableFuture2 = service.requestServerState();
                    Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"requestServerState(...)");
                    object = Result.constructor-impl((Object)((String)CidrConcurrentUtilsKt.waitCancelAware((Future)completableFuture2, (long)Duration.toLong-impl((long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), (DurationUnit)DurationUnit.MILLISECONDS), (String)"requestServerState")));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                stringArray = object;
                object = "failed to get state";
                String timeoutState = (String)(Result.isFailure-impl((Object)stringArray) ? object : stringArray);
                ClangdMeasureResolveInspectionKt.access$getLog$p().warn("Timeout state:\n" + timeoutState);
                stringArray = new String[]{ClangdTestUtilBase.Companion.dumpThreads(service)};
                ClangdMeasureResolveInspectionKt.access$getLog$p().error(ex.getMessage(), stringArray);
            }
            finally {
                service.removeStateListener(startedListener);
                service.removeStateListener(finishedListener);
            }
        }
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[3];
        optRegularComponentArray[0] = OptPane.number((String)"threadNumber", (String)"Thread number", (int)1, (int)Runtime.getRuntime().availableProcessors());
        OptDropdown.Option[] optionArray = new OptDropdown.Option[]{OptPane.option((Enum)IndexingStrategy.NoModules, (String)"No modules"), OptPane.option((Enum)IndexingStrategy.LightModules, (String)"Light modules"), OptPane.option((Enum)IndexingStrategy.Modules, (String)"Modules")};
        optRegularComponentArray[1] = OptPane.dropdown((String)"indexingStrategy", (String)"Indexing strategy", (OptDropdown.Option[])optionArray);
        optRegularComponentArray[2] = OptPane.string((String)"customScopePath", (String)"Scope file", (StringValidator)StringValidator.of((String)"customScopeValidator", arg_0 -> ClangdMeasureResolveInspection.getOptionsPane$lambda$9(this, arg_0)));
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    private static final Unit runInspection$lambda$2(ArrayList $targetFiles, String line) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            char[] cArray = new char[]{';'};
            List targetAndEntry = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (targetAndEntry.size() != 2) break block2;
            Path path = NioPathUtil.toNioPathOrNull((String)((String)CollectionsKt.first((List)targetAndEntry)));
            if (path != null) {
                Path path2;
                Path path3 = path2 = path;
                boolean bl = false;
                VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByNioPath(path3);
                if (virtualFile != null) {
                    VirtualFile virtualFile2;
                    VirtualFile it = virtualFile2 = virtualFile;
                    boolean bl2 = false;
                    $targetFiles.add(it);
                }
            }
        }
        return Unit.INSTANCE;
    }

    private static final void runInspection$lambda$3(ClangdMeasureResolveInspection this$0, List $scopeFiles, GlobalInspectionContext $globalContext, Path $commandLogResultsPath, ClangdIndexerService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Project project = $globalContext.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this$0.measure(service, $scopeFiles, project, $commandLogResultsPath);
    }

    private static final void measure$lambda$4(CompletableFuture $started, IndexerState it) {
        if (it == IndexerState.Working) {
            $started.complete(true);
        }
    }

    private static final void measure$lambda$5(CompletableFuture $started, CompletableFuture $finished, IndexerState it) {
        if (it == IndexerState.Idle && $started.isDone()) {
            $finished.complete(true);
        }
    }

    private static final String getOptionsPane$lambda$9(ClangdMeasureResolveInspection this$0, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return StringsKt.isBlank((CharSequence)value) ? null : (Intrinsics.areEqual((Object)value, (Object)this$0.ROOTS) ? null : (new File(value).exists() ? null : "Should be either a path to a target-entry input file or the \"" + this$0.ROOTS + "\" constant"));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bj\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/inspections/ClangdMeasureResolveInspection$IndexingStrategy;", "", "<init>", "(Ljava/lang/String;I)V", "NoModules", "LightModules", "Modules", "getOption", "", "intellij.c.clangd"})
    public static final class IndexingStrategy
    extends Enum<IndexingStrategy> {
        public static final /* enum */ IndexingStrategy NoModules = new IndexingStrategy();
        public static final /* enum */ IndexingStrategy LightModules = new IndexingStrategy();
        public static final /* enum */ IndexingStrategy Modules = new IndexingStrategy();
        private static final /* synthetic */ IndexingStrategy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public final String getOption() {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                case 1 -> "no-modules";
                case 2 -> "light-modules";
                default -> "modules";
            };
        }

        public static IndexingStrategy[] values() {
            return (IndexingStrategy[])$VALUES.clone();
        }

        public static IndexingStrategy valueOf(String value) {
            return Enum.valueOf(IndexingStrategy.class, value);
        }

        @NotNull
        public static EnumEntries<IndexingStrategy> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = indexingStrategyArray = new IndexingStrategy[]{IndexingStrategy.NoModules, IndexingStrategy.LightModules, IndexingStrategy.Modules};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[IndexingStrategy.values().length];
                try {
                    nArray[IndexingStrategy.NoModules.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[IndexingStrategy.LightModules.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

