/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.intellij.openapi.vfs.VfsUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.FileInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ParsedLocation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ClangdLocationParser;", "", "urlConverter", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangUrlConverter;", "<init>", "(Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangUrlConverter;)V", "getUrlConverter", "()Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangUrlConverter;", "retrieveLocation", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/ParsedLocation;", "text", "", "rangeInSameLineRe", "Lkotlin/text/Regex;", "rangeSpanningMultipleLinesRe", "lineColWithMode", "getFileInfo", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/FileInfo;", "path", "parseRangeInLine", "parseRangeMultipleLines", "parseRangeWithMode", "extractLocation", "intellij.c.clangd"})
public final class ClangdLocationParser {
    @Nullable
    private final ClangUrlConverter urlConverter;
    @NotNull
    private final Regex rangeInSameLineRe;
    @NotNull
    private final Regex rangeSpanningMultipleLinesRe;
    @NotNull
    private final Regex lineColWithMode;

    public ClangdLocationParser(@Nullable ClangUrlConverter urlConverter) {
        this.urlConverter = urlConverter;
        this.rangeInSameLineRe = new Regex("<?(.*?):([0-9]+):([0-9]+), col:([0-9]+)>?(\\$(.*))?");
        this.rangeSpanningMultipleLinesRe = new Regex("<?(.*?):([0-9]+):([0-9]+), line:([0-9]+):([0-9]+)>?(\\$(.*))?");
        this.lineColWithMode = new Regex("<?(.*?):([0-9]+):([0-9]+)(:(.*))?.*");
    }

    @Nullable
    public final ClangUrlConverter getUrlConverter() {
        return this.urlConverter;
    }

    @Nullable
    public final ParsedLocation retrieveLocation(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (StringsKt.isBlank((CharSequence)text)) {
            return null;
        }
        String expansionTag = " <Spelling=";
        int expansionStart = StringsKt.indexOf$default((CharSequence)text, (String)expansionTag, (int)0, (boolean)false, (int)6, null);
        int expansionEnd = StringsKt.indexOf$default((CharSequence)text, (char)'>', (int)(expansionStart + 1), (boolean)false, (int)4, null);
        ParsedLocation loc1 = null;
        ParsedLocation loc2 = null;
        if (expansionStart != -1 && expansionEnd != -1) {
            String string = text.substring(expansionStart + expansionTag.length(), expansionEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String expansion = string;
            String string2 = text;
            int n = expansionEnd + 1;
            loc1 = this.extractLocation(((Object)StringsKt.removeRange((CharSequence)string2, (int)expansionStart, (int)n)).toString());
            loc2 = this.extractLocation(expansion);
        } else {
            loc1 = this.extractLocation(text);
        }
        return loc1 != null && (loc2 == null || loc1.getLine1() > loc2.getLine1() || loc1.getLine1() == loc2.getLine1() && loc1.getCol1() > loc2.getCol1() || !Intrinsics.areEqual((Object)loc1.getFileInfo().getFilePath(), (Object)loc2.getFileInfo().getFilePath())) ? loc1 : loc2;
    }

    private final FileInfo getFileInfo(String path) {
        String string = this.urlConverter != null && this.urlConverter.isWslMode() ? this.urlConverter.fromWslPath(path) : path;
        Intrinsics.checkNotNull((Object)string);
        String filePath = string;
        try {
            return new FileInfo(filePath, VfsUtil.findFile((Path)Paths.get(filePath, new String[0]), (boolean)true));
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    private final ParsedLocation parseRangeInLine(String text) {
        MatchResult matchResult = this.rangeInSameLineRe.matchEntire((CharSequence)text);
        if (matchResult == null || (matchResult = matchResult.getDestructured()) == null) {
            return null;
        }
        MatchResult matchResult2 = matchResult;
        String fp = (String)matchResult2.getMatch().getGroupValues().get(1);
        String l1 = (String)matchResult2.getMatch().getGroupValues().get(2);
        String c1 = (String)matchResult2.getMatch().getGroupValues().get(3);
        String c2 = (String)matchResult2.getMatch().getGroupValues().get(4);
        String m = (String)matchResult2.getMatch().getGroupValues().get(6);
        FileInfo fileInfo = this.getFileInfo(fp);
        if (fileInfo == null) {
            return null;
        }
        FileInfo fileInfo2 = fileInfo;
        return new ParsedLocation(fileInfo2, Integer.parseInt(l1), Integer.parseInt(l1), Integer.parseInt(c1), Integer.parseInt(c2), m);
    }

    private final ParsedLocation parseRangeMultipleLines(String text) {
        MatchResult matchResult = this.rangeSpanningMultipleLinesRe.matchEntire((CharSequence)text);
        if (matchResult == null || (matchResult = matchResult.getDestructured()) == null) {
            return null;
        }
        MatchResult matchResult2 = matchResult;
        String fp = (String)matchResult2.getMatch().getGroupValues().get(1);
        String l1 = (String)matchResult2.getMatch().getGroupValues().get(2);
        String c1 = (String)matchResult2.getMatch().getGroupValues().get(3);
        String l2 = (String)matchResult2.getMatch().getGroupValues().get(4);
        String c2 = (String)matchResult2.getMatch().getGroupValues().get(5);
        String m = (String)matchResult2.getMatch().getGroupValues().get(7);
        FileInfo fileInfo = this.getFileInfo(fp);
        if (fileInfo == null) {
            return null;
        }
        FileInfo fileInfo2 = fileInfo;
        return new ParsedLocation(fileInfo2, Integer.parseInt(l1), Integer.parseInt(l2), Integer.parseInt(c1), Integer.parseInt(c2), m);
    }

    private final ParsedLocation parseRangeWithMode(String text) {
        MatchResult matchResult = this.lineColWithMode.matchEntire((CharSequence)text);
        if (matchResult == null || (matchResult = matchResult.getDestructured()) == null) {
            return null;
        }
        MatchResult matchResult2 = matchResult;
        String fp = (String)matchResult2.getMatch().getGroupValues().get(1);
        String l1 = (String)matchResult2.getMatch().getGroupValues().get(2);
        String c1 = (String)matchResult2.getMatch().getGroupValues().get(3);
        String m = (String)matchResult2.getMatch().getGroupValues().get(5);
        FileInfo fileInfo = this.getFileInfo(fp);
        if (fileInfo == null) {
            return null;
        }
        FileInfo fileInfo2 = fileInfo;
        return new ParsedLocation(fileInfo2, Integer.parseInt(l1), Integer.parseInt(l1), Integer.parseInt(c1), Integer.parseInt(c1), m);
    }

    private final ParsedLocation extractLocation(String text) {
        ParsedLocation parsedLocation = this.parseRangeInLine(text);
        if (parsedLocation == null && (parsedLocation = this.parseRangeMultipleLines(text)) == null) {
            parsedLocation = this.parseRangeWithMode(text);
        }
        return parsedLocation;
    }
}

