/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Obfuscator;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Trustworthiness;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ClangdBridgeInterface {
    public static final ExtensionPointName<ClangdBridgeInterface> EP_NAME = ExtensionPointName.create((String)"clangd.clangdBridge");

    public boolean isClangdOnlyMode();

    public boolean isClangdKindSupported(@NotNull ClangLanguageService.Kind var1);

    default public int getNumberOfASTsToKeep() {
        return EditorWindow.getTabLimit();
    }

    public void registerAnnotatorPassFactories(@NotNull TextEditorHighlightingPassRegistrar var1, int var2, int var3);

    @NotNull
    public List<FileExtensionPair> getFileExtensions(@NotNull Project var1);

    public boolean isSupported(@NotNull VirtualFile var1);

    public boolean isClangdShowErrors(@NotNull Project var1, @Nullable VirtualFile var2);

    @NotNull
    public List<ClangDiagnostic> filterDiagnostics(@NotNull PsiFile var1, @NotNull Trustworthiness var2, @NotNull List<ClangDiagnostic> var3);

    public boolean isSourceFile(@NotNull VirtualFile var1);

    public boolean isHeaderFile(@NotNull VirtualFile var1);

    public boolean getParameterHints(@NotNull Project var1);

    public void setParameterHints(@NotNull Project var1, boolean var2);

    default public boolean getParameterInfo() {
        return true;
    }

    default public boolean getNavigation() {
        return true;
    }

    default public boolean getClangErrorsAndWarnings() {
        return true;
    }

    default public boolean getCompletion() {
        return true;
    }

    default public boolean getMatchPP() {
        return true;
    }

    @NotNull
    public Class<? extends OCInspectionBase> getClazyInspection();

    @Nullable
    public Class<? extends OCInspectionBase> getUnusedIncludesInspection();

    public boolean isInProjectSourcesOrLibraries(@NotNull Project var1, @NotNull VirtualFile var2);

    @NotNull
    public List<SuppressIntentionAction> createSuppressActions(@NotNull PsiFile var1, @NotNull TextRange var2, @NotNull String var3);

    @NotNull
    public ClangIdeFacade createClangIdeFacade(@NotNull @NonNls String var1, @NotNull ClangLanguageService.Kind var2);

    @NotNull
    public Obfuscator createObfuscator();
}

