/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridgeInterface;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIndexerIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Obfuscator;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Trustworthiness;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangdBridge {
    public static final Key<Object> CLANG_CAN_OPEN_FILE = Key.create((String)"ClangCanOpenFileOnResolve");
    public static final Key<Object> CLANG_DONT_CLOSE_FILE = Key.create((String)"ClangDontCloseFileIfOpenedForResolve");
    public static final Key<Boolean> CLANGD_SHOW_ERRORS_ON = Key.create((String)"CLANGD_SHOW_ERRORS_ON");

    public static boolean isClangdOnlyMode() {
        ClangdBridgeInterface bridge = ClangdBridge.getBridge();
        if (bridge != null) {
            return bridge.isClangdOnlyMode();
        }
        return true;
    }

    public static boolean isClangdKindSupported(@NotNull @NotNull @NotNull ClangLanguageService.Kind kind) {
        ClangdBridgeInterface bridge;
        if (kind == null) {
            ClangdBridge.$$$reportNull$$$0(0);
        }
        if ((bridge = ClangdBridge.getBridge()) != null) {
            return bridge.isClangdKindSupported(kind);
        }
        return true;
    }

    public static int getNumberOfASTsToKeep() {
        ClangdBridgeInterface bridge = ClangdBridge.getBridge();
        if (bridge != null) {
            return bridge.getNumberOfASTsToKeep();
        }
        return EditorWindow.getTabLimit();
    }

    public static void registerAnnotatorPassFactories(@NotNull TextEditorHighlightingPassRegistrar registrar, int reparsingPassId, int clangErrorsPassId) {
        ClangdBridgeInterface bridge;
        if (registrar == null) {
            ClangdBridge.$$$reportNull$$$0(1);
        }
        if ((bridge = ClangdBridge.getBridge()) != null) {
            bridge.registerAnnotatorPassFactories(registrar, reparsingPassId, clangErrorsPassId);
        }
    }

    @NotNull
    public static List<FileExtensionPair> getFileExtensions(@NotNull Project project) {
        ClangdBridgeInterface bridge;
        if (project == null) {
            ClangdBridge.$$$reportNull$$$0(2);
        }
        if ((bridge = ClangdBridge.getBridge()) != null) {
            List<FileExtensionPair> list = bridge.getFileExtensions(project);
            if (list == null) {
                ClangdBridge.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<FileExtensionPair> list = CommonClangTidyUtil.getDefaultFileExtensions();
        if (list == null) {
            ClangdBridge.$$$reportNull$$$0(4);
        }
        return list;
    }

    public static boolean isSupported(@NotNull Project project, @Nullable VirtualFile vf) {
        if (project == null) {
            ClangdBridge.$$$reportNull$$$0(5);
        }
        if (vf == null) {
            return false;
        }
        ClangdBridgeInterface bridge = ClangdBridge.getBridge();
        if (bridge != null) {
            return bridge.isSupported(vf);
        }
        if (!(vf instanceof VirtualFileWithId)) {
            return false;
        }
        String ext = vf.getExtension();
        if (ext != null) {
            for (FileExtensionPair extPair : ClangdBridge.getFileExtensions(project)) {
                if (!ext.equalsIgnoreCase(extPair.mySourceExt) && !ext.equalsIgnoreCase(extPair.myHeaderExt)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isClangdShowErrors(@NotNull Project project, @Nullable VirtualFile vf) {
        if (project == null) {
            ClangdBridge.$$$reportNull$$$0(6);
        }
        if (ClangUtils.hasKey(CLANGD_SHOW_ERRORS_ON, project)) {
            return ClangUtils.getKey(CLANGD_SHOW_ERRORS_ON, project);
        }
        ClangdBridgeInterface bridge = ClangdBridge.getBridge();
        if (bridge != null) {
            return bridge.isClangdShowErrors(project, vf);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project);
        return settings != null && settings.isClangdShowErrors();
    }

    @NotNull
    public static List<ClangDiagnostic> filterDiagnostics(@NotNull PsiFile file, @NotNull Trustworthiness trustworthiness, @NotNull List<ClangDiagnostic> diags) {
        ClangdBridgeInterface bridge;
        if (file == null) {
            ClangdBridge.$$$reportNull$$$0(7);
        }
        if (trustworthiness == null) {
            ClangdBridge.$$$reportNull$$$0(8);
        }
        if (diags == null) {
            ClangdBridge.$$$reportNull$$$0(9);
        }
        if ((bridge = ClangdBridge.getBridge()) != null) {
            List<ClangDiagnostic> list = bridge.filterDiagnostics(file, trustworthiness, diags);
            if (list == null) {
                ClangdBridge.$$$reportNull$$$0(10);
            }
            return list;
        }
        List<ClangDiagnostic> list = diags;
        if (list == null) {
            ClangdBridge.$$$reportNull$$$0(11);
        }
        return list;
    }

    public static boolean isSourceFile(@NotNull Project project, @NotNull VirtualFile vf) {
        Iterator iterator;
        if (project == null) {
            ClangdBridge.$$$reportNull$$$0(12);
        }
        if (vf == null) {
            ClangdBridge.$$$reportNull$$$0(13);
        }
        if ((iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator()).hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.isSourceFile(vf);
        }
        String ext = vf.getExtension();
        if (ext != null) {
            for (FileExtensionPair extPair : ClangdBridge.getFileExtensions(project)) {
                if (!ext.equalsIgnoreCase(extPair.mySourceExt)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isHeaderFile(@NotNull Project project, @NotNull VirtualFile vf) {
        ClangdBridgeInterface bridge;
        if (project == null) {
            ClangdBridge.$$$reportNull$$$0(14);
        }
        if (vf == null) {
            ClangdBridge.$$$reportNull$$$0(15);
        }
        if ((bridge = ClangdBridge.getBridge()) != null) {
            return bridge.isHeaderFile(vf);
        }
        String ext = vf.getExtension();
        if (ext != null) {
            for (FileExtensionPair extPair : ClangdBridge.getFileExtensions(project)) {
                if (!ext.equalsIgnoreCase(extPair.myHeaderExt)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean getParameterHints(@NotNull Project project) {
        Iterator iterator;
        if (project == null) {
            ClangdBridge.$$$reportNull$$$0(16);
        }
        if ((iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator()).hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.getParameterHints(project);
        }
        return false;
    }

    public static void setParameterHints(@NotNull Project project, boolean enabled) {
        if (project == null) {
            ClangdBridge.$$$reportNull$$$0(17);
        }
        for (ClangdBridgeInterface bridge : ClangdBridgeInterface.EP_NAME.getExtensionList()) {
            bridge.setParameterHints(project, enabled);
        }
    }

    public static boolean getParameterInfo() {
        Iterator iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator();
        if (iterator.hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.getParameterInfo();
        }
        return false;
    }

    public static boolean getNavigation() {
        Iterator iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator();
        if (iterator.hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.getNavigation();
        }
        return false;
    }

    public static boolean getClangErrorsAndWarnings() {
        Iterator iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator();
        if (iterator.hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.getClangErrorsAndWarnings();
        }
        return false;
    }

    public static boolean getCompletion() {
        Iterator iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator();
        if (iterator.hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.getCompletion();
        }
        return false;
    }

    @Nullable
    public static Class<? extends OCInspectionBase> getClazyInspection() {
        Iterator iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator();
        if (iterator.hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.getClazyInspection();
        }
        return null;
    }

    @Nullable
    public static Class<? extends OCInspectionBase> getUnusedIncludesInspection() {
        for (ClangdBridgeInterface bridge : ClangdBridgeInterface.EP_NAME.getExtensionList()) {
            Class<? extends OCInspectionBase> inspection = bridge.getUnusedIncludesInspection();
            if (inspection == null) continue;
            return inspection;
        }
        return null;
    }

    public static boolean getMatchPP() {
        Iterator iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator();
        if (iterator.hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.getMatchPP();
        }
        return false;
    }

    public static boolean isInProjectSourcesOrLibraries(@NotNull Project project, @NotNull VirtualFile vf) {
        Iterator iterator;
        if (project == null) {
            ClangdBridge.$$$reportNull$$$0(18);
        }
        if (vf == null) {
            ClangdBridge.$$$reportNull$$$0(19);
        }
        if ((iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator()).hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.isInProjectSourcesOrLibraries(project, vf);
        }
        return true;
    }

    @NotNull
    public static List<SuppressIntentionAction> createSuppressActions(@NotNull PsiFile psiFile, @NotNull TextRange range, @NotNull String warningName) {
        Iterator iterator;
        if (psiFile == null) {
            ClangdBridge.$$$reportNull$$$0(20);
        }
        if (range == null) {
            ClangdBridge.$$$reportNull$$$0(21);
        }
        if (warningName == null) {
            ClangdBridge.$$$reportNull$$$0(22);
        }
        if ((iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator()).hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            List<SuppressIntentionAction> list = bridge.createSuppressActions(psiFile, range, warningName);
            if (list == null) {
                ClangdBridge.$$$reportNull$$$0(23);
            }
            return list;
        }
        List<SuppressIntentionAction> list = Collections.emptyList();
        if (list == null) {
            ClangdBridge.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    public static ClangIdeFacade createClangIdeFacade(@NotNull @NonNls String descriptor, @NotNull ClangLanguageService.Kind forKind) {
        Iterator iterator;
        if (descriptor == null) {
            ClangdBridge.$$$reportNull$$$0(25);
        }
        if (forKind == null) {
            ClangdBridge.$$$reportNull$$$0(26);
        }
        if ((iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator()).hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            ClangIdeFacade clangIdeFacade = bridge.createClangIdeFacade(descriptor, forKind);
            if (clangIdeFacade == null) {
                ClangdBridge.$$$reportNull$$$0(27);
            }
            return clangIdeFacade;
        }
        return forKind.isIndexer() ? new ClangIndexerIdeFacadeImpl(descriptor) : new ClangIdeFacadeImpl(descriptor);
    }

    @Nullable
    public static Obfuscator getObfuscator() {
        Iterator iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator();
        if (iterator.hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge.createObfuscator();
        }
        return null;
    }

    @Nullable
    private static ClangdBridgeInterface getBridge() {
        Iterator iterator = ClangdBridgeInterface.EP_NAME.getExtensionList().iterator();
        if (iterator.hasNext()) {
            ClangdBridgeInterface bridge = (ClangdBridgeInterface)iterator.next();
            return bridge;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 10, 11, 23, 24, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 23: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangdBridge";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trustworthiness";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diags";
                break;
            }
            case 13: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warningName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangdBridge";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileExtensions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDiagnostics";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuppressActions";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createClangIdeFacade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isClangdKindSupported";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerAnnotatorPassFactories";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileExtensions";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 23: 
            case 24: 
            case 27: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isClangdShowErrors";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterDiagnostics";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isSourceFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isHeaderFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getParameterHints";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setParameterHints";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isInProjectSourcesOrLibraries";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createSuppressActions";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createClangIdeFacade";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 10, 11, 23, 24, 27 -> new IllegalStateException(string);
        };
    }
}

