/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.utils;

import com.intellij.rml.dfa.impl.ui.Messages;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;

public class ArrayHelper {
    public static <T> T[] deleteElement(T[] array, int index, Class<T> type) {
        Object[] result = ArrayUtil.newArray(type, (int)(array.length - 1));
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index + 1, result, index, array.length - index - 1);
        return result;
    }

    public static <T> T[] deleteElement(T[] array, T element, Class<T> type) {
        Object[] result = ArrayUtil.newArray(type, (int)(array.length - 1));
        int index = ArrayUtil.indexOf((Object[])array, element);
        if (index == -1) {
            throw new IllegalArgumentException(Messages.getString(ArrayHelper.class.getName() + "-0"));
        }
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index + 1, result, index, array.length - index - 1);
        return result;
    }

    public static <T> T[] mergeArrays(T[] array1, T[] array2, Class<T> type) {
        Object[] result = ArrayUtil.newArray(type, (int)(array1.length + array2.length));
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    public static <T> T[] uniteArrays(T[] array1, T[] array2, Class<T> type) {
        LinkedHashSet set = new LinkedHashSet(array1.length + array2.length);
        Collections.addAll(set, array1);
        Collections.addAll(set, array2);
        return ArrayUtil.toObjectArray(set, type);
    }

    public static <T> boolean setEqual(T[] array1, T[] array2) {
        HashSet set = new HashSet(array1.length);
        Collections.addAll(set, array1);
        for (T anArray2 : array2) {
            if (!set.contains(anArray2)) {
                return false;
            }
            set.remove(anArray2);
        }
        return set.isEmpty();
    }

    public static boolean isSuperset(Object[] subset, Object[] superset) {
        HashSet set = new HashSet();
        Collections.addAll(set, superset);
        for (Object element : subset) {
            if (set.contains(element)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] array1, Object[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i].equals(array2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] array1, byte[] array2, int length) {
        for (int i = 0; i < length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }
}

