/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.domains.Domain;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.rml.DomainConstraint;
import com.intellij.rml.dfa.impl.rml.DomainConstraintCollector;
import com.intellij.rml.dfa.impl.rml.DomainsPool;
import com.intellij.rml.dfa.impl.rml.ast.QueryNode;
import com.intellij.rml.dfa.impl.rml.ast.RelExprQuantify;
import com.intellij.rml.dfa.impl.rml.ast.Stmt;
import com.intellij.rml.dfa.impl.rml.ast.StmtPrint;
import com.intellij.rml.dfa.impl.rml.ast.StmtRelAssign;
import com.intellij.rml.dfa.impl.rml.ast.StmtVisitor;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.scripts.VariablesManager;
import com.intellij.rml.dfa.impl.ui.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J:\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0 R*\u0010\u0004\u001a\u001e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/rml/dfa/impl/rml/DomainsPoolWithConstraints;", "Lcom/intellij/rml/dfa/impl/rml/DomainsPool;", "<init>", "()V", "domainsMap", "", "Lkotlin/Pair;", "", "", "Lcom/intellij/rml/dfa/impl/rml/DomainPlace;", "Lcom/intellij/rml/dfa/impl/domains/Domain;", "getDomain", "node", "Lcom/intellij/rml/dfa/impl/rml/ast/QueryNode;", "name", "arrangeDomains", "", "stmt", "Lcom/intellij/rml/dfa/impl/rml/ast/Stmt;", "staticManager", "Lcom/intellij/rml/dfa/impl/scripts/VariablesManager;", "manager", "Lcom/intellij/rml/dfa/impl/scripts/RuntimeVariablesManager;", "computeBestDomain", "variablesManager", "domainName", "domainType", "Lcom/intellij/rml/dfa/impl/domains/DomainType;", "constraints", "", "Lcom/intellij/rml/dfa/impl/rml/DomainConstraint;", "usedDomains", "", "intellij.rml.dfa.impl"})
public final class DomainsPoolWithConstraints
implements DomainsPool {
    @NotNull
    private final Map<Pair<Integer, String>, Domain> domainsMap = new LinkedHashMap();

    @Override
    @NotNull
    public Domain getDomain(@NotNull QueryNode node, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Domain domain = this.domainsMap.get(new Pair((Object)node.getAstNodeId(), (Object)name));
        Intrinsics.checkNotNull((Object)domain);
        return domain;
    }

    public final void arrangeDomains(@NotNull Stmt stmt, @NotNull VariablesManager staticManager, @NotNull RuntimeVariablesManager manager) {
        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
        Intrinsics.checkNotNullParameter((Object)staticManager, (String)"staticManager");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        DomainConstraintCollector domainConstraintCollector = new DomainConstraintCollector(manager);
        stmt.accept(domainConstraintCollector);
        stmt.accept(new StmtVisitor(manager, domainConstraintCollector, this){
            private Set<Domain> usedDomains;
            final /* synthetic */ RuntimeVariablesManager $manager;
            final /* synthetic */ DomainConstraintCollector $domainConstraintCollector;
            final /* synthetic */ DomainsPoolWithConstraints this$0;
            {
                this.$manager = $manager;
                this.$domainConstraintCollector = $domainConstraintCollector;
                this.this$0 = $receiver;
                this.usedDomains = new LinkedHashSet<E>();
            }

            public final void pushDomain(Domain domain) {
                Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
                this.usedDomains.add(domain);
            }

            public final void popDomain(Domain domain) {
                Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
                if (!this.usedDomains.contains(domain)) {
                    String string = Messages.getString(DomainsPool.class.getName() + "-0");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                    throw new DfaInternalException(string);
                }
                this.usedDomains.remove(domain);
            }

            public final void assertEmpty() {
                if (!this.usedDomains.isEmpty()) {
                    String string = Messages.getString(DomainsPool.class.getName() + "-1");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                    throw new DfaInternalException(string);
                }
            }

            /*
             * WARNING - void declaration
             */
            public boolean visitRelAssignStart(StmtRelAssign stmt) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                DomainType[] domainTypes = this.$manager.getRelationDomainTypes(stmt.getRelName());
                String[] stringArray = stmt.getDomainNames();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getDomainNames(...)");
                Iterable iterable = (Iterable)ArraysKt.getIndices((Object[])stringArray);
                DomainConstraintCollector domainConstraintCollector = this.$domainConstraintCollector;
                DomainsPoolWithConstraints domainsPoolWithConstraints = this.this$0;
                RuntimeVariablesManager runtimeVariablesManager = this.$manager;
                boolean $i$f$map = false;
                void var8_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    DomainConstraint[] domainConstraintArray = domainConstraintCollector.getAssignConstraints(stmt)[it];
                    Intrinsics.checkNotNullExpressionValue((Object)domainConstraintArray, (String)"get(...)");
                    List constraints = ArraysKt.toList((Object[])domainConstraintArray);
                    String domainName = stmt.getDomainNames()[it];
                    Intrinsics.checkNotNull((Object)domainName);
                    DomainType domainType = domainTypes[it];
                    Intrinsics.checkNotNullExpressionValue((Object)domainType, (String)"get(...)");
                    Domain domain = domainsPoolWithConstraints.computeBestDomain(runtimeVariablesManager, domainName, domainType, constraints, this.usedDomains);
                    DomainsPoolWithConstraints.access$getDomainsMap$p(domainsPoolWithConstraints).put(new Pair((Object)stmt.getAstNodeId(), (Object)domainName), domain);
                    this.pushDomain(domain);
                    collection.add(Unit.INSTANCE);
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public void visitRelAssignEnd(StmtRelAssign stmt) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                String[] stringArray = stmt.getDomainNames();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getDomainNames(...)");
                Object[] objectArray = stringArray;
                DomainsPoolWithConstraints domainsPoolWithConstraints = this.this$0;
                boolean $i$f$forEach = false;
                for (void element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    V v = DomainsPoolWithConstraints.access$getDomainsMap$p(domainsPoolWithConstraints).get(new Pair((Object)stmt.getAstNodeId(), (Object)it));
                    Intrinsics.checkNotNull(v);
                    this.popDomain((Domain)v);
                }
                this.assertEmpty();
            }

            /*
             * WARNING - void declaration
             */
            public boolean visitPrintStart(StmtPrint stmt) {
                void $this$forEach$iv;
                Integer it;
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                List<Integer> list = stmt.getPrintTypes();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getPrintTypes(...)");
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Object object = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Integer)element$iv$iv;
                    boolean bl = false;
                    Integer n = it;
                    if (!(n != null && n == 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                DomainConstraintCollector domainConstraintCollector = this.$domainConstraintCollector;
                object = this.this$0;
                RuntimeVariablesManager runtimeVariablesManager = this.$manager;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    void $this$mapTo$iv$iv;
                    it = (Integer)element$iv;
                    boolean bl = false;
                    List<?> list2 = stmt.getPrintValues();
                    Intrinsics.checkNotNull((Object)it);
                    ? obj = list2.get(it);
                    Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.impl.rml.ast.StmtPrint.RelationPrintBundle");
                    StmtPrint.RelationPrintBundle bundle = (StmtPrint.RelationPrintBundle)obj;
                    List<String> list3 = bundle.domainNames;
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"domainNames");
                    Iterable $this$map$iv = (Iterable)CollectionsKt.getIndices((Collection)list3);
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void it2;
                        int item$iv$iv;
                        int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                        Collection collection = destination$iv$iv2;
                        boolean bl2 = false;
                        DomainConstraint[] domainConstraintArray = domainConstraintCollector.getPrintConstraints(bundle)[it2];
                        Intrinsics.checkNotNullExpressionValue((Object)domainConstraintArray, (String)"get(...)");
                        List constraints = ArraysKt.toList((Object[])domainConstraintArray);
                        String domainName = bundle.domainNames.get((int)it2);
                        Intrinsics.checkNotNull((Object)domainName);
                        Object object2 = bundle.domainTypes.get((int)it2);
                        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.impl.domains.DomainType");
                        Domain domain = ((DomainsPoolWithConstraints)object).computeBestDomain(runtimeVariablesManager, domainName, (DomainType)object2, constraints, this.usedDomains);
                        DomainsPoolWithConstraints.access$getDomainsMap$p((DomainsPoolWithConstraints)object).put(new Pair((Object)stmt.getAstNodeId(), (Object)domainName), domain);
                        this.pushDomain(domain);
                        collection.add(Unit.INSTANCE);
                    }
                    List cfr_ignored_0 = (List)destination$iv$iv2;
                }
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public void visitPrintEnd(StmtPrint stmt) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                List<Integer> list = stmt.getPrintTypes();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getPrintTypes(...)");
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    Integer it = (Integer)element$iv$iv;
                    boolean bl = false;
                    Integer n = it;
                    if (!(n != null && n == 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                DomainsPoolWithConstraints domainsPoolWithConstraints = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Integer it = (Integer)element$iv;
                    boolean bl = false;
                    List<?> list2 = stmt.getPrintValues();
                    Intrinsics.checkNotNull((Object)it);
                    ? obj = list2.get(it);
                    Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type com.intellij.rml.dfa.impl.rml.ast.StmtPrint.RelationPrintBundle");
                    StmtPrint.RelationPrintBundle bundle = (StmtPrint.RelationPrintBundle)obj;
                    List<String> list3 = bundle.domainNames;
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"domainNames");
                    Iterable $this$forEach$iv2 = list3;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        String it2 = (String)element$iv2;
                        boolean bl2 = false;
                        V v = DomainsPoolWithConstraints.access$getDomainsMap$p(domainsPoolWithConstraints).get(new Pair((Object)stmt.getAstNodeId(), (Object)it2));
                        Intrinsics.checkNotNull(v);
                        this.popDomain((Domain)v);
                    }
                }
                this.assertEmpty();
            }

            public boolean visitQuantifyStart(RelExprQuantify expr) {
                Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                String string = expr.getQuantifier();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQuantifier(...)");
                DomainType domainType = expr.getDomainType();
                Intrinsics.checkNotNullExpressionValue((Object)domainType, (String)"getDomainType(...)");
                List<DomainConstraint> list = this.$domainConstraintCollector.getQuantifyConstraints(expr);
                Intrinsics.checkNotNullExpressionValue(list, (String)"getQuantifyConstraints(...)");
                Domain domain = this.this$0.computeBestDomain(this.$manager, string, domainType, list, this.usedDomains);
                DomainsPoolWithConstraints.access$getDomainsMap$p(this.this$0).put(new Pair((Object)expr.getAstNodeId(), (Object)expr.getQuantifier()), domain);
                this.pushDomain(domain);
                return true;
            }

            public void visitQuantifyEnd(RelExprQuantify expr) {
                Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                V v = DomainsPoolWithConstraints.access$getDomainsMap$p(this.this$0).get(new Pair((Object)expr.getAstNodeId(), (Object)expr.getQuantifier()));
                Intrinsics.checkNotNull(v);
                this.popDomain((Domain)v);
            }
        });
    }

    @NotNull
    public final Domain computeBestDomain(@NotNull RuntimeVariablesManager variablesManager, @NotNull String domainName, @NotNull DomainType domainType, @NotNull List<? extends DomainConstraint> constraints, @NotNull Set<? extends Domain> usedDomains) {
        int i;
        Intrinsics.checkNotNullParameter((Object)variablesManager, (String)"variablesManager");
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        Intrinsics.checkNotNullParameter((Object)domainType, (String)"domainType");
        Intrinsics.checkNotNullParameter(constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter(usedDomains, (String)"usedDomains");
        boolean[] been = new boolean[constraints.size()];
        int maxCost = -1;
        Domain bestDomain = null;
        int n = ((Collection)constraints).size();
        for (i = 0; i < n; ++i) {
            Domain domain;
            if (been[i] || usedDomains.contains(domain = constraints.get(i).getDomain(variablesManager))) continue;
            boolean prohibitive = false;
            int n2 = 0;
            int n22 = ((Collection)constraints).size();
            for (int j = 0; j < n22; ++j) {
                if (!Intrinsics.areEqual((Object)constraints.get(j).getDomain(variablesManager), (Object)domain)) continue;
                been[j] = true;
                if (Intrinsics.areEqual((Object)constraints.get(j).getDomainName(), (Object)domainName)) {
                    ++n2;
                    continue;
                }
                prohibitive = true;
                break;
            }
            if (prohibitive || n2 <= maxCost) continue;
            maxCost = n2;
            bestDomain = domain;
        }
        if (maxCost > -1) {
            Domain domain = bestDomain;
            Intrinsics.checkNotNull(domain);
            return domain;
        }
        i = 0;
        while (true) {
            Domain domain = domainType.getDomain(i);
            boolean unique = true;
            if (usedDomains.contains(domain)) {
                ++i;
                continue;
            }
            for (DomainConstraint domainConstraint : constraints) {
                if (!Intrinsics.areEqual((Object)domainConstraint.getDomain(variablesManager), (Object)domain)) continue;
                unique = false;
                break;
            }
            if (unique) {
                Intrinsics.checkNotNull((Object)domain);
                return domain;
            }
            ++i;
        }
    }

    public static final /* synthetic */ Map access$getDomainsMap$p(DomainsPoolWithConstraints $this) {
        return $this.domainsMap;
    }
}

