/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.domains;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.ui.Messages;
import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\t\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/rml/dfa/impl/domains/AttributesInfo;", "", "fixedBitLength", "", "numOfAttributes", "bitLength", "<init>", "(III)V", "getFixedBitLength", "()I", "getNumOfAttributes", "setNumOfAttributes", "(I)V", "getBitLength", "setBitLength", "addAttribute", "addAttributes", "", "attributesCnt", "extendDomainType", "toString", "", "save", "stream", "Ljava/io/DataOutput;", "Companion", "intellij.rml.dfa.impl"})
public final class AttributesInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int fixedBitLength;
    private int numOfAttributes;
    private int bitLength;
    private static final int START_BIT_LENGTH = 2;
    private static final int BIT_LENGTH_INCREASE_STEP = 1;

    public AttributesInfo(int fixedBitLength, int numOfAttributes, int bitLength) {
        this.fixedBitLength = fixedBitLength;
        this.numOfAttributes = numOfAttributes;
        this.bitLength = bitLength;
    }

    public final int getFixedBitLength() {
        return this.fixedBitLength;
    }

    public final int getNumOfAttributes() {
        return this.numOfAttributes;
    }

    public final void setNumOfAttributes(int n) {
        this.numOfAttributes = n;
    }

    public final int getBitLength() {
        return this.bitLength;
    }

    public final void setBitLength(int n) {
        this.bitLength = n;
    }

    public final int addAttribute() {
        int n = this.numOfAttributes;
        this.numOfAttributes = n + 1;
        if (1 << this.bitLength < this.numOfAttributes + 1) {
            this.extendDomainType();
        }
        return this.numOfAttributes - 1;
    }

    public final void addAttributes(int attributesCnt) {
        this.numOfAttributes += attributesCnt;
        while (1 << this.bitLength < this.numOfAttributes + 1) {
            this.extendDomainType();
        }
    }

    private final void extendDomainType() {
        ++this.bitLength;
        if (this.bitLength > 30 || this.fixedBitLength != -1) {
            String string = Messages.getString(DomainType.class.getName() + "-1");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            throw new DfaInternalException(string);
        }
    }

    @NotNull
    public String toString() {
        return this.numOfAttributes + " (" + this.bitLength + " bits)";
    }

    public final void save(@NotNull DataOutput stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        stream.writeInt(this.numOfAttributes);
        stream.writeInt(this.bitLength);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/rml/dfa/impl/domains/AttributesInfo$Companion;", "", "<init>", "()V", "START_BIT_LENGTH", "", "BIT_LENGTH_INCREASE_STEP", "create", "Lcom/intellij/rml/dfa/impl/domains/AttributesInfo;", "domainType", "Lcom/intellij/rml/dfa/impl/domains/DomainType;", "info", "load", "stream", "Ljava/io/DataInput;", "intellij.rml.dfa.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributesInfo create(@NotNull DomainType domainType) {
            Intrinsics.checkNotNullParameter((Object)domainType, (String)"domainType");
            return domainType.getFixedBitLength() != -1 ? new AttributesInfo(domainType.getFixedBitLength(), 1 << domainType.getFixedBitLength(), domainType.getFixedBitLength()) : new AttributesInfo(domainType.getFixedBitLength(), 0, 2);
        }

        @NotNull
        public final AttributesInfo create(@NotNull AttributesInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            return new AttributesInfo(info.getFixedBitLength(), info.getNumOfAttributes(), info.getBitLength());
        }

        @NotNull
        public final AttributesInfo load(@NotNull DataInput stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            int numOfAttributes = stream.readInt();
            int bitLength = stream.readInt();
            return new AttributesInfo(-1, numOfAttributes, bitLength);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

