/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.makefile.project.resolver.preconfigure.detectors;

import com.jetbrains.cidr.cpp.makefile.io.file.MkPath;
import com.jetbrains.cidr.cpp.makefile.project.resolver.preconfigure.api.MkAbstractBuildSystemDetector;
import com.jetbrains.cidr.cpp.makefile.project.resolver.preconfigure.detectors.MkKbuildDetector;
import com.jetbrains.cidr.cpp.makefile.util.command.MkParsedArg;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001e\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\u000f\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0019\u0010\u0016\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/cpp/makefile/project/resolver/preconfigure/detectors/MkKbuildDetector;", "Lcom/jetbrains/cidr/cpp/makefile/project/resolver/preconfigure/api/MkAbstractBuildSystemDetector;", "<init>", "()V", "makefilePrototypes", "", "Lcom/jetbrains/cidr/cpp/makefile/util/command/MkParsedArg;", "Lcom/jetbrains/cidr/cpp/makefile/io/MkEnvPath;", "getMakefilePrototypes", "()Ljava/util/List;", "preConfigureCommands", "", "Lcom/intellij/openapi/util/NlsSafe;", "localProjectDirectory", "Ljava/nio/file/Path;", "extraMakeSwitches", "Lcom/jetbrains/cidr/cpp/makefile/util/command/MkParsedArgs;", "getExtraMakeSwitches", "isApplicableTo", "", "projectDirectory", "Lcom/jetbrains/cidr/cpp/makefile/io/file/MkPath;", "name", "getName", "()Ljava/lang/String;", "Companion", "intellij.clion.makefile"})
public final class MkKbuildDetector
extends MkAbstractBuildSystemDetector {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final List<MkParsedArg> makefilePrototypes;
    @NotNull
    private final List<MkParsedArg> extraMakeSwitches;
    @NotNull
    private final String name;
    @Language(value="sh")
    @NotNull
    private static final String KBUILD = "Kbuild";
    @Language(value="sh")
    @NotNull
    private static final String KCONFIG = "Kconfig";
    @Language(value="sh")
    @NotNull
    private static final String CONFIG = ".config";

    public MkKbuildDetector() {
        Object[] objectArray = new String[]{KBUILD, KCONFIG, CONFIG};
        this.makefilePrototypes = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (Function1)makefilePrototypes.1.INSTANCE));
        this.extraMakeSwitches = CollectionsKt.listOf((Object)MkParsedArg.box-impl(MkParsedArg.constructor-impl("V=1")));
        this.name = KBUILD;
    }

    @Override
    @NotNull
    public List<MkParsedArg> getMakefilePrototypes() {
        return this.makefilePrototypes;
    }

    @Override
    @Language(value="sh")
    @NotNull
    public String preConfigureCommands(@NotNull Path localProjectDirectory) {
        Intrinsics.checkNotNullParameter((Object)localProjectDirectory, (String)"localProjectDirectory");
        return "#!/bin/sh\n#\n# Kbuild template, feel free to customize.\n#\n[ -f .config ] || \"${MAKE:-make}\" defconfig";
    }

    @Override
    @NotNull
    public List<MkParsedArg> getExtraMakeSwitches() {
        return this.extraMakeSwitches;
    }

    @Override
    public boolean isApplicableTo(@NotNull MkPath projectDirectory) {
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        MkPath mkPath = projectDirectory.findChild(KBUILD);
        boolean kbuildExists = mkPath != null ? mkPath.isRegularFile() : false;
        MkPath mkPath2 = projectDirectory.findChild(KCONFIG);
        boolean kconfigExists = mkPath2 != null ? mkPath2.isRegularFile() : false;
        MkPath mkPath3 = projectDirectory.findChild(this.getMakefile-fR0g1-M());
        boolean makefileExists = mkPath3 != null ? mkPath3.isRegularFile() : false;
        return makefileExists && (kbuildExists || kconfigExists) && super.isApplicableTo(projectDirectory);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/cpp/makefile/project/resolver/preconfigure/detectors/MkKbuildDetector$Companion;", "", "<init>", "()V", "KBUILD", "", "KCONFIG", "CONFIG", "intellij.clion.makefile"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

