/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.makefile.project.resolver.analysis.makeOutput.processListeners;

import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.cpp.io.CPPLocalPathFactory;
import com.jetbrains.cidr.cpp.makefile.MakefileLog;
import com.jetbrains.cidr.cpp.makefile.project.resolver.analysis.makeOutput.processListeners.MkChainableListener;
import com.jetbrains.cidr.cpp.util.CPPPropertiesProvider;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0002'(B)\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001c\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0016H\u0016J\b\u0010\u001e\u001a\u00020\u0016H\u0004J\u001a\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\b\b\u0001\u0010\"\u001a\u00020#H\u0002J\u0019\u0010$\u001a\u00020\u00162\u000e\b\u0004\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00160&H\u0082\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/cidr/cpp/makefile/project/resolver/analysis/makeOutput/processListeners/MkOutputLogger;", "Lcom/jetbrains/cidr/cpp/makefile/project/resolver/analysis/makeOutput/processListeners/MkChainableListener;", "Ljava/io/Closeable;", "standardStreamsCharset", "Ljava/nio/charset/Charset;", "propertiesProvider", "Lcom/jetbrains/cidr/cpp/util/CPPPropertiesProvider;", "Lcom/jetbrains/cidr/cpp/makefile/util/MkPropertiesProvider;", "nextInChain", "Lcom/intellij/execution/process/ProcessListener;", "<init>", "(Ljava/nio/charset/Charset;Lcom/jetbrains/cidr/cpp/util/CPPPropertiesProvider;Lcom/intellij/execution/process/ProcessListener;)V", "isEnabled", "", "processStatus", "Lcom/jetbrains/cidr/cpp/makefile/project/resolver/analysis/makeOutput/processListeners/MkOutputLogger$MkProcessStatus;", "out", "Ljava/io/Writer;", "err", "firstErrorReported", "Ljava/util/concurrent/atomic/AtomicBoolean;", "startNotified", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "processTerminated", "onTextAvailable", "outputType", "Lcom/intellij/openapi/util/Key;", "close", "finalize", "newBufferedWriter", "now", "Ljava/util/Date;", "extension", "", "runAndReportFirstError", "block", "Lkotlin/Function0;", "MkProcessStatus", "Companion", "intellij.clion.makefile"})
@SourceDebugExtension(value={"SMAP\nMkOutputLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MkOutputLogger.kt\ncom/jetbrains/cidr/cpp/makefile/project/resolver/analysis/makeOutput/processListeners/MkOutputLogger\n*L\n1#1,169:1\n149#1,9:170\n149#1,9:179\n149#1,9:188\n149#1,9:197\n149#1,9:206\n149#1,9:215\n*S KotlinDebug\n*F\n+ 1 MkOutputLogger.kt\ncom/jetbrains/cidr/cpp/makefile/project/resolver/analysis/makeOutput/processListeners/MkOutputLogger\n*L\n60#1:170,9\n63#1:179,9\n101#1:188,9\n107#1:197,9\n121#1:206,9\n124#1:215,9\n*E\n"})
public final class MkOutputLogger
extends MkChainableListener
implements Closeable {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Charset standardStreamsCharset;
    private final boolean isEnabled;
    @NotNull
    private volatile MkProcessStatus processStatus;
    @Nullable
    private volatile Writer out;
    @Nullable
    private volatile Writer err;
    @NotNull
    private final AtomicBoolean firstErrorReported;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public MkOutputLogger(@NotNull Charset standardStreamsCharset, @NotNull CPPPropertiesProvider propertiesProvider, @Nullable ProcessListener nextInChain) {
        Intrinsics.checkNotNullParameter((Object)standardStreamsCharset, (String)"standardStreamsCharset");
        Intrinsics.checkNotNullParameter((Object)propertiesProvider, (String)"propertiesProvider");
        super(nextInChain);
        this.standardStreamsCharset = standardStreamsCharset;
        this.isEnabled = propertiesProvider.is("makefile.log.make.output.to.file", false);
        this.processStatus = MkProcessStatus.IDLE;
        this.firstErrorReported = new AtomicBoolean();
    }

    public /* synthetic */ MkOutputLogger(Charset charset, CPPPropertiesProvider cPPPropertiesProvider, ProcessListener processListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            processListener = null;
        }
        this(charset, cPPPropertiesProvider, processListener);
    }

    @Override
    public void startNotified(@NotNull ProcessEvent event) {
        block7: {
            boolean $i$f$runAndReportFirstError;
            MkOutputLogger this_$iv;
            Date now;
            block6: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                super.startNotified(event);
                if (!this.isEnabled) {
                    return;
                }
                MkProcessStatus processStatusSnapshot = this.processStatus;
                if (!(processStatusSnapshot == MkProcessStatus.IDLE)) {
                    boolean $i$a$-require-MkOutputLogger$startNotified$22 = false;
                    MkProcessStatus $i$a$-require-MkOutputLogger$startNotified$22 = processStatusSnapshot;
                    throw new IllegalArgumentException(((Object)((Object)$i$a$-require-MkOutputLogger$startNotified$22)).toString());
                }
                this.processStatus = MkProcessStatus.RUNNING;
                now = new Date();
                this_$iv = this;
                $i$f$runAndReportFirstError = false;
                try {
                    boolean bl = false;
                    this.out = this.newBufferedWriter(now, "out");
                }
                catch (IOException ioe$iv) {
                    if (!this_$iv.firstErrorReported.compareAndSet(false, true)) break block6;
                    MakefileLog.LOG.error((Throwable)ioe$iv);
                }
            }
            this_$iv = this;
            $i$f$runAndReportFirstError = false;
            try {
                boolean bl = false;
                this.err = this.newBufferedWriter(now, "err");
            }
            catch (IOException ioe$iv) {
                if (!this_$iv.firstErrorReported.compareAndSet(false, true)) break block7;
                MakefileLog.LOG.error((Throwable)ioe$iv);
            }
        }
    }

    @Override
    public void processTerminated(@NotNull ProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.processTerminated(event);
        if (!this.isEnabled) {
            return;
        }
        MkProcessStatus processStatusSnapshot = this.processStatus;
        if (!(processStatusSnapshot == MkProcessStatus.RUNNING)) {
            boolean bl = false;
            MkProcessStatus mkProcessStatus = processStatusSnapshot;
            throw new IllegalArgumentException(((Object)((Object)mkProcessStatus)).toString());
        }
        this.processStatus = MkProcessStatus.TERMINATED;
        this.close();
    }

    @Override
    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
        block12: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            super.onTextAvailable(event, outputType);
            if (!this.isEnabled) {
                return;
            }
            if (this.processStatus != MkProcessStatus.RUNNING) {
                return;
            }
            String string = event.getText();
            if (string == null) {
                return;
            }
            String processOutputLine = string;
            if (ProcessOutputType.isStdout(outputType)) {
                MkOutputLogger this_$iv = this;
                boolean $i$f$runAndReportFirstError = false;
                try {
                    boolean bl = false;
                    Writer writer = this.out;
                    if (writer != null) {
                        Writer $this$onTextAvailable_u24lambda_u245_u24lambda_u244 = writer;
                        boolean bl2 = false;
                        $this$onTextAvailable_u24lambda_u245_u24lambda_u244.write(MkChainableListener.trimTrailingNewline(processOutputLine));
                        $this$onTextAvailable_u24lambda_u245_u24lambda_u244.write(MkOutputLogger.LINE_SEPARATOR);
                    }
                    break block12;
                }
                catch (IOException ioe$iv) {
                    if (this_$iv.firstErrorReported.compareAndSet(false, true)) {
                        MakefileLog.LOG.error((Throwable)ioe$iv);
                    }
                    break block12;
                }
            }
            if (ProcessOutputType.isStderr(outputType)) {
                MkOutputLogger this_$iv = this;
                boolean $i$f$runAndReportFirstError = false;
                try {
                    boolean bl = false;
                    Writer writer = this.err;
                    if (writer != null) {
                        Writer $this$onTextAvailable_u24lambda_u247_u24lambda_u246 = writer;
                        boolean bl3 = false;
                        $this$onTextAvailable_u24lambda_u247_u24lambda_u246.write(MkChainableListener.trimTrailingNewline(processOutputLine));
                        $this$onTextAvailable_u24lambda_u247_u24lambda_u246.write(MkOutputLogger.LINE_SEPARATOR);
                    }
                }
                catch (IOException ioe$iv) {
                    if (!this_$iv.firstErrorReported.compareAndSet(false, true)) break block12;
                    MakefileLog.LOG.error((Throwable)ioe$iv);
                }
            }
        }
    }

    @Override
    public void close() {
        block8: {
            boolean $i$f$runAndReportFirstError;
            MkOutputLogger this_$iv;
            block7: {
                if (!this.isEnabled) {
                    return;
                }
                this_$iv = this;
                $i$f$runAndReportFirstError = false;
                try {
                    boolean bl = false;
                    Writer writer = this.out;
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException ioe$iv) {
                    if (!this_$iv.firstErrorReported.compareAndSet(false, true)) break block7;
                    MakefileLog.LOG.error((Throwable)ioe$iv);
                }
            }
            this_$iv = this;
            $i$f$runAndReportFirstError = false;
            try {
                boolean bl = false;
                Writer writer = this.err;
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ioe$iv) {
                if (!this_$iv.firstErrorReported.compareAndSet(false, true)) break block8;
                MakefileLog.LOG.error((Throwable)ioe$iv);
            }
        }
    }

    protected final void finalize() {
        this.close();
    }

    private final Writer newBufferedWriter(Date now, @NlsSafe String extension) throws IOException {
        DateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String logFileBasename = "clion-make-" + dateFormat.format(now);
        String string = System.getProperty("java.io.tmpdir");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String[] stringArray = new String[]{logFileBasename + "." + extension};
        Path logFile = CPPLocalPathFactory.INSTANCE.getPath(string, stringArray);
        BufferedWriter bufferedWriter = Files.newBufferedWriter(logFile, this.standardStreamsCharset, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedWriter, (String)"newBufferedWriter(...)");
        return bufferedWriter;
    }

    private final void runAndReportFirstError(Function0<Unit> block) {
        block2: {
            boolean $i$f$runAndReportFirstError = false;
            try {
                block.invoke();
            }
            catch (IOException ioe) {
                if (!this.firstErrorReported.compareAndSet(false, true)) break block2;
                MakefileLog.LOG.error((Throwable)ioe);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/cpp/makefile/project/resolver/analysis/makeOutput/processListeners/MkOutputLogger$Companion;", "", "<init>", "()V", "LINE_SEPARATOR", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "intellij.clion.makefile"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/cpp/makefile/project/resolver/analysis/makeOutput/processListeners/MkOutputLogger$MkProcessStatus;", "", "<init>", "(Ljava/lang/String;I)V", "IDLE", "RUNNING", "TERMINATED", "intellij.clion.makefile"})
    private static final class MkProcessStatus
    extends Enum<MkProcessStatus> {
        public static final /* enum */ MkProcessStatus IDLE = new MkProcessStatus();
        public static final /* enum */ MkProcessStatus RUNNING = new MkProcessStatus();
        public static final /* enum */ MkProcessStatus TERMINATED = new MkProcessStatus();
        private static final /* synthetic */ MkProcessStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MkProcessStatus[] values() {
            return (MkProcessStatus[])$VALUES.clone();
        }

        public static MkProcessStatus valueOf(String value) {
            return Enum.valueOf(MkProcessStatus.class, value);
        }

        @NotNull
        public static EnumEntries<MkProcessStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = mkProcessStatusArray = new MkProcessStatus[]{MkProcessStatus.IDLE, MkProcessStatus.RUNNING, MkProcessStatus.TERMINATED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

