/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.makefile.io;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.jetbrains.cidr.cpp.makefile.MakefileUtil;
import com.jetbrains.cidr.cpp.makefile.io.MkPathUtils;
import com.jetbrains.cidr.cpp.makefile.io.file.MkNioPath;
import com.jetbrains.cidr.cpp.makefile.io.file.MkVirtualFile;
import com.jetbrains.cidr.cpp.makefile.project.resolver.preconfigure.api.MkBuildSystemDetector;
import com.jetbrains.cidr.cpp.makefile.util.command.MkParsedArg;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a%\u0010\b\u001a\u00020\t*\u00020\n2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000fH\u0000\u00a2\u0006\u0002\u0010\u0010\u001a%\u0010\u0012\u001a\u00020\t*\u00020\n2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000fH\u0000\u00a2\u0006\u0002\u0010\u0010\u001a\u0014\u0010\u001c\u001a\u00020\t*\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0000\u001a\u0014\u0010\u001e\u001a\u00020\t*\u00020\n2\u0006\u0010\u001f\u001a\u00020\nH\u0000\u001a\u000e\u0010#\u001a\u0004\u0018\u00010$*\u00020\nH\u0000\u001a!\u0010*\u001a\u0004\u0018\u00010$*\u00020$2\n\u0010+\u001a\u00060&j\u0002`'H\u0000\u00a2\u0006\u0004\b,\u0010-\u001a\u0012\u00101\u001a\b\u0012\u0004\u0012\u00020\n02*\u00020\nH\u0000\u001a\f\u00103\u001a\u00020\n*\u00020\nH\u0000\u001a\f\u00107\u001a\u00020\n*\u000208H\u0000\u001a\f\u00107\u001a\u00020\n*\u000209H\u0000\u001a\u0014\u0010:\u001a\u00020\u0002*\u00020\u00022\u0006\u0010;\u001a\u00020\u0002H\u0000\" \u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0002X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\b\u001a\u00020\t*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0018\u0010\u0011\u001a\u00020\t*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\f\"\u0018\u0010\u0012\u001a\u00020\t*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\f\"\u0018\u0010\u0013\u001a\u00020\t*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\f\"6\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015*\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158\u00c0\u0002@\u00c0\u0002X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\"\u0018\u0010 \u001a\u00020\t*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\f\"\u0018\u0010!\u001a\u00020\t*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\f\"\u0018\u0010\"\u001a\u00020\t*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\f\"\u001c\u0010%\u001a\u00060&j\u0002`'*\u00020$8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\"\u0018\u0010\u0012\u001a\u00020\t*\u00020$8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010.\"\u0018\u0010/\u001a\u00020\t*\u00020$8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010.\"\u0018\u00100\u001a\u00020\t*\u00020$8AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010.\"\u0018\u0010/\u001a\u00020\t*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\f\"\u0018\u00100\u001a\u00020\t*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\f\"\u0018\u00104\u001a\u00020\t*\u0002058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00106\u00a8\u0006<"}, d2={"BOURNE_SHELLS", "Ljava/util/LinkedHashSet;", "", "Lkotlin/collections/LinkedHashSet;", "C_SHELLS", "KNOWN_SHELLS", "KNOWN_ASSEMBLERS", "EXE_SUFFIX", "exists", "", "Ljava/nio/file/Path;", "getExists", "(Ljava/nio/file/Path;)Z", "options", "", "Ljava/nio/file/LinkOption;", "(Ljava/nio/file/Path;[Ljava/nio/file/LinkOption;)Z", "isDirectory", "isRegularFile", "isExecutable", "value", "", "Ljava/nio/file/attribute/PosixFilePermission;", "posixFilePermissions", "getPosixFilePermissions", "(Ljava/nio/file/Path;)Ljava/util/Set;", "setPosixFilePermissions", "(Ljava/nio/file/Path;Ljava/util/Set;)V", "isAncestorOf", "child", "isSameFileAs", "that", "isKnownShell", "isBourneShell", "isKnownAssembler", "toVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "envName", "Lcom/jetbrains/cidr/cpp/makefile/util/command/MkParsedArg;", "Lcom/jetbrains/cidr/cpp/makefile/io/MkEnvPath;", "getEnvName", "(Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/String;", "findChild", "name", "findChild-j2sQwFI", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)Z", "isMakefile", "isMakefilePrototype", "makefileSequence", "Lkotlin/sequences/Sequence;", "toAbsoluteNormalizedPath", "isMakefileProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Z", "toPath", "Ljava/net/URL;", "Ljava/net/URI;", "withoutSuffix", "suffix", "intellij.clion.makefile"})
@JvmName(name="MkPathUtils")
@SourceDebugExtension(value={"SMAP\nMkPathUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MkPathUtils.kt\ncom/jetbrains/cidr/cpp/makefile/io/MkPathUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,277:1\n1#2:278\n*E\n"})
public final class MkPathUtils {
    @NonNls
    @NotNull
    private static final LinkedHashSet<String> BOURNE_SHELLS;
    @NonNls
    @NotNull
    private static final LinkedHashSet<String> C_SHELLS;
    @NonNls
    @NotNull
    private static final LinkedHashSet<String> KNOWN_SHELLS;
    @NonNls
    @NotNull
    private static final LinkedHashSet<String> KNOWN_ASSEMBLERS;
    @NotNull
    public static final String EXE_SUFFIX = ".exe";

    public static final boolean getExists(@NotNull Path $this$exists) {
        Intrinsics.checkNotNullParameter((Object)$this$exists, (String)"<this>");
        return MkPathUtils.exists($this$exists, new LinkOption[0]);
    }

    public static final boolean exists(@NotNull Path $this$exists, LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)$this$exists, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return Files.exists($this$exists, Arrays.copyOf(options, options.length));
    }

    public static final boolean isDirectory(@NotNull Path $this$isDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$isDirectory, (String)"<this>");
        return Files.isDirectory($this$isDirectory, new LinkOption[0]);
    }

    public static final boolean isRegularFile(@NotNull Path $this$isRegularFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isRegularFile, (String)"<this>");
        return MkPathUtils.isRegularFile($this$isRegularFile, new LinkOption[0]);
    }

    public static final boolean isRegularFile(@NotNull Path $this$isRegularFile, LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)$this$isRegularFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return Files.isRegularFile($this$isRegularFile, Arrays.copyOf(options, options.length));
    }

    public static final boolean isExecutable(@NotNull Path $this$isExecutable) {
        Intrinsics.checkNotNullParameter((Object)$this$isExecutable, (String)"<this>");
        return Files.isExecutable($this$isExecutable);
    }

    @NotNull
    public static final Set<PosixFilePermission> getPosixFilePermissions(@NotNull Path $this$posixFilePermissions) {
        Intrinsics.checkNotNullParameter((Object)$this$posixFilePermissions, (String)"<this>");
        boolean $i$f$getPosixFilePermissions = false;
        Set<PosixFilePermission> set = Files.getPosixFilePermissions($this$posixFilePermissions, new LinkOption[0]);
        Intrinsics.checkNotNullExpressionValue(set, (String)"getPosixFilePermissions(...)");
        return set;
    }

    public static final void setPosixFilePermissions(@NotNull Path $this$posixFilePermissions, @NotNull Set<? extends PosixFilePermission> value) {
        Intrinsics.checkNotNullParameter((Object)$this$posixFilePermissions, (String)"<this>");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        boolean $i$f$setPosixFilePermissions = false;
        Files.setPosixFilePermissions($this$posixFilePermissions, value);
    }

    public static final boolean isAncestorOf(@NotNull Path $this$isAncestorOf, @NotNull Path child) {
        Intrinsics.checkNotNullParameter((Object)$this$isAncestorOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Path absoluteParent = MkPathUtils.toAbsoluteNormalizedPath($this$isAncestorOf);
        Path absoluteChild = MkPathUtils.toAbsoluteNormalizedPath(child);
        if (absoluteParent.getNameCount() >= absoluteChild.getNameCount()) {
            return false;
        }
        Path path = absoluteChild.getParent();
        if (path == null) {
            return false;
        }
        Path immediateParent = path;
        return MkPathUtils.isSameFileAs(absoluteParent, immediateParent) || MkPathUtils.isAncestorOf(absoluteParent, immediateParent);
    }

    public static final boolean isSameFileAs(@NotNull Path $this$isSameFileAs, @NotNull Path that) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isSameFileAs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        try {
            bl = Files.isSameFile($this$isSameFileAs, that);
        }
        catch (FileSystemException fileSystemException) {
            bl = Intrinsics.areEqual((Object)MkPathUtils.toAbsoluteNormalizedPath($this$isSameFileAs), (Object)MkPathUtils.toAbsoluteNormalizedPath(that));
        }
        return bl;
    }

    public static final boolean isKnownShell(@NotNull Path $this$isKnownShell) {
        Intrinsics.checkNotNullParameter((Object)$this$isKnownShell, (String)"<this>");
        Object object = $this$isKnownShell.getFileName();
        if (object == null || (object = object.toString()) == null) {
            return false;
        }
        Object fileName = object;
        return KNOWN_SHELLS.contains(MkPathUtils.withoutSuffix((String)fileName, EXE_SUFFIX));
    }

    public static final boolean isBourneShell(@NotNull Path $this$isBourneShell) {
        Intrinsics.checkNotNullParameter((Object)$this$isBourneShell, (String)"<this>");
        Object object = $this$isBourneShell.getFileName();
        if (object == null || (object = object.toString()) == null) {
            return false;
        }
        Object fileName = object;
        return BOURNE_SHELLS.contains(MkPathUtils.withoutSuffix((String)fileName, EXE_SUFFIX));
    }

    public static final boolean isKnownAssembler(@NotNull Path $this$isKnownAssembler) {
        Intrinsics.checkNotNullParameter((Object)$this$isKnownAssembler, (String)"<this>");
        Object object = $this$isKnownAssembler.getFileName();
        if (object == null || (object = object.toString()) == null) {
            return false;
        }
        Object fileName = object;
        return KNOWN_ASSEMBLERS.contains(MkPathUtils.withoutSuffix((String)fileName, EXE_SUFFIX));
    }

    @Nullable
    public static final VirtualFile toVirtualFile(@NotNull Path $this$toVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)$this$toVirtualFile, (String)"<this>");
        return VfsUtil.findFile((Path)$this$toVirtualFile, (boolean)false);
    }

    @NotNull
    public static final String getEnvName(@NotNull VirtualFile $this$envName) {
        Intrinsics.checkNotNullParameter((Object)$this$envName, (String)"<this>");
        String string = $this$envName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return MkParsedArg.constructor-impl(string);
    }

    @Nullable
    public static final VirtualFile findChild-j2sQwFI(@NotNull VirtualFile $this$findChild_u2dj2sQwFI, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$findChild_u2dj2sQwFI, (String)"$this$findChild");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return $this$findChild_u2dj2sQwFI.findChild(name);
    }

    public static final boolean isRegularFile(@NotNull VirtualFile $this$isRegularFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isRegularFile, (String)"<this>");
        return $this$isRegularFile.exists() && !$this$isRegularFile.isDirectory();
    }

    public static final boolean isMakefile(@NotNull VirtualFile $this$isMakefile) {
        Intrinsics.checkNotNullParameter((Object)$this$isMakefile, (String)"<this>");
        return MkPathUtils.isRegularFile($this$isMakefile) && MakefileUtil.INSTANCE.getMAKEFILE_NAMES_SET().contains($this$isMakefile.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresReadLock
    public static final boolean isMakefilePrototype(@NotNull VirtualFile $this$isMakefilePrototype) {
        Intrinsics.checkNotNullParameter((Object)$this$isMakefilePrototype, (String)"<this>");
        if (!MkPathUtils.isRegularFile($this$isMakefilePrototype)) return false;
        String string = $this$isMakefilePrototype.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String prototype = MkParsedArg.constructor-impl(string);
        boolean bl = false;
        if (!MakefileUtil.INSTANCE.getMAKEFILE_PROTOTYPE_NAMES().contains(MkParsedArg.box-impl(prototype))) return false;
        MkBuildSystemDetector mkBuildSystemDetector = MkBuildSystemDetector.Companion.findDetectorByPrototype-q4qvaYM(prototype);
        if (mkBuildSystemDetector == null) return false;
        VirtualFile virtualFile = $this$isMakefilePrototype.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
        boolean bl2 = mkBuildSystemDetector.isApplicableTo(new MkVirtualFile(virtualFile));
        if (!bl2) return false;
        return true;
    }

    public static final boolean isMakefile(@NotNull Path $this$isMakefile) {
        Intrinsics.checkNotNullParameter((Object)$this$isMakefile, (String)"<this>");
        return MkPathUtils.isRegularFile($this$isMakefile) && MakefileUtil.INSTANCE.getMAKEFILE_NAMES_SET().contains(((Object)$this$isMakefile.getFileName()).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isMakefilePrototype(@NotNull Path $this$isMakefilePrototype) {
        Intrinsics.checkNotNullParameter((Object)$this$isMakefilePrototype, (String)"<this>");
        if (!MkPathUtils.isRegularFile($this$isMakefilePrototype)) return false;
        String p0 = ((Object)$this$isMakefilePrototype.getFileName()).toString();
        boolean $i$f$_get_isMakefilePrototype_$stub_for_inlining = false;
        boolean bl = false;
        String prototype = MkParsedArg.constructor-impl(p0);
        boolean bl2 = false;
        if (!MakefileUtil.INSTANCE.getMAKEFILE_PROTOTYPE_NAMES().contains(MkParsedArg.box-impl(prototype))) return false;
        MkBuildSystemDetector mkBuildSystemDetector = MkBuildSystemDetector.Companion.findDetectorByPrototype-q4qvaYM(prototype);
        if (mkBuildSystemDetector == null) return false;
        Path path = $this$isMakefilePrototype.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        boolean bl3 = mkBuildSystemDetector.isApplicableTo(new MkNioPath(path));
        if (!bl3) return false;
        return true;
    }

    @NotNull
    public static final Sequence<Path> makefileSequence(@NotNull Path $this$makefileSequence) {
        Intrinsics.checkNotNullParameter((Object)$this$makefileSequence, (String)"<this>");
        return MkPathUtils.isDirectory($this$makefileSequence) ? SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)MakefileUtil.INSTANCE.getMAKEFILE_NAMES()), (Function1)((Function1)new Function1<String, Path>((Object)$this$makefileSequence){

            public final Path invoke(String p0) {
                return ((Path)this.receiver).resolve(p0);
            }
        })), (Function1)((Function1)makefileSequence.2.INSTANCE)) : SequencesKt.emptySequence();
    }

    @NotNull
    public static final Path toAbsoluteNormalizedPath(@NotNull Path $this$toAbsoluteNormalizedPath) {
        Intrinsics.checkNotNullParameter((Object)$this$toAbsoluteNormalizedPath, (String)"<this>");
        Path path = $this$toAbsoluteNormalizedPath.toAbsolutePath().normalize();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"normalize(...)");
        return path;
    }

    public static final boolean isMakefileProject(@NotNull Project $this$isMakefileProject) {
        Intrinsics.checkNotNullParameter((Object)$this$isMakefileProject, (String)"<this>");
        return !MakefileUtil.linkedProjectSettings($this$isMakefileProject).isEmpty();
    }

    @NotNull
    public static final Path toPath(@NotNull URL $this$toPath) {
        Intrinsics.checkNotNullParameter((Object)$this$toPath, (String)"<this>");
        URI uRI = $this$toPath.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
        return MkPathUtils.toPath(uRI);
    }

    @NotNull
    public static final Path toPath(@NotNull URI $this$toPath) {
        Intrinsics.checkNotNullParameter((Object)$this$toPath, (String)"<this>");
        Path path = Paths.get($this$toPath);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @NotNull
    public static final String withoutSuffix(@NotNull String $this$withoutSuffix, @NotNull String suffix) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$withoutSuffix, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        if (StringsKt.endsWith((String)$this$withoutSuffix, (String)suffix, (boolean)true)) {
            String string2 = $this$withoutSuffix.substring(0, $this$withoutSuffix.length() - suffix.length());
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = $this$withoutSuffix;
        }
        return string;
    }

    static {
        Object[] objectArray = new String[]{"sh", "ash", "dash", "bash", "rbash", "ksh", "ksh93", "rksh", "rksh93", "zsh"};
        BOURNE_SHELLS = SetsKt.linkedSetOf((Object[])objectArray);
        objectArray = new String[]{"csh", "bsd-csh", "tcsh"};
        C_SHELLS = SetsKt.linkedSetOf((Object[])objectArray);
        Object[] $this$KNOWN_SHELLS_u24lambda_u240 = objectArray = new LinkedHashSet();
        boolean bl = false;
        CollectionsKt.addAll((Collection)((Collection)$this$KNOWN_SHELLS_u24lambda_u240), (Iterable)BOURNE_SHELLS);
        CollectionsKt.addAll((Collection)((Collection)$this$KNOWN_SHELLS_u24lambda_u240), (Iterable)C_SHELLS);
        ((Collection)$this$KNOWN_SHELLS_u24lambda_u240).add("fish");
        KNOWN_SHELLS = objectArray;
        objectArray = new String[]{"nasm", "yasm"};
        KNOWN_ASSEMBLERS = SetsKt.linkedSetOf((Object[])objectArray);
    }
}

