/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.fetch.GitFetchResult;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.ui.branch.GitBranchActionsUtilKt;
import org.jetbrains.annotations.NotNull;

public class GitFetch
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            GitFetch.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (!GitBranchActionsUtilKt.hasRemotes(project)) {
            e.getPresentation().setEnabled(false);
            return;
        }
        if (GitFetchSupport.fetchSupport(project).isFetchRunning()) {
            e.getPresentation().setEnabled(false);
            e.getPresentation().setDescription(GitBundle.message("action.Git.Fetch.description.fetch.in.progress", new Object[0]));
            return;
        }
        e.getPresentation().setDescription("");
        e.getPresentation().setEnabledAndVisible(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            GitFetch.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            GitFetch.$$$reportNull$$$0(2);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        GitVcs.runInBackground(new Task.Backgroundable(project, GitBundle.message("fetching", new Object[0]), true){
            GitFetchResult result;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.result = GitFetchSupport.fetchSupport(project).fetchAllRemotes(GitUtil.getRepositories(project));
            }

            public void onFinished() {
                if (this.result != null) {
                    GitFetch.this.onFetchFinished(project, this.result);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/actions/GitFetch$1", "run"));
            }
        });
    }

    @RequiresEdt
    protected void onFetchFinished(@NotNull Project project, @NotNull GitFetchResult result2) {
        if (project == null) {
            GitFetch.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            GitFetch.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.assertEventDispatchThread();
        result2.showNotification();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/actions/GitFetch";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/actions/GitFetch";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onFetchFinished";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

