/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson.wizard.project;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.external.system.fus.CidrExternalUsageUtil;
import com.jetbrains.cidr.meson.MesonUtil;
import com.jetbrains.cidr.meson.MesonUtilKt;
import com.jetbrains.cidr.meson.bundle.MesonBundle;
import com.jetbrains.cidr.meson.wizard.MesonFileTemplateFactoryKt;
import com.jetbrains.cidr.meson.wizard.project.MesonProjectGenerator;
import com.jetbrains.cidr.meson.wizard.project.MesonProjectGeneratorCPPStandard;
import com.jetbrains.cidr.meson.wizard.project.MesonProjectGeneratorCStandard;
import com.jetbrains.cidr.meson.wizard.project.MesonProjectGeneratorLanguage;
import com.jetbrains.cidr.meson.wizard.project.MesonProjectGeneratorProjectCreatorKt;
import com.jetbrains.cidr.meson.wizard.project.MesonProjectGeneratorType;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/meson/wizard/project/MesonProjectGeneratorProjectCreator;", "", "<init>", "()V", "generateProject", "", "project", "Lcom/intellij/openapi/project/Project;", "projectGenerator", "Lcom/jetbrains/cidr/meson/wizard/project/MesonProjectGenerator;", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "generateMesonBuildFileText", "", "projectName", "fileTemplateManager", "Lcom/intellij/ide/fileTemplates/FileTemplateManager;", "getFileTemplateProperties", "", "generateSourceFilesPathAndText", "Lcom/jetbrains/cidr/meson/wizard/project/MesonProjectGeneratorProjectCreator$FileContent;", "getDefaultProjectProperties", "Ljava/util/Properties;", "FileContent", "intellij.clion.meson"})
@SourceDebugExtension(value={"SMAP\nMesonProjectGeneratorProjectCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MesonProjectGeneratorProjectCreator.kt\ncom/jetbrains/cidr/meson/wizard/project/MesonProjectGeneratorProjectCreator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
public final class MesonProjectGeneratorProjectCreator {
    @NotNull
    public static final MesonProjectGeneratorProjectCreator INSTANCE = new MesonProjectGeneratorProjectCreator();

    private MesonProjectGeneratorProjectCreator() {
    }

    public final void generateProject(@NotNull Project project, @NotNull MesonProjectGenerator projectGenerator, @NotNull VirtualFile baseDir) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)projectGenerator), (String)"projectGenerator");
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        try {
            CidrExternalUsageUtil.INSTANCE.logProjectCreated(MesonUtilKt.getID(), project);
            FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)project);
            String string = baseDir.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Intrinsics.checkNotNull((Object)fileTemplateManager);
            String mesonBuildFileText = this.generateMesonBuildFileText(string, fileTemplateManager, projectGenerator);
            FileContent sourceFile = (FileContent)ApplicationManager.getApplication().runReadAction(() -> MesonProjectGeneratorProjectCreator.generateProject$lambda$0(project, fileTemplateManager, projectGenerator));
            Ref.ObjectRef buildFile = new Ref.ObjectRef();
            Ref.ObjectRef sourceVirtualFile = new Ref.ObjectRef();
            ApplicationManager.getApplication().runWriteAction(() -> MesonProjectGeneratorProjectCreator.generateProject$lambda$3(buildFile, baseDir, project, sourceVirtualFile, sourceFile, mesonBuildFileText));
            MesonUtil.INSTANCE.linkMesonProject(project, baseDir);
            VirtualFile[] virtualFileArray = new VirtualFile[]{baseDir};
            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                if (buildFile.element != null) {
                    PsiNavigationSupport psiNavigationSupport = PsiNavigationSupport.getInstance();
                    Object object = buildFile.element;
                    Intrinsics.checkNotNull((Object)object);
                    psiNavigationSupport.createNavigatable(project, (VirtualFile)object, -1).navigate(false);
                }
                if (sourceVirtualFile.element != null) {
                    PsiNavigationSupport psiNavigationSupport = PsiNavigationSupport.getInstance();
                    Object object = sourceVirtualFile.element;
                    Intrinsics.checkNotNull((Object)object);
                    psiNavigationSupport.createNavigatable(project, (VirtualFile)object, -1).navigate(true);
                }
            }
        }
        catch (IOException e) {
            Object[] objectArray = new Object[1];
            String string = e.getMessage();
            if (string == null) {
                string = MesonBundle.message("template.meson.cant.generate.project.unknown.reason", new Object[0]);
            }
            objectArray[0] = string;
            Messages.showErrorDialog((Project)project, (String)MesonBundle.message("template.meson.cant.generate.project", objectArray), (String)CLionCMakeBundle.message((String)"cmake.new.project", (Object[])new Object[0]));
            MesonProjectGeneratorProjectCreatorKt.access$getLOG$p().error("Exception while trying to generate project", (Throwable)e);
        }
    }

    private final String generateMesonBuildFileText(String projectName, FileTemplateManager fileTemplateManager, MesonProjectGenerator projectGenerator) {
        String language = ((MesonProjectGeneratorLanguage)((Object)projectGenerator.getLanguageProperty().get())).getCommand();
        String type = ((MesonProjectGeneratorType)((Object)projectGenerator.getTypeProperty().get())).getCommand();
        FileTemplate fileTemplate = fileTemplateManager.getJ2eeTemplate(language + "." + type + ".meson.build");
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getJ2eeTemplate(...)");
        FileTemplate template = fileTemplate;
        Map<String, String> properties = this.getFileTemplateProperties(projectName, projectGenerator);
        String string = template.getText(properties);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private final Map<String, String> getFileTemplateProperties(String projectName, MesonProjectGenerator projectGenerator) {
        CharSequence charSequence;
        CharSequence charSequence2 = projectName;
        Regex regex = new Regex("['\\\\]");
        Pair[] pairArray = "";
        if (StringsKt.isBlank((CharSequence)(charSequence2 = (CharSequence)regex.replace(charSequence2, (String)pairArray)))) {
            boolean bl = false;
            charSequence = "project";
        } else {
            charSequence = charSequence2;
        }
        String normalizedProjectName = (String)charSequence;
        String cStandard = ((MesonProjectGeneratorCStandard)((Object)projectGenerator.getCStandardProperty().get())).toString();
        String cppStandard = ((MesonProjectGeneratorCPPStandard)((Object)projectGenerator.getCppStandardProperty().get())).toString();
        pairArray = new Pair[]{TuplesKt.to((Object)"PROJECT_NAME", (Object)normalizedProjectName), TuplesKt.to((Object)"PROJECT_VERSION", (Object)"1.0.0"), TuplesKt.to((Object)"MESON_LIBRARY_C_TARGET_NAME", (Object)MesonFileTemplateFactoryKt.getMESON_LIBRARY_C_TARGET_NAME().invoke((Object)normalizedProjectName)), TuplesKt.to((Object)"MESON_LIBRARY_CPP_TARGET_NAME", (Object)MesonFileTemplateFactoryKt.getMESON_LIBRARY_CPP_TARGET_NAME().invoke((Object)normalizedProjectName)), TuplesKt.to((Object)"MESON_EXECUTABLE_C_TARGET_NAME", (Object)MesonFileTemplateFactoryKt.getMESON_EXECUTABLE_C_TARGET_NAME().invoke((Object)normalizedProjectName)), TuplesKt.to((Object)"MESON_EXECUTABLE_CPP_TARGET_NAME", (Object)MesonFileTemplateFactoryKt.getMESON_EXECUTABLE_CPP_TARGET_NAME().invoke((Object)normalizedProjectName)), TuplesKt.to((Object)"MESON_TEST_TARGET_NAME", (Object)"test"), TuplesKt.to((Object)"MESON_EXECUTABLE_C_SOURCE_DEFAULT_NAME", (Object)"main.c"), TuplesKt.to((Object)"MESON_LIBRARY_C_SOURCE_DEFAULT_NAME", (Object)"main.c"), TuplesKt.to((Object)"MESON_LIBRARY_C_HEADER_DEFAULT_NAME", (Object)"main.h"), TuplesKt.to((Object)"MESON_EXECUTABLE_CPP_SOURCE_DEFAULT_NAME", (Object)"main.cpp"), TuplesKt.to((Object)"MESON_LIBRARY_CPP_SOURCE_DEFAULT_NAME", (Object)"main.cpp"), TuplesKt.to((Object)"MESON_LIBRARY_CPP_HEADER_DEFAULT_NAME", (Object)"main.h"), TuplesKt.to((Object)"MESON_WARNING_LEVEL", (Object)"3"), TuplesKt.to((Object)"MESON_INSTALL_OPTION", (Object)"true"), TuplesKt.to((Object)"MESON_LIB_ARGS", (Object)"lib_args"), TuplesKt.to((Object)"BUILDING_LIBRARY_ARGUMENT", (Object)"BUILDING_MESON_LIBRARY"), TuplesKt.to((Object)"MESON_CPP_LANGUAGE_STANDARD", (Object)cppStandard), TuplesKt.to((Object)"MESON_C_LANGUAGE_STANDARD", (Object)cStandard)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final FileContent generateSourceFilesPathAndText(Project project, FileTemplateManager fileTemplateManager, MesonProjectGenerator projectGenerator) {
        MesonProjectGeneratorLanguage language = (MesonProjectGeneratorLanguage)((Object)projectGenerator.getLanguageProperty().get());
        projectGenerator.getTypeProperty().get();
        switch (WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
            case 1: {
                String string = fileTemplateManager.getJ2eeTemplate("main.c.txt").getText(this.getDefaultProjectProperties(project));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                return new FileContent("main.c", string);
            }
            case 2: {
                String string = fileTemplateManager.getJ2eeTemplate("main.cpp.txt").getText(this.getDefaultProjectProperties(project));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                return new FileContent("main.cpp", string);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final Properties getDefaultProjectProperties(Project project) {
        PsiDirectory psiDir;
        FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)project);
        Properties properties = templateManager.getDefaultProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getDefaultProperties(...)");
        Properties props = properties;
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        if (projectDir != null && (psiDir = PsiManager.getInstance((Project)project).findDirectory(projectDir)) != null) {
            FileTemplateUtil.fillDefaultProperties((Properties)props, (PsiDirectory)psiDir);
        }
        return props;
    }

    private static final FileContent generateProject$lambda$0(Project $project, FileTemplateManager $fileTemplateManager, MesonProjectGenerator $projectGenerator) {
        Intrinsics.checkNotNull((Object)$fileTemplateManager);
        return INSTANCE.generateSourceFilesPathAndText($project, $fileTemplateManager, $projectGenerator);
    }

    /*
     * WARNING - void declaration
     */
    private static final void generateProject$lambda$3(Ref.ObjectRef $buildFile, VirtualFile $baseDir, Project $project, Ref.ObjectRef $sourceVirtualFile, FileContent $sourceFile, String $mesonBuildFileText) {
        void $this$generateProject_u24lambda_u243_u24lambda_u242;
        VirtualFile $this$generateProject_u24lambda_u243_u24lambda_u241;
        VirtualFile virtualFile;
        VirtualFile virtualFile2 = virtualFile = $baseDir.createChildData((Object)$project, "meson.build");
        Ref.ObjectRef objectRef = $buildFile;
        boolean bl = false;
        String string = $mesonBuildFileText;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        $this$generateProject_u24lambda_u243_u24lambda_u241.setBinaryContent(byArray);
        objectRef.element = virtualFile;
        $this$generateProject_u24lambda_u243_u24lambda_u241 = virtualFile = $baseDir.createChildData((Object)$project, $sourceFile.getFileName());
        objectRef = $sourceVirtualFile;
        boolean bl2 = false;
        string = $sourceFile.getContent();
        Charset charset2 = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
        byte[] byArray2 = string.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        $this$generateProject_u24lambda_u243_u24lambda_u242.setBinaryContent(byArray2);
        objectRef.element = virtualFile;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/meson/wizard/project/MesonProjectGeneratorProjectCreator$FileContent;", "", "fileName", "", "content", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getFileName", "()Ljava/lang/String;", "getContent", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.clion.meson"})
    private static final class FileContent {
        @NotNull
        private final String fileName;
        @NotNull
        private final String content;

        public FileContent(@NotNull String fileName, @NotNull String content) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.fileName = fileName;
            this.content = content;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        @NotNull
        public final String component1() {
            return this.fileName;
        }

        @NotNull
        public final String component2() {
            return this.content;
        }

        @NotNull
        public final FileContent copy(@NotNull String fileName, @NotNull String content) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return new FileContent(fileName, content);
        }

        public static /* synthetic */ FileContent copy$default(FileContent fileContent, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = fileContent.fileName;
            }
            if ((n & 2) != 0) {
                string2 = fileContent.content;
            }
            return fileContent.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "FileContent(fileName=" + this.fileName + ", content=" + this.content + ")";
        }

        public int hashCode() {
            int result2 = this.fileName.hashCode();
            result2 = result2 * 31 + this.content.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileContent)) {
                return false;
            }
            FileContent fileContent = (FileContent)other;
            if (!Intrinsics.areEqual((Object)this.fileName, (Object)fileContent.fileName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.content, (Object)fileContent.content);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MesonProjectGeneratorLanguage.values().length];
            try {
                nArray[MesonProjectGeneratorLanguage.C.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MesonProjectGeneratorLanguage.CPP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

