/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.meson.psi.MesonElementTypes;
import com.jetbrains.cidr.meson.psi.MesonFile;
import com.jetbrains.cidr.meson.psi.MesonLexer;
import com.jetbrains.cidr.meson.psi.MesonParser;
import com.jetbrains.cidr.meson.psi.MesonTokenTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/meson/psi/MesonParserDefinition;", "Lcom/intellij/lang/ParserDefinition;", "<init>", "()V", "createLexer", "Lcom/intellij/lexer/Lexer;", "project", "Lcom/intellij/openapi/project/Project;", "createParser", "Lcom/intellij/lang/PsiParser;", "getFileNodeType", "Lcom/intellij/psi/tree/IFileElementType;", "getWhitespaceTokens", "Lcom/intellij/psi/tree/TokenSet;", "getCommentTokens", "getStringLiteralElements", "createElement", "Lcom/intellij/psi/PsiElement;", "node", "Lcom/intellij/lang/ASTNode;", "createFile", "Lcom/intellij/psi/PsiFile;", "viewProvider", "Lcom/intellij/psi/FileViewProvider;", "intellij.clion.meson"})
public final class MesonParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(@Nullable Project project) {
        return (Lexer)new MesonLexer();
    }

    @NotNull
    public PsiParser createParser(@Nullable Project project) {
        return new MesonParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return MesonElementTypes.Companion.getMESON_FILE();
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = MesonElementTypes.Companion.getWHITE_SPACES();
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"<get-WHITE_SPACES>(...)");
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return MesonElementTypes.Companion.getCOMMENTS();
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return MesonElementTypes.Companion.getSTRING_LITERALS();
    }

    @NotNull
    public PsiElement createElement(@Nullable ASTNode node) {
        PsiElement psiElement = MesonTokenTypes.Factory.createElement(node);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createElement(...)");
        return psiElement;
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        return (PsiFile)new MesonFile(viewProvider);
    }
}

