/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson.highlighting;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.cidr.meson.colors.MesonColor;
import com.jetbrains.cidr.meson.psi.KeyValueItem;
import com.jetbrains.cidr.meson.psi.KeywordArgument;
import com.jetbrains.cidr.meson.psi.MesonExpression;
import com.jetbrains.cidr.meson.psi.MesonFunctionExpression;
import com.jetbrains.cidr.meson.psi.MesonMethodExpression;
import com.jetbrains.cidr.meson.psi.MesonTokenTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/meson/highlighting/MesonHighlighterAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "highlight", "textAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "intellij.clion.meson"})
public final class MesonHighlighterAnnotator
implements Annotator,
DumbAware {
    /*
     * Enabled aggressive block sorting
     */
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element), (Object)MesonTokenTypes.ID)) {
            psiElement = element.getParent();
            MesonFunctionExpression mesonFunctionExpression = psiElement instanceof MesonFunctionExpression ? (MesonFunctionExpression)psiElement : null;
            if (Intrinsics.areEqual((Object)(mesonFunctionExpression != null ? mesonFunctionExpression.getFunctionIdentifier() : null), (Object)element)) {
                if (element.getParent().getParent() instanceof MesonMethodExpression) {
                    this.highlight(holder, MesonColor.METHOD_CALL.getTextAttributesKey());
                    return;
                }
                this.highlight(holder, MesonColor.FUNCTION_CALL.getTextAttributesKey());
                return;
            }
        }
        if (element instanceof MesonExpression) {
            psiElement = ((MesonExpression)element).getParent();
            KeyValueItem keyValueItem = psiElement instanceof KeyValueItem ? (KeyValueItem)psiElement : null;
            if (Intrinsics.areEqual((Object)(keyValueItem != null ? keyValueItem.getKey() : null), (Object)element)) {
                this.highlight(holder, MesonColor.KEY.getTextAttributesKey());
                return;
            }
        }
        if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element), (Object)MesonTokenTypes.ID)) return;
        psiElement = element.getParent();
        KeywordArgument keywordArgument = psiElement instanceof KeywordArgument ? (KeywordArgument)psiElement : null;
        if (!Intrinsics.areEqual((Object)(keywordArgument != null ? keywordArgument.getKeyIdentifier() : null), (Object)element)) return;
        this.highlight(holder, MesonColor.KEY.getTextAttributesKey());
    }

    private final void highlight(AnnotationHolder holder, TextAttributesKey textAttributesKey) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String string = textAttributesKey.getExternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalName(...)");
            String en = string;
            String string2 = en.substring(StringsKt.lastIndexOf$default((CharSequence)en, (String)".", (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            holder.newAnnotation(HighlightSeverity.INFORMATION, string2).textAttributes(textAttributesKey).create();
        } else {
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(textAttributesKey).create();
        }
    }
}

