/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson.execution.build;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTask;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.build.runners.CidrProjectTaskRunner;
import com.jetbrains.cidr.execution.build.runners.CidrTaskRunner;
import com.jetbrains.cidr.execution.build.tasks.CidrCleanTask;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.meson.MesonUtil;
import com.jetbrains.cidr.meson.MesonUtilKt;
import com.jetbrains.cidr.meson.MesonWorkspace;
import com.jetbrains.cidr.meson.execution.build.MesonAbstractBuildProjectTaskRunner;
import com.jetbrains.cidr.meson.execution.build.MesonBuildAllConfiguration;
import com.jetbrains.cidr.meson.execution.build.MesonBuildConfiguration;
import com.jetbrains.cidr.meson.execution.build.MesonBuildTargetConfiguration;
import com.jetbrains.cidr.meson.execution.build.MesonCustomProjectTask;
import com.jetbrains.cidr.meson.execution.build.MesonProjectBuildFilesRunner;
import com.jetbrains.cidr.meson.execution.build.MesonProjectBuildTargetTaskRunner;
import com.jetbrains.cidr.meson.execution.build.MesonProjectBuildTaskRunner;
import com.jetbrains.cidr.meson.execution.build.MesonProjectCleanTaskRunner;
import com.jetbrains.cidr.meson.execution.build.MesonProjectTaskRunnerKt;
import com.jetbrains.cidr.meson.settings.MesonProjectSettings;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/meson/execution/build/MesonProjectTaskRunner;", "Lcom/jetbrains/cidr/execution/build/runners/CidrProjectTaskRunner;", "<init>", "()V", "buildSystemId", "", "getBuildSystemId", "()Ljava/lang/String;", "runnerForTask", "Lcom/jetbrains/cidr/execution/build/runners/CidrTaskRunner;", "task", "Lcom/intellij/task/ProjectTask;", "project", "Lcom/intellij/openapi/project/Project;", "canRun", "", "projectTask", "intellij.clion.meson"})
@SourceDebugExtension(value={"SMAP\nMesonProjectTaskRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MesonProjectTaskRunner.kt\ncom/jetbrains/cidr/meson/execution/build/MesonProjectTaskRunner\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,84:1\n12574#2,2:85\n*S KotlinDebug\n*F\n+ 1 MesonProjectTaskRunner.kt\ncom/jetbrains/cidr/meson/execution/build/MesonProjectTaskRunner\n*L\n69#1:85,2\n*E\n"})
public final class MesonProjectTaskRunner
extends CidrProjectTaskRunner {
    @NotNull
    private final String buildSystemId;

    public MesonProjectTaskRunner() {
        String string = MesonUtilKt.getID().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        this.buildSystemId = string;
    }

    @NotNull
    public String getBuildSystemId() {
        return this.buildSystemId;
    }

    @Nullable
    public CidrTaskRunner runnerForTask(@NotNull ProjectTask task, @NotNull Project project) {
        CidrTaskRunner cidrTaskRunner;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectTask projectTask = task;
        if (projectTask instanceof ProjectModelBuildTask) {
            ProjectModelBuildableElement projectModelBuildableElement = ((ProjectModelBuildTask)task).getBuildableElement();
            Intrinsics.checkNotNull((Object)projectModelBuildableElement, (String)"null cannot be cast to non-null type com.jetbrains.cidr.meson.execution.build.MesonBuildConfiguration");
            MesonBuildConfiguration buildConfiguration = (MesonBuildConfiguration)projectModelBuildableElement;
            cidrTaskRunner = buildConfiguration instanceof MesonBuildAllConfiguration ? (MesonAbstractBuildProjectTaskRunner)new MesonProjectBuildTaskRunner((MesonBuildAllConfiguration)buildConfiguration) : (buildConfiguration instanceof MesonBuildTargetConfiguration ? (MesonAbstractBuildProjectTaskRunner)new MesonProjectBuildTargetTaskRunner((MesonBuildTargetConfiguration)buildConfiguration) : null);
        } else if (projectTask instanceof ModuleFilesBuildTask) {
            MesonProjectSettings settings = (MesonProjectSettings)((Object)CollectionsKt.first((Iterable)MesonUtil.INSTANCE.linkedProjectSettings(project)));
            MesonProjectSettings.MesonProfile profile = settings.profile();
            cidrTaskRunner = (CidrTaskRunner)new MesonProjectBuildFilesRunner(profile.getToolchainName());
        } else if (projectTask instanceof ModuleBuildTask) {
            MesonProjectSettings settings = (MesonProjectSettings)((Object)CollectionsKt.first((Iterable)MesonUtil.INSTANCE.linkedProjectSettings(project)));
            MesonProjectSettings.MesonProfile profile = settings.profile();
            Path buildDir = profile.getBuildPath(project);
            MesonBuildAllConfiguration buildConfiguration = new MesonBuildAllConfiguration(profile.getName(), profile.getToolchainName(), buildDir, profile.getMesonExecutable());
            cidrTaskRunner = new MesonProjectBuildTaskRunner(buildConfiguration);
        } else if (projectTask instanceof CidrCleanTask) {
            CidrBuildConfiguration cidrBuildConfiguration = ((CidrCleanTask)task).getBuildConfiguration();
            Intrinsics.checkNotNull((Object)cidrBuildConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.cidr.meson.execution.build.MesonBuildConfiguration");
            MesonBuildConfiguration buildConfiguration = (MesonBuildConfiguration)cidrBuildConfiguration;
            cidrTaskRunner = new MesonProjectCleanTaskRunner(buildConfiguration);
        } else if (projectTask instanceof MesonCustomProjectTask) {
            cidrTaskRunner = ((MesonCustomProjectTask)task).getRunner();
        } else {
            MesonProjectTaskRunnerKt.getLOG().warn("Trying to get task runner for task with type " + task.getClass().getName() + " in " + MesonProjectTaskRunner.class.getSimpleName());
            cidrTaskRunner = null;
        }
        return cidrTaskRunner;
    }

    public boolean canRun(@NotNull ProjectTask projectTask) {
        boolean bl;
        block8: {
            ProjectTask projectTask2;
            block9: {
                block11: {
                    block10: {
                        boolean bl2;
                        block6: {
                            block7: {
                                Intrinsics.checkNotNullParameter((Object)projectTask, (String)"projectTask");
                                projectTask2 = projectTask;
                                if (!(projectTask2 instanceof ProjectModelBuildTask)) break block7;
                                bl = ((ProjectModelBuildTask)projectTask).getBuildableElement() instanceof MesonBuildConfiguration;
                                break block8;
                            }
                            if (!(projectTask2 instanceof ModuleFilesBuildTask)) break block9;
                            VirtualFile[] virtualFileArray = ((ModuleFilesBuildTask)projectTask).getFiles();
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
                            if (((Object[])virtualFileArray).length == 0) break block10;
                            VirtualFile[] virtualFileArray2 = ((ModuleFilesBuildTask)projectTask).getFiles();
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"getFiles(...)");
                            Object[] $this$any$iv = virtualFileArray2;
                            boolean $i$f$any = false;
                            for (Object element$iv : $this$any$iv) {
                                VirtualFile it = (VirtualFile)element$iv;
                                boolean bl3 = false;
                                if (!(it.isDirectory() || !OCFileTypeHelpers.isSourceFile((String)it.getName()) && !OCFileTypeHelpers.isHeaderFile((String)it.getName()))) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                        if (!bl2) break block11;
                    }
                    return false;
                }
                Project project = ((ModuleFilesBuildTask)projectTask).getModule().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                MesonWorkspace workspace = MesonWorkspace.Companion.getInstance(project);
                bl = workspace.isInitialized() && Intrinsics.areEqual((Object)((ModuleFilesBuildTask)projectTask).getModule(), (Object)workspace.getModule());
                break block8;
            }
            if (projectTask2 instanceof ModuleBuildTask) {
                Project project = ((ModuleBuildTask)projectTask).getModule().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                MesonWorkspace workspace = MesonWorkspace.Companion.getInstance(project);
                bl = workspace.isInitialized() && Intrinsics.areEqual((Object)((ModuleBuildTask)projectTask).getModule(), (Object)workspace.getModule());
            } else {
                bl = projectTask2 instanceof CidrCleanTask ? ((CidrCleanTask)projectTask).getBuildConfiguration() instanceof MesonBuildConfiguration : projectTask2 instanceof MesonCustomProjectTask;
            }
        }
        return bl;
    }
}

