/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.meson;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.external.system.workspace.ExternalWorkspace;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.meson.MesonUtil;
import com.jetbrains.cidr.meson.MesonUtilKt;
import com.jetbrains.cidr.meson.bundle.MesonBundle;
import com.jetbrains.cidr.meson.settings.MesonProjectSettings;
import com.jetbrains.cidr.project.workspace.WorkspaceWithEnvironment;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="MesonWorkspace")
@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tH\u0016J8\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\bJ\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0017H\u0016R\u0014\u0010\u0013\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/cidr/meson/MesonWorkspace;", "Lcom/jetbrains/cidr/external/system/workspace/ExternalWorkspace;", "Lcom/jetbrains/cidr/project/workspace/WorkspaceWithEnvironment;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getClientKey", "", "Lorg/jetbrains/annotations/NotNull;", "createEnvironment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "toolchainNameOrNullForDefault", "problems", "Lcom/jetbrains/cidr/toolchains/EnvironmentProblems;", "checkIfFunctional", "", "onMissingToolchain", "Ljava/lang/Runnable;", "environment", "getEnvironment", "()Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "collectExcludeRoots", "", "Ljava/io/File;", "contentRoot", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "Companion", "intellij.clion.meson"})
@SourceDebugExtension(value={"SMAP\nMesonWorkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MesonWorkspace.kt\ncom/jetbrains/cidr/meson/MesonWorkspace\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1368#2:98\n1454#2,5:99\n1557#2:104\n1628#2,3:105\n*S KotlinDebug\n*F\n+ 1 MesonWorkspace.kt\ncom/jetbrains/cidr/meson/MesonWorkspace\n*L\n74#1:98\n74#1:99,5\n75#1:104\n75#1:105,3\n*E\n"})
public final class MesonWorkspace
extends ExternalWorkspace
implements WorkspaceWithEnvironment {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public MesonWorkspace(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @NotNull
    public String getClientKey() {
        String string = MesonUtilKt.getID().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return string;
    }

    @Nullable
    public CPPEnvironment createEnvironment(@Nullable Project project, @Nullable String toolchainNameOrNullForDefault, @NotNull EnvironmentProblems problems, boolean checkIfFunctional, @Nullable Runnable onMissingToolchain) {
        Intrinsics.checkNotNullParameter((Object)problems, (String)"problems");
        return CPPToolchains.createCPPEnvironment((Project)project, (File)this.getProjectPath().toFile(), (String)toolchainNameOrNullForDefault, (EnvironmentProblems)problems, (boolean)checkIfFunctional, (Runnable)onMissingToolchain);
    }

    @NotNull
    public final CPPEnvironment createEnvironment(@Nullable String toolchainNameOrNullForDefault) throws ExecutionException {
        EnvironmentProblems environmentProblems = new EnvironmentProblems();
        CPPEnvironment environment = this.createEnvironment(this.getProject(), toolchainNameOrNullForDefault, environmentProblems, false, null);
        if (environmentProblems.hasProblems() || environment == null) {
            environmentProblems.throwAsExecutionException();
            throw new ExecutionException(MesonBundle.message("resolver.no.environment", new Object[0]));
        }
        return environment;
    }

    private final CPPEnvironment getEnvironment() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        MesonProjectSettings projectSettings = (MesonProjectSettings)((Object)CollectionsKt.first((Iterable)MesonUtil.INSTANCE.linkedProjectSettings(project)));
        EnvironmentProblems environmentProblems = new EnvironmentProblems();
        CPPEnvironment environment = this.createEnvironment(this.myProject, projectSettings.profile().getToolchainName(), environmentProblems, false, null);
        environmentProblems.throwAsExecutionException();
        if (environment == null) {
            throw new ExecutionException(MesonBundle.message("resolver.no.environment", new Object[0]));
        }
        return environment;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<File> collectExcludeRoots(@Nullable File contentRoot) {
        if (this.isInitialized()) {
            try {
                void $this$mapTo$iv$iv;
                Object list$iv$iv;
                MesonProjectSettings it;
                Iterable $this$flatMapTo$iv$iv;
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Iterable $this$flatMap$iv = MesonUtil.INSTANCE.linkedProjectSettings(project);
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (MesonProjectSettings)((Object)element$iv$iv);
                    boolean bl = false;
                    list$iv$iv = it.getProfiles();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$flatMapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    list$iv$iv = (MesonProjectSettings.MesonProfile)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Path path = this.getProjectPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getProjectPath(...)");
                    collection.add(((MesonProjectSettings.MesonProfile)((Object)it)).getBuildPath(path).toFile());
                }
                return (List)destination$iv$iv;
            }
            catch (IOException ex) {
                return CollectionsKt.emptyList();
            }
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<CidrToolEnvironment> getEnvironment() {
        List list;
        try {
            list = CollectionsKt.listOf((Object)this.getEnvironment());
        }
        catch (ExecutionException ex) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @JvmStatic
    @NotNull
    public static final MesonWorkspace getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/meson/MesonWorkspace$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/cidr/meson/MesonWorkspace;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clion.meson"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MesonWorkspace getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(MesonWorkspace.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (MesonWorkspace)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

