/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangQuickFixFactoryKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.inspections.IfToTernary;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCBreakStatement;
import com.jetbrains.cidr.lang.psi.OCContinueStatement;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCEmptyStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;
import com.jetbrains.cidr.lang.quickfixes.OCChangeElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b\u001a\u001d\u0010\f\u001a\n \r*\u0004\u0018\u00010\b0\b2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u000f\u001a\u0016\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0002\u001a&\u0010\u0012\u001a\u0004\u0018\u00010\u00012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0006\u0010\u000e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0006H\u0002\u001a \u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0002\u001a\u0010\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0019H\u0002\u00a8\u0006'"}, d2={"getSimplifyFix", "Lcom/intellij/codeInsight/intention/IntentionAction;", "element", "Lcom/intellij/psi/PsiElement;", "simplified", "getStatementName", "", "simplifyStatementWithConstCondition", "Lcom/jetbrains/cidr/lang/psi/OCStatement;", "conditionValue", "", "statement", "createEmptyStatement", "kotlin.jvm.PlatformType", "context", "(Lcom/intellij/psi/PsiElement;)Lcom/jetbrains/cidr/lang/psi/OCStatement;", "isSafeToSimplify", "tryGetSimplifyFix", "getSimplifyQuickFix", "params", "", "Lcom/jetbrains/cidr/lang/symbols/OCResolveContext;", "urlConverter", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/ClangUrlConverter;", "parenthesize", "Lcom/jetbrains/cidr/lang/psi/OCExpression;", "expression", "parentPrecedence", "", "ensureIsBoolean", "expr", "defaultTypeValue", "binaryExpr", "left", "right", "operator", "Lcom/jetbrains/cidr/lang/parser/OCElementType;", "negateExpr", "operand", "intellij.c.clangdBridge"})
@SourceDebugExtension(value={"SMAP\nSimplifyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimplifyInspection.kt\ncom/jetbrains/cidr/lang/inspections/SimplifyInspectionKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,236:1\n11165#2:237\n11500#2,3:238\n774#3:241\n865#3:242\n866#3:244\n1#4:243\n*S KotlinDebug\n*F\n+ 1 SimplifyInspection.kt\ncom/jetbrains/cidr/lang/inspections/SimplifyInspectionKt\n*L\n56#1:237\n56#1:238,3\n56#1:241\n56#1:242\n56#1:244\n*E\n"})
public final class SimplifyInspectionKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IntentionAction getSimplifyFix(@NotNull PsiElement element, @NotNull PsiElement simplified) {
        IntentionAction intentionAction;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)simplified, (String)"simplified");
        String subject = SimplifyInspectionKt.getStatementName(element);
        if (element instanceof OCStatement && element.getParent() instanceof OCBlockStatement && simplified instanceof OCBlockStatement) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$mapTo$iv$iv;
            ASTNode[] aSTNodeArray = ((OCBlockStatement)simplified).getNode().getChildren(null);
            Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
            Object $this$map$iv = aSTNodeArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((Object[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ASTNode aSTNode = (ASTNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPsi());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                PsiElement it = (PsiElement)element$iv$iv;
                boolean bl2 = false;
                if (PsiTreeUtilKt.getElementType((PsiElement)it) != null) {
                    IElementType it2;
                    boolean bl3 = false;
                    bl = !OCTokenTypes.WHITESPACES.contains(it2);
                } else {
                    bl = false;
                }
                if (!(bl && !Intrinsics.areEqual((Object)it, (Object)((OCBlockStatement)simplified).getOpeningBrace()) && !Intrinsics.areEqual((Object)it, (Object)((OCBlockStatement)simplified).getClosingBrace()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List children = (List)destination$iv$iv;
            Object[] objectArray2 = new Object[]{subject};
            intentionAction = (IntentionAction)new OCChangeElementIntentionAction(element, children, OCInspectionsBundle.message((String)"intention.family.name.simplify", (Object[])objectArray2));
        } else if (simplified instanceof OCEmptyStatement) {
            Object[] objectArray = new Object[]{subject};
            intentionAction = (IntentionAction)new OCRemoveElementsIntentionAction(element, CommonQuickFixBundle.message((String)"fix.remove.title", (Object[])objectArray));
        } else if (simplified instanceof OCExpression && element instanceof OCIfStatement) {
            intentionAction = (IntentionAction)new IfToTernary(subject, element, simplified);
        } else if (element instanceof OCExpression) {
            intentionAction = (IntentionAction)new OCChangeElementIntentionAction((PsiElement)OCParenthesesUtils.topmostParenthesized((OCExpression)((OCExpression)element)), simplified, OCInspectionsBundle.message((String)"intention.family.name.simplify.expression", (Object[])new Object[0]));
        } else {
            Object[] objectArray = new Object[]{subject};
            intentionAction = (IntentionAction)new OCChangeElementIntentionAction(element, simplified, OCInspectionsBundle.message((String)"intention.family.name.simplify", (Object[])objectArray));
        }
        return intentionAction;
    }

    private static final String getStatementName(PsiElement element) {
        PsiElement psiElement = element;
        return psiElement instanceof OCIfStatement ? "'if' statement" : (psiElement instanceof OCWhileStatement ? "'while' statement" : (psiElement instanceof OCDoWhileStatement ? "'do-while' statement" : (psiElement instanceof OCForStatement ? "'for' statement" : "statement")));
    }

    @Nullable
    public static final OCStatement simplifyStatementWithConstCondition(boolean conditionValue, @NotNull OCStatement statement) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        OCStatement oCStatement = statement;
        if (oCStatement instanceof OCIfStatement) {
            OCStatement thenBranch = ((OCIfStatement)statement).getThenBranch();
            OCStatement elseBranch = ((OCIfStatement)statement).getElseBranch();
            if (conditionValue) {
                object = thenBranch;
            } else {
                object = elseBranch;
                if (object == null) {
                    object = SimplifyInspectionKt.createEmptyStatement((PsiElement)statement);
                }
            }
        } else if (oCStatement instanceof OCWhileStatement) {
            object = conditionValue ? null : SimplifyInspectionKt.createEmptyStatement((PsiElement)statement);
        } else if (oCStatement instanceof OCDoWhileStatement) {
            object = conditionValue ? null : ((OCDoWhileStatement)statement).getBody();
        } else if (oCStatement instanceof OCForStatement) {
            OCStatement initializer = ((OCForStatement)statement).getInitializer();
            if (conditionValue) {
                object = null;
            } else {
                object = initializer;
                if (object == null) {
                    object = SimplifyInspectionKt.createEmptyStatement((PsiElement)statement);
                }
            }
        } else {
            OCLog.LOG.info("Unsupported element in simplify condition: " + statement.getClass().getCanonicalName());
            object = null;
        }
        return object;
    }

    private static final OCStatement createEmptyStatement(PsiElement context) {
        return OCElementFactory.statementFromText((String)";", (PsiElement)context);
    }

    public static final boolean isSafeToSimplify(@NotNull PsiElement element, @NotNull PsiElement simplified) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)simplified, (String)"simplified");
        if (element instanceof OCDoWhileStatement) {
            Class[] classArray = new Class[]{OCBreakStatement.class, OCContinueStatement.class};
            Collection collection = PsiTreeUtil.findChildrenOfAnyType((PsiElement)simplified, (Class[])classArray);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfAnyType(...)");
            Collection statements = collection;
            for (OCStatement statement : statements) {
                PsiElement parentElement;
                PsiElement psiElement;
                if (statement instanceof OCBreakStatement) {
                    Class[] classArray2 = new Class[]{OCSwitchStatement.class, OCLoopStatement.class};
                    psiElement = PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)statement), (Class[])classArray2);
                } else {
                    psiElement = PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)statement), OCLoopStatement.class);
                }
                if ((parentElement = psiElement) != element) continue;
                return false;
            }
        }
        return true;
    }

    private static final IntentionAction tryGetSimplifyFix(PsiElement element, PsiElement simplified) {
        return simplified != null && SimplifyInspectionKt.isSafeToSimplify(element, simplified) ? SimplifyInspectionKt.getSimplifyFix(element, simplified) : null;
    }

    @Nullable
    public static final IntentionAction getSimplifyQuickFix(@NotNull List<String> params, @NotNull OCResolveContext context, @NotNull ClangUrlConverter urlConverter) {
        String fixitId;
        block47: {
            OCPunctuatorElementType oCPunctuatorElementType;
            Intrinsics.checkNotNullParameter(params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)urlConverter, (String)"urlConverter");
            fixitId = params.get(0);
            if (Intrinsics.areEqual((Object)fixitId, (Object)"cond-stmt") && params.size() == 3) {
                Project project = context.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                PsiElement psiElement = ClangQuickFixFactoryKt.locatePsiElement(params.get(2), project, urlConverter);
                OCStatement oCStatement = psiElement instanceof OCStatement ? (OCStatement)psiElement : null;
                if (oCStatement == null) {
                    return null;
                }
                OCStatement stmt = oCStatement;
                boolean condition = Intrinsics.areEqual((Object)params.get(1), (Object)"true");
                return SimplifyInspectionKt.tryGetSimplifyFix((PsiElement)stmt, (PsiElement)SimplifyInspectionKt.simplifyStatementWithConstCondition(condition, stmt));
            }
            if (Intrinsics.areEqual((Object)fixitId, (Object)"const-cond") && params.size() == 3) {
                PsiElement parent;
                boolean bl;
                Project project = context.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Object object = ClangQuickFixFactoryKt.locatePsiElement(params.get(2), project, urlConverter);
                OCExpression oCExpression = object instanceof OCExpression ? (OCExpression)object : null;
                if (oCExpression == null) {
                    return null;
                }
                OCExpression cond = oCExpression;
                object = params.get(1);
                if (Intrinsics.areEqual((Object)object, (Object)"true")) {
                    bl = true;
                } else if (Intrinsics.areEqual((Object)object, (Object)"false")) {
                    bl = false;
                } else {
                    return null;
                }
                boolean condition = bl;
                OCExpression oCExpression2 = OCParenthesesUtils.topmostParenthesized((OCExpression)cond);
                PsiElement psiElement = oCExpression2 != null && (oCExpression2 = oCExpression2.getParent()) != null ? oCExpression2.getParent() : (parent = null);
                if (parent instanceof OCIfStatement || parent instanceof OCLoopStatement) {
                    return SimplifyInspectionKt.tryGetSimplifyFix(parent, (PsiElement)SimplifyInspectionKt.simplifyStatementWithConstCondition(condition, (OCStatement)parent));
                }
                return SimplifyInspectionKt.tryGetSimplifyFix((PsiElement)cond, (PsiElement)OCElementFactory.booleanConstant((boolean)condition, (OCResolveContext)context));
            }
            if (Intrinsics.areEqual((Object)fixitId, (Object)"expr") && params.size() == 4) {
                Project project = context.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                OCExpression oCExpression = (OCExpression)PsiTreeUtil.getParentOfType((PsiElement)ClangQuickFixFactoryKt.locatePsiElement(params.get(1), project, urlConverter), OCExpression.class, (boolean)false);
                if (oCExpression == null) {
                    return null;
                }
                OCExpression operand = oCExpression;
                String defaultTypeValue = params.get(2);
                Project project2 = context.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                PsiElement psiElement = ClangQuickFixFactoryKt.locatePsiElement(params.get(3), project2, urlConverter);
                if (psiElement == null) {
                    return null;
                }
                PsiElement element = psiElement;
                return SimplifyInspectionKt.tryGetSimplifyFix(element, (PsiElement)SimplifyInspectionKt.ensureIsBoolean(operand, defaultTypeValue));
            }
            if (Intrinsics.areEqual((Object)fixitId, (Object)"negate") && params.size() == 4) {
                Project project = context.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                OCExpression oCExpression = (OCExpression)PsiTreeUtil.getParentOfType((PsiElement)ClangQuickFixFactoryKt.locatePsiElement(params.get(1), project, urlConverter), OCExpression.class, (boolean)false);
                if (oCExpression == null) {
                    return null;
                }
                OCExpression operand = oCExpression;
                String defaultTypeValue = params.get(2);
                Project project3 = context.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                PsiElement psiElement = ClangQuickFixFactoryKt.locatePsiElement(params.get(3), project3, urlConverter);
                if (psiElement == null) {
                    return null;
                }
                PsiElement element = psiElement;
                return SimplifyInspectionKt.tryGetSimplifyFix(element, (PsiElement)SimplifyInspectionKt.negateExpr(SimplifyInspectionKt.ensureIsBoolean(operand, defaultTypeValue)));
            }
            if (!Intrinsics.areEqual((Object)fixitId, (Object)"binary") || params.size() != 6) break block47;
            Project project = context.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            OCExpression oCExpression = (OCExpression)PsiTreeUtil.getParentOfType((PsiElement)ClangQuickFixFactoryKt.locatePsiElement(params.get(1), project, urlConverter), OCExpression.class, (boolean)false);
            if (oCExpression == null) {
                return null;
            }
            OCExpression left = oCExpression;
            String defaultTypeValue = params.get(2);
            String operatorStr = params.get(3);
            Project project4 = context.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
            OCExpression oCExpression3 = (OCExpression)PsiTreeUtil.getParentOfType((PsiElement)ClangQuickFixFactoryKt.locatePsiElement(params.get(4), project4, urlConverter), OCExpression.class, (boolean)false);
            if (oCExpression3 == null) {
                return null;
            }
            OCExpression right = oCExpression3;
            Project project5 = context.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project5, (String)"getProject(...)");
            PsiElement psiElement = ClangQuickFixFactoryKt.locatePsiElement(params.get(5), project5, urlConverter);
            if (psiElement == null) {
                return null;
            }
            PsiElement element = psiElement;
            left = SimplifyInspectionKt.ensureIsBoolean(left, defaultTypeValue);
            if (StringsKt.startsWith$default((String)operatorStr, (String)"!", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)operatorStr, (Object)"!=")) {
                left = SimplifyInspectionKt.negateExpr(left);
                String string = operatorStr.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                operatorStr = string;
            }
            switch (operatorStr) {
                case "||": {
                    oCPunctuatorElementType = OCTokenTypes.OROR;
                    break;
                }
                case "&&": {
                    oCPunctuatorElementType = OCTokenTypes.ANDAND;
                    break;
                }
                case ">": {
                    oCPunctuatorElementType = OCTokenTypes.GT;
                    break;
                }
                case "<": {
                    oCPunctuatorElementType = OCTokenTypes.LT;
                    break;
                }
                case ">=": {
                    oCPunctuatorElementType = OCTokenTypes.GTEQ;
                    break;
                }
                case "<=": {
                    oCPunctuatorElementType = OCTokenTypes.LTEQ;
                    break;
                }
                case "==": {
                    oCPunctuatorElementType = OCTokenTypes.EQEQ;
                    break;
                }
                case "!=": {
                    oCPunctuatorElementType = OCTokenTypes.EXCLEQ;
                    break;
                }
                default: {
                    return null;
                }
            }
            OCPunctuatorElementType operator = oCPunctuatorElementType;
            Intrinsics.checkNotNull((Object)operator);
            return SimplifyInspectionKt.tryGetSimplifyFix(element, (PsiElement)SimplifyInspectionKt.binaryExpr(left, right, (OCElementType)operator));
        }
        throw new IllegalArgumentException("Unknown clang fixit " + fixitId);
    }

    private static final OCExpression parenthesize(OCExpression expression, int parentPrecedence) {
        OCExpression oCExpression;
        if (OCElementUtil.isPartOfMacroSubstitution((PsiElement)((PsiElement)expression))) {
            return expression;
        }
        if (OCParenthesesUtils.getPrecedence((OCExpression)expression, (boolean)false) > parentPrecedence) {
            OCParenthesizedExpression oCParenthesizedExpression = OCParenthesesUtils.appendParentheses((OCExpression)expression);
            Intrinsics.checkNotNullExpressionValue((Object)oCParenthesizedExpression, (String)"appendParentheses(...)");
            oCExpression = (OCExpression)oCParenthesizedExpression;
        } else {
            oCExpression = expression;
        }
        return oCExpression;
    }

    private static final OCExpression ensureIsBoolean(OCExpression expr, String defaultTypeValue) {
        OCExpression oCExpression;
        if (Intrinsics.areEqual((Object)defaultTypeValue, (Object)"false")) {
            oCExpression = expr;
        } else {
            OCExpression oCExpression2 = OCElementFactory.expressionFromText((String)defaultTypeValue, (PsiElement)((PsiElement)expr), (boolean)false);
            Intrinsics.checkNotNull((Object)oCExpression2);
            OCPunctuatorElementType oCPunctuatorElementType = OCTokenTypes.EXCLEQ;
            Intrinsics.checkNotNullExpressionValue((Object)oCPunctuatorElementType, (String)"EXCLEQ");
            oCExpression = SimplifyInspectionKt.binaryExpr(expr, oCExpression2, (OCElementType)oCPunctuatorElementType);
        }
        return oCExpression;
    }

    private static final OCExpression binaryExpr(OCExpression left, OCExpression right, OCElementType operator) {
        int precedence = OCParenthesesUtils.getPrecedence((OCElementType)operator);
        OCBinaryExpression oCBinaryExpression = OCElementFactory.binaryExpression((PsiElement)((PsiElement)SimplifyInspectionKt.parenthesize(left, precedence)), (PsiElement)((PsiElement)SimplifyInspectionKt.parenthesize(right, precedence)), (OCElementType)operator);
        Intrinsics.checkNotNullExpressionValue((Object)oCBinaryExpression, (String)"binaryExpression(...)");
        return (OCExpression)oCBinaryExpression;
    }

    private static final OCExpression negateExpr(OCExpression operand) {
        OCUnaryExpression oCUnaryExpression = OCElementFactory.unaryExpression((PsiElement)((PsiElement)SimplifyInspectionKt.parenthesize(operand, OCParenthesesUtils.getPrecedence((OCElementType)((OCElementType)OCTokenTypes.EXCL)))), (OCElementType)((OCElementType)OCTokenTypes.EXCL));
        Intrinsics.checkNotNullExpressionValue((Object)oCUnaryExpression, (String)"unaryExpression(...)");
        return (OCExpression)oCUnaryExpression;
    }
}

