/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangQuickFixFactoryKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangdQuickFix;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextEdit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0014J\b\u0010\f\u001a\u00020\u0005H\u0016J\u001b\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0094\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/annotator/OCClangdQuickFix;", "Lcom/jetbrains/cidr/lang/quickfixes/OCQuickFix;", "fixit", "Lorg/eclipse/lsp4j/CodeAction;", "isPreviewMode", "", "<init>", "(Lorg/eclipse/lsp4j/CodeAction;Z)V", "(Lorg/eclipse/lsp4j/CodeAction;)V", "getFamilyName", "", "getTextInternal", "isAvailable", "invoke", "", "file", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "intellij.c.clangdBridge"})
@SourceDebugExtension(value={"SMAP\nClangQuickFixFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangQuickFixFactory.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/annotator/OCClangdQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,657:1\n1062#2:658\n1863#2,2:659\n*S KotlinDebug\n*F\n+ 1 ClangQuickFixFactory.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/annotator/OCClangdQuickFix\n*L\n81#1:658\n81#1:659,2\n*E\n"})
public final class OCClangdQuickFix
extends OCQuickFix {
    @NotNull
    private final CodeAction fixit;
    private final boolean isPreviewMode;

    public OCClangdQuickFix(@NotNull CodeAction fixit, boolean isPreviewMode) {
        Intrinsics.checkNotNullParameter((Object)fixit, (String)"fixit");
        this.fixit = fixit;
        this.isPreviewMode = isPreviewMode;
    }

    public OCClangdQuickFix(@NotNull CodeAction fixit) {
        Intrinsics.checkNotNullParameter((Object)fixit, (String)"fixit");
        this(fixit, false);
    }

    @NotNull
    public String getFamilyName() {
        String string = ClangdBundle.message((String)"language.cpp.clangd.quick.fix", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    protected String getTextInternal() {
        String string = StringUtil.capitalize((String)this.fixit.getTitle());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"capitalize(...)");
        return string;
    }

    public boolean isAvailable() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void invoke(@Nullable PsiFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (file == null) {
            return;
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager documentManager = fileDocumentManager;
        Map editsByDocument = new LinkedHashMap();
        Map map = this.fixit.getEdit().getChanges();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getChanges(...)");
        for (Map.Entry change : map.entrySet()) {
            Document document;
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl((String)change.getKey());
            if (virtualFile == null || this.isPreviewMode && !Intrinsics.areEqual((Object)virtualFile, (Object)file.getVirtualFile()) || (document = documentManager.getDocument(virtualFile)) == null) continue;
            if (editsByDocument.get(document) == null) {
                editsByDocument.put(document, (List)new ArrayList());
            }
            Object v = editsByDocument.get(document);
            Intrinsics.checkNotNull(v);
            List list = (List)v;
            Object v2 = change.getValue();
            Intrinsics.checkNotNullExpressionValue(v2, (String)"<get-value>(...)");
            list.addAll((Collection)v2);
        }
        if (editsByDocument.isEmpty()) {
            return;
        }
        for (Map.Entry documentEdits : editsByDocument.entrySet()) {
            void $this$forEach$iv;
            Document document = (Document)documentEdits.getKey();
            List edits = (List)documentEdits.getValue();
            Iterable $this$sortedByDescending$iv = edits;
            boolean $i$f$sortedByDescending = false;
            $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(document){
                final /* synthetic */ Document $document$inlined;
                {
                    this.$document$inlined = document;
                }

                public final int compare(T a, T b) {
                    TextEdit it = (TextEdit)b;
                    boolean bl = false;
                    Position position = it.getRange().getStart();
                    Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getStart(...)");
                    it = (TextEdit)a;
                    Comparable comparable = Integer.valueOf(ClangQuickFixFactoryKt.getOffset(position, this.$document$inlined));
                    bl = false;
                    Position position2 = it.getRange().getStart();
                    Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"getStart(...)");
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(ClangQuickFixFactoryKt.getOffset(position2, this.$document$inlined)));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TextEdit it = (TextEdit)element$iv;
                boolean bl = false;
                Position position = it.getRange().getStart();
                Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getStart(...)");
                int n = ClangQuickFixFactoryKt.getOffset(position, document);
                Position position2 = it.getRange().getEnd();
                Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"getEnd(...)");
                document.replaceString(n, ClangQuickFixFactoryKt.getOffset(position2, document), (CharSequence)it.getNewText());
            }
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        }
    }

    @NotNull
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return (FileModifier)new ClangdQuickFix(this.fixit, true);
    }
}

