/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.InlayHintsSettings;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridgeInterface;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorsAnnotatorPass;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangErrorsAnnotatorSlowPassFactory;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.OurClangTidyInspectionsViaClangdAnnotatorPassFactory;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.AdvancedClangIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIdeFacade;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangIndexerIdeFacadeImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Obfuscator;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ObfuscatorImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Trustworthiness;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.inspections.ClazyInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCUnusedIncludeDirectiveInspection;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForCallable;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForFile;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangForStatement;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.settings.OCFileExtensionsSettings;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangdBridgeImpl
implements ClangdBridgeInterface {
    public boolean isClangdOnlyMode() {
        return false;
    }

    public boolean isClangdKindSupported(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ClangLanguageService.Kind kind) {
        if (kind == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(0);
        }
        return true;
    }

    public void registerAnnotatorPassFactories(@NotNull TextEditorHighlightingPassRegistrar registrar, int reparsingPassId, int clangErrorsPassId) {
        if (registrar == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(1);
        }
        new ClangErrorsAnnotatorSlowPassFactory(registrar, clangErrorsPassId);
        new OurClangTidyInspectionsViaClangdAnnotatorPassFactory(registrar, reparsingPassId);
    }

    @NotNull
    public List<FileExtensionPair> getFileExtensions(@NotNull Project project) {
        if (project == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(2);
        }
        CodeStyleSettings settings = CodeStyle.getSettings((Project)project);
        List list = ((OCFileExtensionsSettings)settings.getCustomSettings(OCFileExtensionsSettings.class)).FILE_EXTENSION_PAIRS_ORDERED;
        if (list == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean isSupported(@NotNull VirtualFile vf) {
        if (vf == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(4);
        }
        return OCLanguageUtils.isSupported((VirtualFile)vf);
    }

    public boolean isClangdShowErrors(@NotNull Project project, @Nullable VirtualFile vf) {
        ClangdSettings settings;
        if (project == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(5);
        }
        return (settings = ClangdSettings.getInstance((Project)project)) != null && settings.isClangdShowErrors();
    }

    @NotNull
    public List<ClangDiagnostic> filterDiagnostics(@NotNull PsiFile file, @NotNull Trustworthiness trustworthiness, @NotNull List<ClangDiagnostic> diags) {
        if (file == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(6);
        }
        if (trustworthiness == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(7);
        }
        if (diags == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(8);
        }
        if (trustworthiness.hasNoCompilationCommand() || trustworthiness.isCompilationCommandGuessed()) {
            List list = ContainerUtil.filter(diags, diag -> {
                if (diag.getSeverity() == HighlightSeverity.ERROR) {
                    ClangErrorsAnnotatorPass.reportSuppressed((PsiFile)file, (ClangDiagnostic)diag);
                    return false;
                }
                return true;
            });
            if (list == null) {
                ClangdBridgeImpl.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<ClangDiagnostic> list = diags;
        if (list == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    public boolean isSourceFile(@NotNull VirtualFile vf) {
        if (vf == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(11);
        }
        return !vf.isDirectory() && OCFileTypeHelpers.sourceExtensions().contains(vf.getExtension());
    }

    public boolean isHeaderFile(@NotNull VirtualFile vf) {
        if (vf == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(12);
        }
        return !vf.isDirectory() && (vf.getExtension() == null || OCFileTypeHelpers.headerExtensions().contains(vf.getExtension()));
    }

    public boolean getParameterHints(@NotNull Project project) {
        if (project == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(13);
        }
        return HintUtilsKt.isParameterHintsEnabledForLanguage((Language)OCLanguageUtils.getConfigLanguage()) || InlayHintsSettings.instance().hintsEnabled(OCLanguageUtils.getConfigLanguage());
    }

    public void setParameterHints(@NotNull Project project, boolean enabled) {
        if (project == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(14);
        }
        HintUtilsKt.setShowParameterHintsForLanguage((boolean)enabled, (Language)OCLanguageUtils.getConfigLanguage());
        InlayHintsSettings.instance().setHintsEnabledForLanguage(OCLanguageUtils.getConfigLanguage(), enabled);
    }

    @NotNull
    public Class<? extends OCInspectionBase> getClazyInspection() {
        return ClazyInspection.class;
    }

    @NotNull
    public Class<? extends OCInspectionBase> getUnusedIncludesInspection() {
        return OCUnusedIncludeDirectiveInspection.class;
    }

    public boolean isInProjectSourcesOrLibraries(@NotNull Project project, @NotNull VirtualFile vf) {
        if (project == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(15);
        }
        if (vf == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(16);
        }
        return OCSearchScope.isInProjectSourcesOrLibraries((Project)project, (VirtualFile)vf);
    }

    @NotNull
    public List<SuppressIntentionAction> createSuppressActions(@NotNull PsiFile file, @NotNull TextRange range, @NotNull String warningName) {
        if (file == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(17);
        }
        if (range == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(18);
        }
        if (warningName == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(19);
        }
        OCSuppressionGroup suppressionGroup = new OCSuppressionGroup("clang", warningName);
        OCFile ocFile = OCLanguageUtils.asOCFile((PsiFile)file);
        if (ocFile == null) {
            List<SuppressIntentionAction> list = Collections.emptyList();
            if (list == null) {
                ClangdBridgeImpl.$$$reportNull$$$0(20);
            }
            return list;
        }
        List<SuppressIntentionAction> list = Arrays.asList(new OCSuppressClangForFile((PsiFile)ocFile, range, suppressionGroup), new OCSuppressClangForCallable((PsiFile)ocFile, range, suppressionGroup), new OCSuppressClangForStatement((PsiFile)ocFile, range, suppressionGroup));
        if (list == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    public ClangIdeFacade createClangIdeFacade(@NotNull @NonNls String descriptor, @NotNull ClangLanguageService.Kind forKind) {
        if (descriptor == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(22);
        }
        if (forKind == null) {
            ClangdBridgeImpl.$$$reportNull$$$0(23);
        }
        return forKind == ClangLanguageService.Kind.Indexer ? new ClangIndexerIdeFacadeImpl(descriptor) : new AdvancedClangIdeFacadeImpl(descriptor);
    }

    @NotNull
    public Obfuscator createObfuscator() {
        return new ObfuscatorImpl();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 9, 10, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangdBridgeImpl";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trustworthiness";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diags";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warningName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/ClangdBridgeImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileExtensions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDiagnostics";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isClangdKindSupported";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerAnnotatorPassFactories";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFileExtensions";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 20: 
            case 21: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isClangdShowErrors";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filterDiagnostics";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSourceFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isHeaderFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getParameterHints";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setParameterHints";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInProjectSourcesOrLibraries";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createSuppressActions";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createClangIdeFacade";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 9, 10, 20, 21 -> new IllegalStateException(string);
        };
    }
}

