/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.wizard;

import com.google.gson.stream.JsonReader;
import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.execution.wizard.Device;
import com.intellij.clion.embedded.execution.wizard.GdbServer;
import com.intellij.clion.embedded.execution.wizard.GdbServerType;
import com.intellij.clion.embedded.execution.wizard.GdbServerWizard;
import com.intellij.clion.embedded.execution.wizard.GdbWizardOptions;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.EnvironmentUtil;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/clion/embedded/execution/wizard/JLinkServer;", "Lcom/intellij/clion/embedded/execution/wizard/GdbServer;", "<init>", "()V", "getDisplayName", "", "getDefaultServerExecutableName", "getDialogPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "wizard", "Lcom/intellij/clion/embedded/execution/wizard/GdbServerWizard;", "gatherData", "", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lcom/intellij/clion/embedded/execution/wizard/GdbWizardOptions;", "findDefaultLocation", "generateConnectionString", "port", "", "Companion", "intellij.clion.embedded"})
public final class JLinkServer
extends GdbServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DEFAULT_SPEED = "8000";
    @NotNull
    private static final String DEFAULT_GDBSERVER_NAME = SystemInfo.isWindows ? "JLinkGDBServerCL.exe" : "JLinkGDBServerCLExe";
    @NotNull
    private static final String[] SPEEDS;

    public JLinkServer() {
        super(GdbServerType.JLINK);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = EmbeddedBundle.message("jlink.gdb.server.displayname", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public String getDefaultServerExecutableName() {
        return DEFAULT_GDBSERVER_NAME;
    }

    @Override
    @NotNull
    public DialogPanel getDialogPanel(@NotNull GdbServerWizard wizard) {
        Intrinsics.checkNotNullParameter((Object)((Object)wizard), (String)"wizard");
        return BuilderKt.panel(arg_0 -> JLinkServer.getDialogPanel$lambda$1(this, wizard, arg_0));
    }

    @Override
    public void gatherData(@NotNull Project project, @NotNull GdbWizardOptions state) throws CommitStepException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        super.gatherData(project, state);
        state.setDevicesTree(Companion.readDevicesList());
    }

    @Override
    @Nullable
    public String findDefaultLocation() {
        return Companion.findDefaultGdbserverLocation();
    }

    @Override
    @NotNull
    public String generateConnectionString(@NotNull GdbWizardOptions state, int port) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        String string = this.selectedDeviceKey(state);
        String string2 = state.getInterfaceType().toString();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return "-device \"" + string + "\" -if " + string3 + " -speed " + state.getFrequency() + " -port " + port + " -nogui -singlerun";
    }

    private static final Unit getDialogPanel$lambda$1$lambda$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        return Unit.INSTANCE;
    }

    private static final Unit getDialogPanel$lambda$1(JLinkServer this$0, GdbServerWizard $wizard, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = EmbeddedBundle.message("label.jlink.gdb.server", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, JLinkServer::getDialogPanel$lambda$1$lambda$0);
        Panel.separator$default((Panel)$this$panel, null, (int)1, null);
        this$0.interfacesRow($this$panel, $wizard);
        String[] stringArray = SPEEDS;
        this$0.speedRow($this$panel, $wizard, DEFAULT_SPEED, Arrays.copyOf(stringArray, stringArray.length));
        this$0.devicesListRows($this$panel, $wizard);
        return Unit.INSTANCE;
    }

    static {
        String[] stringArray = new String[]{"AUTO", "ADAPTIVE", "400", "500", "600", "750", "900", "1000", "1333", "1600", "2000", "3200", "4000", "4800", "6000", DEFAULT_SPEED, "9600", "12000", "16000"};
        SPEEDS = stringArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/clion/embedded/execution/wizard/JLinkServer$Companion;", "", "<init>", "()V", "DEFAULT_SPEED", "", "DEFAULT_GDBSERVER_NAME", "getDEFAULT_GDBSERVER_NAME", "()Ljava/lang/String;", "SPEEDS", "", "getSPEEDS", "()[Ljava/lang/String;", "[Ljava/lang/String;", "readDevicesList", "Ljavax/swing/tree/DefaultMutableTreeNode;", "findDefaultGdbserverLocation", "intellij.clion.embedded"})
    @SourceDebugExtension(value={"SMAP\nJLinkServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JLinkServer.kt\ncom/intellij/clion/embedded/execution/wizard/JLinkServer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1611#2,9:105\n1863#2:114\n1864#2:116\n1620#2:117\n1557#2:118\n1628#2,3:119\n1368#2:122\n1454#2,5:123\n1557#2:128\n1628#2,3:129\n774#2:132\n865#2,2:133\n1#3:115\n*S KotlinDebug\n*F\n+ 1 JLinkServer.kt\ncom/intellij/clion/embedded/execution/wizard/JLinkServer$Companion\n*L\n88#1:105,9\n88#1:114\n88#1:116\n88#1:117\n89#1:118\n89#1:119,3\n93#1:122\n93#1:123,5\n94#1:128\n94#1:129,3\n95#1:132\n95#1:133,2\n88#1:115\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDEFAULT_GDBSERVER_NAME() {
            return DEFAULT_GDBSERVER_NAME;
        }

        @NotNull
        public final String[] getSPEEDS() {
            return SPEEDS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final DefaultMutableTreeNode readDevicesList() {
            DefaultMutableTreeNode devicesTree = new DefaultMutableTreeNode();
            InputStream inputStream = this.getClass().getResourceAsStream("segger-devices.json");
            Intrinsics.checkNotNull((Object)inputStream);
            InputStream deviceList = inputStream;
            Closeable closeable = (Closeable)new JsonReader((Reader)new InputStreamReader(deviceList));
            Throwable throwable = null;
            try {
                JsonReader jsonReader = (JsonReader)closeable;
                boolean bl = false;
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    String vendorName = jsonReader.nextName();
                    DefaultMutableTreeNode vendorNode = new DefaultMutableTreeNode(vendorName);
                    devicesTree.add(vendorNode);
                    jsonReader.beginObject();
                    while (jsonReader.hasNext()) {
                        String groupName = jsonReader.nextName();
                        DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode(groupName);
                        vendorNode.add(groupNode);
                        jsonReader.beginObject();
                        while (jsonReader.hasNext()) {
                            String mcuKey = jsonReader.nextName();
                            String description = jsonReader.nextString();
                            Intrinsics.checkNotNull((Object)mcuKey);
                            Intrinsics.checkNotNull((Object)vendorName);
                            groupNode.add(new DefaultMutableTreeNode(new Device(mcuKey, vendorName, null, null, description, 12, null)));
                        }
                        jsonReader.endObject();
                    }
                    jsonReader.endObject();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return devicesTree;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final String findDefaultGdbserverLocation() {
            String location2 = GdbServer.Companion.findPathLocation(this.getDEFAULT_GDBSERVER_NAME());
            if (location2 == null) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                void $this$flatMapTo$iv$iv;
                List list;
                Iterable<File> iterable;
                Iterable destination$iv$iv;
                Object object;
                if (SystemInfo.isWindows) {
                    void $this$mapTo$iv$iv2;
                    Iterable $this$mapNotNullTo$iv$iv;
                    object = new String[]{"ProgramFiles", "ProgramFiles(x86)"};
                    Iterable $this$mapNotNull$iv = CollectionsKt.listOf((Object[])object);
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable2 = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Object object2 = $this$forEach$iv$iv$iv.iterator();
                    while (object2.hasNext()) {
                        String it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = object2.next();
                        boolean bl = false;
                        String p0 = (String)element$iv$iv;
                        boolean $i$f$findDefaultGdbserverLocation$stub_for_inlining = false;
                        boolean bl2 = false;
                        if (EnvironmentUtil.getValue((String)p0) == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    Iterable $this$map$iv2 = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv2;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void s;
                        object2 = (String)item$iv$iv;
                        iterable = destination$iv$iv;
                        boolean bl = false;
                        iterable.add(new File((String)s, "SEGGER"));
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = SystemInfo.isMac ? CollectionsKt.listOf((Object)new File("/Applications/SEGGER/")) : CollectionsKt.listOf((Object)new File("/opt/SEGGER/"));
                }
                List baseFolders = list;
                Iterable $this$flatMap$iv = baseFolders;
                boolean $i$f$flatMap = false;
                destination$iv$iv = $this$flatMap$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    File it = (File)element$iv$iv;
                    boolean bl = false;
                    Object object3 = it.listFiles();
                    if (object3 == null || (object3 = ArraysKt.asList((Object[])object3)) == null) {
                        object3 = CollectionsKt.emptyList();
                    }
                    Iterable list$iv$iv = (Iterable)object3;
                    CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv2;
                boolean $i$f$map = false;
                $this$flatMapTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void dir;
                    File list$iv$iv = (File)item$iv$iv;
                    iterable = destination$iv$iv2;
                    boolean bl = false;
                    iterable.add(new File((File)dir, Companion.getDEFAULT_GDBSERVER_NAME()));
                }
                $this$map$iv = (List)destination$iv$iv2;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    File p0 = (File)element$iv$iv;
                    boolean $i$f$findDefaultGdbserverLocation$stub_for_inlining$4 = false;
                    boolean bl = false;
                    if (!p0.canExecute()) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                object = (File)CollectionsKt.getOrNull((List)CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv2), (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        File p0 = (File)b;
                        boolean $i$f$findDefaultGdbserverLocation$stub_for_inlining$5 = false;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)p0.toString());
                        p0 = (File)a;
                        Comparable comparable2 = comparable;
                        $i$f$findDefaultGdbserverLocation$stub_for_inlining$5 = false;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.toString())));
                    }
                }), (int)0);
                location2 = object != null ? ((File)object).toString() : null;
            }
            return location2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

