/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.ui;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.execution.ui.FileChooseInput;
import com.intellij.clion.embedded.execution.ui.OpenOcdConfigurationEditor;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ModalityUiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmbeddedSettingsPanel
extends JPanel {
    public static final String CUBE_TITLE = "Stm32CubeMX";
    public static final String OPEN_OCD_TITLE = "OpenOCD";
    @NotNull
    private final FileChooseInput openOcdLocation;
    private final FileChooseInput stm32CubeMXLocation;

    public EmbeddedSettingsPanel() {
        GridLayoutManager gridLayout = new GridLayoutManager(4, 3);
        this.setLayout((LayoutManager)gridLayout);
        gridLayout.setColumnStretch(1, 10);
        gridLayout.setVGap(18);
        this.add((Component)new Spacer(), new GridConstraints(3, 0, 1, 3, 0, 0, 0, 0, new Dimension(1, 16), null, null));
        this.openOcdLocation = new FileChooseInput.OpenOcdBinaryLocation(EmbeddedBundle.message("tool.location", OPEN_OCD_TITLE), OpenOcdConfigurationEditor.USER_HOME);
        this.openOcdLocation.setTextFieldPreferredWidth(15);
        this.addValueRow(1, this.openOcdLocation.getValueName(), this.openOcdLocation);
        AbstractAction testOpenOcd = new AbstractAction(EmbeddedBundle.message("tool.test.action", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fileName = EmbeddedSettingsPanel.this.openOcdLocation.getText().trim();
                EmbeddedSettingsPanel.checkExeVersion(e, fileName, EmbeddedSettingsPanel.OPEN_OCD_TITLE, 500, true, "--version");
            }
        };
        this.add((Component)new JButton(testOpenOcd), new GridConstraints(1, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.stm32CubeMXLocation = new FileChooseInput.CubeMXBinaryLocation(EmbeddedBundle.message("tool.location", CUBE_TITLE), OpenOcdConfigurationEditor.USER_HOME);
        this.stm32CubeMXLocation.setTextFieldPreferredWidth(15);
        this.addValueRow(2, this.stm32CubeMXLocation.getValueName(), this.stm32CubeMXLocation);
        AbstractAction testCube = new AbstractAction(EmbeddedBundle.message("tool.test.action", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmbeddedSettingsPanel.checkCubeVersion(e, EmbeddedSettingsPanel.this.stm32CubeMXLocation.getText().trim());
            }
        };
        this.add((Component)new JButton(testCube), new GridConstraints(2, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.add((Component)new Spacer(), new GridConstraints(3, 0, 1, 3, 0, 0, 0, 4, null, null, null));
    }

    private <T extends JComponent> void addValueRow(int row, @Nullable @NlsContexts.Label String labelText, @NotNull T component) {
        if (component == null) {
            EmbeddedSettingsPanel.$$$reportNull$$$0(0);
        }
        this.add(component, new GridConstraints(row, 1, 1, 1, 8, 1, 5, 0, new Dimension(24, 16), null, null));
        if (labelText != null) {
            JLabel label = new JLabel(labelText);
            this.add((Component)label, new GridConstraints(row, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            label.setLabelFor(component);
        }
    }

    @NotNull
    public FileChooseInput getOpenOcdLocation() {
        FileChooseInput fileChooseInput = this.openOcdLocation;
        if (fileChooseInput == null) {
            EmbeddedSettingsPanel.$$$reportNull$$$0(1);
        }
        return fileChooseInput;
    }

    public FileChooseInput getStm32CubeMXLocation() {
        return this.stm32CubeMXLocation;
    }

    private static void checkCubeVersion(final @NotNull ActionEvent event, final @NotNull String fileName) {
        if (event == null) {
            EmbeddedSettingsPanel.$$$reportNull$$$0(2);
        }
        if (fileName == null) {
            EmbeddedSettingsPanel.$$$reportNull$$$0(3);
        }
        new Task.Modal(null, EmbeddedBundle.message("tool.checking", CUBE_TITLE), true){

            public void run(@NotNull ProgressIndicator indicator) {
                File file;
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!(file = new File(fileName)).exists()) {
                    EmbeddedSettingsPanel.showMessage(event, false, EmbeddedBundle.message("cube.file.is.not.found", fileName));
                } else if (!file.isFile()) {
                    EmbeddedSettingsPanel.showMessage(event, false, EmbeddedBundle.message("cube.file.is.not.file", fileName));
                } else {
                    try (ZipFile zipFile = new ZipFile(file);){
                        Enumeration<? extends ZipEntry> entries = zipFile.entries();
                        while (entries.hasMoreElements() && !indicator.isCanceled()) {
                            ZipEntry entry = entries.nextElement();
                            if (!"META-INF/MANIFEST.MF".equals(entry.getName())) continue;
                            EmbeddedSettingsPanel.showMessage(event, true, EmbeddedBundle.message("cube.valid.title", EmbeddedSettingsPanel.CUBE_TITLE));
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    EmbeddedSettingsPanel.showMessage(event, false, EmbeddedBundle.message("file.is.not.valid.cube.executable", fileName, EmbeddedSettingsPanel.CUBE_TITLE));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/clion/embedded/execution/ui/EmbeddedSettingsPanel$3", "run"));
            }
        }.queue();
    }

    private static void checkExeVersion(final @NotNull ActionEvent event, final @NotNull String fileName, @NotNull String utilityTitle, final int timeoutInMilliseconds, final boolean collectStderr, final String ... parameters) {
        ValidationResult result;
        if (event == null) {
            EmbeddedSettingsPanel.$$$reportNull$$$0(4);
        }
        if (fileName == null) {
            EmbeddedSettingsPanel.$$$reportNull$$$0(5);
        }
        if (utilityTitle == null) {
            EmbeddedSettingsPanel.$$$reportNull$$$0(6);
        }
        if (!(result = FileChooseInput.OpenOcdBinaryLocation.validateFileResult(new File(fileName))).isOk()) {
            EmbeddedSettingsPanel.showMessage(event, false, result.getErrorMessage());
        } else {
            new Task.Modal(null, EmbeddedBundle.message("identify.utility.version", utilityTitle), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{fileName}).withParameters(parameters);
                    try {
                        ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine, (int)timeoutInMilliseconds);
                        if (output.getExitCode() != 0) {
                            throw new RuntimeException();
                        }
                        String versionOutput = collectStderr ? output.getStderr() : output.getStdout();
                        boolean success = StringUtil.containsIgnoreCase((String)versionOutput, (String)EmbeddedSettingsPanel.OPEN_OCD_TITLE) && !StringUtil.containsIgnoreCase((String)versionOutput, (String)"OpenOCD/") && !StringUtil.containsIgnoreCase((String)versionOutput, (String)"OpenOCD\\");
                        success = success || StringUtil.containsIgnoreCase((String)versionOutput, (String)"Open") && StringUtil.containsIgnoreCase((String)versionOutput, (String)"Chip") && StringUtil.containsIgnoreCase((String)versionOutput, (String)"Debugger");
                        EmbeddedSettingsPanel.showMessage(event, success, success ? versionOutput : EmbeddedBundle.message("unknown.binary", fileName));
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onThrowable(@NotNull Throwable error) {
                    if (error == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    EmbeddedSettingsPanel.showMessage(event, false, EmbeddedBundle.message("file.cannot.be.executed", fileName));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "error";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/clion/embedded/execution/ui/EmbeddedSettingsPanel$4";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "run";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onThrowable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.queue();
        }
    }

    private static void showMessage(@NotNull ActionEvent event, boolean success, @NotNull @NlsContexts.PopupContent String message) {
        if (event == null) {
            EmbeddedSettingsPanel.$$$reportNull$$$0(7);
        }
        if (message == null) {
            EmbeddedSettingsPanel.$$$reportNull$$$0(8);
        }
        JComponent component = (JComponent)event.getSource();
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
            MessageType messageType = success ? MessageType.INFO : MessageType.ERROR;
            PopupUtil.showBalloonForComponent((Component)component, (String)message, (MessageType)messageType, (boolean)false, null);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/clion/embedded/execution/ui/EmbeddedSettingsPanel";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "utilityTitle";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/clion/embedded/execution/ui/EmbeddedSettingsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenOcdLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addValueRow";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkCubeVersion";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkExeVersion";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

