/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.rtos.freertos;

import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.execution.rtos.freertos.FreeRtosDataManager;
import com.intellij.clion.embedded.execution.rtos.freertos.FreeRtosUtilsKt;
import com.intellij.clion.embedded.execution.rtos.freertos.Heap;
import com.intellij.clion.embedded.execution.rtos.freertos.HeapBlock;
import com.intellij.clion.embedded.execution.rtos.freertos.HeapBlockAddressRangeColumn;
import com.intellij.clion.embedded.execution.rtos.freertos.HeapBlockDetailsColumn;
import com.intellij.clion.embedded.execution.rtos.freertos.HeapBlockSizeColumn;
import com.intellij.clion.embedded.execution.rtos.freertos.HeapRegion;
import com.intellij.clion.embedded.execution.rtos.freertos.HeapRegionAddressRangeColumn;
import com.intellij.clion.embedded.execution.rtos.freertos.HeapRegionFreeColumn;
import com.intellij.clion.embedded.execution.rtos.freertos.HeapRegionNumberColumn;
import com.intellij.clion.embedded.execution.rtos.freertos.HeapRegionUsageColumn;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u0001:\u0001\u0014B9\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0002J\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/clion/embedded/execution/rtos/freertos/FreeRtosHeapComponent;", "Lcom/intellij/ui/components/JBPanel;", "heapTableView", "Lcom/intellij/ui/table/TableView;", "Lcom/intellij/clion/embedded/execution/rtos/freertos/HeapRegion;", "heapBlocksTableView", "Lcom/intellij/clion/embedded/execution/rtos/freertos/HeapBlock;", "dataGetter", "Lkotlin/Function0;", "", "Lcom/intellij/clion/embedded/execution/rtos/freertos/Heap;", "<init>", "(Lcom/intellij/ui/table/TableView;Lcom/intellij/ui/table/TableView;Lkotlin/jvm/functions/Function0;)V", "heapInfoLabel", "Lcom/intellij/openapi/ui/ex/MultiLineLabel;", "getHeapInfo", "", "h", "update", "", "Companion", "intellij.clion.embedded"})
public final class FreeRtosHeapComponent
extends JBPanel<JBPanel<?>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TableView<HeapRegion> heapTableView;
    @NotNull
    private final TableView<HeapBlock> heapBlocksTableView;
    @NotNull
    private final Function0<List<Heap>> dataGetter;
    @NotNull
    private final MultiLineLabel heapInfoLabel;

    private FreeRtosHeapComponent(TableView<HeapRegion> heapTableView, TableView<HeapBlock> heapBlocksTableView, Function0<? extends List<Heap>> dataGetter) {
        JBPanel jBPanel;
        this.heapTableView = heapTableView;
        this.heapBlocksTableView = heapBlocksTableView;
        this.dataGetter = dataGetter;
        this.heapInfoLabel = new MultiLineLabel("");
        this.setFont(Font.getFont("Monospaced"));
        this.setLayout(new BoxLayout((Container)((Object)this), 0));
        JBPanel it = jBPanel = new JBPanel();
        boolean bl = false;
        it.setLayout((LayoutManager)new BoxLayout((Container)it, 1));
        it.add((Component)this.heapInfoLabel);
        it.add((Component)ScrollPaneFactory.createScrollPane((Component)((Component)this.heapTableView)));
        JBPanel pane = jBPanel;
        OnePixelSplitter splitter = new OnePixelSplitter(false, "clion.embedded.freertos.heap.splitter.proportion", 0.4f);
        splitter.setFirstComponent((JComponent)pane);
        splitter.setSecondComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Component)this.heapBlocksTableView)));
        this.add((Component)splitter);
    }

    private final String getHeapInfo(Heap h) {
        String string = EmbeddedBundle.message("freertos.heap.type.label", new Object[0]);
        String string2 = h.getType();
        String string3 = EmbeddedBundle.message("freertos.heap.usage.label", new Object[0]);
        String string4 = "%.3f";
        Object[] objectArray = new Object[]{(double)h.getUsed() / (double)h.getSize() * (double)100};
        String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        long l = h.getUsed();
        String string6 = EmbeddedBundle.message("freertos.heap.free.label", new Object[0]);
        string4 = "%.3f";
        objectArray = new Object[]{(double)h.getFree() / (double)h.getSize() * (double)100};
        String string7 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
        String commonPart = StringsKt.trimMargin$default((String)("\n      |" + string + ": " + string2 + "\n      |" + string3 + ": " + string5 + "% (" + l + " B)\n      |" + string6 + ": " + string7 + "% (" + h.getFree() + " B)\n    "), null, (int)1, null);
        String optionalPart = Intrinsics.areEqual((Object)h.getType(), (Object)"HEAP_5") || Intrinsics.areEqual((Object)h.getType(), (Object)"HEAP_4") ? StringsKt.trimMargin$default((String)("\n      |\n      |" + EmbeddedBundle.message("freertos.heap.allocations.label", new Object[0]) + ": " + h.getAllocationsCount() + "\n      |" + EmbeddedBundle.message("freertos.heap.frees.label", new Object[0]) + ": " + h.getFreesCount() + "\n    "), null, (int)1, null) : "";
        return commonPart + optionalPart;
    }

    public final void update() {
        Heap heap = (Heap)CollectionsKt.firstOrNull((List)((List)this.dataGetter.invoke()));
        if (heap != null) {
            this.heapTableView.getTableViewModel().setItems(heap.getRegions());
            this.heapInfoLabel.setText(this.getHeapInfo(heap));
            this.heapBlocksTableView.getTableViewModel().setItems(heap.getRegions().size() == 1 ? ((HeapRegion)CollectionsKt.first(heap.getRegions())).getBlocks() : (List<HeapBlock>)new ArrayList());
        }
    }

    public /* synthetic */ FreeRtosHeapComponent(TableView heapTableView, TableView heapBlocksTableView, Function0 dataGetter, DefaultConstructorMarker $constructor_marker) {
        this((TableView<HeapRegion>)heapTableView, (TableView<HeapBlock>)heapBlocksTableView, (Function0<? extends List<Heap>>)dataGetter);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/clion/embedded/execution/rtos/freertos/FreeRtosHeapComponent$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/clion/embedded/execution/rtos/freertos/FreeRtosHeapComponent;", "dataManager", "Lcom/intellij/clion/embedded/execution/rtos/freertos/FreeRtosDataManager;", "intellij.clion.embedded"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FreeRtosHeapComponent create(@NotNull FreeRtosDataManager dataManager) {
            TableView tableView;
            Intrinsics.checkNotNullParameter((Object)dataManager, (String)"dataManager");
            ColumnInfo[] columnInfoArray = new ColumnInfo[]{HeapRegionNumberColumn.INSTANCE, HeapRegionUsageColumn.INSTANCE, HeapRegionFreeColumn.INSTANCE, HeapRegionAddressRangeColumn.INSTANCE};
            ListTableModel heapTableModel = new ListTableModel(columnInfoArray);
            ColumnInfo[] columnInfoArray2 = new ColumnInfo[]{HeapBlockDetailsColumn.INSTANCE, HeapBlockAddressRangeColumn.INSTANCE, HeapBlockSizeColumn.INSTANCE};
            ListTableModel heapBlocksModel = new ListTableModel(columnInfoArray2);
            TableView it = tableView = FreeRtosUtilsKt.createDefaultTableView(heapTableModel);
            boolean bl = false;
            it.setSelectionMode(0);
            it.setRowSelectionAllowed(true);
            TableView heapTableView = tableView;
            TableView heapBlocksTableView = FreeRtosUtilsKt.createDefaultTableView(heapBlocksModel);
            heapTableView.getSelectionModel().addListSelectionListener(arg_0 -> Companion.create$lambda$1(heapTableView, heapBlocksTableView, arg_0));
            if (!dataManager.getConfig().getHeapInfoAvailable()) {
                heapBlocksTableView.getEmptyText().appendLine(EmbeddedBundle.message("freertos.heap.info.not.available", new Object[0]));
            }
            return new FreeRtosHeapComponent(heapTableView, heapBlocksTableView, () -> Companion.create$lambda$2(dataManager), null);
        }

        private static final void create$lambda$1(TableView $heapTableView, TableView $heapBlocksTableView, ListSelectionEvent it) {
            Collection collection = $heapTableView.getSelection();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSelection(...)");
            HeapRegion heapRegion = (HeapRegion)CollectionsKt.firstOrNull((Iterable)collection);
            if (heapRegion == null) {
                return;
            }
            HeapRegion heapRegion2 = heapRegion;
            $heapBlocksTableView.getTableViewModel().setItems(heapRegion2.getBlocks());
        }

        private static final List create$lambda$2(FreeRtosDataManager $dataManager) {
            return $dataManager.getHeapData();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

