/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.rtos.freertos;

import com.intellij.CommonBundle;
import com.intellij.clion.embedded.EmbeddedBundle;
import com.intellij.clion.embedded.execution.rtos.GdbRtosSupportKt;
import com.intellij.clion.embedded.execution.rtos.freertos.FreeRtosConfig;
import com.intellij.clion.embedded.execution.rtos.freertos.Heap;
import com.intellij.clion.embedded.execution.rtos.freertos.HeapDataRetriever;
import com.intellij.clion.embedded.execution.rtos.freertos.Queue;
import com.intellij.clion.embedded.execution.rtos.freertos.QueueDataRetriever;
import com.intellij.clion.embedded.execution.rtos.freertos.Task;
import com.intellij.clion.embedded.execution.rtos.freertos.TaskDataRetriever;
import com.intellij.clion.embedded.execution.rtos.freertos.Timer;
import com.intellij.clion.embedded.execution.rtos.freertos.TimerDataRetriever;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010-\u001a\u00020$*\u00020\u00052\u0006\u0010.\u001a\u00020/2\n\u00100\u001a\u000601j\u0002`2H\u0002J\u0014\u00103\u001a\u0002042\n\u00100\u001a\u000601j\u0002`2H\u0002J\u0012\u00105\u001a\u0002042\b\b\u0001\u00106\u001a\u00020/H\u0002J\u0014\u00107\u001a\u0002042\f\u00108\u001a\b\u0012\u0004\u0012\u00020409R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0014\"\u0004\b\u001a\u0010\u0016R \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0014\"\u0004\b\u001e\u0010\u0016R \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0014\"\u0004\b\"\u0010\u0016R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010&R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006:"}, d2={"Lcom/intellij/clion/embedded/execution/rtos/freertos/FreeRtosDataManager;", "", "debugProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;)V", "queueDataRetriever", "Lcom/intellij/clion/embedded/execution/rtos/freertos/QueueDataRetriever;", "taskDataRetriever", "Lcom/intellij/clion/embedded/execution/rtos/freertos/TaskDataRetriever;", "timerDataRetriever", "Lcom/intellij/clion/embedded/execution/rtos/freertos/TimerDataRetriever;", "heapDataRetriever", "Lcom/intellij/clion/embedded/execution/rtos/freertos/HeapDataRetriever;", "queueData", "", "Lcom/intellij/clion/embedded/execution/rtos/freertos/Queue;", "getQueueData", "()Ljava/util/List;", "setQueueData", "(Ljava/util/List;)V", "taskData", "Lcom/intellij/clion/embedded/execution/rtos/freertos/Task;", "getTaskData", "setTaskData", "timerData", "Lcom/intellij/clion/embedded/execution/rtos/freertos/Timer;", "getTimerData", "setTimerData", "heapData", "Lcom/intellij/clion/embedded/execution/rtos/freertos/Heap;", "getHeapData", "setHeapData", "queueStructSize", "", "getQueueStructSize", "()J", "tcbStructSize", "getTcbStructSize", "config", "Lcom/intellij/clion/embedded/execution/rtos/freertos/FreeRtosConfig;", "getConfig", "()Lcom/intellij/clion/embedded/execution/rtos/freertos/FreeRtosConfig;", "calculateSizeof", "typeName", "", "messageBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "collectErrors", "", "showNotificationIfNeeded", "warningMessage", "updateAll", "updateListener", "Lkotlin/Function0;", "intellij.clion.embedded"})
@SourceDebugExtension(value={"SMAP\nFreeRtosDataManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FreeRtosDataManager.kt\ncom/intellij/clion/embedded/execution/rtos/freertos/FreeRtosDataManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,298:1\n24#2:299\n*S KotlinDebug\n*F\n+ 1 FreeRtosDataManager.kt\ncom/intellij/clion/embedded/execution/rtos/freertos/FreeRtosDataManager\n*L\n113#1:299\n*E\n"})
public final class FreeRtosDataManager {
    @NotNull
    private final CidrDebugProcess debugProcess;
    @NotNull
    private final QueueDataRetriever queueDataRetriever;
    @NotNull
    private final TaskDataRetriever taskDataRetriever;
    @NotNull
    private final TimerDataRetriever timerDataRetriever;
    @NotNull
    private final HeapDataRetriever heapDataRetriever;
    @NotNull
    private List<Queue> queueData;
    @NotNull
    private List<Task> taskData;
    @NotNull
    private List<Timer> timerData;
    @NotNull
    private List<Heap> heapData;
    private final long queueStructSize;
    private final long tcbStructSize;
    @NotNull
    private final FreeRtosConfig config;

    public FreeRtosDataManager(@NotNull CidrDebugProcess debugProcess, @NotNull DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        this.debugProcess = debugProcess;
        this.queueDataRetriever = new QueueDataRetriever();
        this.taskDataRetriever = new TaskDataRetriever(this);
        this.timerDataRetriever = new TimerDataRetriever();
        this.heapDataRetriever = new HeapDataRetriever(this);
        this.queueData = CollectionsKt.emptyList();
        this.taskData = CollectionsKt.emptyList();
        this.timerData = CollectionsKt.emptyList();
        this.heapData = CollectionsKt.emptyList();
        StringBuilder messageBuilder = new StringBuilder();
        this.queueStructSize = this.calculateSizeof(driver, "Queue_t", messageBuilder);
        this.tcbStructSize = this.calculateSizeof(driver, "TCB_t", messageBuilder);
        String string = driver.executeInterpreterCommand(-1L, -1, "p/r $rtos_config()");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"executeInterpreterCommand(...)");
        FreeRtosConfig freeRtosConfig = GdbRtosSupportKt.tryDecodeJsonFromConsoleOutput(string, FreeRtosConfig.Companion.serializer());
        if (freeRtosConfig == null) {
            freeRtosConfig = new FreeRtosConfig(false, false, false, false, false, false, false, false, false, 511, null);
        }
        this.config = freeRtosConfig;
        this.collectErrors(messageBuilder);
        String string2 = messageBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        this.showNotificationIfNeeded(string2);
    }

    @NotNull
    public final List<Queue> getQueueData() {
        return this.queueData;
    }

    public final void setQueueData(@NotNull List<Queue> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.queueData = list;
    }

    @NotNull
    public final List<Task> getTaskData() {
        return this.taskData;
    }

    public final void setTaskData(@NotNull List<Task> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.taskData = list;
    }

    @NotNull
    public final List<Timer> getTimerData() {
        return this.timerData;
    }

    public final void setTimerData(@NotNull List<Timer> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.timerData = list;
    }

    @NotNull
    public final List<Heap> getHeapData() {
        return this.heapData;
    }

    public final void setHeapData(@NotNull List<Heap> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.heapData = list;
    }

    public final long getQueueStructSize() {
        return this.queueStructSize;
    }

    public final long getTcbStructSize() {
        return this.tcbStructSize;
    }

    @NotNull
    public final FreeRtosConfig getConfig() {
        return this.config;
    }

    private final long calculateSizeof(DebuggerDriver $this$calculateSizeof, String typeName, StringBuilder messageBuilder) {
        long l;
        String string = $this$calculateSizeof.executeInterpreterCommand(-1L, -1, "py print(gdb.parse_and_eval(\"sizeof(" + typeName + ")\"))");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"executeInterpreterCommand(...)");
        Long l2 = StringsKt.toLongOrNull((String)((Object)StringsKt.trim((CharSequence)string)).toString());
        if (l2 != null) {
            l = l2;
        } else {
            DebuggerDriver it = $this$calculateSizeof;
            boolean bl = false;
            Object[] objectArray = new Object[]{typeName};
            String string2 = EmbeddedBundle.message("freertos.integration.sizeof.failed", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String message = string2;
            StringBuilder stringBuilder = messageBuilder.append(message);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
            CidrDebuggerLog.LOG.warn(message);
            l = 0L;
        }
        return l;
    }

    private final void collectErrors(StringBuilder messageBuilder) {
        if (!(this.config.getUseTraceFacility() && this.config.getUseTimers() && this.config.getHeapInfoAvailable() && this.config.getQueueRegistryEnabled() && this.config.getGenerateRuntimeStats() && this.config.getRecordStackHighAddress() && this.config.getUseMutexes())) {
            messageBuilder.append(EmbeddedBundle.message("freertos.integration.not.full", new Object[0]));
        }
    }

    private final void showNotificationIfNeeded(@Nls String warningMessage) {
        if (!StringsKt.isBlank((CharSequence)warningMessage)) {
            Notification noDataFoundNotification = new Notification("Embedded Development", EmbeddedBundle.message("freertos.integration.enabled", new Object[0]), warningMessage, NotificationType.WARNING);
            noDataFoundNotification.addAction((AnAction)DumbAwareAction.create((String)CommonBundle.message((String)"action.help", (Object[])new Object[0]), arg_0 -> FreeRtosDataManager.showNotificationIfNeeded$lambda$2(FreeRtosDataManager::showNotificationIfNeeded$lambda$1, arg_0)));
            Notifications.Bus.notify((Notification)noDataFoundNotification, (Project)this.debugProcess.getProject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateAll(@NotNull Function0<Unit> updateListener) {
        Intrinsics.checkNotNullParameter(updateListener, (String)"updateListener");
        try {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                int label;
                final /* synthetic */ FreeRtosDataManager this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            if (!this.this$0.getConfig().getQueueRegistryEnabled()) ** GOTO lbl18
                            var2_3 = this.this$0;
                            this.L$0 = var2_3;
                            this.label = 1;
                            v0 = FreeRtosDataManager.access$getQueueDataRetriever$p(this.this$0).getObjectData(FreeRtosDataManager.access$getDebugProcess$p(this.this$0), (Continuation<? super List<Queue>>)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl17
                        }
                        case 1: {
                            var2_3 = (FreeRtosDataManager)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            var2_3.setQueueData((List)v0);
lbl18:
                            // 2 sources

                            var2_3 = this.this$0;
                            this.L$0 = var2_3;
                            this.label = 2;
                            v1 = FreeRtosDataManager.access$getTaskDataRetriever$p(this.this$0).getObjectData(FreeRtosDataManager.access$getDebugProcess$p(this.this$0), (Continuation<? super List<Task>>)((Continuation)this));
                            if (v1 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl29
                        }
                        case 2: {
                            var2_3 = (FreeRtosDataManager)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl29:
                            // 2 sources

                            var2_3.setTaskData((List)v1);
                            if (!this.this$0.getConfig().getUseTimers()) ** GOTO lbl43
                            var2_3 = this.this$0;
                            this.L$0 = var2_3;
                            this.label = 3;
                            v2 = FreeRtosDataManager.access$getTimerDataRetriever$p(this.this$0).getObjectData(FreeRtosDataManager.access$getDebugProcess$p(this.this$0), (Continuation<? super List<Timer>>)((Continuation)this));
                            if (v2 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl42
                        }
                        case 3: {
                            var2_3 = (FreeRtosDataManager)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl42:
                            // 2 sources

                            var2_3.setTimerData((List)v2);
lbl43:
                            // 2 sources

                            if (!this.this$0.getConfig().getHeapInfoAvailable()) ** GOTO lbl56
                            var2_3 = this.this$0;
                            this.L$0 = var2_3;
                            this.label = 4;
                            v3 = FreeRtosDataManager.access$getHeapDataRetriever$p(this.this$0).getObjectData(FreeRtosDataManager.access$getDebugProcess$p(this.this$0), (Continuation<? super List<Heap>>)((Continuation)this));
                            if (v3 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl55
                        }
                        case 4: {
                            var2_3 = (FreeRtosDataManager)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl55:
                            // 2 sources

                            var2_3.setHeapData((List)v3);
lbl56:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
        catch (DebuggerCommandException ex) {
            FreeRtosDataManager $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(FreeRtosDataManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("FreeRTOS objects updating failed: " + ex);
        }
        finally {
            updateListener.invoke();
        }
    }

    private static final Unit showNotificationIfNeeded$lambda$1(AnActionEvent it) {
        HelpManager.getInstance().invokeHelp("rtos.objectsview");
        return Unit.INSTANCE;
    }

    private static final void showNotificationIfNeeded$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ QueueDataRetriever access$getQueueDataRetriever$p(FreeRtosDataManager $this) {
        return $this.queueDataRetriever;
    }

    public static final /* synthetic */ CidrDebugProcess access$getDebugProcess$p(FreeRtosDataManager $this) {
        return $this.debugProcess;
    }

    public static final /* synthetic */ TaskDataRetriever access$getTaskDataRetriever$p(FreeRtosDataManager $this) {
        return $this.taskDataRetriever;
    }

    public static final /* synthetic */ TimerDataRetriever access$getTimerDataRetriever$p(FreeRtosDataManager $this) {
        return $this.timerDataRetriever;
    }

    public static final /* synthetic */ HeapDataRetriever access$getHeapDataRetriever$p(FreeRtosDataManager $this) {
        return $this.heapDataRetriever;
    }
}

