/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution.rtos;

import com.intellij.clion.embedded.execution.rtos.GdbRtosSupport;
import com.intellij.clion.embedded.execution.rtos.GdbRtosSupportKt;
import com.intellij.clion.embedded.execution.rtos.RtosLLThread;
import com.intellij.clion.embedded.execution.rtos.RtosLLValue;
import com.intellij.clion.embedded.execution.rtos.RtosOptions;
import com.intellij.clion.embedded.execution.rtos.RtosSettings;
import com.intellij.clion.embedded.execution.rtos.RtosType;
import com.intellij.clion.embedded.execution.rtos.RtosUsagesCollector;
import com.intellij.clion.embedded.execution.rtos.freertos.FreeRtosDataManager;
import com.intellij.clion.embedded.execution.rtos.freertos.FreeRtosPosixPort;
import com.intellij.clion.embedded.execution.rtos.freertos.FreeRtosRegistry;
import com.intellij.clion.embedded.execution.rtos.freertos.Task;
import com.intellij.clion.embedded.execution.rtos.zephyr.ZephyrUtilsKt;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessConfigurator;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/clion/embedded/execution/rtos/GdbRtosSupport;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcessConfigurator;", "<init>", "()V", "rtosType", "Lcom/intellij/clion/embedded/execution/rtos/RtosType;", "configure", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "RtosCommonCommands", "intellij.clion.embedded"})
public final class GdbRtosSupport
implements CidrDebugProcessConfigurator {
    @Nullable
    private RtosType rtosType;

    public void configure(@NotNull CidrDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        DebuggerDriverConfiguration debuggerDriverConfiguration = process.getRunParameters().getDebuggerDriverConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)debuggerDriverConfiguration, (String)"getDebuggerDriverConfiguration(...)");
        DebuggerDriverConfiguration debuggerDriverConfiguration2 = debuggerDriverConfiguration;
        if (!(debuggerDriverConfiguration2 instanceof GDBDriverConfiguration)) {
            return;
        }
        Project project = process.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
        RtosOptions state = RtosSettings.Companion.getState(project);
        if (!state.isRtosEnabled()) {
            return;
        }
        Project project2 = process.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"<get-project>(...)");
        RtosUsagesCollector.INSTANCE.logTryDetectRtos(project2, state.getRtosType());
        process.postCommand(arg_0 -> GdbRtosSupport.configure$lambda$0(debuggerDriverConfiguration2, state, this, process, arg_0));
    }

    private static final void configure$lambda$0(DebuggerDriverConfiguration $debuggerDriverConfiguration, RtosOptions $state, GdbRtosSupport this$0, CidrDebugProcess $process, DebuggerDriver driver) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            try {
                block11: {
                    block10: {
                        driver.executeInterpreterCommand(-1L, -1, "python " + GdbRtosSupportKt.generateRtosImportScript($debuggerDriverConfiguration, $state.getRtosType()));
                        String string = driver.executeInterpreterCommand(-1L, -1, "p/r $rtos_init(\"" + $state.getRtosType().name() + "\")");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"executeInterpreterCommand(...)");
                        String consoleOutput = string;
                        Map map = (Map)GdbRtosSupportKt.tryDecodeJsonFromConsoleOutput(consoleOutput, BuiltinSerializersKt.MapSerializer((KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE), (KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE)));
                        if (map == null) {
                            return;
                        }
                        Map answer = map;
                        CharSequence charSequence = (CharSequence)answer.get("name");
                        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) break block9;
                        Object v = answer.get("name");
                        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
                        this$0.rtosType = RtosType.valueOf((String)v);
                        if (this$0.rtosType == RtosType.FREERTOS) {
                            FreeRtosDataManager dataManager = new FreeRtosDataManager($process, driver);
                            FreeRtosRegistry.Companion.registerObjectsTab($process, dataManager);
                            if (dataManager.getConfig().isPosix() && SystemInfo.isLinux) {
                                ((GDBDriver)driver).setThreadFrameInfoDriverDelegate((GDBDriver.ThreadFrameInfoDriverDelegate)new FreeRtosPosixPort());
                            } else {
                                ((GDBDriver)driver).setThreadFrameInfoDriverDelegate((GDBDriver.ThreadFrameInfoDriverDelegate)this$0.new RtosCommonCommands());
                            }
                            Project project = $process.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
                            RtosUsagesCollector.INSTANCE.logRtosDetected(project, RtosType.FREERTOS);
                            break block9;
                        }
                        if (this$0.rtosType != RtosType.ZEPHYR) break block10;
                        Project project = $process.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
                        if (ZephyrUtilsKt.isZephyrConfigurationComplete(project, driver)) break block11;
                    }
                    if (this$0.rtosType != RtosType.AZURE) break block9;
                }
                ((GDBDriver)driver).setThreadFrameInfoDriverDelegate((GDBDriver.ThreadFrameInfoDriverDelegate)this$0.new RtosCommonCommands());
                Project project = $process.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
                RtosType rtosType = this$0.rtosType;
                Intrinsics.checkNotNull((Object)((Object)rtosType));
                RtosUsagesCollector.INSTANCE.logRtosDetected(project, rtosType);
            }
            catch (ExecutionException e) {
                CidrDebuggerLog.LOG.info("RTOS integration state: " + $state.getRtosType() + ", RTOS has not been found");
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J1\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J6\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J&\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u0019H\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010&\u001a\u00020\"H\u0016J.\u0010'\u001a\b\u0012\u0004\u0012\u00020\"0\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010&\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J2\u0010(\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016\u00a8\u0006-"}, d2={"Lcom/intellij/clion/embedded/execution/rtos/GdbRtosSupport$RtosCommonCommands;", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ThreadFrameInfoDriverDelegate;", "<init>", "(Lcom/intellij/clion/embedded/execution/rtos/GdbRtosSupport;)V", "doReadStopPlaceAsync", "Ljava/util/concurrent/CompletableFuture;", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StopPlace;", "bridge", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Bridge;", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver;", "stopTuple", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBTuple;", "getThreads", "", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "switchTaskContextAndExecute", "T", "task", "Lcom/intellij/clion/embedded/execution/rtos/RtosLLThread;", "callable", "Lkotlin/Function0;", "(Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Bridge;Lcom/intellij/clion/embedded/execution/rtos/RtosLLThread;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "getFrames", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$ResultList;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;", "thread", "from", "", "count", "untilFirstLineWithCode", "", "getVariables", "", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;", "frame", "getData", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValueData;", "value", "getVariableChildren", "evaluate", "expression", "", "language", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$DebuggerLanguage;", "intellij.clion.embedded"})
    @SourceDebugExtension(value={"SMAP\nGdbRtosSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdbRtosSupport.kt\ncom/intellij/clion/embedded/execution/rtos/GdbRtosSupport$RtosCommonCommands\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,279:1\n1557#2:280\n1628#2,3:281\n1557#2:284\n1628#2,3:285\n*S KotlinDebug\n*F\n+ 1 GdbRtosSupport.kt\ncom/intellij/clion/embedded/execution/rtos/GdbRtosSupport$RtosCommonCommands\n*L\n84#1:280\n84#1:281,3\n125#1:284\n125#1:285,3\n*E\n"})
    private final class RtosCommonCommands
    implements GDBDriver.ThreadFrameInfoDriverDelegate {
        @NotNull
        public CompletableFuture<DebuggerDriver.StopPlace> doReadStopPlaceAsync(@NotNull GDBDriver.Bridge bridge, @NotNull GDBDriver driver, @NotNull GDBTuple stopTuple) {
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            Intrinsics.checkNotNullParameter((Object)stopTuple, (String)"stopTuple");
            return GdbRtosSupportKt.rtosDoReadStopPlaceAsync(bridge, stopTuple, (Function0<? extends CompletableFuture<DebuggerDriver.StopPlace>>)((Function0)() -> RtosCommonCommands.doReadStopPlaceAsync$lambda$0(this, bridge, driver, stopTuple)));
        }

        @NotNull
        public List<LLThread> getThreads(@NotNull GDBDriver.Bridge bridge, @NotNull GDBDriver driver) {
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            return GdbRtosSupportKt.getRtosThreads(bridge, (Function2<? super Long, ? super List<Task>, ? extends List<? extends LLThread>>)((Function2)RtosCommonCommands::getThreads$lambda$2));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final <T> T switchTaskContextAndExecute(GDBDriver.Bridge bridge, RtosLLThread task, Function0<? extends T> callable) {
            DebuggerDriver.StopPlace stopPlace = bridge.getStopPlace();
            if (Intrinsics.areEqual((Object)(stopPlace != null && (stopPlace = stopPlace.frame) != null ? stopPlace.getProgramCounter() : null), (Object)task.getProgramCounter())) {
                return (T)callable.invoke();
            }
            bridge.sendSilentRequestAndGetOutput("p/s 1", new Object[0]);
            bridge.sendSilentRequestAndGetOutput("p/r $rtos_switch_thread(" + task.getStackTopAddress() + ")", new Object[0]);
            try {
                Object object = callable.invoke();
                return (T)object;
            }
            finally {
                bridge.sendSilentRequestAndGetOutput("p/r $rtos_switch_back()", new Object[0]);
            }
        }

        @NotNull
        public DebuggerDriver.ResultList<LLFrame> getFrames(@NotNull GDBDriver.Bridge bridge, @NotNull LLThread thread, int from, int count, boolean untilFirstLineWithCode) {
            DebuggerDriver.ResultList resultList;
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
            if (thread instanceof RtosLLThread) {
                Object object = bridge.executeCommand(() -> RtosCommonCommands.getFrames$lambda$4(this, bridge, thread, from, count, untilFirstLineWithCode));
                Intrinsics.checkNotNull((Object)object);
                resultList = (DebuggerDriver.ResultList)object;
            } else {
                DebuggerDriver.ResultList resultList2 = super.getFrames(bridge, thread, from, count, untilFirstLineWithCode);
                Intrinsics.checkNotNull((Object)resultList2);
                resultList = resultList2;
            }
            return resultList;
        }

        @NotNull
        public List<LLValue> getVariables(@NotNull GDBDriver.Bridge bridge, @NotNull LLThread thread, @NotNull LLFrame frame) {
            List list;
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            if (thread instanceof RtosLLThread) {
                Object object = bridge.executeCommand((GDBDriver.Command)((GDBDriver.SuspendedCommand)() -> RtosCommonCommands.getVariables$lambda$7(this, bridge, thread, frame)));
                Intrinsics.checkNotNull((Object)object);
                list = (List)object;
            } else {
                List list2 = super.getVariables(bridge, thread, frame);
                Intrinsics.checkNotNull((Object)list2);
                list = list2;
            }
            return list;
        }

        @NotNull
        public LLValueData getData(@NotNull GDBDriver.Bridge bridge, @NotNull LLValue value) {
            LLValueData lLValueData;
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof RtosLLValue) {
                Object object = bridge.executeCommand((GDBDriver.Command)((GDBDriver.SuspendedCommand)() -> RtosCommonCommands.getData$lambda$9(this, bridge, value)));
                Intrinsics.checkNotNull((Object)object);
                lLValueData = (LLValueData)object;
            } else {
                LLValueData lLValueData2 = bridge.doLoadVariableData(value);
                Intrinsics.checkNotNull((Object)lLValueData2);
                lLValueData = lLValueData2;
            }
            return lLValueData;
        }

        @NotNull
        public DebuggerDriver.ResultList<LLValue> getVariableChildren(@NotNull GDBDriver.Bridge bridge, @NotNull LLValue value, int from, int count) {
            DebuggerDriver.ResultList resultList;
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value instanceof RtosLLValue) {
                Object object = bridge.executeCommand((GDBDriver.Command)((GDBDriver.SuspendedCommand)() -> RtosCommonCommands.getVariableChildren$lambda$11(this, bridge, value, from, count)));
                Intrinsics.checkNotNull((Object)object);
                resultList = (DebuggerDriver.ResultList)object;
            } else {
                DebuggerDriver.ResultList resultList2 = bridge.doGetVariableChildren(value, from, count);
                Intrinsics.checkNotNull((Object)resultList2);
                resultList = resultList2;
            }
            return resultList;
        }

        @NotNull
        public LLValue evaluate(@NotNull GDBDriver.Bridge bridge, @NotNull LLThread thread, @NotNull LLFrame frame, @NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage language) {
            LLValue lLValue;
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (thread instanceof RtosLLThread) {
                Object object = bridge.executeCommand((GDBDriver.Command)new GDBDriver.EvaluationCommand<LLValue>(expression, this, bridge, thread, frame, language){
                    final /* synthetic */ String $expression;
                    final /* synthetic */ RtosCommonCommands this$0;
                    final /* synthetic */ GDBDriver.Bridge $bridge;
                    final /* synthetic */ LLThread $thread;
                    final /* synthetic */ LLFrame $frame;
                    final /* synthetic */ DebuggerDriver.DebuggerLanguage $language;
                    {
                        this.$expression = $expression;
                        this.this$0 = $receiver;
                        this.$bridge = $bridge;
                        this.$thread = $thread;
                        this.$frame = $frame;
                        this.$language = $language;
                        super($expression);
                    }

                    public LLValue call() {
                        Object object = RtosCommonCommands.access$switchTaskContextAndExecute(this.this$0, this.$bridge, (RtosLLThread)this.$thread, () -> evaluate.1.call$lambda$0(this.$bridge, this.$thread, this.$frame, this.$expression, this.$language));
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"access$switchTaskContextAndExecute(...)");
                        return (LLValue)object;
                    }

                    private static final LLValue call$lambda$0(GDBDriver.Bridge $bridge, LLThread $thread, LLFrame $frame, String $expression, DebuggerDriver.DebuggerLanguage $language) {
                        return $bridge.doEvaluate(((RtosLLThread)$thread).getGdbThreadId(), $frame.getIndex(), $expression, $language);
                    }
                });
                Intrinsics.checkNotNull((Object)object);
                lLValue = (LLValue)object;
            } else {
                LLValue lLValue2 = bridge.doEvaluate(thread.getId(), frame.getIndex(), expression, language);
                Intrinsics.checkNotNull((Object)lLValue2);
                lLValue = lLValue2;
            }
            return lLValue;
        }

        private static final CompletableFuture doReadStopPlaceAsync$lambda$0(RtosCommonCommands this$0, GDBDriver.Bridge $bridge, GDBDriver $driver, GDBTuple $stopTuple) {
            CompletableFuture completableFuture = super.doReadStopPlaceAsync($bridge, $driver, $stopTuple);
            Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"doReadStopPlaceAsync(...)");
            return completableFuture;
        }

        /*
         * WARNING - void declaration
         */
        private static final List getThreads$lambda$2(long threadId, List tasks) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)tasks, (String)"tasks");
            Iterable $this$map$iv = tasks;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Task task = (Task)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new RtosLLThread(threadId, it.getId(), it.getState(), it.getName(), it.getStackTop(), it.getProgramCounter()));
            }
            return (List)destination$iv$iv;
        }

        private static final DebuggerDriver.ResultList getFrames$lambda$4$lambda$3(GDBDriver.Bridge $bridge, int $from, int $count, boolean $untilFirstLineWithCode) {
            return $bridge.doGetFrames(1L, $from, $count, $untilFirstLineWithCode);
        }

        private static final DebuggerDriver.ResultList getFrames$lambda$4(RtosCommonCommands this$0, GDBDriver.Bridge $bridge, LLThread $thread, int $from, int $count, boolean $untilFirstLineWithCode) {
            return (DebuggerDriver.ResultList)this$0.switchTaskContextAndExecute($bridge, (RtosLLThread)$thread, () -> RtosCommonCommands.getFrames$lambda$4$lambda$3($bridge, $from, $count, $untilFirstLineWithCode));
        }

        /*
         * WARNING - void declaration
         */
        private static final List getVariables$lambda$7$lambda$6(GDBDriver.Bridge $bridge, LLThread $thread, LLFrame $frame) {
            void $this$mapTo$iv$iv;
            List list = $bridge.doGetFrameVariables(((RtosLLThread)$thread).getGdbThreadId(), $frame.getIndex());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"doGetFrameVariables(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LLValue lLValue = (LLValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                RtosLLThread rtosLLThread = (RtosLLThread)$thread;
                int n = $frame.getIndex();
                Intrinsics.checkNotNull((Object)it);
                collection.add(new RtosLLValue(rtosLLThread, n, (LLValue)it));
            }
            return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        }

        private static final List getVariables$lambda$7(RtosCommonCommands this$0, GDBDriver.Bridge $bridge, LLThread $thread, LLFrame $frame) {
            return (List)this$0.switchTaskContextAndExecute($bridge, (RtosLLThread)$thread, () -> RtosCommonCommands.getVariables$lambda$7$lambda$6($bridge, $thread, $frame));
        }

        private static final LLValueData getData$lambda$9$lambda$8(GDBDriver.Bridge $bridge, LLValue $value) {
            return $bridge.doLoadVariableData($value);
        }

        private static final LLValueData getData$lambda$9(RtosCommonCommands this$0, GDBDriver.Bridge $bridge, LLValue $value) {
            return (LLValueData)this$0.switchTaskContextAndExecute($bridge, ((RtosLLValue)$value).getMyRtosLLThread(), () -> RtosCommonCommands.getData$lambda$9$lambda$8($bridge, $value));
        }

        private static final DebuggerDriver.ResultList getVariableChildren$lambda$11$lambda$10(GDBDriver.Bridge $bridge, LLValue $value, int $from, int $count) {
            return $bridge.doGetVariableChildren($value, $from, $count);
        }

        private static final DebuggerDriver.ResultList getVariableChildren$lambda$11(RtosCommonCommands this$0, GDBDriver.Bridge $bridge, LLValue $value, int $from, int $count) {
            return (DebuggerDriver.ResultList)this$0.switchTaskContextAndExecute($bridge, ((RtosLLValue)$value).getMyRtosLLThread(), () -> RtosCommonCommands.getVariableChildren$lambda$11$lambda$10($bridge, $value, $from, $count));
        }

        public static final /* synthetic */ Object access$switchTaskContextAndExecute(RtosCommonCommands $this, GDBDriver.Bridge bridge, RtosLLThread task, Function0 callable) {
            return $this.switchTaskContextAndExecute(bridge, task, callable);
        }
    }
}

