/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded.execution;

import com.intellij.clion.embedded.execution.EmbeddedSettingsState;
import com.intellij.clion.embedded.execution.ui.EmbeddedSettingsPanel;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EmbeddedSettingsConfigurable
implements SearchableConfigurable {
    static final String DEFAULT_OPENOCD_LOCATION;
    static final String DEFAULT_STM32CUBEMX_LOCATION;
    @NotNull
    private static final Future<String> PATH_OPENOCD_LOCATION;
    private EmbeddedSettingsPanel panel = null;

    @NotNull
    public static String getPathOcdLocation() {
        String string;
        try {
            string = PATH_OPENOCD_LOCATION.get(300L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            String string2 = DEFAULT_OPENOCD_LOCATION;
            if (string2 == null) {
                EmbeddedSettingsConfigurable.$$$reportNull$$$0(1);
            }
            return string2;
        }
        if (string == null) {
            EmbeddedSettingsConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getId() {
        return "com.jetbrains.cidr.embedded.config";
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"configurable.EmbeddedSettingsConfigurable.display.name", (Object[])new Object[0]);
    }

    public boolean isModified() {
        EmbeddedSettingsState state = EmbeddedSettingsState.getInstance();
        if (state == null) {
            return true;
        }
        return !StringUtil.equalsTrimWhitespaces((CharSequence)this.panel.getOpenOcdLocation().getText(), (CharSequence)state.openOcdLocation) || !StringUtil.equalsTrimWhitespaces((CharSequence)this.panel.getStm32CubeMXLocation().getText().trim(), (CharSequence)state.stm32CubeMXLocation);
    }

    public void apply() {
        EmbeddedSettingsState state = EmbeddedSettingsState.getInstance();
        if (state != null) {
            state.openOcdLocation = this.panel.getOpenOcdLocation().getText().trim();
            state.stm32CubeMXLocation = this.panel.getStm32CubeMXLocation().getText().trim();
        }
    }

    public void disposeUIResources() {
        this.panel = null;
    }

    @Nullable
    public JComponent createComponent() {
        this.panel = new EmbeddedSettingsPanel();
        return this.panel;
    }

    public void reset() {
        EmbeddedSettingsState state = EmbeddedSettingsState.getInstance();
        this.panel.getOpenOcdLocation().setText(state.openOcdLocation);
        this.panel.getStm32CubeMXLocation().setText(state.stm32CubeMXLocation);
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    private static String findExecutableInPath(@NotNull String name, String defaultPath) {
        if (name == null) {
            EmbeddedSettingsConfigurable.$$$reportNull$$$0(2);
        }
        if (SystemInfo.isWindows) {
            return PathEnvironmentVariableUtil.findExecutableInWindowsPath((String)name, (String)defaultPath);
        }
        File file = PathEnvironmentVariableUtil.findInPath((String)name);
        return file == null ? defaultPath : file.getAbsolutePath();
    }

    @Nullable
    public String getHelpTopic() {
        return "settings.embeddedtools";
    }

    static {
        if (SystemInfo.isWindows) {
            DEFAULT_STM32CUBEMX_LOCATION = "C:\\Program Files\\STMicroelectronics\\STM32Cube\\STM32CubeMX\\STM32CubeMX.exe";
            DEFAULT_OPENOCD_LOCATION = SystemProperties.getUserHome();
        } else if (SystemInfo.isMac) {
            DEFAULT_STM32CUBEMX_LOCATION = "/Applications/STMicroelectronics/STM32CubeMX.app/Contents/Resources/STM32CubeMX";
            DEFAULT_OPENOCD_LOCATION = SystemProperties.getUserHome();
        } else {
            DEFAULT_OPENOCD_LOCATION = "/usr/bin/openocd";
            DEFAULT_STM32CUBEMX_LOCATION = SystemProperties.getUserHome();
        }
        PATH_OPENOCD_LOCATION = ApplicationManager.getApplication().executeOnPooledThread(() -> EmbeddedSettingsConfigurable.findExecutableInPath("openocd", DEFAULT_OPENOCD_LOCATION));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/clion/embedded/execution/EmbeddedSettingsConfigurable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathOcdLocation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/clion/embedded/execution/EmbeddedSettingsConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findExecutableInPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

