/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.embedded;

import com.intellij.clion.embedded.execution.wizard.GdbServerType;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EmbeddedUsagesCollector
extends CounterUsagesCollector {
    private static final Pair<String, GdbServerType>[] KNOWN_GDBSERVERS_BY_NAME = (Pair[])ContainerUtil.ar((Object[])new Pair[]{Pair.pair((Object)"gdbserver", (Object)((Object)GdbServerType.GDBSERVER)), Pair.pair((Object)"ssh", (Object)((Object)GdbServerType.SSH_TUNNEL)), Pair.pair((Object)"plink", (Object)((Object)GdbServerType.SSH_TUNNEL))});
    private static final Pair<String, GdbServerType>[] KNOWN_GDBSERVERS_BY_NAME_FRAGMENT = (Pair[])ContainerUtil.ar((Object[])new Pair[]{Pair.pair((Object)"openocd", (Object)((Object)GdbServerType.OPENOCD)), Pair.pair((Object)"st-util", (Object)((Object)GdbServerType.STUTIL)), Pair.pair((Object)"jlinkgdbserver", (Object)((Object)GdbServerType.JLINK)), Pair.pair((Object)"st-link_gdbserver", (Object)((Object)GdbServerType.STLINK)), Pair.pair((Object)"qemu", (Object)((Object)GdbServerType.QEMU)), Pair.pair((Object)"pyocd", (Object)((Object)GdbServerType.PYOCD)), Pair.pair((Object)"pegdbserver_console", (Object)((Object)GdbServerType.PEMICRO)), Pair.pair((Object)"xmd", (Object)((Object)GdbServerType.XMD))});
    private static final String[] KNOWN_MCU_FAMILIES = new String[]{"STM32C0", "STM32F0", "STM32F1", "STM32F2", "STM32F3", "STM32F4", "STM32F7", "STM32G0", "STM32G4", "STM32H5", "STM32H7", "STM32L0", "STM32L1", "STM32L4A", "STM32L4P", "STM32L4Q", "STM32L4R", "STM32L4S", "STM32L4", "STM32L5", "STM32MP1", "STM32U5", "STM32WBA", "STM32WB1", "STM32WB3", "STM32WB5", "STM32WL", "UPDATE_FAILED"};
    private static final EventLogGroup GROUP = new EventLogGroup("cidr.embedded", 4);
    private static final EventId2<String, Boolean> PROJECT_UPDATE;
    private static final EventId1<GdbServerType> CUSTOM_GDB_SERVER_STARTED;
    private static final EventId STARTED_EVENT;
    private static final EventId1<GdbServerType> RUN_CONFIG_CREATED_EVENT;

    public static void triggerStm32CubeMXParse(@NotNull Project project, @NotNull String mcuName, boolean automatic) {
        if (project == null) {
            EmbeddedUsagesCollector.$$$reportNull$$$0(0);
        }
        if (mcuName == null) {
            EmbeddedUsagesCollector.$$$reportNull$$$0(1);
        }
        mcuName = mcuName.toUpperCase(Locale.ROOT);
        String mcuFamily = "UNKNOWN";
        for (String tryFamily : KNOWN_MCU_FAMILIES) {
            if (!mcuName.startsWith(tryFamily)) continue;
            mcuFamily = tryFamily;
            break;
        }
        PROJECT_UPDATE.log(project, (Object)mcuFamily, (Object)automatic);
    }

    public static void triggerGdbServerRun(@NotNull Project project, @NotNull String gdbServer) {
        if (project == null) {
            EmbeddedUsagesCollector.$$$reportNull$$$0(2);
        }
        if (gdbServer == null) {
            EmbeddedUsagesCollector.$$$reportNull$$$0(3);
        }
        int anySlashIndex = Math.max(0, gdbServer.lastIndexOf(47));
        anySlashIndex = Math.max(anySlashIndex, gdbServer.lastIndexOf(92));
        String pureName = FileUtil.getNameWithoutExtension((String)gdbServer.substring(anySlashIndex)).toLowerCase(Locale.ROOT);
        GdbServerType serverType = null;
        for (Pair<String, GdbServerType> pair : KNOWN_GDBSERVERS_BY_NAME) {
            if (!((String)pair.first).equalsIgnoreCase(pureName)) continue;
            serverType = (GdbServerType)((Object)pair.second);
            break;
        }
        if (serverType == null) {
            for (Pair<String, GdbServerType> pair : KNOWN_GDBSERVERS_BY_NAME_FRAGMENT) {
                if (!pureName.contains((CharSequence)pair.first)) continue;
                serverType = (GdbServerType)((Object)pair.second);
                break;
            }
        }
        if (serverType == null) {
            serverType = GdbServerType.OTHER;
        }
        CUSTOM_GDB_SERVER_STARTED.log(project, (Object)serverType);
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    public static void logWizardStart(@Nullable Project project) {
        STARTED_EVENT.log(project);
    }

    public static void logWizardSuccess(@Nullable Project project, @NotNull GdbServerType type) {
        if (type == null) {
            EmbeddedUsagesCollector.$$$reportNull$$$0(4);
        }
        RUN_CONFIG_CREATED_EVENT.log(project, (Object)type);
    }

    static {
        List allowedMcuFamilyNames = ContainerUtil.append(Arrays.asList(KNOWN_MCU_FAMILIES), (Object[])new String[]{"UNKNOWN"});
        PROJECT_UPDATE = GROUP.registerEvent("STM32CUBEMX_PROJECT_UPDATE", (EventField)EventFields.String((String)"MCU_NAME", (List)allowedMcuFamilyNames), (EventField)EventFields.Boolean((String)"AUTOMATIC"));
        CUSTOM_GDB_SERVER_STARTED = GROUP.registerEvent("CUSTOM_GDB_SERVER_STARTED", (EventField)EventFields.Enum((String)"SERVER_TYPE", GdbServerType.class, GdbServerType::getFusName));
        STARTED_EVENT = GROUP.registerEvent("gdbserver.wizard.started");
        RUN_CONFIG_CREATED_EVENT = GROUP.registerEvent("gdbserver.runconfig.created", (EventField)EventFields.Enum((String)"gdbserverType", GdbServerType.class, GdbServerType::getFusName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mcuName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gdbServer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/clion/embedded/EmbeddedUsagesCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerStm32CubeMXParse";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerGdbServerRun";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "logWizardSuccess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

