/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.CidrUtilsExecutionBundle;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrToolsUtil {
    public static final int DEFAULT_COMMAND_TIMEOUT = StringUtil.parseInt((String)System.getProperty("cidr.remote.command.timeout"), (int)5000);
    private static final Logger LOG = Logger.getInstance(CidrToolsUtil.class);

    public static int sendUnixSignal(@NotNull HostMachine host, int pid, @NotNull String signalName) {
        if (host == null) {
            CidrToolsUtil.$$$reportNull$$$0(0);
        }
        if (signalName == null) {
            CidrToolsUtil.$$$reportNull$$$0(1);
        }
        GeneralCommandLine cmd = new GeneralCommandLine(new String[]{"kill", "-s", signalName, Integer.toString(pid)});
        try {
            return host.runProcess(cmd, DEFAULT_COMMAND_TIMEOUT).getExitCode();
        }
        catch (ExecutionException e) {
            LOG.warn("Cannot send signal to remote process (pid = " + pid + ", signal = " + signalName + ")", (Throwable)e);
            return -1;
        }
    }

    @NotNull
    public static String generateTempFileName(@NotNull HostMachine host) throws ExecutionException {
        if (host == null) {
            CidrToolsUtil.$$$reportNull$$$0(2);
        }
        return CidrToolsUtil.getTempFileName(command -> host.runProcess(command, DEFAULT_COMMAND_TIMEOUT), host.getOS());
    }

    @NotNull
    private static String getTempFileName(@NotNull CommandRunner runner, @NotNull OS osType) throws ExecutionException {
        GeneralCommandLine command;
        ProcessOutput output;
        if (runner == null) {
            CidrToolsUtil.$$$reportNull$$$0(3);
        }
        if (osType == null) {
            CidrToolsUtil.$$$reportNull$$$0(4);
        }
        CidrToolsUtil.assertUnixOnly(osType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("RemoteUtil: get temporary file name");
        }
        if (!(output = runner.run(command = new GeneralCommandLine(new String[]{"mktemp", "-u"}))).checkSuccess(LOG)) {
            throw new ExecutionException(CidrUtilsExecutionBundle.message("remote.exception.cannot.generate.temp.path.ext", output.getExitCode()));
        }
        String result = StringUtil.nullize((String)output.getStdout().trim());
        if (result == null) {
            throw new ExecutionException(CidrUtilsExecutionBundle.message("remote.exception.cannot.generate.temp.path", new Object[0]));
        }
        String string = result;
        if (string == null) {
            CidrToolsUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static void assertUnixOnly(@NotNull OS osType) throws ExecutionException {
        if (osType == null) {
            CidrToolsUtil.$$$reportNull$$$0(6);
        }
        if (osType == OS.Windows) {
            throw new ExecutionException((Throwable)new UnsupportedOperationException(osType.name()));
        }
    }

    public static boolean checkSuccess(@NotNull GeneralCommandLine cl, @NotNull ProcessOutput output, @NotNull Logger logger) {
        if (cl == null) {
            CidrToolsUtil.$$$reportNull$$$0(7);
        }
        if (output == null) {
            CidrToolsUtil.$$$reportNull$$$0(8);
        }
        if (logger == null) {
            CidrToolsUtil.$$$reportNull$$$0(9);
        }
        if (output.getExitCode() == 0 && !output.isTimeout()) {
            return true;
        }
        logger.info(CidrToolsUtil.logInfo(cl, output));
        return false;
    }

    @NotNull
    public static String logInfo(@NotNull GeneralCommandLine cl, @NotNull ProcessOutput output) {
        if (cl == null) {
            CidrToolsUtil.$$$reportNull$$$0(10);
        }
        if (output == null) {
            CidrToolsUtil.$$$reportNull$$$0(11);
        }
        String string = "[" + cl.getCommandLineString() + "]: " + CidrToolsUtil.extractError(output);
        if (string == null) {
            CidrToolsUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static String extractError(@NotNull ProcessOutput output) {
        if (output == null) {
            CidrToolsUtil.$$$reportNull$$$0(13);
        }
        StringBuilder sb = new StringBuilder();
        if (output.isTimeout()) {
            sb.append("(timed out)");
        } else {
            sb.append("(exit code ").append(output.getExitCode()).append(") ");
            if (!output.getStderr().isEmpty()) {
                sb.append(output.getStderr());
            } else {
                sb.append(output.getStdout());
            }
        }
        String string = sb.toString();
        if (string == null) {
            CidrToolsUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    public static File getXcodeSelect() {
        return CidrToolsUtil.getXcodeSelect(new CidrToolEnvironment(), null);
    }

    @Nullable
    public static File getXcodeSelect(@NotNull CidrToolEnvironment environment, @Nullable ProgressIndicator indicator) {
        if (environment == null) {
            CidrToolsUtil.$$$reportNull$$$0(15);
        }
        GeneralCommandLine cl = new GeneralCommandLine();
        cl.setExePath("xcode-select");
        cl.addParameter("-print-path");
        cl.setCharset(CharsetToolkit.getDefaultSystemCharset());
        try {
            ProcessOutput result = environment.getHostMachine().runProcess(cl, indicator, 1000);
            if (result.isTimeout()) {
                throw new ExecutionException("xcode-select timed out");
            }
            String err = result.getStderr().trim();
            if (!StringUtil.isEmpty((String)err)) {
                throw new ExecutionException(err);
            }
            String path = result.getStdout().trim();
            if (StringUtil.isEmptyOrSpaces((String)path)) {
                throw new ExecutionException("xcode-select returned an empty path");
            }
            return new File(path);
        }
        catch (ExecutionException e) {
            LOG.info("Cannot determine default Xcode version: " + e.getMessage());
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signalName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "osType";
                break;
            }
            case 5: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/toolchains/CidrToolsUtil";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/toolchains/CidrToolsUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempFileName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "logInfo";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "extractError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sendUnixSignal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generateTempFileName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTempFileName";
                break;
            }
            case 5: 
            case 12: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "assertUnixOnly";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkSuccess";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "logInfo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractError";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getXcodeSelect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 12, 14 -> new IllegalStateException(string);
        };
    }

    public static interface CommandRunner {
        @NotNull
        public ProcessOutput run(@NotNull GeneralCommandLine var1) throws ExecutionException;
    }

    public static class Status {
        @NotNull
        public final StatusCode code;
        @NotNull
        @Nls
        public final String message;

        public Status(@NotNull StatusCode code, @NotNull @Nls String message) {
            if (code == null) {
                Status.$$$reportNull$$$0(0);
            }
            if (message == null) {
                Status.$$$reportNull$$$0(1);
            }
            this.code = code;
            this.message = message;
        }

        public static Status error(@NotNull @Nls String message) {
            if (message == null) {
                Status.$$$reportNull$$$0(2);
            }
            return new Status(StatusCode.ERROR, message);
        }

        public static Status of(@NotNull Pair<Boolean, @Nls String> status) {
            if (status == null) {
                Status.$$$reportNull$$$0(3);
            }
            return new Status((Boolean)status.first != false ? StatusCode.OK : StatusCode.ERROR, (String)status.second);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.code == status.code && this.message.equals(status.message);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.code, this.message});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/toolchains/CidrToolsUtil$Status";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "of";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum StatusCode {
        OK,
        WARNING,
        ERROR;

    }
}

