/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.HostUtilKt;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrEnvironmentUtil {
    public static final int PATH_CACHE_SIZE = 10000;
    private static final Logger LOG = Logger.getInstance(CidrEnvironmentUtil.class);
    public static final String envCommand = "env";
    private static final String envNullFlag = "--null";
    private static final String sourcePosixCommand = ".";
    private static final String redirectOutput = "1> /dev/null ";
    private static final String fallbackShellAdvancedSetting = "cidr.util.fallback.shell";

    @NotNull
    public static Map<String, String> readLinuxEnvironmentFromFile(@NotNull String file, @NotNull HostMachine host, @NotNull Map<String, String> parentEnvironment) throws IOException, ExecutionException {
        if (file == null) {
            CidrEnvironmentUtil.$$$reportNull$$$0(0);
        }
        if (host == null) {
            CidrEnvironmentUtil.$$$reportNull$$$0(1);
        }
        if (parentEnvironment == null) {
            CidrEnvironmentUtil.$$$reportNull$$$0(2);
        }
        return CidrEnvironmentUtil.readLinuxEnvironmentFromFile(file, host, null, null, parentEnvironment);
    }

    @NotNull
    public static Map<String, String> readLinuxEnvironmentFromFile(@NotNull String file, @NotNull HostMachine host, @Nullable String interpreterPath, @Nullable String envPath, @NotNull Map<String, String> parentEnvironment) throws IOException, ExecutionException {
        if (file == null) {
            CidrEnvironmentUtil.$$$reportNull$$$0(3);
        }
        if (host == null) {
            CidrEnvironmentUtil.$$$reportNull$$$0(4);
        }
        if (parentEnvironment == null) {
            CidrEnvironmentUtil.$$$reportNull$$$0(5);
        }
        String envCommand = envPath == null ? envCommand : envPath;
        boolean envSupportsNullFlag = CidrEnvironmentUtil.testEnvForNullFlag(host, envCommand);
        if (interpreterPath == null && (interpreterPath = CidrEnvironmentUtil.getShellPath(host, envCommand, envSupportsNullFlag)) == null) {
            LOG.warn("SHELL is not found in environment, falling back to advanced setting cidr.util.fallback.shell");
            interpreterPath = AdvancedSettings.getString((String)fallbackShellAdvancedSetting);
        }
        StringBuilder envCommandStringBuilder = new StringBuilder(envCommand);
        if (envSupportsNullFlag) {
            envCommandStringBuilder.append(" ").append(envNullFlag);
        }
        String sourceCommandString = ". " + CommandLineUtil.posixQuote((String)file) + " 1> /dev/null && " + envCommandStringBuilder;
        GeneralCommandLine readShellEnvCommand = new GeneralCommandLine(new String[]{interpreterPath, "-l", "-c", envCommandStringBuilder.toString()});
        readShellEnvCommand.withEnvironment(parentEnvironment);
        GeneralCommandLine readShellEnvWithFileCommand = new GeneralCommandLine(new String[]{interpreterPath, "-l", "-c", sourceCommandString});
        readShellEnvWithFileCommand.withEnvironment(parentEnvironment);
        Map<String, String> shellEnv = CidrEnvironmentUtil.runCommandAndParseEnv(readShellEnvCommand, host, envSupportsNullFlag);
        Map<String, String> shellEnvWithFile = CidrEnvironmentUtil.runCommandAndParseEnv(readShellEnvWithFileCommand, host, envSupportsNullFlag);
        return CidrEnvironmentUtil.subtractEnvironments(shellEnvWithFile, shellEnv);
    }

    @Nullable
    private static String getShellPath(@NotNull HostMachine host, String envCommand, boolean envSupportsNullFlag) throws ExecutionException, IOException {
        if (host == null) {
            CidrEnvironmentUtil.$$$reportNull$$$0(6);
        }
        GeneralCommandLine envCmd = new GeneralCommandLine();
        envCmd.setExePath(envCommand);
        if (envSupportsNullFlag) {
            envCmd.addParameter(envNullFlag);
        }
        Map<String, String> initialEnv = CidrEnvironmentUtil.runCommandAndParseEnv(envCmd, host, envSupportsNullFlag);
        return initialEnv.getOrDefault("SHELL", null);
    }

    private static boolean testEnvForNullFlag(@NotNull HostMachine host, @NotNull String envPath) {
        if (host == null) {
            CidrEnvironmentUtil.$$$reportNull$$$0(7);
        }
        if (envPath == null) {
            CidrEnvironmentUtil.$$$reportNull$$$0(8);
        }
        GeneralCommandLine envTestCmd = new GeneralCommandLine(new String[]{envPath, envNullFlag});
        CidrLogService.LOG.debug("Going to execute command {}", new Object[]{envTestCmd});
        try {
            ProcessOutput output = host.runProcess(envTestCmd, HostUtilKt.getReadEnvironmentFileTimeoutMs());
            return output.checkSuccess(CidrLogService.LOG);
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    @NotNull
    private static Map<String, String> runCommandAndParseEnv(@NotNull GeneralCommandLine shellSourceCmd, @NotNull HostMachine host, final boolean envSupportsNullFlag) throws ExecutionException, IOException {
        if (shellSourceCmd == null) {
            CidrEnvironmentUtil.$$$reportNull$$$0(9);
        }
        if (host == null) {
            CidrEnvironmentUtil.$$$reportNull$$$0(10);
        }
        CidrLogService.LOG.debug("Going to execute command {}", new Object[]{shellSourceCmd});
        final ProcessOutput sourceOutput = host.runProcess(shellSourceCmd.withEnvironment("LC_ALL", "C.UTF-8"), CidrRunProcessUtil.getProgressIndicator(), HostUtilKt.getReadEnvironmentFileTimeoutMs());
        if (!sourceOutput.checkSuccess(CidrLogService.LOG)) {
            throw new IOException(sourceOutput.getStderr());
        }
        return new HashMap<String, String>(){
            {
                Arrays.stream(sourceOutput.getStdout().split(envSupportsNullFlag ? "\u0000" : "\n")).forEach((? super T string) -> {
                    int index = string.indexOf("=");
                    if (index > 0) {
                        this.put(string.substring(0, index), string.substring(index + 1));
                    }
                });
            }
        };
    }

    @NotNull
    public static Map<String, String> subtractEnvironments(@NotNull Map<String, String> sourcedEnv, @NotNull Map<String, String> originalEnv) {
        if (sourcedEnv == null) {
            CidrEnvironmentUtil.$$$reportNull$$$0(11);
        }
        if (originalEnv == null) {
            CidrEnvironmentUtil.$$$reportNull$$$0(12);
        }
        HashMap<String, String> result = new HashMap<String, String>(sourcedEnv);
        originalEnv.forEach((key, value) -> {
            if (result.containsKey(key) && Objects.equals(value, result.get(key))) {
                result.remove(key);
            }
        });
        HashMap<String, String> hashMap = result;
        if (hashMap == null) {
            CidrEnvironmentUtil.$$$reportNull$$$0(13);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentEnvironment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellSourceCmd";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcedEnv";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalEnv";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/system/CidrEnvironmentUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/system/CidrEnvironmentUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "subtractEnvironments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readLinuxEnvironmentFromFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getShellPath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "testEnvForNullFlag";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runCommandAndParseEnv";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "subtractEnvironments";
                break;
            }
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }
}

