/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory.hexdump;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightManagerImpl;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.JBColor;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import com.jetbrains.cidr.execution.debugger.memory.BaseDocRegion;
import com.jetbrains.cidr.execution.debugger.memory.CidrHexdumpOptions;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import com.jetbrains.cidr.execution.debugger.memory.DocRegion;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.AbstractHexdumpDataProvider;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.ByteCoordinates;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.CidrHexdumpByteUpdate;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.CidrHexdumpRegion;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.CidrHexdumpRegionKt;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 _2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001_B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0014\u0010\u001f\u001a\u00020 2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0016J\u001c\u0010\"\u001a\u00020#2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010%\u001a\u00020&H\u0014J\u0014\u0010'\u001a\u00020#2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030(H\u0002J\b\u0010,\u001a\u00020#H\u0016J\b\u0010-\u001a\u00020#H\u0014J\u0014\u00103\u001a\u00020#2\n\u00104\u001a\u000605j\u0002`6H\u0014J\u0014\u00107\u001a\u00020#2\n\u00104\u001a\u000605j\u0002`6H\u0014J\"\u00108\u001a\u00020#2\n\u00104\u001a\u000605j\u0002`62\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00020:H\u0014J=\u0010;\u001a\u00020#2\n\u00104\u001a\u000605j\u0002`62\u0006\u0010<\u001a\u00020\u001a2\b\u0010=\u001a\u0004\u0018\u00010\u00022\u0010\b\u0002\u0010>\u001a\n\u0018\u00010/j\u0004\u0018\u0001`0H\u0002\u00a2\u0006\u0002\u0010?J\u0012\u0010@\u001a\u0004\u0018\u00010\u001a2\u0006\u0010A\u001a\u00020\u0012H\u0014J\u0010\u0010B\u001a\u00020\u00122\u0006\u0010<\u001a\u00020\u001aH\u0014J\u0010\u0010C\u001a\u00020\u00122\u0006\u0010D\u001a\u00020\u0012H\u0002J\u0018\u0010E\u001a\u00020\u00122\u0006\u0010<\u001a\u00020\u001a2\u0006\u0010A\u001a\u00020\u0012H\u0014J\u0018\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010H\u001a\u00020\u00122\u0006\u0010I\u001a\u00020JJ\u0018\u0010K\u001a\u00020#2\u0006\u0010L\u001a\u00020G2\b\u0010M\u001a\u0004\u0018\u00010NJ\u0010\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020\u001aH\u0002J\u0010\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010R\u001a\u00020\u0012J\u0010\u0010S\u001a\u00020\u00122\u0006\u0010T\u001a\u00020\u0012H\u0002J\u0018\u0010U\u001a\u00020#2\u0006\u0010V\u001a\u00020P2\u0006\u0010W\u001a\u00020\u0002H\u0002J \u0010U\u001a\u00020#2\u0006\u0010X\u001a\u00020P2\u0006\u0010W\u001a\u00020\u00022\u0006\u0010Y\u001a\u00020ZH\u0002J\u001e\u0010[\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010X\u001a\u00020P2\u0006\u0010Y\u001a\u00020ZH\u0002J\u0010\u0010\\\u001a\u00020#2\u0006\u0010<\u001a\u00020\u001aH\u0002J\b\u0010]\u001a\u00020ZH\u0002J\b\u0010^\u001a\u00020ZH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00120\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\u00060/j\u0002`08BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102\u00a8\u0006`"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/CidrHexdumpRegion;", "Lcom/jetbrains/cidr/execution/debugger/memory/BaseDocRegion;", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "dataRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion$Completed$Loaded;", "highlightingSessionId", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/ex/DocumentEx;Lcom/intellij/openapi/util/TextRange;Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion$Completed$Loaded;J)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "columnsCount", "", "lineLen", "hexRangeInLine", "asciiRangeInLine", "betweenHexAndAsciiRangeInLine", "afterAsciiRangeInLine", "updatedBytes", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "updateVersions", "updateHighlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "canBeSeamlesslyUpdatedBy", "", "newRegion", "replaceSeamlessly", "", "oldRegion", "newText", "", "highlightChangedBytes", "Lcom/jetbrains/cidr/execution/debugger/memory/DocRegion;", "rangeMarkersToDispose", "", "Lcom/intellij/openapi/editor/RangeMarker;", "markOutdated", "disposeOnDeletion", "myAsciiBuffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getMyAsciiBuffer", "()Ljava/lang/StringBuilder;", "renderHeader", "buffer", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "renderFooter", "renderEntry", "dataEntry", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataEntry;", "renderSingleByte", "address", "byte", "asciiBuffer", "(Ljava/lang/Appendable;Lcom/jetbrains/cidr/execution/debugger/memory/Address;Ljava/lang/Byte;Ljava/lang/StringBuilder;)V", "getAddressForLineNumberInsideRegion", "lineNumber", "getLineNumberInsideRegion", "lineOf", "offset", "getOffsetInsideLine", "updateByte", "Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/CidrHexdumpByteUpdate;", "offsetInRegion", "typedChar", "", "updateCompleted", "update", "err", "", "getCoordinates", "Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/ByteCoordinates;", "addr", "regionOffset", "byteHexOffsetInLine", "n", "writeAndHighlight", "coordinates", "b", "coord", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "highlightRanges", "removeUpdateHighlighters", "updateSuccessAttributes", "updateFailureAttributes", "Companion", "intellij.cidr.debugger"})
@SourceDebugExtension(value={"SMAP\nCidrHexdumpRegion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrHexdumpRegion.kt\ncom/jetbrains/cidr/execution/debugger/memory/hexdump/CidrHexdumpRegion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,498:1\n1611#2,9:499\n1863#2:508\n1864#2:511\n1620#2:512\n1863#2,2:513\n1863#2:515\n1863#2:516\n1863#2,2:517\n1864#2:519\n1864#2:520\n1863#2,2:521\n1863#2,2:523\n1863#2,2:525\n1#3:509\n1#3:510\n*S KotlinDebug\n*F\n+ 1 CidrHexdumpRegion.kt\ncom/jetbrains/cidr/execution/debugger/memory/hexdump/CidrHexdumpRegion\n*L\n79#1:499,9\n79#1:508\n79#1:511\n79#1:512\n87#1:513,2\n99#1:515\n113#1:516\n121#1:517,2\n113#1:519\n99#1:520\n149#1:521,2\n150#1:523,2\n421#1:525,2\n79#1:510\n*E\n"})
public final class CidrHexdumpRegion
extends BaseDocRegion<Byte> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final long highlightingSessionId;
    private final int columnsCount;
    private final int lineLen;
    @NotNull
    private final TextRange hexRangeInLine;
    @NotNull
    private final TextRange asciiRangeInLine;
    @NotNull
    private final TextRange betweenHexAndAsciiRangeInLine;
    @NotNull
    private final TextRange afterAsciiRangeInLine;
    @NotNull
    private final ConcurrentHashMap<Address, Byte> updatedBytes;
    @NotNull
    private final ConcurrentHashMap<Address, Integer> updateVersions;
    @NotNull
    private final ConcurrentHashMap<Address, List<RangeHighlighter>> updateHighlighters;
    @NotNull
    private final List<RangeMarker> rangeMarkersToDispose;
    @NotNull
    private StringBuilder myAsciiBuffer;
    @NotNull
    private static final Key<Boolean> CHANGED_BYTE_HIGHLIGHTER_KEY;
    private static final int WORD_BYTES = 4;
    public static final int PAGE_BYTES = 4096;
    @NotNull
    public static final String BYTE_SEPARATOR = " ";
    @NotNull
    public static final String WORD_SEPARATOR = "  ";
    @NotNull
    private static final String ASCII_PREFIX = "   \u2502 ";
    @NotNull
    private static final String ASCII_SUFFIX = " \u2502";
    private static final int HEX_BYTE_WITH_SEPARATOR_LEN = 3;
    private static final int WORD_TEXT_LEN = 14;

    public CidrHexdumpRegion(@NotNull Project project, @NotNull DocumentEx document, @NotNull TextRange textRange2, @NotNull CidrMemoryData.DataRegion.Completed.Loaded<Byte> dataRegion, long highlightingSessionId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)textRange2, (String)"textRange");
        Intrinsics.checkNotNullParameter(dataRegion, (String)"dataRegion");
        super(document, textRange2, dataRegion);
        this.project = project;
        this.highlightingSessionId = highlightingSessionId;
        this.columnsCount = CidrHexdumpOptions.Companion.getColumnsCount((Document)document);
        this.updatedBytes = new ConcurrentHashMap();
        this.updateVersions = new ConcurrentHashMap();
        this.updateHighlighters = new ConcurrentHashMap();
        int bytesPerLine = this.columnsCount;
        int wordsPerLine = bytesPerLine >= 4 ? bytesPerLine / 4 : 1;
        int hexRangeLength = 3 * bytesPerLine + 2 * wordsPerLine;
        this.lineLen = hexRangeLength + 5 + bytesPerLine + 2 + 1;
        this.hexRangeInLine = TextRange.from((int)0, (int)hexRangeLength);
        this.asciiRangeInLine = TextRange.from((int)(hexRangeLength + 5), (int)bytesPerLine);
        this.betweenHexAndAsciiRangeInLine = TextRange.create((int)this.hexRangeInLine.getEndOffset(), (int)this.asciiRangeInLine.getStartOffset());
        this.afterAsciiRangeInLine = TextRange.create((int)this.asciiRangeInLine.getEndOffset(), (int)this.lineLen);
        this.rangeMarkersToDispose = new ArrayList();
        this.myAsciiBuffer = new StringBuilder();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canBeSeamlesslyUpdatedBy(@NotNull BaseDocRegion<?> newRegion) {
        Intrinsics.checkNotNullParameter(newRegion, (String)"newRegion");
        if (!super.canBeSeamlesslyUpdatedBy(newRegion)) return false;
        if (!(newRegion instanceof CidrHexdumpRegion)) return false;
        CidrHexdumpRegion cidrHexdumpRegion = (CidrHexdumpRegion)newRegion;
        CidrHexdumpRegion cidrHexdumpRegion2 = cidrHexdumpRegion;
        if (cidrHexdumpRegion2 == null) return false;
        if (this.columnsCount != cidrHexdumpRegion2.columnsCount) return false;
        return true;
    }

    @Override
    protected void replaceSeamlessly(@NotNull BaseDocRegion<?> oldRegion, @NotNull CharSequence newText) {
        Intrinsics.checkNotNullParameter(oldRegion, (String)"oldRegion");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        super.replaceSeamlessly(oldRegion, newText);
        this.highlightChangedBytes((DocRegion)oldRegion);
    }

    private final void highlightChangedBytes(DocRegion<?> oldRegion) {
        Iterator $this$mapNotNullTo$iv$iv;
        CidrHexdumpRegion oldHexdumpRegion;
        CidrHexdumpRegion cidrHexdumpRegion = oldHexdumpRegion = oldRegion instanceof CidrHexdumpRegion ? (CidrHexdumpRegion)oldRegion : null;
        CidrMemoryData.Data data = cidrHexdumpRegion != null ? cidrHexdumpRegion.getData() : null;
        AbstractHexdumpDataProvider.ByteData byteData = data instanceof AbstractHexdumpDataProvider.ByteData ? (AbstractHexdumpDataProvider.ByteData)data : null;
        if (byteData == null) {
            return;
        }
        AbstractHexdumpDataProvider.ByteData oldData = byteData;
        List editors = EditorFactory.getInstance().editors((Document)this.getDocument()).toList();
        if (editors.isEmpty()) {
            return;
        }
        Iterable $this$mapNotNull$iv = CollectionsKt.zip(oldData.getEntries(), this.getData().getEntries());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object it$iv$iv;
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pair pair = (Pair)element$iv$iv;
            int n = 0;
            CidrMemoryData.DataEntry dataEntry = (CidrMemoryData.DataEntry)pair.component1();
            CidrMemoryData.DataEntry newEntry = (CidrMemoryData.DataEntry)pair.component2();
            boolean bl2 = Intrinsics.areEqual((Object)dataEntry.getAddress(), (Object)newEntry.getAddress());
            if (_Assertions.ENABLED && !bl2) {
                object = "Assertion failed";
                throw new AssertionError(object);
            }
            Byte by = oldHexdumpRegion.updatedBytes.get(dataEntry.getAddress());
            byte oldValue = by != null ? by.byteValue() : ((Number)dataEntry.getValue()).byteValue();
            Object it = object = newEntry;
            boolean bl3 = false;
            if ((oldValue != ((Number)newEntry.getValue()).byteValue() ? object : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List changedEntries = (List)destination$iv$iv;
        if (oldHexdumpRegion.highlightingSessionId == this.highlightingSessionId) {
            Set<Map.Entry<Address, List<RangeHighlighter>>> set = oldHexdumpRegion.updateHighlighters.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry $i$f$mapNotNullTo22 = (Map.Entry)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)$i$f$mapNotNullTo22);
                Object k = $i$f$mapNotNullTo22.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
                Address addr = (Address)k;
                Object v = $i$f$mapNotNullTo22.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
                List highlighters = (List)v;
                RangeHighlighter rangeHighlighter = (RangeHighlighter)CollectionsKt.firstOrNull((List)highlighters);
                Object attrs = rangeHighlighter != null ? rangeHighlighter.getTextAttributes() : null;
                if (attrs == null) continue;
                ByteCoordinates coordinates = this.getCoordinates(addr);
                this.highlightRanges(coordinates, (TextAttributes)attrs);
            }
        }
        TextAttributes fgAttributes = XDebuggerUIConstants.CHANGED_VALUE_ATTRIBUTES.toTextAttributes();
        Intrinsics.checkNotNull(editors);
        Iterable $this$forEach$iv = editors;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv) {
            Project project;
            Editor editor = (Editor)element$iv;
            boolean bl = false;
            if (editor.getProject() == null) continue;
            HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
            Intrinsics.checkNotNull((Object)highlightManager, (String)"null cannot be cast to non-null type com.intellij.codeInsight.highlighting.HighlightManagerImpl");
            HighlightManagerImpl highlightManager2 = (HighlightManagerImpl)highlightManager;
            int hideFlags = 1;
            Intrinsics.checkNotNullExpressionValue((Object)highlightManager2.getHighlighters(editor), (String)"getHighlighters(...)");
            if (oldHexdumpRegion.highlightingSessionId != this.highlightingSessionId) {
                RangeHighlighter[] currentHighlighters;
                for (RangeHighlighter rangeHighlighter : currentHighlighters) {
                    Intrinsics.checkNotNull((Object)rangeHighlighter);
                    RangeHighlighter highlighter = rangeHighlighter;
                    if (!Intrinsics.areEqual((Object)highlighter.getUserData(CHANGED_BYTE_HIGHLIGHTER_KEY), (Object)true)) continue;
                    TextRange it = highlighter.getTextRange();
                    boolean bl5 = false;
                    boolean bl3 = it.intersects(oldRegion.getTextRange()) || it.intersects(this.getTextRange());
                    if (!bl3) continue;
                    highlightManager2.removeSegmentHighlighter(editor, highlighter);
                }
            }
            Iterable $this$forEach$iv2 = changedEntries;
            boolean $i$f$forEach4 = false;
            for (Object t : $this$forEach$iv2) {
                Iterator bl4;
                CidrMemoryData.DataEntry changedEntry = (CidrMemoryData.DataEntry)t;
                boolean bl7 = false;
                ArrayList highlighters = new ArrayList();
                ByteCoordinates coordinates = this.getCoordinates(changedEntry.getAddress());
                TextRange[] textRangeArray = new TextRange[]{coordinates.getHexRange(), coordinates.getAsciiRange()};
                Intrinsics.checkNotNullExpressionValue(CollectionsKt.arrayListOf((Object[])textRangeArray).iterator(), (String)"iterator(...)");
                while (bl4.hasNext()) {
                    Object e = bl4.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    TextRange range = (TextRange)e;
                    highlightManager2.addRangeHighlight(editor, range.getStartOffset(), range.getEndOffset(), EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES, false, (Collection)highlighters);
                    highlightManager2.addOccurrenceHighlight(editor, range.getStartOffset(), range.getEndOffset(), fgAttributes, hideFlags, (Collection)highlighters, null);
                }
                Iterable $this$forEach$iv3 = highlighters;
                boolean $i$f$forEach5 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    RangeHighlighter it = (RangeHighlighter)element$iv3;
                    boolean bl8 = false;
                    it.putUserData(CHANGED_BYTE_HIGHLIGHTER_KEY, (Object)true);
                }
            }
        }
    }

    @Override
    public void markOutdated() {
        TextAttributes commentAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DefaultLanguageHighlighterColors.LINE_COMMENT);
        TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(HighlighterColors.NO_HIGHLIGHTING).clone();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"clone(...)");
        TextAttributes fgAttributes = textAttributes;
        fgAttributes.setForegroundColor(commentAttributes.getForegroundColor());
        fgAttributes.setBackgroundColor(commentAttributes.getBackgroundColor());
        EditorFactory.getInstance().editors((Document)this.getDocument()).forEach(arg_0 -> CidrHexdumpRegion.markOutdated$lambda$8(arg_0 -> CidrHexdumpRegion.markOutdated$lambda$7(this, fgAttributes, arg_0), arg_0));
    }

    @Override
    protected void disposeOnDeletion() {
        super.disposeOnDeletion();
        Iterable $this$forEach$iv = this.rangeMarkersToDispose;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeMarker p0 = (RangeMarker)element$iv;
            boolean $i$f$disposeOnDeletion$stub_for_inlining = false;
            boolean bl = false;
            p0.dispose();
        }
        Set set = this.updateHighlighters.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        $this$forEach$iv = set;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Address it = (Address)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.removeUpdateHighlighters(it);
        }
    }

    private final StringBuilder getMyAsciiBuffer() {
        if (this.myAsciiBuffer == null) {
            this.myAsciiBuffer = new StringBuilder();
        }
        return this.myAsciiBuffer;
    }

    @Override
    protected void renderHeader(@NotNull Appendable buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Address start = this.getData().getRange().getStart();
        long missingStartBytesNumber = AddressUtil.reminder(start, this.columnsCount);
        AddressRange missingStartRange = AddressUtil.until(start.minus(missingStartBytesNumber), start);
        for (Address address : missingStartRange) {
            this.renderSingleByte(buffer, address, null, this.getMyAsciiBuffer());
        }
    }

    @Override
    protected void renderFooter(@NotNull Appendable buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Address endInclusive = this.getData().getRange().getEndInclusive();
        long missingEndBytesNumber = (long)this.columnsCount - AddressUtil.reminder(endInclusive, this.columnsCount) - 1L;
        AddressRange missingEndRange = AddressUtil.until(endInclusive.plus(1), endInclusive.plus(1).plus(missingEndBytesNumber));
        for (Address address : missingEndRange) {
            this.renderSingleByte(buffer, address, null, this.getMyAsciiBuffer());
        }
    }

    @Override
    protected void renderEntry(@NotNull Appendable buffer, @NotNull CidrMemoryData.DataEntry<Byte> dataEntry) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(dataEntry, (String)"dataEntry");
        this.renderSingleByte(buffer, dataEntry.getAddress(), dataEntry.getValue(), this.getMyAsciiBuffer());
    }

    private final void renderSingleByte(Appendable buffer, Address address, Byte by, StringBuilder asciiBuffer) {
        Object byteString;
        boolean bl;
        Object object = by;
        if (object == null || (object = Companion.toUnsignedHexString((Byte)object)) == null) {
            object = WORD_SEPARATOR;
        }
        boolean bl2 = bl = ((String)(byteString = object)).length() == 2;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "'" + (String)byteString + "' must be a zero-padded unsigned byte";
            throw new AssertionError((Object)string);
        }
        if (Companion.isAlignedTo(address, 4) && this.columnsCount > 4 || Companion.isAlignedTo(address, this.columnsCount)) {
            buffer.append(WORD_SEPARATOR);
        }
        buffer.append(BYTE_SEPARATOR);
        buffer.append((CharSequence)byteString);
        StringBuilder stringBuilder = asciiBuffer;
        if (stringBuilder != null) {
            stringBuilder.append(CidrHexdumpRegionKt.access$toAscii(by));
        }
        if (Companion.isAlignedTo(address.plus(1), this.columnsCount)) {
            if (asciiBuffer != null) {
                buffer.append(ASCII_PREFIX);
                buffer.append(asciiBuffer);
                buffer.append(ASCII_SUFFIX);
                asciiBuffer.setLength(0);
            }
            buffer.append('\n');
        }
    }

    static /* synthetic */ void renderSingleByte$default(CidrHexdumpRegion cidrHexdumpRegion, Appendable appendable, Address address, Byte by, StringBuilder stringBuilder, int n, Object object) {
        if ((n & 8) != 0) {
            stringBuilder = null;
        }
        cidrHexdumpRegion.renderSingleByte(appendable, address, by, stringBuilder);
    }

    @Override
    @Nullable
    protected Address getAddressForLineNumberInsideRegion(int lineNumber) {
        AddressRange addressRange = this.getRange();
        Address start = addressRange.component1();
        Address endInclusive = addressRange.component2();
        Address alignedStart = AddressUtil.roundDown(start, (Number)this.columnsCount);
        Address address = alignedStart.plus(lineNumber * this.columnsCount);
        return address.compareTo(endInclusive) <= 0 ? address : null;
    }

    @Override
    protected int getLineNumberInsideRegion(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return this.lineOf((int)address.minus(this.getRange().getStart()));
    }

    private final int lineOf(int offset) {
        return offset / this.columnsCount;
    }

    @Override
    protected int getOffsetInsideLine(@NotNull Address address, int lineNumber) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        ByteCoordinates coord = this.getCoordinates(address);
        int lineStartDocOffset = this.getTextRange().getStartOffset() + coord.getLineInRegion() * this.lineLen;
        return coord.getHexRange().getStartOffset() - lineStartDocOffset;
    }

    @Nullable
    public final CidrHexdumpByteUpdate updateByte(int offsetInRegion, char typedChar) {
        int docOffset = this.getTextRange().getStartOffset() + offsetInRegion;
        ByteCoordinates byteCoordinates = this.getCoordinates(offsetInRegion);
        if (byteCoordinates == null) {
            return null;
        }
        ByteCoordinates coord = byteCoordinates;
        Byte updatedByte = null;
        Function1 updatedRange = null;
        if (coord.getAsciiRange().contains(docOffset)) {
            char unicode = typedChar;
            if ((unicode & 0xFF) != unicode) {
                return null;
            }
            updatedByte = (byte)unicode;
            updatedRange = (Function1)updateByte.1.INSTANCE;
        }
        if (coord.getHexRange().contains(docOffset)) {
            String currentByteSeq = ((Object)coord.getHexRange().subSequence(this.getDocument().getImmutableCharSequence())).toString();
            Integer n = StringsKt.toIntOrNull((String)currentByteSeq, (int)16);
            if (n == null) {
                return null;
            }
            int currentByte = n;
            Integer n2 = StringsKt.toIntOrNull((String)String.valueOf(typedChar), (int)16);
            if (n2 == null) {
                return null;
            }
            int typedHalfByte = n2;
            updatedByte = docOffset == coord.getHexRange().getStartOffset() ? Byte.valueOf((byte)(currentByte & 0xF | typedHalfByte << 4)) : Byte.valueOf((byte)(currentByte & 0xF0 | typedHalfByte));
            updatedRange = (Function1)updateByte.2.INSTANCE;
        }
        if (updatedByte != null && updatedRange != null) {
            int nextOffset;
            Address nextAddress = coord.getAddress().plus(1);
            int n = docOffset + 1 < ((TextRange)updatedRange.invoke((Object)coord)).getEndOffset() ? docOffset + 1 : (nextOffset = this.getRange().contains((Comparable)nextAddress) ? ((TextRange)updatedRange.invoke((Object)this.getCoordinates(nextAddress))).getStartOffset() : ((TextRange)updatedRange.invoke((Object)this.getCoordinates(this.getRange().getStart()))).getStartOffset() + this.getTextRange().getLength());
            Integer updateVersion = this.updateVersions.merge(coord.getAddress(), 1, (arg_0, arg_1) -> CidrHexdumpRegion.updateByte$lambda$12(CidrHexdumpRegion::updateByte$lambda$11, arg_0, arg_1));
            if (updateVersion == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            this.writeAndHighlight(coord, updatedByte);
            return new CidrHexdumpByteUpdate(coord, updatedByte, RangesKt.coerceAtMost((int)nextOffset, (int)(this.getDocument().getTextLength() - 1)), updateVersion);
        }
        return null;
    }

    public final void updateCompleted(@NotNull CidrHexdumpByteUpdate update2, @Nullable Throwable err) {
        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
        Integer n = this.updateVersions.get(update2.getCoord().getAddress());
        int n2 = update2.getVersion();
        if (n == null || n != n2) {
            return;
        }
        this.removeUpdateHighlighters(update2.getCoord().getAddress());
        if (err == null) {
            ((Map)this.updatedBytes).put(update2.getCoord().getAddress(), update2.getNewValue());
            this.highlightRanges(update2.getCoord(), this.updateSuccessAttributes());
        } else {
            Byte by = this.updatedBytes.get(update2.getCoord().getAddress());
            byte valueBeforeFailedUpdate = by != null ? by.byteValue() : ((Number)((CidrMemoryData.DataEntry)CollectionsKt.elementAt(this.getData().getEntries(), (int)update2.getCoord().getByteInRegion())).getValue()).byteValue();
            this.writeAndHighlight(update2.getCoord(), valueBeforeFailedUpdate, this.updateFailureAttributes());
        }
    }

    private final ByteCoordinates getCoordinates(Address addr) {
        if (!this.getRange().contains((Comparable)addr)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int byteInRegion = (int)addr.minus(this.getRange().getStart());
        int lineInRegion = (int)(addr.minus(this.getRange().getStart()) / (long)this.columnsCount);
        int lineStartDocOffset = this.getTextRange().getStartOffset() + this.lineLen * lineInRegion;
        Address lineStartAddress = this.getRange().getStart().plus(lineInRegion * this.columnsCount);
        int byteInLine = (int)addr.minus(lineStartAddress);
        int hexStart = this.byteHexOffsetInLine(byteInLine);
        int asciiStart = this.asciiRangeInLine.getStartOffset() + byteInLine;
        int byteInWord = byteInLine % 4;
        return new ByteCoordinates(addr, byteInRegion, lineInRegion, byteInLine, byteInWord, new TextRange(lineStartDocOffset + hexStart, lineStartDocOffset + hexStart + 2), new TextRange(lineStartDocOffset + asciiStart, lineStartDocOffset + asciiStart + 1));
    }

    @Nullable
    public final ByteCoordinates getCoordinates(int regionOffset) {
        int docOffset = this.getTextRange().getStartOffset() + regionOffset;
        if (!this.getTextRange().contains(docOffset)) {
            return null;
        }
        int regionLine = regionOffset / this.lineLen;
        Address address = this.getAddressForLineNumberInsideRegion(regionLine);
        if (address == null) {
            return null;
        }
        Address lineStartAddress = address;
        int lineStartRegionOffset = this.lineLen * regionLine;
        int offsetInLine = regionOffset - lineStartRegionOffset;
        if (this.asciiRangeInLine.contains(offsetInLine)) {
            int byteInLine = offsetInLine - this.asciiRangeInLine.getStartOffset();
            return this.getCoordinates(lineStartAddress.plus(byteInLine));
        }
        if (this.hexRangeInLine.contains(offsetInLine)) {
            int wordInLine = offsetInLine / 14;
            Address wordStartAddress = lineStartAddress.plus(wordInLine * 4);
            int offsetInWord = offsetInLine % 14;
            int byteInWord = offsetInWord < 2 ? 0 : (offsetInWord - 2) / 3;
            Address byteAddress = wordStartAddress.plus(byteInWord);
            return this.getCoordinates(byteAddress);
        }
        if (this.betweenHexAndAsciiRangeInLine.contains(offsetInLine) || this.afterAsciiRangeInLine.contains(offsetInLine)) {
            Address lastByteInLine = lineStartAddress.plus(this.columnsCount).minus(1);
            return this.getCoordinates(lastByteInLine);
        }
        return null;
    }

    private final int byteHexOffsetInLine(int n) {
        int wordInLine = n / 4;
        return (wordInLine + 1) * 2 + (n + 1) * 1 + n * 2;
    }

    private final void writeAndHighlight(ByteCoordinates coordinates, byte b) {
        TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DefaultLanguageHighlighterColors.IDENTIFIER).clone();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"clone(...)");
        TextAttributes attributes = textAttributes;
        attributes.setBackgroundColor((Color)JBColor.LIGHT_GRAY);
        this.writeAndHighlight(coordinates, b, attributes);
    }

    private final void writeAndHighlight(ByteCoordinates coord, byte b, TextAttributes attributes) {
        this.getDocument().replaceString(coord.getHexRange().getStartOffset(), coord.getHexRange().getEndOffset(), (CharSequence)Companion.toUnsignedHexString(b));
        this.getDocument().replaceString(coord.getAsciiRange().getStartOffset(), coord.getAsciiRange().getEndOffset(), (CharSequence)CidrHexdumpRegionKt.access$toAscii(b));
        this.highlightRanges(coord, attributes);
    }

    private final List<RangeHighlighter> highlightRanges(ByteCoordinates coord, TextAttributes attributes) {
        this.removeUpdateHighlighters(coord.getAddress());
        ArrayList highlighters = new ArrayList();
        MarkupModel markup = DocumentMarkupModel.forDocument((Document)((Document)this.getDocument()), (Project)this.project, (boolean)true);
        Object[] objectArray = new TextRange[]{coord.getHexRange(), coord.getAsciiRange()};
        for (TextRange range : SetsKt.setOf((Object[])objectArray)) {
            ((Collection)highlighters).add(markup.addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 5999, attributes, HighlighterTargetArea.EXACT_RANGE));
        }
        ((Map)this.updateHighlighters).put(coord.getAddress(), highlighters);
        return highlighters;
    }

    private final void removeUpdateHighlighters(Address address) {
        block1: {
            List<RangeHighlighter> list = this.updateHighlighters.remove(address);
            if (list == null) break block1;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RangeHighlighter it = (RangeHighlighter)element$iv;
                boolean bl = false;
                it.dispose();
            }
        }
    }

    private final TextAttributes updateSuccessAttributes() {
        TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DefaultLanguageHighlighterColors.IDENTIFIER).clone();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"clone(...)");
        TextAttributes attributes = textAttributes;
        attributes.setBackgroundColor((Color)JBColor.GREEN);
        return attributes;
    }

    private final TextAttributes updateFailureAttributes() {
        TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DefaultLanguageHighlighterColors.IDENTIFIER).clone();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributes, (String)"clone(...)");
        TextAttributes attributes = textAttributes;
        attributes.setBackgroundColor((Color)JBColor.RED);
        return attributes;
    }

    private static final Unit markOutdated$lambda$7(CidrHexdumpRegion this$0, TextAttributes $fgAttributes, Editor editor) {
        Project project = editor.getProject();
        if (project == null) {
            return Unit.INSTANCE;
        }
        Project project2 = project;
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project2);
        Intrinsics.checkNotNull((Object)highlightManager, (String)"null cannot be cast to non-null type com.intellij.codeInsight.highlighting.HighlightManagerImpl");
        HighlightManagerImpl highlightManager2 = (HighlightManagerImpl)highlightManager;
        int hideFlags = 4;
        highlightManager2.hideHighlights(editor, hideFlags);
        RangeHighlighter rangeHighlighter = editor.getMarkupModel().addRangeHighlighter(this$0.getRangeMarker().getStartOffset(), this$0.getRangeMarker().getEndOffset(), 1000, $fgAttributes, HighlighterTargetArea.EXACT_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
        RangeHighlighter rangeHighlighter2 = rangeHighlighter;
        ((Collection)this$0.rangeMarkersToDispose).add(rangeHighlighter2);
        return Unit.INSTANCE;
    }

    private static final void markOutdated$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Integer updateByte$lambda$11(Integer old, Integer n) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)n, (String)"new");
        return old + n;
    }

    private static final Integer updateByte$lambda$12(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    static {
        Key key = Key.create((String)"CidrHexdumpRegion.changedByteHighlighter");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        CHANGED_BYTE_HIGHLIGHTER_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0013\u001a\u00020\u0006*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nJ\n\u0010\u0016\u001a\u00020\r*\u00020\u0017R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/CidrHexdumpRegion$Companion;", "", "<init>", "()V", "CHANGED_BYTE_HIGHLIGHTER_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "WORD_BYTES", "", "PAGE_BYTES", "BYTE_SEPARATOR", "", "WORD_SEPARATOR", "ASCII_PREFIX", "ASCII_SUFFIX", "HEX_BYTE_WITH_SEPARATOR_LEN", "WORD_TEXT_LEN", "isAlignedTo", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "n", "toUnsignedHexString", "", "intellij.cidr.debugger"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAlignedTo(@NotNull Address $this$isAlignedTo, int n) {
            Intrinsics.checkNotNullParameter((Object)$this$isAlignedTo, (String)"<this>");
            return $this$isAlignedTo.getUnsignedLongValue() % (long)n == 0L;
        }

        @NotNull
        public final String toUnsignedHexString(byte $this$toUnsignedHexString) {
            String string = Integer.toUnsignedString(Byte.toUnsignedInt($this$toUnsignedHexString), 16);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUnsignedString(...)");
            return StringsKt.padStart((String)string, (int)2, (char)'0');
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

