/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory.disasm;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.util.PathUtil;
import com.intellij.xdebugger.frame.XStackFrame;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFile;
import com.jetbrains.cidr.execution.debugger.memory.disasm.DisasmFileType;
import java.awt.Component;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J,\u0010\u0005\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0007\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/ForceMappingEditorNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.cidr.debugger"})
public final class ForceMappingEditorNotificationProvider
implements EditorNotificationProvider,
DumbAware {
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile frameFile;
        String sourcePath;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!FileTypeRegistry.getInstance().isFileOfType(file, (FileType)DisasmFileType.INSTANCE)) {
            return null;
        }
        if (!(file instanceof MemoryViewFile)) {
            return null;
        }
        CidrDebugProcess cidrDebugProcess = (CidrDebugProcess)file.getUserData(CidrDebugProcess.DEBUG_PROCESS_KEY);
        if (cidrDebugProcess == null) {
            return null;
        }
        CidrDebugProcess process = cidrDebugProcess;
        XStackFrame xStackFrame = process.getSession().getCurrentStackFrame();
        CidrStackFrame cidrStackFrame = xStackFrame instanceof CidrStackFrame ? (CidrStackFrame)xStackFrame : null;
        if (cidrStackFrame == null) {
            return null;
        }
        CidrStackFrame frame = cidrStackFrame;
        String string = frame.getFrame().getFile();
        if (string == null) {
            string = "";
        }
        if (((CharSequence)(sourcePath = string)).length() == 0 || frame.hasSourceFile()) {
            return null;
        }
        VirtualFile virtualFile = frameFile = VfsUtil.findFile((Path)Paths.get(sourcePath, new String[0]), (boolean)false);
        boolean frameFileExists = (virtualFile != null ? virtualFile.exists() : false) && !frameFile.isDirectory();
        return arg_0 -> ForceMappingEditorNotificationProvider.collectNotificationData$lambda$2(frameFileExists, sourcePath, frame, frameFile, process, project, arg_0);
    }

    private static final void collectNotificationData$lambda$2$lambda$0(CidrDebugProcess $process, String $sourcePath, DebuggerSourceFileHash $sourceHash, VirtualFile $frameFile) {
        $process.getSourceFileLocator().forceFileMapping($sourcePath, $sourceHash, $frameFile, false);
    }

    private static final void collectNotificationData$lambda$2$lambda$1(Project $project, FileEditor $it, CidrDebugProcess $process, String $sourcePath, DebuggerSourceFileHash $sourceHash) {
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        FileChooserDialog fileChooserDialog = FileChooserFactory.getInstance().createFileChooser(fileChooserDescriptor, $project, (Component)$it.getComponent());
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDialog, (String)"createFileChooser(...)");
        FileChooserDialog fileChooser = fileChooserDialog;
        VirtualFile[] virtualFileArray = new VirtualFile[]{ProjectUtil.guessProjectDir((Project)$project)};
        VirtualFile[] virtualFileArray2 = fileChooser.choose($project, virtualFileArray);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"choose(...)");
        VirtualFile virtualFile = (VirtualFile)ArraysKt.firstOrNull((Object[])virtualFileArray2);
        if (virtualFile == null) {
            return;
        }
        VirtualFile chosenFile = virtualFile;
        $process.getSourceFileLocator().forceFileMapping($sourcePath, $sourceHash, chosenFile, true);
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$2(boolean $frameFileExists, String $sourcePath, CidrStackFrame $frame, VirtualFile $frameFile, CidrDebugProcess $process, Project $project, FileEditor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EditorNotificationPanel panel2 = new EditorNotificationPanel(it, EditorNotificationPanel.Status.Info);
        if ($frameFileExists) {
            var8_8 = new Object[]{PathUtil.getFileName((String)$sourcePath)};
            panel2.setText(CidrDebuggerBundle.message("debug.editor.notification.force.mapping.exists", var8_8));
        } else {
            var8_8 = new Object[]{PathUtil.getFileName((String)$sourcePath)};
            panel2.setText(CidrDebuggerBundle.message("debug.editor.notification.force.mapping", var8_8));
        }
        DebuggerSourceFileHash sourceHash = $frame.getFrame().getHash();
        if ($frameFile != null && $frameFileExists) {
            panel2.createActionLabel(CidrDebuggerBundle.message("debug.editor.notification.force.mapping.use.it.anyway", new Object[0]), () -> ForceMappingEditorNotificationProvider.collectNotificationData$lambda$2$lambda$0($process, $sourcePath, sourceHash, $frameFile));
        }
        panel2.createActionLabel(CidrDebuggerBundle.message("debug.editor.notification.force.mapping.select.file", new Object[0]), () -> ForceMappingEditorNotificationProvider.collectNotificationData$lambda$2$lambda$1($project, it, $process, $sourcePath, sourceHash));
        return panel2;
    }
}

