/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.ide.FileIconProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.MemoryLiveExecutionAware;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/MemoryLiveExecutionFileIconProvider;", "Lcom/intellij/ide/FileIconProvider;", "<init>", "()V", "getIcon", "Ljavax/swing/Icon;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "flags", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.cidr.debugger"})
public final class MemoryLiveExecutionFileIconProvider
implements FileIconProvider {
    @Nullable
    public Icon getIcon(@NotNull VirtualFile file, int flags, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof MemoryViewFile)) {
            return null;
        }
        CidrMemoryDoc<?> cidrMemoryDoc = ((MemoryViewFile)file).getMemoryDoc();
        if (cidrMemoryDoc == null) {
            return null;
        }
        CidrMemoryDoc<?> memoryDoc = cidrMemoryDoc;
        Icon icon = ((MemoryViewFile)file).getFileType().getIcon();
        CidrMemoryData.DataProvider<?> dataProvider = memoryDoc.getDataProvider();
        MemoryLiveExecutionAware memoryLiveExecutionAware = dataProvider instanceof MemoryLiveExecutionAware ? (MemoryLiveExecutionAware)((Object)dataProvider) : null;
        if (memoryLiveExecutionAware == null) {
            return icon;
        }
        MemoryLiveExecutionAware liveExecutionAware = memoryLiveExecutionAware;
        if (!liveExecutionAware.isLiveExecutionData()) {
            return icon;
        }
        return ExecutionUtil.getLiveIndicator((Icon)icon, (boolean)liveExecutionAware.isExecutionAlive());
    }
}

