/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ValueRendererUtils {
    public static boolean isQuotedString(@NotNull String s) {
        if (s == null) {
            ValueRendererUtils.$$$reportNull$$$0(0);
        }
        return ValueRendererUtils.isBeginQuotedString(s) && s.charAt(s.length() - 1) == '\"';
    }

    private static int skipMark(@NotNull String text, int textLength, int startIndex) {
        char next;
        if (text == null) {
            ValueRendererUtils.$$$reportNull$$$0(1);
        }
        if (startIndex + 2 <= textLength && text.charAt(startIndex) == '\u00fe' && ((next = text.charAt(startIndex + 1)) == 'S' || next == 'K' || next == 'N' || next == 'C' || next == 'V' || next == 'E')) {
            startIndex += 2;
        }
        return startIndex;
    }

    public static boolean isBeginQuotedString(@NotNull String s) {
        int stringLen;
        if (s == null) {
            ValueRendererUtils.$$$reportNull$$$0(2);
        }
        if ((stringLen = s.length()) <= 1) {
            return false;
        }
        int start = 0;
        if ((start = ValueRendererUtils.skipMark(s, stringLen, start)) + 1 < stringLen && s.charAt(start) == '0' && s.charAt(start + 1) == 'x') {
            start += 2;
            while (start < stringLen && StringUtil.isHexDigit((char)s.charAt(start))) {
                ++start;
            }
            if ((start = ValueRendererUtils.skipMark(s, stringLen, start)) >= stringLen || s.charAt(start) != ' ') {
                return false;
            }
            ++start;
        }
        if ((start = ValueRendererUtils.skipMark(s, stringLen, start)) < stringLen && (s.charAt(start) == 'L' || s.charAt(start) == 'U' || s.charAt(start) == 'u')) {
            ++start;
        }
        return start + 1 < stringLen && s.charAt(start) == '\"';
    }

    @NotNull
    public static String getRawString(@NotNull String s) {
        int stringLen;
        if (s == null) {
            ValueRendererUtils.$$$reportNull$$$0(3);
        }
        if ((stringLen = s.length()) >= 2) {
            char ch0;
            int start = 0;
            if (s.charAt(start) == '0' && s.charAt(start + 1) == 'x') {
                start += 2;
                while (start < s.length() && StringUtil.isHexDigit((char)s.charAt(start))) {
                    ++start;
                }
                if (s.charAt(start) == ' ') {
                    ++start;
                } else {
                    String string = StringUtil.unescapeStringCharacters((String)s);
                    if (string == null) {
                        ValueRendererUtils.$$$reportNull$$$0(4);
                    }
                    return string;
                }
            }
            if ((ch0 = s.charAt(start)) == '\"') {
                ++start;
            } else if (start + 2 < stringLen && (ch0 == 'L' || ch0 == 'U' || ch0 == 'u') && s.charAt(start + 1) == '\"') {
                start += 2;
            } else {
                String string = StringUtil.unescapeStringCharacters((String)s);
                if (string == null) {
                    ValueRendererUtils.$$$reportNull$$$0(5);
                }
                return string;
            }
            if (s.endsWith("\"")) {
                s = s.substring(start, stringLen - 1);
            } else if (s.endsWith("\u2026")) {
                char ch = s.charAt(stringLen - 2);
                s = ch == '\"' ? s.substring(start, stringLen - 2) : s.substring(start, stringLen - 1);
            } else if (s.endsWith("...") && stringLen >= start + 4) {
                char ch = s.charAt(stringLen - 4);
                s = ch == '\"' ? s.substring(start, stringLen - 4) : s.substring(start, stringLen - 3);
            }
        }
        String string = s = StringUtil.unescapeStringCharacters((String)s);
        if (string == null) {
            ValueRendererUtils.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String extractString(@NotNull String formattedText) {
        if (formattedText == null) {
            ValueRendererUtils.$$$reportNull$$$0(7);
        }
        StringBuilder result = new StringBuilder();
        int length = formattedText.length();
        int index = 0;
        while ((index = ValueRendererUtils.skipMark(formattedText, length, index)) < length) {
            char ch = formattedText.charAt(index);
            result.append(ch);
            ++index;
        }
        String string = result.toString();
        if (string == null) {
            ValueRendererUtils.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String shortenTemplateType(@NotNull String type) {
        if (type == null) {
            ValueRendererUtils.$$$reportNull$$$0(9);
        }
        return ValueRendererUtils.shortenTemplateType(type, 1);
    }

    @NotNull
    public static String shortenTemplateType(@NotNull String type, int templateTypeReduceLevel) {
        if (type == null) {
            ValueRendererUtils.$$$reportNull$$$0(10);
        }
        StringBuilder result = new StringBuilder();
        int count = 0;
        for (int i = 0; i < type.length(); ++i) {
            char c = type.charAt(i);
            if (c == '<') {
                ++count;
            }
            if (count <= templateTypeReduceLevel) {
                int length = result.length();
                if (c == '>' && length > 2 && result.charAt(length - 1) == ' ' && result.charAt(length - 2) != '>') {
                    result.setLength(length - 1);
                }
                result.append(c);
            }
            if (c != '>') continue;
            --count;
        }
        String string = count == 0 ? result.toString() : type;
        if (string == null) {
            ValueRendererUtils.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public static String extractRichValueStringContent(@NotNull String richValue) {
        if (richValue == null) {
            ValueRendererUtils.$$$reportNull$$$0(12);
        }
        int idx = 0;
        String stringContent = null;
        while (idx < richValue.length()) {
            char c = richValue.charAt(idx);
            if (c == '\u00fe') {
                RichValueToken token = ValueRendererUtils.readRichValueToken(richValue, idx);
                if (token == null) {
                    return null;
                }
                if (token.tokenType == 'C') {
                    idx = token.endIndex;
                    continue;
                }
                if (token.tokenType == 'S') {
                    if (stringContent != null) {
                        return null;
                    }
                    String tokenText = token.tokenContent;
                    String noPrefix = ValueRendererUtils.trimStringPrefix(tokenText);
                    if (!noPrefix.startsWith("\"")) {
                        return null;
                    }
                    stringContent = StringUtil.trimEnd((String)noPrefix.substring(1), (String)"\"");
                    idx = token.endIndex;
                    continue;
                }
                return null;
            }
            if (StringUtil.isWhiteSpace((char)c)) {
                ++idx;
                continue;
            }
            return null;
        }
        return stringContent;
    }

    @NotNull
    public static String trimStringPrefix(@NotNull String s) {
        if (s == null) {
            ValueRendererUtils.$$$reportNull$$$0(13);
        }
        if (s.isEmpty()) {
            String string = s;
            if (string == null) {
                ValueRendererUtils.$$$reportNull$$$0(14);
            }
            return string;
        }
        char ch0 = s.charAt(0);
        if (ch0 == 'L' || ch0 == 'U') {
            String string = s.substring(1);
            if (string == null) {
                ValueRendererUtils.$$$reportNull$$$0(15);
            }
            return string;
        }
        if (ch0 == 'u') {
            if (s.length() > 1 && s.charAt(1) == '8') {
                String string = s.substring(2);
                if (string == null) {
                    ValueRendererUtils.$$$reportNull$$$0(16);
                }
                return string;
            }
            String string = s.substring(1);
            if (string == null) {
                ValueRendererUtils.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            ValueRendererUtils.$$$reportNull$$$0(18);
        }
        return string;
    }

    public static int getQuoteCount(@NotNull String s) {
        if (s == null) {
            ValueRendererUtils.$$$reportNull$$$0(19);
        }
        int quoteCount = 0;
        for (int idx = 0; idx < s.length(); ++idx) {
            char c = s.charAt(idx);
            if (c == '\"') {
                ++quoteCount;
                continue;
            }
            if (c != '\\') continue;
            ++idx;
        }
        return quoteCount;
    }

    @NotNull
    public static String unescapeForRichString(@NotNull String s) {
        if (s == null) {
            ValueRendererUtils.$$$reportNull$$$0(20);
        }
        String string = StringUtil.unescapeAnsiStringCharacters((String)s);
        if (string == null) {
            ValueRendererUtils.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Nullable
    public static RichValueToken readRichValueToken(@NotNull String richValue, int startMarkIndex) {
        if (richValue == null) {
            ValueRendererUtils.$$$reportNull$$$0(22);
        }
        if (richValue.charAt(startMarkIndex) != '\u00fe') {
            return null;
        }
        if (startMarkIndex + 1 > richValue.length() - 1) {
            return null;
        }
        char tokenType = richValue.charAt(startMarkIndex + 1);
        if (tokenType != 'S' && tokenType != 'K' && tokenType != 'N' && tokenType != 'C' && tokenType != 'V') {
            return null;
        }
        int contentStart = startMarkIndex + 2;
        int endMarkIndex = richValue.indexOf(254, contentStart);
        if (endMarkIndex < 0) {
            return null;
        }
        if (endMarkIndex + 1 > richValue.length() - 1) {
            return null;
        }
        if (richValue.charAt(endMarkIndex + 1) != 'E') {
            return null;
        }
        return new RichValueToken(startMarkIndex, endMarkIndex + 2, tokenType, richValue.substring(contentStart, endMarkIndex));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 8, 11, 14, 15, 16, 17, 18, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRendererUtils";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattedText";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "richValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRendererUtils";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawString";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "extractString";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenTemplateType";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "trimStringPrefix";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeForRichString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "skipMark";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isBeginQuotedString";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRawString";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractString";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shortenTemplateType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extractRichValueStringContent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "trimStringPrefix";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getQuoteCount";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "unescapeForRichString";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "readRichValueToken";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 8, 11, 14, 15, 16, 17, 18, 21 -> new IllegalStateException(string);
        };
    }

    public static class RichValueToken {
        public final int startIndex;
        public final int endIndex;
        public final char tokenType;
        public final String tokenContent;

        public RichValueToken(int startIndex, int endIndex, char tokenType, String tokenContent) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.tokenType = tokenType;
            this.tokenContent = tokenContent;
        }
    }
}

