/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrFormattedNumberValuePresentation;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrNumberValuePresentation;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrNumberWithAdditionalFormatValuePresentation;
import com.jetbrains.cidr.execution.debugger.evaluation.TextWithPattern;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.CidrHexdumpRegion;
import java.math.BigInteger;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001aD\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0001\u001a\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0001\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"POINTER_ATTRIBUTES_KEY", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Lorg/jetbrains/annotations/NotNull;", "unsignedHexNumberPattern", "Lkotlin/text/Regex;", "getUnsignedHexNumberPattern", "()Lkotlin/text/Regex;", "createHexValuePresentation", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrNumberValuePresentation;", "value", "", "type", "numberText", "stringText", "number", "Ljava/math/BigInteger;", "sizeBytes", "", "asSecondaryFormat", "", "formatHexValue", "intellij.cidr.debugger"})
public final class ValuePresentationKt {
    @NotNull
    private static final TextAttributesKey POINTER_ATTRIBUTES_KEY;
    @NotNull
    private static final Regex unsignedHexNumberPattern;

    @NotNull
    public static final Regex getUnsignedHexNumberPattern() {
        return unsignedHexNumberPattern;
    }

    @JvmOverloads
    @NotNull
    public static final CidrNumberValuePresentation createHexValuePresentation(@NotNull String value, @Nullable String type, @NotNull String numberText, @NotNull String stringText, @NotNull BigInteger number, int sizeBytes, boolean asSecondaryFormat) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)numberText, (String)"numberText");
        Intrinsics.checkNotNullParameter((Object)stringText, (String)"stringText");
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        TextWithPattern hexFormattedNumber = new TextWithPattern(ValuePresentationKt.formatHexValue(number, sizeBytes), unsignedHexNumberPattern);
        return asSecondaryFormat ? (CidrNumberValuePresentation)new CidrNumberWithAdditionalFormatValuePresentation(value, type, numberText, stringText, hexFormattedNumber) : (CidrNumberValuePresentation)new CidrFormattedNumberValuePresentation(value, type, hexFormattedNumber, stringText);
    }

    public static /* synthetic */ CidrNumberValuePresentation createHexValuePresentation$default(String string, String string2, String string3, String string4, BigInteger bigInteger, int n, boolean bl, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            bl = true;
        }
        return ValuePresentationKt.createHexValuePresentation(string, string2, string3, string4, bigInteger, n, bl);
    }

    @NlsSafe
    @NotNull
    public static final String formatHexValue(@NotNull BigInteger number, int sizeBytes) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        BigInteger bigInteger = BigInteger.ONE.shiftLeft(sizeBytes * 8);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"shiftLeft(...)");
        BigInteger bigInteger2 = bigInteger;
        BigInteger bigInteger3 = BigInteger.ONE;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"ONE");
        BigInteger bigInteger4 = bigInteger2.subtract(bigInteger3);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"subtract(...)");
        BigInteger mask = bigInteger4;
        BigInteger maskedNumber = number.and(mask);
        if (maskedNumber.equals(BigInteger.ZERO)) {
            return "0x0";
        }
        byte[] bytes = maskedNumber.toByteArray();
        Intrinsics.checkNotNull((Object)bytes);
        if (!(!(bytes.length == 0))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        byte b0 = bytes[0];
        String firstByteWithoutPadding = b0 == 0 ? "" : Integer.toUnsignedString(Byte.toUnsignedInt(b0), 16);
        List list = ArraysKt.drop((byte[])bytes, (int)1);
        String string = "0x" + firstByteWithoutPadding;
        return CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", (CharSequence)string, null, (int)0, null, ValuePresentationKt::formatHexValue$lambda$0, (int)28, null);
    }

    @JvmOverloads
    @NotNull
    public static final CidrNumberValuePresentation createHexValuePresentation(@NotNull String value, @Nullable String type, @NotNull String numberText, @NotNull String stringText, @NotNull BigInteger number, int sizeBytes) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)numberText, (String)"numberText");
        Intrinsics.checkNotNullParameter((Object)stringText, (String)"stringText");
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        return ValuePresentationKt.createHexValuePresentation$default(value, type, numberText, stringText, number, sizeBytes, false, 64, null);
    }

    private static final CharSequence formatHexValue$lambda$0(byte it) {
        return CidrHexdumpRegion.Companion.toUnsignedHexString(it);
    }

    public static final /* synthetic */ TextAttributesKey access$getPOINTER_ATTRIBUTES_KEY$p() {
        return POINTER_ATTRIBUTES_KEY;
    }

    static {
        TextAttributesKey textAttributesKey = TextAttributesKey.createTextAttributesKey((String)"DEBUGGER_MEMORY_ADDRESS", (TextAttributesKey)DefaultLanguageHighlighterColors.METADATA);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"createTextAttributesKey(...)");
        POINTER_ATTRIBUTES_KEY = textAttributesKey;
        unsignedHexNumberPattern = new Regex("^0x(\\p{XDigit}+)$");
    }
}

