/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Pair;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueModifier;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrEvaluatorHelper;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import org.jetbrains.annotations.NotNull;

public class CidrValueModifier
extends XValueModifier {
    @NotNull
    private final CidrPhysicalValue myValue;

    public CidrValueModifier(@NotNull CidrPhysicalValue value) {
        if (value == null) {
            CidrValueModifier.$$$reportNull$$$0(0);
        }
        this.myValue = value;
    }

    public void setValue(@NotNull XExpression expr, @NotNull XValueModifier.XModificationCallback callback) {
        if (expr == null) {
            CidrValueModifier.$$$reportNull$$$0(1);
        }
        if (callback == null) {
            CidrValueModifier.$$$reportNull$$$0(2);
        }
        this.myValue.getProcess().postCommand(driver -> {
            try {
                CidrStackFrame frame = this.myValue.getFrame();
                Pair<LLValue, String> valuePair = CidrEvaluatorHelper.getInstance().convertAndEvaluate(frame.getProcess(), driver, expr, frame.getSourcePosition(), frame.getThreadId(), frame.getFrameIndex());
                this.setValue(expr.getExpression(), valuePair, callback, driver);
            }
            catch (DebuggerCommandException e) {
                callback.errorOccurred(CidrDebuggerBundle.message("debug.assign.error.cannotAssignExpression", expr.getExpression(), this.myValue.getName()) + ":\n" + e.getMessage());
                CidrDebuggerLog.LOG.info(e.getMessage());
            }
        });
    }

    @NotNull
    public CidrPhysicalValue getValue() {
        CidrPhysicalValue cidrPhysicalValue = this.myValue;
        if (cidrPhysicalValue == null) {
            CidrValueModifier.$$$reportNull$$$0(3);
        }
        return cidrPhysicalValue;
    }

    protected void setValue(final @NotNull String origExpr, @NotNull Pair<LLValue, String> valuePair, final @NotNull XValueModifier.XModificationCallback callback, @NotNull DebuggerDriver driver) throws ExecutionException, DebuggerCommandException {
        if (origExpr == null) {
            CidrValueModifier.$$$reportNull$$$0(4);
        }
        if (valuePair == null) {
            CidrValueModifier.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            CidrValueModifier.$$$reportNull$$$0(6);
        }
        if (driver == null) {
            CidrValueModifier.$$$reportNull$$$0(7);
        }
        EvaluationContext context = this.myValue.createEvaluationContext(driver, null);
        final String qualName = this.myValue.getEvaluationExpression(true);
        String lValueStr = context.convertToLValue(qualName);
        CidrEvaluator evaluator = this.myValue.getFrame().getEvaluator();
        if (evaluator == null) {
            callback.errorOccurred(CidrDebuggerBundle.message("debug.assign.error.cannotAssignExpression", origExpr, qualName));
            CidrDebuggerLog.LOG.info(this.myValue.getFrame().toString() + " has null evaluator");
            return;
        }
        String rValueStr = context.convertToRValue(this.myValue.getVarData(context), valuePair);
        evaluator.evaluate(lValueStr + "=" + rValueStr, new XDebuggerEvaluator.XEvaluationCallback(){

            public void evaluated(@NotNull XValue result) {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                callback.valueModified();
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(1);
                }
                callback.errorOccurred(CidrDebuggerBundle.message("debug.assign.error.cannotAssignExpression", origExpr, qualName) + ":\n" + errorMessage);
                CidrDebuggerLog.LOG.info(errorMessage);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrValueModifier$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "evaluated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this.myValue.getFrame().getSourcePosition());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrValueModifier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origExpr";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuePair";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrValueModifier";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

