/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb.formatters;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.system.OS;
import com.intellij.xdebugger.XDebugSessionListener;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessConfigurator;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.formatters.LLDBNatvisDiagnosticsLevel;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.formatters.natvis.NatvisFileProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0002\b\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/lldb/formatters/LLDBNatvisSupport;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcessConfigurator;", "<init>", "()V", "configure", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "Companion", "HexBackendStateManager", "intellij.cidr.debugger"})
@SourceDebugExtension(value={"SMAP\nLLDBNatvisSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLDBNatvisSupport.kt\ncom/jetbrains/cidr/execution/debugger/backend/lldb/formatters/LLDBNatvisSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1368#2:116\n1454#2,5:117\n*S KotlinDebug\n*F\n+ 1 LLDBNatvisSupport.kt\ncom/jetbrains/cidr/execution/debugger/backend/lldb/formatters/LLDBNatvisSupport\n*L\n68#1:116\n68#1:117,5\n*E\n"})
public final class LLDBNatvisSupport
implements CidrDebugProcessConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void configure(@NotNull CidrDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        DebuggerDriverConfiguration debuggerDriverConfiguration = process.getRunParameters().getDebuggerDriverConfiguration();
        LLDBDriverConfiguration lLDBDriverConfiguration = debuggerDriverConfiguration instanceof LLDBDriverConfiguration ? (LLDBDriverConfiguration)debuggerDriverConfiguration : null;
        if (lLDBDriverConfiguration == null) {
            return;
        }
        LLDBDriverConfiguration driverConfiguration = lLDBDriverConfiguration;
        if (driverConfiguration.getHostMachine().getOS() != OS.Windows) {
            return;
        }
        CidrDebuggerSettings cidrDebuggerSettings = CidrDebuggerSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)cidrDebuggerSettings), (String)"getInstance(...)");
        CidrDebuggerSettings settings = cidrDebuggerSettings;
        if (!settings.isLLDBNatvisRenderersEnabled()) {
            return;
        }
        process.putUserData(CidrPhysicalValue.DO_NOT_SHOW_ADDRESSES, true);
        process.putUserData(CidrPhysicalValue.THREAT_VALUE_AS_RICH_TEXT, true);
        LLDBNatvisDiagnosticsLevel diagnosticsLevel = settings.getLLDBNatvisDiagnosticsLevel();
        process.postCommand(arg_0 -> LLDBNatvisSupport.configure$lambda$0(diagnosticsLevel, arg_0));
        HexBackendStateManager hexStateManager = new HexBackendStateManager(process, settings);
        process.getSession().addSessionListener((XDebugSessionListener)hexStateManager, process.getProcessDisposable());
        process.setHexChangedHandler(hexStateManager);
        boolean globalHexEnabled = settings.isHexFormattingEnabled();
        boolean globalHexShowBoth = settings.isHexAsSecondaryFormattingEnabled();
        hexStateManager.sendSetRequest(globalHexEnabled, globalHexShowBoth);
        process.postCommand(arg_0 -> LLDBNatvisSupport.configure$lambda$3(process, arg_0));
    }

    private static final void configure$lambda$0(LLDBNatvisDiagnosticsLevel $diagnosticsLevel, DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNull((Object)((Object)$diagnosticsLevel));
        Companion.initializeNatvis(driver, $diagnosticsLevel);
    }

    /*
     * WARNING - void declaration
     */
    private static final List configure$lambda$3$lambda$2(CidrDebugProcess $process) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = NatvisFileProvider.Companion.getEP_NAME().getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            NatvisFileProvider it = (NatvisFileProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getNatvisPaths($process);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void configure$lambda$3(CidrDebugProcess $process, DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        List natvisPaths = (List)ApplicationManager.getApplication().runReadAction(() -> LLDBNatvisSupport.configure$lambda$3$lambda$2($process));
        Intrinsics.checkNotNull((Object)natvisPaths);
        Companion.loadNatvisFiles(driver, natvisPaths);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u001c\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/lldb/formatters/LLDBNatvisSupport$Companion;", "", "<init>", "()V", "initializeNatvis", "", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "diagnosticsLevel", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/formatters/LLDBNatvisDiagnosticsLevel;", "setGlobalHex", "hexEnabled", "", "hexShowBoth", "loadNatvisFiles", "natvisFilesList", "", "", "intellij.cidr.debugger"})
    public static final class Companion {
        private Companion() {
        }

        public final void initializeNatvis(@NotNull DebuggerDriver driver, @NotNull LLDBNatvisDiagnosticsLevel diagnosticsLevel) {
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            Intrinsics.checkNotNullParameter((Object)((Object)diagnosticsLevel), (String)"diagnosticsLevel");
            driver.executeInterpreterCommand(-1L, -1, "command script import renderers.jb_lldb_logging_manager");
            driver.executeInterpreterCommand(-1L, -1, "jb_renderers_set_diagnostics_level " + diagnosticsLevel.getLevel());
            driver.executeInterpreterCommand(-1L, -1, "command script import renderers.jb_lldb_declarative_formatters");
            driver.executeInterpreterCommand(-1L, -1, "jb_renderers_loaders_add natvis renderers.jb_lldb_natvis_loader natvis_loader");
        }

        public final void setGlobalHex(@NotNull DebuggerDriver driver, boolean hexEnabled, boolean hexShowBoth) {
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            int globalHexEnabled = hexEnabled ? 1 : 0;
            int globalHexShowBoth = hexShowBoth ? 1 : 0;
            driver.executeInterpreterCommand(-1L, -1, "jb_renderers_set_global_hex " + globalHexEnabled + " " + globalHexShowBoth);
            driver.executeInterpreterCommand(-1L, -1, "script");
        }

        public final void loadNatvisFiles(@NotNull DebuggerDriver driver, @NotNull List<String> natvisFilesList) {
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            Intrinsics.checkNotNullParameter(natvisFilesList, (String)"natvisFilesList");
            if (natvisFilesList.isEmpty()) {
                return;
            }
            ((LLDBDriver)driver).getNatvisLoader().loadNatvisFiles(driver, natvisFilesList);
            ((LLDBDriver)driver).setNatvisEnabled(true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0002J\u0016\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/lldb/formatters/LLDBNatvisSupport$HexBackendStateManager;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess$HexChangedHandler;", "Lcom/intellij/xdebugger/XDebugSessionListener;", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "settings", "Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerSettings;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerSettings;)V", "lastAppliedValueHex", "", "lastAppliedValueHexSecondary", "handleHexChanged", "", "sessionPaused", "synchronizeState", "sendSetRequest", "hexEnabled", "hexShowBoth", "intellij.cidr.debugger"})
    private static final class HexBackendStateManager
    implements CidrDebugProcess.HexChangedHandler,
    XDebugSessionListener {
        @NotNull
        private final CidrDebugProcess process;
        @NotNull
        private final CidrDebuggerSettings settings;
        private volatile boolean lastAppliedValueHex;
        private volatile boolean lastAppliedValueHexSecondary;

        public HexBackendStateManager(@NotNull CidrDebugProcess process, @NotNull CidrDebuggerSettings settings) {
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
            this.process = process;
            this.settings = settings;
        }

        @Override
        public void handleHexChanged() {
            this.synchronizeState();
        }

        public void sessionPaused() {
            this.synchronizeState();
        }

        private final void synchronizeState() {
            boolean lastAppliedHex = this.lastAppliedValueHex;
            boolean lastAppliedHexSecondary = this.lastAppliedValueHexSecondary;
            boolean globalHexEnabled = this.settings.isHexFormattingEnabled();
            boolean globalHexShowBoth = this.settings.isHexAsSecondaryFormattingEnabled();
            if (lastAppliedHex != globalHexEnabled || lastAppliedHexSecondary != globalHexShowBoth) {
                this.sendSetRequest(globalHexEnabled, globalHexShowBoth);
            }
        }

        public final void sendSetRequest(boolean hexEnabled, boolean hexShowBoth) {
            this.process.postCommand(arg_0 -> HexBackendStateManager.sendSetRequest$lambda$0(hexEnabled, hexShowBoth, arg_0)).thenAccept(arg_0 -> HexBackendStateManager.sendSetRequest$lambda$3(arg_0 -> HexBackendStateManager.sendSetRequest$lambda$2(this, hexEnabled, hexShowBoth, arg_0), arg_0));
        }

        private static final void sendSetRequest$lambda$0(boolean $hexEnabled, boolean $hexShowBoth, DebuggerDriver driver) {
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            Companion.setGlobalHex(driver, $hexEnabled, $hexShowBoth);
        }

        private static final void sendSetRequest$lambda$2$lambda$1(HexBackendStateManager this$0) {
            this$0.process.getSession().rebuildViews();
        }

        private static final Unit sendSetRequest$lambda$2(HexBackendStateManager this$0, boolean $hexEnabled, boolean $hexShowBoth, Void it) {
            this$0.lastAppliedValueHex = $hexEnabled;
            this$0.lastAppliedValueHexSecondary = $hexShowBoth;
            ApplicationManager.getApplication().invokeLater(() -> HexBackendStateManager.sendSetRequest$lambda$2$lambda$1(this$0));
            return Unit.INSTANCE;
        }

        private static final void sendSetRequest$lambda$3(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }
    }
}

