/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.jetbrains.cidr.execution.debugger.backend.lldb.DebuggerCommandContext;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Model;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Protocol;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProtobufMessageFactory {
    private ProtobufMessageFactory() {
    }

    public static Protocol.CompositeRequest getChildrenCount(int id) {
        return Protocol.CompositeRequest.newBuilder().setGetChildrenCount(Protocol.GetChildrenCount_Req.newBuilder().setId(id)).build();
    }

    public static Message kill() {
        return Protocol.CompositeRequest.newBuilder().setKill(Protocol.Kill_Req.newBuilder()).build();
    }

    public static Protocol.CompositeRequest detach() {
        return Protocol.CompositeRequest.newBuilder().setDetach(Protocol.Detach_Req.newBuilder()).build();
    }

    public static Protocol.CompositeRequest attach(int pid, boolean implicitContinue) {
        return Protocol.CompositeRequest.newBuilder().setAttach(ProtobufMessageFactory.newAttachBuilder(pid, implicitContinue)).build();
    }

    public static Protocol.CompositeRequest remoteAttach(int pid, @NotNull String fdPassingServiceUnixSocket, boolean implicitContinue) {
        if (fdPassingServiceUnixSocket == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(0);
        }
        Protocol.Attach_Req.Builder builder = ProtobufMessageFactory.newAttachBuilder(pid, implicitContinue).setFdPassingServiceUnixSocket(fdPassingServiceUnixSocket);
        return Protocol.CompositeRequest.newBuilder().setAttach(builder).build();
    }

    private static Protocol.Attach_Req.Builder newAttachBuilder(int pid, boolean implicitContinue) {
        return Protocol.Attach_Req.newBuilder().setPid(pid).setImplicitContinue(implicitContinue);
    }

    public static Message attachByName(String name, boolean wait, boolean implicitContinue) {
        return Protocol.CompositeRequest.newBuilder().setAttachByName(Protocol.AttachByName_Req.newBuilder().setName(name).setImplicitContinue(implicitContinue).setToWait(wait)).build();
    }

    public static Protocol.CompositeRequest remoteLaunch(@NotNull String localPath, @NotNull GeneralCommandLine targetCommandLine, @NotNull String socket) {
        if (localPath == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(1);
        }
        if (targetCommandLine == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(2);
        }
        if (socket == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(3);
        }
        Protocol.RemoteLaunch_Req.Builder launchBuilder = ProtobufMessageFactory.createRemoteLaunchBuilder(localPath, targetCommandLine, socket);
        Protocol.CompositeRequest.Builder result = Protocol.CompositeRequest.newBuilder();
        result.setRemoteLaunch(launchBuilder);
        return result.build();
    }

    @NotNull
    public static Protocol.CompositeRequest createRemoteTarget(@NotNull String exePath, @Nullable String arch, @NotNull String platform, @Nullable String platformSdkRoot, @NotNull String remoteExePath) {
        if (exePath == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(4);
        }
        if (platform == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(5);
        }
        if (remoteExePath == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(6);
        }
        Protocol.CreateTarget_Req.Builder builder = Protocol.CreateTarget_Req.newBuilder().setExePath(exePath).setPlatform(platform).setRemoteExePath(remoteExePath);
        if (arch != null) {
            builder.setArch(arch);
        }
        if (platformSdkRoot != null) {
            builder.setPlatformSdkRoot(platformSdkRoot);
        }
        Protocol.CompositeRequest compositeRequest = Protocol.CompositeRequest.newBuilder().setCreateTarget(builder.build()).build();
        if (compositeRequest == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(7);
        }
        return compositeRequest;
    }

    @NotNull
    public static Protocol.CompositeRequest createRemoteTarget(@NotNull String exePath, @NotNull String platform, @NotNull String remoteExePath) {
        if (exePath == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(8);
        }
        if (platform == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(9);
        }
        if (remoteExePath == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(10);
        }
        return ProtobufMessageFactory.createRemoteTarget(exePath, null, platform, null, remoteExePath);
    }

    public static Protocol.CompositeRequest suspend() {
        Protocol.Suspend_Req.Builder builder = Protocol.Suspend_Req.newBuilder();
        return Protocol.CompositeRequest.newBuilder().setSuspend(builder).build();
    }

    public static Protocol.CompositeRequest removeBreakpoint(int id) {
        Protocol.RemoveBreakpoint_Req.Builder builder = Protocol.RemoveBreakpoint_Req.newBuilder().setId(id);
        return Protocol.CompositeRequest.newBuilder().setRemoveBreakpoint(builder).build();
    }

    public static Protocol.CompositeRequest removeWatchpoint(int id) {
        Protocol.RemoveWatchpoint_Req.Builder builder = Protocol.RemoveWatchpoint_Req.newBuilder().setId(id);
        return Protocol.CompositeRequest.newBuilder().setRemoveWatchpoint(builder).build();
    }

    public static Protocol.CompositeRequest addBreakpoint(String path, int line, boolean ignoreSourceHash, @Nullable String condition) {
        Protocol.AddBreakpoint_Req.Builder builder = Protocol.AddBreakpoint_Req.newBuilder().setFile(path).setLine(line).setIgnoreSourceHash(ignoreSourceHash);
        if (condition != null) {
            builder.setCondition(condition);
        }
        return Protocol.CompositeRequest.newBuilder().setAddBreakpoint(builder).build();
    }

    public static Protocol.CompositeRequest addBreakpoint(long addressULong, @Nullable String condition) {
        Protocol.AddBreakpoint_Req.Builder builder = Protocol.AddBreakpoint_Req.newBuilder().setAddress(addressULong);
        if (condition != null) {
            builder.setCondition(condition);
        }
        return Protocol.CompositeRequest.newBuilder().setAddBreakpoint(builder).build();
    }

    @NotNull
    public static Protocol.CompositeRequest addBreakpoint(@NotNull String pattern, boolean regExpPattern, @Nullable String module, @Nullable String condition, long threadId) {
        if (pattern == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(11);
        }
        Protocol.AddBreakpoint_Req.Builder builder = Protocol.AddBreakpoint_Req.newBuilder().setSymbolPattern(pattern);
        builder.setRegexp(regExpPattern);
        builder.setThreadId((int)threadId);
        if (module != null) {
            builder.setModuleName(module);
        }
        if (condition != null) {
            builder.setCondition(condition);
        }
        Protocol.CompositeRequest compositeRequest = Protocol.CompositeRequest.newBuilder().setAddBreakpoint(builder).build();
        if (compositeRequest == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(12);
        }
        return compositeRequest;
    }

    public static Protocol.CompositeRequest getThreads() {
        return Protocol.CompositeRequest.newBuilder().setGetThreads(Protocol.GetThreads_Req.newBuilder()).build();
    }

    public static Protocol.CompositeRequest getFrames(long threadId, int from, int count, boolean untilFirstLineWithCode) {
        return Protocol.CompositeRequest.newBuilder().setGetFrames(Protocol.GetFrames_Req.newBuilder().setThreadId((int)threadId).setFromIndex(from).setCount(count).setUntilValidLineEntry(untilFirstLineWithCode)).build();
    }

    public static Protocol.CompositeRequest exit() {
        return Protocol.CompositeRequest.newBuilder().setExit(Protocol.Exit_Req.newBuilder()).build();
    }

    public static Protocol.CompositeRequest launch(GeneralCommandLine targetCommandLine, boolean useExternalConsole, boolean usePseudoConsole, @Nullable String stdinPath, @Nullable String stdoutPath, @Nullable String stderrPath) {
        Protocol.CompositeRequest.Builder result = Protocol.CompositeRequest.newBuilder();
        Model.ConsoleOptions consoleOptions = usePseudoConsole ? Model.ConsoleOptions.LaunchInPseudoConsole : (useExternalConsole ? Model.ConsoleOptions.LaunchInExternalConsole : Model.ConsoleOptions.LaunchInParentConsole);
        Protocol.Launch_Req.Builder launchBuilder = ProtobufMessageFactory.createLaunchBuilder(targetCommandLine.getExePath(), targetCommandLine, consoleOptions, stdinPath, stdoutPath, stderrPath);
        result.setLaunch(launchBuilder);
        return result.build();
    }

    private static Model.CommandLine.Builder createCommandLineBuilder(@NotNull String localPath, @NotNull GeneralCommandLine targetCommandLine) {
        if (localPath == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(13);
        }
        if (targetCommandLine == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(14);
        }
        Model.CommandLine.Builder cl = Model.CommandLine.newBuilder();
        cl.setExePath(localPath);
        Path workDirectory = targetCommandLine.getWorkingDirectory();
        if (workDirectory == null) {
            workDirectory = Path.of(localPath, new String[0]).getParent();
        }
        cl.setWorkingDir(workDirectory.normalize().toString());
        Map envParams = targetCommandLine.getEffectiveEnvironment();
        for (String env : envParams.keySet()) {
            cl.addEnv(Model.EnvParam.newBuilder().setName(env).setValue((String)envParams.get(env)));
        }
        for (String param : targetCommandLine.getParametersList().getArray()) {
            cl.addParam(param);
        }
        return cl;
    }

    private static Protocol.Launch_Req.Builder createLaunchBuilder(@NotNull String localPath, @NotNull GeneralCommandLine targetCommandLine, @NotNull Model.ConsoleOptions consoleOptions, @Nullable String stdinPath, @Nullable String stdoutPath, @Nullable String stderrPath) {
        if (localPath == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(15);
        }
        if (targetCommandLine == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(16);
        }
        if (consoleOptions == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(17);
        }
        Model.CommandLine.Builder cl = ProtobufMessageFactory.createCommandLineBuilder(localPath, targetCommandLine);
        if (stdinPath != null) {
            cl.setStdinPath(stdinPath);
        }
        if (stdoutPath != null) {
            cl.setStdoutPath(stdoutPath);
        }
        if (stderrPath != null) {
            cl.setStderrPath(stderrPath);
        }
        return Protocol.Launch_Req.newBuilder().setCommandLine(cl).setConsoleOptions(consoleOptions);
    }

    private static Protocol.RemoteLaunch_Req.Builder createRemoteLaunchBuilder(@NotNull String localPath, @NotNull GeneralCommandLine targetCommandLine, @NotNull String socket) {
        if (localPath == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(18);
        }
        if (targetCommandLine == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(19);
        }
        if (socket == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(20);
        }
        Model.CommandLine.Builder cl = ProtobufMessageFactory.createCommandLineBuilder(localPath, targetCommandLine);
        return Protocol.RemoteLaunch_Req.newBuilder().setCommandLine(cl).setFdPassingServiceUnixSocket(socket);
    }

    public static Protocol.CompositeRequest createTarget(String exePath, String arch) {
        Protocol.CreateTarget_Req.Builder builder = Protocol.CreateTarget_Req.newBuilder().setArch(arch).setExePath(exePath);
        return Protocol.CompositeRequest.newBuilder().setCreateTarget(builder.build()).build();
    }

    public static Protocol.CompositeRequest connectPlatform(String platform, String url) {
        Protocol.ConnectPlatform_Req.Builder builder = Protocol.ConnectPlatform_Req.newBuilder().setPlatform(platform).setUrl(url);
        return Protocol.CompositeRequest.newBuilder().setConnectPlatform(builder.build()).build();
    }

    public static Protocol.CompositeRequest connectProcess(String url, String plugin, boolean implicitContinue) {
        Protocol.ConnectProcess_Req.Builder builder = Protocol.ConnectProcess_Req.newBuilder().setUrl(url).setImplicitContinue(implicitContinue);
        if (plugin != null) {
            builder.setPlugin(plugin);
        }
        return Protocol.CompositeRequest.newBuilder().setConnectProcess(builder.build()).build();
    }

    public static Protocol.CompositeRequest executeShellCommand(String command, String workingDir, int timeoutSecs) {
        Protocol.ExecuteShellCommand_Req.Builder builder = Protocol.ExecuteShellCommand_Req.newBuilder().setCommand(command).setTimeoutSecs(timeoutSecs);
        if (workingDir != null) {
            builder.setWorkingDir(workingDir);
        }
        return Protocol.CompositeRequest.newBuilder().setExecuteShellCommand(builder.build()).build();
    }

    public static Protocol.CompositeRequest resume() {
        return Protocol.CompositeRequest.newBuilder().setContinue(Protocol.Continue_Req.newBuilder()).build();
    }

    public static Protocol.CompositeRequest stepInto(long threadId, boolean stepByInstruction) {
        return Protocol.CompositeRequest.newBuilder().setStepInto(Protocol.StepInto_Req.newBuilder().setThreadId((int)threadId).setStepInstruction(stepByInstruction)).build();
    }

    public static Protocol.CompositeRequest stepOut(long threadId) {
        return Protocol.CompositeRequest.newBuilder().setStepOut(Protocol.StepOut_Req.newBuilder().setThreadId((int)threadId)).build();
    }

    public static Protocol.CompositeRequest stepOver(long threadId, boolean stepByInstruction) {
        return Protocol.CompositeRequest.newBuilder().setStepOver(Protocol.StepOver_Req.newBuilder().setThreadId((int)threadId).setStepInstruction(stepByInstruction)).build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static Protocol.CompositeRequest stepScripted(long threadId, @NotNull String string) {
        void className;
        if (string == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(21);
        }
        Protocol.CompositeRequest compositeRequest = Protocol.CompositeRequest.newBuilder().setStepScripted(Protocol.StepScripted_Req.newBuilder().setStepClassName((String)className).setThreadId((int)threadId)).build();
        if (compositeRequest == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(22);
        }
        return compositeRequest;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static Protocol.CompositeRequest jumpToLine(long threadId, @NotNull String filePath, int line, boolean bl) {
        void can_leave_function;
        if (filePath == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(23);
        }
        Protocol.CompositeRequest compositeRequest = Protocol.CompositeRequest.newBuilder().setJumpToLine(Protocol.JumpToLine_Req.newBuilder().setFile(filePath).setLine(line).setCanLeaveFunction((boolean)can_leave_function).setThreadId((int)threadId)).build();
        if (compositeRequest == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(24);
        }
        return compositeRequest;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static Protocol.CompositeRequest jumpToAddress(long threadId, @NotNull Long addr, boolean bl) {
        void can_leave_function;
        if (addr == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(25);
        }
        Protocol.CompositeRequest compositeRequest = Protocol.CompositeRequest.newBuilder().setJumpToAddress(Protocol.JumpToAddress_Req.newBuilder().setAddr(addr).setCanLeaveFunction((boolean)can_leave_function).setThreadId((int)threadId)).build();
        if (compositeRequest == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(26);
        }
        return compositeRequest;
    }

    public static Protocol.CompositeRequest evaluateExpression(long threadId, int frameIndex, String expression, @Nullable Model.Language language) {
        Protocol.EvaluateExpression_Req.Builder expressionMsg = Protocol.EvaluateExpression_Req.newBuilder().setExpression(expression).setThreadId((int)threadId).setFrameIndex(frameIndex);
        if (language != null) {
            expressionMsg.setLanguage(language);
        }
        return Protocol.CompositeRequest.newBuilder().setEvaluateExpression(expressionMsg).build();
    }

    public static Protocol.CompositeRequest handleConsoleCommand(long threadId, int frameIndex, String command) {
        return Protocol.CompositeRequest.newBuilder().setHandleConsoleCommand(Protocol.HandleConsoleCommand_Req.newBuilder().setCommand(command).setThreadId((int)threadId).setFrameIndex(frameIndex)).build();
    }

    public static Protocol.CompositeRequest handleConsoleCommand(@NotNull DebuggerCommandContext commandContext, @NotNull String command) {
        if (commandContext == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(27);
        }
        if (command == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(28);
        }
        Protocol.HandleConsoleCommand_Req.Builder consoleCommandRequestBuilder = Protocol.HandleConsoleCommand_Req.newBuilder().setCommand(command);
        if (commandContext.getIgnoreExecutionContext()) {
            consoleCommandRequestBuilder.setIgnoreThreadContext(true);
        } else {
            consoleCommandRequestBuilder.setThreadId(commandContext.getThreadId()).setFrameIndex(commandContext.getFrameIndex());
        }
        return Protocol.CompositeRequest.newBuilder().setHandleConsoleCommand(consoleCommandRequestBuilder.build()).build();
    }

    public static Protocol.CompositeRequest dispatchInput(String input, Model.DispatchTarget target) {
        return Protocol.CompositeRequest.newBuilder().setDispatchInput(Protocol.DispatchInput_Req.newBuilder().setInput(input).setTarget(target)).build();
    }

    public static Protocol.CompositeRequest handleCompletion(String command, int pos) {
        return Protocol.CompositeRequest.newBuilder().setHandleCompletion(Protocol.HandleCompletion_Req.newBuilder().setCommand(command).setPos(pos)).build();
    }

    public static Protocol.CompositeRequest handleSignal(String signalName, boolean stop, boolean pass, boolean notify) {
        return Protocol.CompositeRequest.newBuilder().setHandleSignal(Protocol.HandleSignal_Req.newBuilder().setSignal(signalName).setStop(stop).setPass(pass).setNotify(notify)).build();
    }

    public static Protocol.CompositeRequest getValueChildren(int id, int offset, int count) {
        return Protocol.CompositeRequest.newBuilder().setGetValueChildren(Protocol.GetValueChildren_Req.newBuilder().setId(id).setOffset(offset).setCount(count)).build();
    }

    public static Protocol.CompositeRequest getValueData(int id, int maxDescriptionLength) {
        return Protocol.CompositeRequest.newBuilder().setGetValueData(Protocol.GetValueData_Req.newBuilder().setId(id).setMaxDescriptionLength(maxDescriptionLength)).build();
    }

    public static Protocol.CompositeRequest getValueDescription(int id, int maxLength) {
        return Protocol.CompositeRequest.newBuilder().setGetValueDescription(Protocol.GetValueDescription_Req.newBuilder().setId(id).setMaxLength(maxLength)).build();
    }

    public static Protocol.CompositeRequest arraySlice(int id, int offset, int count) {
        return Protocol.CompositeRequest.newBuilder().setGetArraySlice(Protocol.GetArraySlice_Req.newBuilder().setValueId(id).setOffset(offset).setCount(count)).build();
    }

    public static Protocol.CompositeRequest addWatchpoint(int id, @Nullable String condition, boolean read, boolean write, boolean resolveLocation) {
        Protocol.AddWatchpoint_Req.Builder builder = Protocol.AddWatchpoint_Req.newBuilder().setRead(read ? 1 : 0).setWrite(write ? 1 : 0).setToResolveLocation(resolveLocation ? 1 : 0).setValueId(id);
        if (condition != null) {
            builder.setCondition(condition);
        }
        return Protocol.CompositeRequest.newBuilder().setAddWatchpoint(builder).build();
    }

    public static Protocol.CompositeRequest getVars(long threadID, int frameIndex, boolean statics, boolean globals) {
        return Protocol.CompositeRequest.newBuilder().setGetVars(Protocol.GetVars_Req.newBuilder().setThreadId((int)threadID).setFrameIndex(frameIndex).setStatics(statics).setGlobals(globals)).build();
    }

    public static Protocol.CompositeRequest setValuesFilteringEnabled(boolean enabled) {
        return Protocol.CompositeRequest.newBuilder().setValuesFilteringPolicy(Protocol.ValuesFilteringPolicy_Req.newBuilder().setFilterEnabled(enabled ? 1 : 0)).build();
    }

    public static Protocol.CompositeRequest getValueAddress(int id) {
        return Protocol.CompositeRequest.newBuilder().setGetValueAddress(Protocol.GetValueAddress_Req.newBuilder().setId(id)).build();
    }

    public static Protocol.CompositeRequest disassemble(long start, long end) {
        return Protocol.CompositeRequest.newBuilder().setDisassemble(Protocol.Disassemble_Req.newBuilder().setStart(start).setEnd(end).build()).build();
    }

    public static Protocol.CompositeRequest disassembleUntilPivot(long start, long pivotAddr, int pivotInstrSize) {
        return Protocol.CompositeRequest.newBuilder().setDisassembleUntilPivot(Protocol.DisassembleUntilPivot_Req.newBuilder().setStart(start).setPivotAddr(pivotAddr).setPivotInstrSize(pivotInstrSize).build()).build();
    }

    public static Protocol.CompositeRequest dumpSections() {
        return Protocol.CompositeRequest.newBuilder().setDumpSections(Protocol.DumpSections_Req.newBuilder().build()).build();
    }

    public static Protocol.CompositeRequest dumpMemory(long start, long end) {
        return Protocol.CompositeRequest.newBuilder().setDumpMemory(Protocol.DumpMemory_Req.newBuilder().setStart(start).setEnd(end).build()).build();
    }

    public static Protocol.CompositeRequest contextInfo(long address, long rangeStart, long rangeEnd) {
        return Protocol.CompositeRequest.newBuilder().setContextInfo(Protocol.ContextInfo_Req.newBuilder().setAddr(address).setRangeStart(rangeStart).setRangeEnd(rangeEnd).build()).build();
    }

    public static Protocol.CompositeRequest loadCoreDump(String coreDump) {
        Protocol.LoadCore_Req.Builder builder = Protocol.LoadCore_Req.newBuilder().setCoreDumpPath(coreDump);
        return Protocol.CompositeRequest.newBuilder().setLoadCore(builder.build()).build();
    }

    public static Protocol.CompositeRequest cancelSymbolsDownload(@NotNull String details) {
        if (details == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(29);
        }
        Protocol.CancelSymbolsDownload_Req.Builder builder = Protocol.CancelSymbolsDownload_Req.newBuilder().setDetails(details);
        return Protocol.CompositeRequest.newBuilder().setCancelSymbolsDownload(builder.build()).build();
    }

    @NotNull
    public static Protocol.CompositeRequest freezeThread(long threadId) {
        Protocol.CompositeRequest compositeRequest = Protocol.CompositeRequest.newBuilder().setFreezeThread(Protocol.FreezeThread_Req.newBuilder().setThreadId((int)threadId)).build();
        if (compositeRequest == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(30);
        }
        return compositeRequest;
    }

    @NotNull
    public static Protocol.CompositeRequest unfreezeThread(long threadId) {
        Protocol.CompositeRequest compositeRequest = Protocol.CompositeRequest.newBuilder().setUnfreezeThread(Protocol.UnfreezeThread_Req.newBuilder().setThreadId((int)threadId)).build();
        if (compositeRequest == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(31);
        }
        return compositeRequest;
    }

    public static Protocol.CompositeRequest writeMemory(long address, byte[] bytes) {
        return Protocol.CompositeRequest.newBuilder().setWriteMemory(Protocol.WriteMemory_Req.newBuilder().setAddr(address).setData(ByteString.copyFrom((byte[])bytes))).build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static Protocol.CompositeRequest getRegisters(long threadId, int frameIndex, @NotNull Set<String> set) {
        void regNames;
        if (set == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(32);
        }
        Protocol.CompositeRequest compositeRequest = Protocol.CompositeRequest.newBuilder().setGetRegisters(Protocol.GetRegisters_Req.newBuilder().setThreadId((int)threadId).setFrameIndex(frameIndex).addAllRegisterNames((Iterable<String>)regNames)).build();
        if (compositeRequest == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(33);
        }
        return compositeRequest;
    }

    @NotNull
    public static Protocol.CompositeRequest getArch() {
        Protocol.CompositeRequest compositeRequest = Protocol.CompositeRequest.newBuilder().setGetArch(Protocol.GetArch_Req.newBuilder()).build();
        if (compositeRequest == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(34);
        }
        return compositeRequest;
    }

    @NotNull
    public static Protocol.CompositeRequest getRegisterSets() {
        Protocol.CompositeRequest compositeRequest = Protocol.CompositeRequest.newBuilder().setGetRegisterSets(Protocol.GetRegisterSets_Req.newBuilder()).build();
        if (compositeRequest == null) {
            ProtobufMessageFactory.$$$reportNull$$$0(35);
        }
        return compositeRequest;
    }

    public static Protocol.CompositeRequest resizeConsole(int columns, int rows) {
        return Protocol.CompositeRequest.newBuilder().setResizeConsole(Protocol.ResizeConsole_Req.newBuilder().setColumns(columns).setRows(rows)).build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 12, 22, 24, 26, 30, 31, 33, 34, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fdPassingServiceUnixSocket";
                break;
            }
            case 1: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 2: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetCommandLine";
                break;
            }
            case 3: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "socket";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteExePath";
                break;
            }
            case 7: 
            case 12: 
            case 22: 
            case 24: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/lldb/ProtobufMessageFactory";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleOptions";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addr";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandContext";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/lldb/ProtobufMessageFactory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoteTarget";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addBreakpoint";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "stepScripted";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "jumpToLine";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "jumpToAddress";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "freezeThread";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "unfreezeThread";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisters";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getArch";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisterSets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "remoteAttach";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "remoteLaunch";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteTarget";
                break;
            }
            case 7: 
            case 12: 
            case 22: 
            case 24: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addBreakpoint";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLineBuilder";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createLaunchBuilder";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteLaunchBuilder";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "stepScripted";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "jumpToLine";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "jumpToAddress";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "handleConsoleCommand";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "cancelSymbolsDownload";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getRegisters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 12, 22, 24, 26, 30, 31, 33, 34, 35 -> new IllegalStateException(string);
        };
    }
}

