/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0002R6\u0010\u0004\u001a*\u0012&\u0012$\u0012\u0004\u0012\u00020\u0007\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\t0\b0\u0006j\u0002`\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/lldb/LLDBErrorBeautifier;", "", "<init>", "()V", "myReplacers", "", "Lkotlin/Pair;", "Ljava/util/regex/Pattern;", "Lkotlin/Function2;", "", "Ljava/util/regex/Matcher;", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/Replacer;", "patchEvaluateMessage", "message", "patchLoadValueMessage", "errorMessage", "logPatchedMessage", "", "context", "newMessage", "intellij.cidr.debugger"})
public final class LLDBErrorBeautifier {
    @NotNull
    private final List<Pair<Pattern, Function2<String, Matcher, String>>> myReplacers;

    public LLDBErrorBeautifier() {
        List replacers = new ArrayList();
        Collection collection = replacers;
        Pattern pattern = Pattern.compile("^warning: Stopped in a C\\+\\+ method, but 'this' isn't available; pretending we are in a generic context\nerror:");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        Pair pair = new Pair((Object)pattern, LLDBErrorBeautifier::_init_$lambda$0);
        collection.add(pair);
        collection = replacers;
        Pattern pattern2 = Pattern.compile("^error: invalid use of 'this' outside of a non-static member function\\s*$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        pair = new Pair((Object)pattern2, LLDBErrorBeautifier::_init_$lambda$1);
        collection.add(pair);
        collection = replacers;
        Pattern pattern3 = Pattern.compile("^error: Couldn't materialize: couldn't get the value of variable (\\w+): variable not available");
        Intrinsics.checkNotNullExpressionValue((Object)pattern3, (String)"compile(...)");
        pair = new Pair((Object)pattern3, LLDBErrorBeautifier::_init_$lambda$2);
        collection.add(pair);
        collection = replacers;
        Pattern pattern4 = Pattern.compile("^error: no member named '(.+)' in '(.+)'\\s*$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern4, (String)"compile(...)");
        pair = new Pair((Object)pattern4, LLDBErrorBeautifier::_init_$lambda$3);
        collection.add(pair);
        collection = replacers;
        Pattern pattern5 = Pattern.compile("^error: use of undeclared identifier '(.+)'\\s*$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern5, (String)"compile(...)");
        pair = new Pair((Object)pattern5, LLDBErrorBeautifier::_init_$lambda$4);
        collection.add(pair);
        this.myReplacers = replacers;
    }

    @NotNull
    public final String patchEvaluateMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        for (Pair<Pattern, Function2<String, Matcher, String>> replacer : this.myReplacers) {
            Matcher matcher = ((Pattern)replacer.getFirst()).matcher(message);
            if (!matcher.find()) continue;
            Function2 function2 = (Function2)replacer.getSecond();
            Intrinsics.checkNotNull((Object)matcher);
            String newMessage = (String)function2.invoke((Object)message, (Object)matcher);
            this.logPatchedMessage("evaluation", message, newMessage);
            return newMessage;
        }
        return message;
    }

    @NotNull
    public final String patchLoadValueMessage(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        if (Intrinsics.areEqual((Object)errorMessage, (Object)"variable not available")) {
            return "Variable is not available";
        }
        return errorMessage;
    }

    private final void logPatchedMessage(String context, String message, String newMessage) {
        CidrDebuggerLog.LOG.debug("Masking " + context + " error message '" + message + "' as '" + newMessage + "'");
    }

    private static final String _init_$lambda$0(String string, Matcher matcher) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"<unused var>");
        return "'this' is not available, possibly due to compiler optimizations";
    }

    private static final String _init_$lambda$1(String string, Matcher matcher) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"<unused var>");
        return "'this' is not available outside of a non-static member function";
    }

    private static final String _init_$lambda$2(String string, Matcher matcher) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return "Variable '" + matcher.group(1) + "' is not available, possibly due to compiler optimizations";
    }

    private static final String _init_$lambda$3(String string, Matcher matcher) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return "Identifier '" + matcher.group(1) + "' is not available in '" + matcher.group(2) + "', possibly due to compiler optimizations";
    }

    private static final String _init_$lambda$4(String string, Matcher matcher) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        return "Identifier '" + matcher.group(1) + "' is not available, possibly due to compiler optimizations";
    }
}

