/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.CommonBundle;
import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUsagesCollector;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbIndexEntry;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbIndexStorage;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbIndexer;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbIndexerKt;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbIndexingSession;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbIndexingSessionFileStat;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbLoadedLibrariesStorage;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J6\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0082@\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010\u001fJ\u0012\u0010 \u001a\u0004\u0018\u00010\u000e2\u0006\u0010!\u001a\u00020\u0016H\u0002J\"\u0010\"\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbIndexer;", "", "parentScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "scope", "oldIndexCleanupRunning", "Ljava/util/concurrent/atomic/AtomicBoolean;", "libraryLoaded", "", "indexingSession", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbIndexingSession;", "libraryPath", "", "waitForCompletion", "scheduleIndexing", "project", "Lcom/intellij/openapi/project/Project;", "gdbExecutablePath", "gdbIndexDirPath", "executableToDebug", "Ljava/io/File;", "indexFile", "sessionId", "", "fileToIndex", "fileStat", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbIndexingSessionFileStat;", "(JLjava/lang/String;Ljava/lang/String;Ljava/io/File;Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbIndexingSessionFileStat;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cleanupOldIndexes", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readBuildId", "file", "createIndex", "dstDir", "Companion", "intellij.cidr.debugger"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGdbIndexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdbIndexer.kt\ncom/jetbrains/cidr/execution/debugger/backend/gdb/GdbIndexer\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,738:1\n31#2,2:739\n40#3,3:741\n1310#4,2:744\n*S KotlinDebug\n*F\n+ 1 GdbIndexer.kt\ncom/jetbrains/cidr/execution/debugger/backend/gdb/GdbIndexer\n*L\n195#1:739,2\n304#1:741,3\n457#1:744,2\n*E\n"})
public final class GdbIndexer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final AtomicBoolean oldIndexCleanupRunning;
    @NotNull
    private static final AtomicLong nextIndexingSessionId = new AtomicLong(0L);
    @NotNull
    private static final String BUILD_ID_PREFIX = "Build ID: ";

    public GdbIndexer(@NotNull CoroutineScope parentScope) {
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        this.scope = CoroutineScopeKt.childScope$default((CoroutineScope)parentScope, (String)"GdbIndexer", null, (boolean)true, (int)2, null);
        this.oldIndexCleanupRunning = new AtomicBoolean(false);
    }

    public final void libraryLoaded(@NotNull GdbIndexingSession indexingSession, @NotNull String libraryPath) {
        Intrinsics.checkNotNullParameter((Object)indexingSession, (String)"indexingSession");
        Intrinsics.checkNotNullParameter((Object)libraryPath, (String)"libraryPath");
        ComponentManager $this$service$iv = (ComponentManager)indexingSession.getProject();
        boolean $i$f$service = false;
        Class<GdbLoadedLibrariesStorage> serviceClass$iv = GdbLoadedLibrariesStorage.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((GdbLoadedLibrariesStorage)((Object)object)).addLibrary(indexingSession.getExecutable(), libraryPath);
    }

    public final void waitForCompletion(@NotNull GdbIndexingSession indexingSession) {
        Intrinsics.checkNotNullParameter((Object)indexingSession, (String)"indexingSession");
        Job indexingJob2 = indexingSession.getIndexingJob();
        long t0 = System.currentTimeMillis();
        BackgroundableProcessIndicator indicator = new BackgroundableProcessIndicator(indexingSession.getProject(), CidrDebuggerBundle.message("debug.gdb.preparingIndexesProgress", new Object[0]), CommonBundle.getCancelButtonText(), "", true);
        try {
            ProgressManager.getInstance().runProcess(() -> GdbIndexer.waitForCompletion$lambda$0(indexingJob2, t0, indexingSession), (ProgressIndicator)indicator);
        }
        catch (ProcessCanceledException e) {
            Job.DefaultImpls.cancel$default((Job)indexingJob2, null, (int)1, null);
            long duration = System.currentTimeMillis() - t0;
            CidrDebuggerLog.LOG.info(GdbIndexerKt.access$getLogPrefix(indexingSession) + ": wait for completion canceled after " + duration + "ms");
            CidrDebuggerUsagesCollector.INSTANCE.logGdbIndexingCancelled(duration);
            indexingSession.getFileStat().report();
        }
    }

    @NotNull
    public final GdbIndexingSession scheduleIndexing(@NotNull Project project, @NotNull String gdbExecutablePath, @NotNull String gdbIndexDirPath, @NotNull File executableToDebug) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gdbExecutablePath, (String)"gdbExecutablePath");
        Intrinsics.checkNotNullParameter((Object)gdbIndexDirPath, (String)"gdbIndexDirPath");
        Intrinsics.checkNotNullParameter((Object)executableToDebug, (String)"executableToDebug");
        long sessionId = nextIndexingSessionId.incrementAndGet();
        GdbIndexingSessionFileStat fileStat = new GdbIndexingSessionFileStat();
        Job indexingJob2 = BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)new CoroutineName("Gdb index (" + sessionId + ", " + executableToDebug.getPath() + ")")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, executableToDebug, project, sessionId, gdbExecutablePath, gdbIndexDirPath, fileStat, null){
            int label;
            final /* synthetic */ GdbIndexer this$0;
            final /* synthetic */ File $executableToDebug;
            final /* synthetic */ Project $project;
            final /* synthetic */ long $sessionId;
            final /* synthetic */ String $gdbExecutablePath;
            final /* synthetic */ String $gdbIndexDirPath;
            final /* synthetic */ GdbIndexingSessionFileStat $fileStat;
            {
                this.this$0 = $receiver;
                this.$executableToDebug = $executableToDebug;
                this.$project = $project;
                this.$sessionId = $sessionId;
                this.$gdbExecutablePath = $gdbExecutablePath;
                this.$gdbIndexDirPath = $gdbIndexDirPath;
                this.$fileStat = $fileStat;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = SupervisorKt.supervisorScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$executableToDebug, this.$project, this.this$0, this.$sessionId, this.$gdbExecutablePath, this.$gdbIndexDirPath, this.$fileStat, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ File $executableToDebug;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ GdbIndexer this$0;
                            final /* synthetic */ long $sessionId;
                            final /* synthetic */ String $gdbExecutablePath;
                            final /* synthetic */ String $gdbIndexDirPath;
                            final /* synthetic */ GdbIndexingSessionFileStat $fileStat;
                            {
                                this.$executableToDebug = $executableToDebug;
                                this.$project = $project;
                                this.this$0 = $receiver;
                                this.$sessionId = $sessionId;
                                this.$gdbExecutablePath = $gdbExecutablePath;
                                this.$gdbIndexDirPath = $gdbIndexDirPath;
                                this.$fileStat = $fileStat;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        int n;
                                        ResultKt.throwOnFailure((Object)object);
                                        CoroutineScope $this$supervisorScope = (CoroutineScope)this.L$0;
                                        BuildersKt.launch$default((CoroutineScope)$this$supervisorScope, (CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)new CoroutineName("Gdb index " + this.$executableToDebug.getPath())), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$sessionId, this.$gdbExecutablePath, this.$gdbIndexDirPath, this.$executableToDebug, this.$fileStat, null){
                                            int label;
                                            final /* synthetic */ GdbIndexer this$0;
                                            final /* synthetic */ long $sessionId;
                                            final /* synthetic */ String $gdbExecutablePath;
                                            final /* synthetic */ String $gdbIndexDirPath;
                                            final /* synthetic */ File $executableToDebug;
                                            final /* synthetic */ GdbIndexingSessionFileStat $fileStat;
                                            {
                                                this.this$0 = $receiver;
                                                this.$sessionId = $sessionId;
                                                this.$gdbExecutablePath = $gdbExecutablePath;
                                                this.$gdbIndexDirPath = $gdbIndexDirPath;
                                                this.$executableToDebug = $executableToDebug;
                                                this.$fileStat = $fileStat;
                                                super(2, $completion);
                                            }

                                            /*
                                             * WARNING - void declaration
                                             * Enabled force condition propagation
                                             * Lifted jumps to return sites
                                             */
                                            public final Object invokeSuspend(Object object) {
                                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        this.label = 1;
                                                        Object object3 = GdbIndexer.access$indexFile(this.this$0, this.$sessionId, this.$gdbExecutablePath, this.$gdbIndexDirPath, this.$executableToDebug, this.$fileStat, (Continuation)this);
                                                        if (object3 != object2) return Unit.INSTANCE;
                                                        return object2;
                                                    }
                                                    case 1: {
                                                        void $result;
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        Object object3 = $result;
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (int)2, null);
                                        ComponentManager $this$service$iv = (ComponentManager)this.$project;
                                        boolean $i$f$service = false;
                                        Class<GdbLoadedLibrariesStorage> serviceClass$iv = GdbLoadedLibrariesStorage.class;
                                        Object object2 = $this$service$iv.getService(serviceClass$iv);
                                        if (object2 == null) {
                                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                                        }
                                        GdbLoadedLibrariesStorage librariesStorage = (GdbLoadedLibrariesStorage)((Object)object2);
                                        Map<String, Long> libsForExecutable = librariesStorage.librariesForExecutable(this.$executableToDebug);
                                        long ideStartTime = ApplicationManager.getApplication().getStartTime();
                                        Iterable $this$count$iv = libsForExecutable.values();
                                        boolean $i$f$count = false;
                                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                            n = 0;
                                        } else {
                                            int count$iv = 0;
                                            for (T element$iv : $this$count$iv) {
                                                long it = ((Number)element$iv).longValue();
                                                boolean bl = false;
                                                if (!(it > ideStartTime) || ++count$iv >= 0) continue;
                                                CollectionsKt.throwCountOverflow();
                                            }
                                            n = count$iv;
                                        }
                                        boolean shouldRemoveOldLibs = n > libsForExecutable.size() / 4;
                                        Instant keepLibraryThreshold = Instant.now().minus(7L, ChronoUnit.DAYS);
                                        for (Map.Entry<String, Long> entry : libsForExecutable.entrySet()) {
                                            String lib = entry.getKey();
                                            long lastLoadedTime = ((Number)entry.getValue()).longValue();
                                            if (shouldRemoveOldLibs && Instant.ofEpochMilli(lastLoadedTime).isBefore(keepLibraryThreshold)) {
                                                librariesStorage.deleteLibrary(this.$executableToDebug, lib);
                                                continue;
                                            }
                                            BuildersKt.launch$default((CoroutineScope)$this$supervisorScope, (CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)new CoroutineName("Gdb index " + lib)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$sessionId, this.$gdbExecutablePath, this.$gdbIndexDirPath, lib, this.$fileStat, null){
                                                int label;
                                                final /* synthetic */ GdbIndexer this$0;
                                                final /* synthetic */ long $sessionId;
                                                final /* synthetic */ String $gdbExecutablePath;
                                                final /* synthetic */ String $gdbIndexDirPath;
                                                final /* synthetic */ String $lib;
                                                final /* synthetic */ GdbIndexingSessionFileStat $fileStat;
                                                {
                                                    this.this$0 = $receiver;
                                                    this.$sessionId = $sessionId;
                                                    this.$gdbExecutablePath = $gdbExecutablePath;
                                                    this.$gdbIndexDirPath = $gdbIndexDirPath;
                                                    this.$lib = $lib;
                                                    this.$fileStat = $fileStat;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * WARNING - void declaration
                                                 * Enabled force condition propagation
                                                 * Lifted jumps to return sites
                                                 */
                                                public final Object invokeSuspend(Object object) {
                                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)object);
                                                            this.label = 1;
                                                            Object object3 = GdbIndexer.access$indexFile(this.this$0, this.$sessionId, this.$gdbExecutablePath, this.$gdbIndexDirPath, new File(this.$lib), this.$fileStat, (Continuation)this);
                                                            if (object3 != object2) return Unit.INSTANCE;
                                                            return object2;
                                                        }
                                                        case 1: {
                                                            void $result;
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            Object object3 = $result;
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (int)2, null);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        BuildersKt.launch$default((CoroutineScope)GdbIndexer.access$getScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$gdbIndexDirPath, null){
                            int label;
                            final /* synthetic */ GdbIndexer this$0;
                            final /* synthetic */ String $gdbIndexDirPath;
                            {
                                this.this$0 = $receiver;
                                this.$gdbIndexDirPath = $gdbIndexDirPath;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = GdbIndexer.access$cleanupOldIndexes(this.this$0, this.$gdbIndexDirPath, (Continuation)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        CidrDebuggerLog.LOG.debug(GdbIndexerKt.access$logPrefix(sessionId) + ": schedule indexing for " + executableToDebug.getPath());
        return new GdbIndexingSession(sessionId, project, executableToDebug, indexingJob2, fileStat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object indexFile(long var1_1, String var3_2, String var4_3, File var5_4, GdbIndexingSessionFileStat var6_5, Continuation<? super Unit> $completion) {
        if (!($completion instanceof indexFile.1)) ** GOTO lbl-1000
        var30_7 = $completion;
        if ((var30_7.label & -2147483648) != 0) {
            var30_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                long J$0;
                long J$1;
                /* synthetic */ Object result;
                final /* synthetic */ GdbIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GdbIndexer.access$indexFile(this.this$0, 0L, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var31_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                t0 = System.currentTimeMillis();
                $continuation.L$0 = this;
                $continuation.L$1 = gdbExecutablePath;
                $continuation.L$2 = gdbIndexDirPath;
                $continuation.L$3 = fileToIndex;
                $continuation.L$4 = fileStat;
                $continuation.J$0 = sessionId;
                $continuation.J$1 = t0;
                $continuation.label = 1;
                v0 = CoroutinesKt.checkCanceled((Continuation)$continuation);
                if (v0 == var31_9) {
                    return var31_9;
                }
                ** GOTO lbl35
            }
            case 1: {
                t0 = $continuation.J$1;
                sessionId = $continuation.J$0;
                fileStat = (GdbIndexingSessionFileStat)$continuation.L$4;
                fileToIndex = (File)$continuation.L$3;
                gdbIndexDirPath = (String)$continuation.L$2;
                gdbExecutablePath = (String)$continuation.L$1;
                this = (GdbIndexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl35:
                // 2 sources

                if (!fileToIndex.exists()) {
                    return Unit.INSTANCE;
                }
                filePath = fileToIndex.getAbsolutePath();
                logPrefix = GdbIndexerKt.access$logPrefix(sessionId);
                fileSize = fileToIndex.length();
                fileStat.recordProcessedFile(fileSize);
                $i$f$service = false;
                serviceClass$iv = GdbIndexStorage.class;
                v1 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (v1 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                indexStorage = (GdbIndexStorage)v1;
                indexEntry = indexStorage.entryForFile(fileToIndex);
                if (indexEntry != null && indexEntry.isUpToDate(fileToIndex)) {
                    if (!indexEntry.getHasIndex()) {
                        CidrDebuggerLog.LOG.debug(logPrefix + ": skip indexing " + filePath + ": no index was created on previous run");
                        return Unit.INSTANCE;
                    }
                    indexFileName = indexEntry.getBuildId() + ".gdb-index";
                    var18_18 /* !! */  = new String[]{indexFileName};
                    v2 = Paths.get(gdbIndexDirPath, Arrays.copyOf(var18_18 /* !! */ , var18_18 /* !! */ .length));
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"get(...)");
                    indexPath = v2;
                    if (indexEntry.getHasIndex()) {
                        v3 = new LinkOption[]{};
                        if (Files.exists(indexPath, Arrays.copyOf(v3, v3.length))) {
                            CidrDebuggerLog.LOG.debug(logPrefix + ": reuse build id and index for " + filePath + ": " + indexFileName);
                            var18_18 /* !! */  = indexPath;
                            var19_22 = FileTime.fromMillis(System.currentTimeMillis());
                            Intrinsics.checkNotNullExpressionValue((Object)var19_22, (String)"fromMillis(...)");
                            Intrinsics.checkNotNullExpressionValue((Object)Files.setLastModifiedTime((Path)var18_18 /* !! */ , var19_22), (String)"setLastModifiedTime(...)");
                            return Unit.INSTANCE;
                        }
                    }
                }
                sizeToLog = fileSize > 0x100000L ? fileSize / (long)0x100000 + " mb" : "< 1 mb";
                CidrDebuggerLog.LOG.debug(logPrefix + ": processing " + filePath + " (" + sizeToLog + ")");
                tmpDir = null;
                $continuation.L$0 = this;
                $continuation.L$1 = gdbExecutablePath;
                $continuation.L$2 = gdbIndexDirPath;
                $continuation.L$3 = fileToIndex;
                $continuation.L$4 = fileStat;
                $continuation.L$5 = filePath;
                $continuation.L$6 = logPrefix;
                $continuation.L$7 = indexStorage;
                $continuation.L$8 = indexEntry;
                $continuation.J$0 = t0;
                $continuation.J$1 = fileSize;
                $continuation.label = 2;
                v4 = CoroutinesKt.checkCanceled((Continuation)$continuation);
                ** if (v4 != var31_9) goto lbl87
lbl86:
                // 1 sources

                return var31_9;
lbl87:
                // 1 sources

                ** GOTO lbl105
            }
            case 2: {
                fileSize = $continuation.J$1;
                t0 = $continuation.J$0;
                tmpDir = null;
                indexEntry = (GdbIndexEntry)$continuation.L$8;
                indexStorage = (GdbIndexStorage)$continuation.L$7;
                logPrefix = (String)$continuation.L$6;
                filePath = (String)$continuation.L$5;
                fileStat = (GdbIndexingSessionFileStat)$continuation.L$4;
                fileToIndex = (File)$continuation.L$3;
                gdbIndexDirPath = (String)$continuation.L$2;
                gdbExecutablePath = (String)$continuation.L$1;
                this = (GdbIndexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl105:
                // 2 sources

                try {
                    var19_23 = this.readBuildId(fileToIndex);
                }
                catch (ExecutionException e) {
                    v5 = e.getMessage();
                    if (v5 == null) {
                        v5 = e.getClass().getName();
                    }
                    error = v5;
                    CidrDebuggerLog.LOG.warn(logPrefix + ": failed to read build id from " + filePath + ": " + error);
                    var22_30 = Unit.INSTANCE;
                    return var22_30;
                }
                buildId = var19_23;
                if (buildId != null) ** GOTO lbl127
                CidrDebuggerLog.LOG.debug(logPrefix + ": no build id in " + filePath + ", exclude it from indexing until the file is modified");
                indexStorage.saveEntry(fileToIndex, null, false);
                var19_23 = Unit.INSTANCE;
                return var19_23;
lbl127:
                // 2 sources

                v6 = indexEntry;
                v7 = oldBuildId = v6 != null ? v6.getBuildId() : null;
                if (oldBuildId != null && !Intrinsics.areEqual((Object)oldBuildId, (Object)buildId)) {
                    error = new String[]{oldBuildId + ".gdb-index"};
                    v8 = Paths.get(gdbIndexDirPath, Arrays.copyOf(error, error.length));
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"get(...)");
                    oldIndex = v8;
                    v9 = new LinkOption[]{};
                    if (Files.exists(oldIndex, Arrays.copyOf(v9, v9.length))) {
                        CidrDebuggerLog.LOG.debug(logPrefix + ": remove old index for " + filePath + ": " + oldBuildId + ".gdb-index");
                        PathKt.delete$default((Path)oldIndex, (boolean)false, (int)1, null);
                    }
                }
                error = new String[]{buildId + ".gdb-index"};
                v10 = Paths.get(gdbIndexDirPath, Arrays.copyOf(error, error.length));
                Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"get(...)");
                indexPath = v10;
                v11 = new LinkOption[]{};
                if (!Files.exists(indexPath, Arrays.copyOf(v11, v11.length))) ** GOTO lbl155
                CidrDebuggerLog.LOG.debug(logPrefix + ": found existing index for " + filePath + ": " + buildId + ".gdb-index");
                error = indexPath;
                v12 = FileTime.fromMillis(System.currentTimeMillis());
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"fromMillis(...)");
                Intrinsics.checkNotNullExpressionValue((Object)Files.setLastModifiedTime((Path)error, v12), (String)"setLastModifiedTime(...)");
                indexStorage.saveEntry(fileToIndex, buildId, true);
                error = Unit.INSTANCE;
                return error;
lbl155:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = gdbExecutablePath;
                $continuation.L$2 = gdbIndexDirPath;
                $continuation.L$3 = fileToIndex;
                $continuation.L$4 = fileStat;
                $continuation.L$5 = filePath;
                $continuation.L$6 = logPrefix;
                $continuation.L$7 = indexStorage;
                $continuation.L$8 = buildId;
                $continuation.J$0 = t0;
                $continuation.J$1 = fileSize;
                $continuation.label = 3;
                v13 = CoroutinesKt.checkCanceled((Continuation)$continuation);
                ** if (v13 != var31_9) goto lbl170
lbl169:
                // 1 sources

                return var31_9;
lbl170:
                // 1 sources

                ** GOTO lbl188
            }
            case 3: {
                fileSize = $continuation.J$1;
                t0 = $continuation.J$0;
                buildId = (String)$continuation.L$8;
                tmpDir = null;
                indexStorage = (GdbIndexStorage)$continuation.L$7;
                logPrefix = (String)$continuation.L$6;
                filePath = (String)$continuation.L$5;
                fileStat = (GdbIndexingSessionFileStat)$continuation.L$4;
                fileToIndex = (File)$continuation.L$3;
                gdbIndexDirPath = (String)$continuation.L$2;
                gdbExecutablePath = (String)$continuation.L$1;
                this = (GdbIndexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v13 = $result;
lbl188:
                // 2 sources

                tmpDir = FileUtil.createTempDirectory((File)new File(gdbIndexDirPath), (String)fileToIndex.getName(), (String)".tmp");
                fileStat.recordIndexedFile(fileSize);
                try {
                    var22_31 /* !! */  = this.createIndex(gdbExecutablePath, tmpDir, fileToIndex);
                }
                catch (ExecutionException e) {
                    v14 = e.getMessage();
                    if (v14 == null) {
                        v14 = e.getClass().getName();
                    }
                    error = v14;
                    CidrDebuggerLog.LOG.warn(logPrefix + ": failed to create gdb-index for " + filePath + ": " + error);
                    var25_36 = Unit.INSTANCE;
                    v15 = tmpDir;
                    if (v15 != null) {
                        it = v15;
                        $i$a$-let-GdbIndexer$indexFile$2 = false;
                        FileUtil.deleteRecursively((Path)it.toPath());
                    }
                    return var25_36;
                }
                indexFile = var22_31 /* !! */ ;
                $continuation.L$0 = gdbIndexDirPath;
                $continuation.L$1 = fileToIndex;
                $continuation.L$2 = filePath;
                $continuation.L$3 = logPrefix;
                $continuation.L$4 = indexStorage;
                $continuation.L$5 = tmpDir;
                $continuation.L$6 = buildId;
                $continuation.L$7 = indexFile;
                $continuation.L$8 = null;
                $continuation.J$0 = t0;
                $continuation.label = 4;
                v16 = CoroutinesKt.checkCanceled((Continuation)$continuation);
                ** if (v16 != var31_9) goto lbl224
lbl223:
                // 1 sources

                return var31_9;
lbl224:
                // 1 sources

                ** GOTO lbl239
            }
            case 4: {
                t0 = $continuation.J$0;
                indexFile = (File)$continuation.L$7;
                buildId = (String)$continuation.L$6;
                tmpDir = (File)$continuation.L$5;
                indexStorage = (GdbIndexStorage)$continuation.L$4;
                logPrefix = (String)$continuation.L$3;
                filePath = (String)$continuation.L$2;
                fileToIndex = (File)$continuation.L$1;
                gdbIndexDirPath = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v16 = $result;
lbl239:
                // 2 sources

                if (indexFile != null) ** GOTO lbl251
                CidrDebuggerLog.LOG.debug(logPrefix + ": no index was created for " + filePath + ", exclude it from indexing until the file is modified");
                indexStorage.saveEntry(fileToIndex, buildId, false);
                var22_31 /* !! */  = Unit.INSTANCE;
                v17 = tmpDir;
                if (v17 != null) {
                    it = v17;
                    $i$a$-let-GdbIndexer$indexFile$2 = false;
                    FileUtil.deleteRecursively((Path)it.toPath());
                }
                return var22_31 /* !! */ ;
lbl251:
                // 2 sources

                indexStorage.saveEntry(fileToIndex, buildId, true);
                $continuation.L$0 = gdbIndexDirPath;
                $continuation.L$1 = filePath;
                $continuation.L$2 = logPrefix;
                $continuation.L$3 = tmpDir;
                $continuation.L$4 = buildId;
                $continuation.L$5 = indexFile;
                $continuation.L$6 = null;
                $continuation.L$7 = null;
                $continuation.J$0 = t0;
                $continuation.label = 5;
                v18 = CoroutinesKt.checkCanceled((Continuation)$continuation);
                ** if (v18 != var31_9) goto lbl265
lbl264:
                // 1 sources

                return var31_9;
lbl265:
                // 1 sources

                ** GOTO lbl278
            }
            case 5: {
                t0 = $continuation.J$0;
                indexFile = (File)$continuation.L$5;
                buildId = (String)$continuation.L$4;
                tmpDir = (File)$continuation.L$3;
                logPrefix = (String)$continuation.L$2;
                filePath = (String)$continuation.L$1;
                gdbIndexDirPath = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v18 = $result;
lbl278:
                    // 2 sources

                    if (!(dstIndexFile = new File(gdbIndexDirPath + "/" + buildId + ".gdb-index")).exists() && !indexFile.renameTo(dstIndexFile)) {
                        CidrDebuggerLog.LOG.warn(logPrefix + ": failed to move index file " + indexFile.getPath() + " to " + dstIndexFile.getPath());
                    }
                    t1 = System.currentTimeMillis();
                    CidrDebuggerLog.LOG.debug(logPrefix + ": " + filePath + " is processed in " + (t1 - t0) + "ms");
                    v19 = tmpDir;
                }
                catch (Exception e) {
                    if (e instanceof CancellationException) {
                        throw e;
                    }
                    v20 = e.getMessage();
                    if (v20 == null) {
                        v20 = e.getClass().getName();
                    }
                    error = v20;
                    CidrDebuggerLog.LOG.warn(logPrefix + ": error while processing " + filePath + ": " + error);
                    CidrDebuggerLog.LOG.debug((Throwable)e);
                    ** GOTO lbl310
                }
                if (v19 != null) {
                    it = v19;
                    $i$a$-let-GdbIndexer$indexFile$2 = false;
                    FileUtil.deleteRecursively((Path)it.toPath());
                }
                ** GOTO lbl310
            }
            {
                finally {
                    v21 = tmpDir;
                    if (v21 != null) {
                        it = v21;
                        $i$a$-let-GdbIndexer$indexFile$2 = false;
                        FileUtil.deleteRecursively((Path)it.toPath());
                    }
                }
            }
lbl310:
            // 2 sources

            return Unit.INSTANCE;
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Exception decompiling
     */
    private final Object cleanupOldIndexes(String var1_1, Continuation<? super Unit> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final String readBuildId(File file) throws ExecutionException {
        String[] stringArray = new String[]{"readelf", "-n", file.getPath()};
        ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(stringArray));
        String string = output.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        for (Object e : StringsKt.lines((CharSequence)string)) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            String line = (String)e;
            String trimmed = ((Object)StringsKt.trimStart((CharSequence)line)).toString();
            if (!StringsKt.startsWith$default((String)trimmed, (String)BUILD_ID_PREFIX, (boolean)false, (int)2, null)) continue;
            String string2 = trimmed.substring(10);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return ((Object)StringsKt.trim((CharSequence)string2)).toString();
        }
        return null;
    }

    private final File createIndex(String gdbExecutablePath, File dstDir, File file) {
        File file2;
        block3: {
            String[] stringArray = new String[]{gdbExecutablePath, "--batch", "-nx", "-iex", "set auto-load no", "-iex", "set debuginfod enabled off", "-ex", "file " + file.getPath(), "-ex", "save gdb-index " + dstDir.getPath()};
            ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(stringArray));
            File[] fileArray = dstDir.listFiles();
            if (fileArray != null) {
                File[] $this$firstOrNull$iv = fileArray;
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!it.isFile()) continue;
                    file2 = element$iv;
                    break block3;
                }
                file2 = null;
            } else {
                file2 = null;
            }
        }
        return file2;
    }

    private static final void waitForCompletion$lambda$0(Job $indexingJob, long $t0, GdbIndexingSession $indexingSession) {
        CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($indexingJob, $t0, $indexingSession, null){
            int label;
            final /* synthetic */ Job $indexingJob;
            final /* synthetic */ long $t0;
            final /* synthetic */ GdbIndexingSession $indexingSession;
            {
                this.$indexingJob = $indexingJob;
                this.$t0 = $t0;
                this.$indexingSession = $indexingSession;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.$indexingJob.join((Continuation)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        duration = System.currentTimeMillis() - this.$t0;
                        CidrDebuggerLog.LOG.debug(GdbIndexerKt.access$getLogPrefix(this.$indexingSession) + ": wait for completion " + duration + "ms");
                        if (this.$indexingJob.isCancelled()) {
                            CidrDebuggerUsagesCollector.INSTANCE.logGdbIndexingCancelled(duration);
                        } else {
                            CidrDebuggerUsagesCollector.INSTANCE.logGdbIndexingCompleted(duration);
                        }
                        this.$indexingSession.getFileStat().report();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @JvmStatic
    @NotNull
    public static final GdbIndexer getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ Object access$indexFile(GdbIndexer $this, long sessionId, String gdbExecutablePath, String gdbIndexDirPath, File fileToIndex, GdbIndexingSessionFileStat fileStat, Continuation $completion) {
        return $this.indexFile(sessionId, gdbExecutablePath, gdbIndexDirPath, fileToIndex, fileStat, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ CoroutineScope access$getScope$p(GdbIndexer $this) {
        return $this.scope;
    }

    public static final /* synthetic */ Object access$cleanupOldIndexes(GdbIndexer $this, String gdbIndexDirPath, Continuation $completion) {
        return $this.cleanupOldIndexes(gdbIndexDirPath, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbIndexer$Companion;", "", "<init>", "()V", "nextIndexingSessionId", "Ljava/util/concurrent/atomic/AtomicLong;", "BUILD_ID_PREFIX", "", "getInstance", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbIndexer;", "intellij.cidr.debugger"})
    @SourceDebugExtension(value={"SMAP\nGdbIndexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdbIndexer.kt\ncom/jetbrains/cidr/execution/debugger/backend/gdb/GdbIndexer$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,738:1\n40#2,3:739\n*S KotlinDebug\n*F\n+ 1 GdbIndexer.kt\ncom/jetbrains/cidr/execution/debugger/backend/gdb/GdbIndexer$Companion\n*L\n186#1:739,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GdbIndexer getInstance() {
            boolean $i$f$service = false;
            Class<GdbIndexer> serviceClass$iv = GdbIndexer.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (GdbIndexer)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

