/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.jetbrains.cidr.execution.debugger.backend.FileLocation;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0003H\u0016J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/LLBreakpointLocation;", "", "id", "", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "fileLocation", "Lcom/jetbrains/cidr/execution/debugger/backend/FileLocation;", "<init>", "(Ljava/lang/String;Lcom/jetbrains/cidr/execution/debugger/memory/Address;Lcom/jetbrains/cidr/execution/debugger/backend/FileLocation;)V", "getId", "()Ljava/lang/String;", "getAddress", "()Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "getFileLocation", "()Lcom/jetbrains/cidr/execution/debugger/backend/FileLocation;", "toString", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "intellij.cidr.debugger.backend"})
public final class LLBreakpointLocation {
    @NotNull
    private final String id;
    @NotNull
    private final Address address;
    @Nullable
    private final FileLocation fileLocation;

    public LLBreakpointLocation(@NotNull String id, @NotNull Address address, @Nullable FileLocation fileLocation) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.id = id;
        this.address = address;
        this.fileLocation = fileLocation;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final Address getAddress() {
        return this.address;
    }

    @Nullable
    public final FileLocation getFileLocation() {
        return this.fileLocation;
    }

    @NotNull
    public String toString() {
        String result = "id:" + this.id + "@" + this.address;
        if (this.fileLocation != null) {
            result = result + "@" + this.fileLocation + ".file:" + this.fileLocation + ".line";
        }
        return result;
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final Address component2() {
        return this.address;
    }

    @Nullable
    public final FileLocation component3() {
        return this.fileLocation;
    }

    @NotNull
    public final LLBreakpointLocation copy(@NotNull String id, @NotNull Address address, @Nullable FileLocation fileLocation) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return new LLBreakpointLocation(id, address, fileLocation);
    }

    public static /* synthetic */ LLBreakpointLocation copy$default(LLBreakpointLocation lLBreakpointLocation, String string, Address address, FileLocation fileLocation, int n, Object object) {
        if ((n & 1) != 0) {
            string = lLBreakpointLocation.id;
        }
        if ((n & 2) != 0) {
            address = lLBreakpointLocation.address;
        }
        if ((n & 4) != 0) {
            fileLocation = lLBreakpointLocation.fileLocation;
        }
        return lLBreakpointLocation.copy(string, address, fileLocation);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.address.hashCode();
        result = result * 31 + (this.fileLocation == null ? 0 : this.fileLocation.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LLBreakpointLocation)) {
            return false;
        }
        LLBreakpointLocation lLBreakpointLocation = (LLBreakpointLocation)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)lLBreakpointLocation.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.address, (Object)lLBreakpointLocation.address)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.fileLocation, (Object)lLBreakpointLocation.fileLocation);
    }
}

