/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.ProcessOutputReaders;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpointLocation;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLMemoryHunk;
import com.jetbrains.cidr.execution.debugger.backend.LLModule;
import com.jetbrains.cidr.execution.debugger.backend.LLRegisterSet;
import com.jetbrains.cidr.execution.debugger.backend.LLSection;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.backend.features.DisabledRawViewSupport;
import com.jetbrains.cidr.execution.debugger.backend.features.RawViewSupport;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.intellij.lang.annotations.PrintFormat;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class DebuggerDriver {
    public static final Key<Boolean> USE_EXTERNAL_CONSOLE_KEY = Key.create((String)"USE_EXTERNAL_CONSOLE");
    public static final int LOAD_TIMEOUT_MS = 90000;
    public static final int TIMEOUT_MS = 30000;
    public static final int EVALUATION_TIMEOUT_MS = 30000;
    public static final int CLOSE_TIMEOUT_MS = 300;
    public static final int DESTROY_TIMEOUT_MS = 1500;
    public static final int MAX_DESCRIPTION = 256;
    public static final int MAX_DISASSEMBLE_FUNCTION_SIZE = 65536;
    @NotNull
    protected final Handler myHandler;
    @NotNull
    private volatile TargetStateTransition myStateTransition;
    @NotNull
    protected final QueueProcessor<Runnable> myHandlerProcessor;
    @Nullable
    private ProcessOutputReaders myReaders;
    @NotNull
    private final AtomicReference<Semaphore> myTerminalReadFinished;
    @Nullable
    private CidrEventSpan myStateSpan;
    protected boolean myToRedirect;
    @Nullable
    private Runnable myBeforeHandleTargetOutputCallback;
    private static final String PID_NOT_SUPPORTED = "pid_not_supported";

    public DebuggerDriver(@NotNull Handler handler) {
        if (handler == null) {
            DebuggerDriver.$$$reportNull$$$0(0);
        }
        this.myStateTransition = new TargetStateTransition(TargetState.NOT_READY, TargetState.NOT_READY);
        this.myTerminalReadFinished = new AtomicReference();
        this.myBeforeHandleTargetOutputCallback = null;
        this.myHandlerProcessor = QueueProcessor.createRunnableQueueProcessor();
        this.myHandler = Handler.createQueuedHandler(handler, this.myHandlerProcessor);
    }

    public boolean supportsWatchpoints() {
        return true;
    }

    public abstract boolean supportsWatchpointLifetime();

    public boolean supportsJumpToLine() {
        return false;
    }

    @NotNull
    public abstract BaseProcessHandler getProcessHandler();

    public abstract boolean isInPromptMode();

    @NotNull
    public TargetState getState() {
        TargetState targetState = this.myStateTransition.getCurrentState();
        if (targetState == null) {
            DebuggerDriver.$$$reportNull$$$0(1);
        }
        return targetState;
    }

    @NotNull
    public TargetStateTransition getStateTransition() {
        TargetStateTransition targetStateTransition = this.myStateTransition;
        if (targetStateTransition == null) {
            DebuggerDriver.$$$reportNull$$$0(2);
        }
        return targetStateTransition;
    }

    @NotNull
    public abstract HostMachine getHostMachine();

    public abstract void setValuesFilteringEnabled(boolean var1) throws ExecutionException;

    @NotNull
    public abstract Inferior loadForLaunch(@NotNull Installer var1, @Nullable String var2) throws ExecutionException;

    @NotNull
    public abstract Inferior loadForAttach(int var1) throws ExecutionException;

    @NotNull
    public abstract Inferior loadForAttach(@NotNull String var1, boolean var2) throws ExecutionException;

    @NotNull
    public abstract Inferior loadCoreDump(@NotNull File var1, @Nullable File var2, @Nullable File var3, @NotNull List<PathMapping> var4) throws ExecutionException;

    @NotNull
    public abstract Inferior loadCoreDump(@NotNull File var1, @Nullable File var2, @Nullable File var3, @NotNull List<PathMapping> var4, @NotNull List<String> var5) throws ExecutionException;

    @NotNull
    public abstract Inferior loadForRemote(@NotNull String var1, @Nullable File var2, @Nullable File var3, @NotNull List<PathMapping> var4) throws ExecutionException;

    public abstract boolean interrupt() throws ExecutionException;

    public abstract boolean resume() throws ExecutionException;

    public boolean resume(@NotNull LLThread thread) throws ExecutionException {
        if (thread == null) {
            DebuggerDriver.$$$reportNull$$$0(3);
        }
        return this.resume();
    }

    @Deprecated
    public abstract void stepOver(boolean var1) throws ExecutionException;

    @Deprecated
    public abstract void stepInto(boolean var1, boolean var2) throws ExecutionException;

    @Deprecated
    public abstract void stepOut(boolean var1) throws ExecutionException;

    public void stepOver(@NotNull LLThread thread, boolean stepByInstruction) throws ExecutionException {
        if (thread == null) {
            DebuggerDriver.$$$reportNull$$$0(4);
        }
        this.stepOver(stepByInstruction);
    }

    public void stepInto(@NotNull LLThread thread, boolean forceStepIntoFramesWithNoDebugInfo, boolean stepByInstruction) throws ExecutionException {
        if (thread == null) {
            DebuggerDriver.$$$reportNull$$$0(5);
        }
        this.stepInto(forceStepIntoFramesWithNoDebugInfo, stepByInstruction);
    }

    public void stepOut(@NotNull LLThread thread, boolean stopInFramesWithNoDebugInfo) throws ExecutionException {
        if (thread == null) {
            DebuggerDriver.$$$reportNull$$$0(6);
        }
        this.stepOut(stopInFramesWithNoDebugInfo);
    }

    public abstract void runTo(@NotNull String var1, int var2) throws ExecutionException;

    public abstract void runTo(@NotNull Address var1) throws ExecutionException;

    @NotNull
    public abstract StopPlace jumpToLine(@NotNull LLThread var1, @NotNull String var2, int var3, boolean var4) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract StopPlace jumpToAddress(@NotNull LLThread var1, @NotNull Address var2, boolean var3) throws ExecutionException, DebuggerCommandException;

    public abstract void addPathMapping(int var1, @NotNull String var2, @NotNull String var3) throws ExecutionException;

    public abstract void addForcedFileMapping(int var1, @NotNull String var2, @Nullable DebuggerSourceFileHash var3, @NotNull String var4) throws ExecutionException;

    protected abstract boolean doExit() throws ExecutionException;

    @NotNull
    public abstract LLWatchpoint addWatchpoint(long var1, int var3, @NotNull LLValue var4, @NotNull String var5, @Nullable LLWatchpoint.Lifetime var6, @NotNull LLWatchpoint.AccessType var7) throws ExecutionException, DebuggerCommandException;

    public abstract void removeWatchpoint(@NotNull List<Integer> var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public AddBreakpointResult addBreakpoint(@NotNull String path, int line) throws ExecutionException, DebuggerCommandException {
        if (path == null) {
            DebuggerDriver.$$$reportNull$$$0(7);
        }
        AddBreakpointResult addBreakpointResult = this.addBreakpoint(path, line, null, false);
        if (addBreakpointResult == null) {
            DebuggerDriver.$$$reportNull$$$0(8);
        }
        return addBreakpointResult;
    }

    @NotNull
    public AddBreakpointResult addBreakpoint(@NotNull String path, int line, @Nullable String condition) throws ExecutionException, DebuggerCommandException {
        if (path == null) {
            DebuggerDriver.$$$reportNull$$$0(9);
        }
        AddBreakpointResult addBreakpointResult = this.addBreakpoint(path, line, condition, false);
        if (addBreakpointResult == null) {
            DebuggerDriver.$$$reportNull$$$0(10);
        }
        return addBreakpointResult;
    }

    @NotNull
    public abstract AddBreakpointResult addBreakpoint(@NotNull String var1, int var2, @Nullable String var3, boolean var4) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract AddBreakpointResult addAddressBreakpoint(@NotNull Address var1, @Nullable String var2) throws ExecutionException, DebuggerCommandException;

    @Nullable
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull String symbolPattern) throws ExecutionException, DebuggerCommandException {
        if (symbolPattern == null) {
            DebuggerDriver.$$$reportNull$$$0(11);
        }
        return this.addSymbolicBreakpoint(symbolPattern, null, null);
    }

    @Nullable
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull String symbolPattern, @Nullable String module, @Nullable String condition) throws ExecutionException, DebuggerCommandException {
        if (symbolPattern == null) {
            DebuggerDriver.$$$reportNull$$$0(12);
        }
        SymbolicBreakpoint symBreakpoint = new SymbolicBreakpoint();
        symBreakpoint.setPattern(symbolPattern);
        symBreakpoint.setModule(module);
        symBreakpoint.setCondition(condition);
        return this.addSymbolicBreakpoint(symBreakpoint);
    }

    @Nullable
    public abstract LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull SymbolicBreakpoint var1) throws ExecutionException, DebuggerCommandException;

    public abstract void removeCodepoints(@NotNull Collection<Integer> var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract List<LLThread> getThreads() throws ExecutionException, DebuggerCommandException;

    @NotNull
    public ResultList<LLFrame> getFrames(@NotNull LLThread thread, int from, int count) throws ExecutionException, DebuggerCommandException {
        if (thread == null) {
            DebuggerDriver.$$$reportNull$$$0(13);
        }
        ResultList<LLFrame> resultList = this.getFrames(thread, from, count, false);
        if (resultList == null) {
            DebuggerDriver.$$$reportNull$$$0(14);
        }
        return resultList;
    }

    @NotNull
    public abstract ResultList<LLFrame> getFrames(@NotNull LLThread var1, int var2, int var3, boolean var4) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public List<LLValue> getVariables(@NotNull LLThread thread, @NotNull LLFrame frame) throws ExecutionException, DebuggerCommandException {
        if (thread == null) {
            DebuggerDriver.$$$reportNull$$$0(15);
        }
        if (frame == null) {
            DebuggerDriver.$$$reportNull$$$0(16);
        }
        List<LLValue> list = this.getVariables(thread.getId(), frame.getIndex());
        if (list == null) {
            DebuggerDriver.$$$reportNull$$$0(17);
        }
        return list;
    }

    @ApiStatus.Experimental
    @NotNull
    public FrameVariables getFrameVariables(@NotNull LLThread thread, @NotNull LLFrame frame) throws ExecutionException, DebuggerCommandException {
        if (thread == null) {
            DebuggerDriver.$$$reportNull$$$0(18);
        }
        if (frame == null) {
            DebuggerDriver.$$$reportNull$$$0(19);
        }
        List<LLValue> variables = this.getVariables(thread, frame);
        return new FrameVariables(variables, false);
    }

    @Deprecated
    @NotNull
    public abstract List<LLValue> getVariables(long var1, int var3) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract LLValueData getData(@NotNull LLValue var1) throws ExecutionException, DebuggerCommandException;

    @Nullable
    public abstract String getDescription(@NotNull LLValue var1, int var2) throws ExecutionException, DebuggerCommandException;

    @Nullable
    public abstract Integer getChildrenCount(@NotNull LLValue var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract ResultList<LLValue> getVariableChildren(@NotNull LLValue var1, int var2, int var3) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public LLValue evaluate(@NotNull LLThread thread, @NotNull LLFrame frame, @NotNull String expression, @Nullable DebuggerLanguage language) throws ExecutionException, DebuggerCommandException {
        if (thread == null) {
            DebuggerDriver.$$$reportNull$$$0(20);
        }
        if (frame == null) {
            DebuggerDriver.$$$reportNull$$$0(21);
        }
        if (expression == null) {
            DebuggerDriver.$$$reportNull$$$0(22);
        }
        LLValue lLValue = this.evaluate(thread.getId(), frame.getIndex(), expression, language);
        if (lLValue == null) {
            DebuggerDriver.$$$reportNull$$$0(23);
        }
        return lLValue;
    }

    @NotNull
    public final LLValue evaluate(@NotNull LLThread thread, @NotNull LLFrame frame, @NlsSafe @NotNull String expression) throws ExecutionException, DebuggerCommandException {
        if (thread == null) {
            DebuggerDriver.$$$reportNull$$$0(24);
        }
        if (frame == null) {
            DebuggerDriver.$$$reportNull$$$0(25);
        }
        if (expression == null) {
            DebuggerDriver.$$$reportNull$$$0(26);
        }
        LLValue lLValue = this.evaluate(thread, frame, expression, null);
        if (lLValue == null) {
            DebuggerDriver.$$$reportNull$$$0(27);
        }
        return lLValue;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NotNull
    public final LLValue evaluate(long threadId, int frameIndex, @NlsSafe @NotNull String string) throws ExecutionException, DebuggerCommandException {
        void expression;
        if (string == null) {
            DebuggerDriver.$$$reportNull$$$0(28);
        }
        LLValue lLValue = this.evaluate(threadId, frameIndex, (String)expression, null);
        if (lLValue == null) {
            DebuggerDriver.$$$reportNull$$$0(29);
        }
        return lLValue;
    }

    @Deprecated
    @NotNull
    public abstract LLValue evaluate(long var1, int var3, @NotNull String var4, @Nullable DebuggerLanguage var5) throws ExecutionException, DebuggerCommandException;

    public int getPointerSize() throws ExecutionException, DebuggerCommandException {
        LLValue value = this.evaluate(-1L, -1, "sizeof(void *)");
        return (int)this.getData(value).intValue();
    }

    @NotNull
    public abstract List<LLInstruction> disassembleFunction(@NotNull Address var1, @NotNull AddressRange var2) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract List<LLInstruction> disassemble(@NotNull AddressRange var1) throws ExecutionException, DebuggerCommandException;

    @Nullable
    public LLInstruction disassemble(@NotNull Address address) throws ExecutionException, DebuggerCommandException {
        List<LLInstruction> instructions;
        if (address == null) {
            DebuggerDriver.$$$reportNull$$$0(30);
        }
        return (instructions = this.disassemble(AddressUtil.addressToRange(address, 1L))).isEmpty() ? null : instructions.get(0);
    }

    @NotNull
    public abstract List<LLMemoryHunk> dumpMemory(@NotNull AddressRange var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract List<LLModule> getLoadedModules() throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract List<LLSection> getModuleSections(@NotNull LLModule var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract ShellCommandResult executeShellCommand(@NotNull String var1, @Nullable List<String> var2, @Nullable String var3, int var4) throws ExecutionException;

    @Deprecated(forRemoval=true)
    @TestOnly
    public void executeConsoleCommand(@NotNull String command) throws ExecutionException, DebuggerCommandException {
        if (command == null) {
            DebuggerDriver.$$$reportNull$$$0(31);
        }
        this.executeInterpreterCommand(-1L, -1, command);
    }

    @TestOnly
    @NotNull
    public abstract String executeInterpreterCommand(@NotNull String var1) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract String executeInterpreterCommand(long var1, int var3, @NotNull String var4) throws ExecutionException, DebuggerCommandException;

    @NotNull
    public abstract ResultList<String> completeConsoleCommand(@NotNull String var1, int var2) throws ExecutionException;

    public abstract void handleSignal(@NotNull String var1, boolean var2, boolean var3, boolean var4) throws ExecutionException, DebuggerCommandException;

    public abstract void cancelSymbolsDownload(@NotNull String var1) throws ExecutionException, DebuggerCommandException;

    public boolean supportsFreezeSingleThread() {
        return false;
    }

    public boolean supportsFreezeOtherThreads() {
        return false;
    }

    public void freezeThread(@NotNull LLThread thread) throws ExecutionException, DebuggerCommandException {
        if (thread == null) {
            DebuggerDriver.$$$reportNull$$$0(32);
        }
        throw new UnsupportedOperationException("Freeze thread is not supported");
    }

    public void unfreezeThread(@NotNull LLThread thread) throws ExecutionException, DebuggerCommandException {
        if (thread == null) {
            DebuggerDriver.$$$reportNull$$$0(33);
        }
        throw new UnsupportedOperationException("Unfreeze thread is not supported");
    }

    public void freezeOtherThreads(@NotNull LLThread thread) throws ExecutionException, DebuggerCommandException {
        if (thread == null) {
            DebuggerDriver.$$$reportNull$$$0(34);
        }
        throw new UnsupportedOperationException("Freeze thread is not supported");
    }

    public void unfreezeAllThreads(@NotNull LLThread thread) throws ExecutionException, DebuggerCommandException {
        if (thread == null) {
            DebuggerDriver.$$$reportNull$$$0(35);
        }
        throw new UnsupportedOperationException("Unfreeze thread is not supported");
    }

    public boolean supportsDebuggingForkedProcess() {
        return false;
    }

    public boolean supportsDebuggingMultipleProcesses() {
        return false;
    }

    public void setFollowChildOnFork(boolean followChild) throws ExecutionException, DebuggerCommandException {
        throw new UnsupportedOperationException("Setting fork mode is not supported");
    }

    public void setDetachOnFork(boolean detach) throws ExecutionException, DebuggerCommandException {
        throw new UnsupportedOperationException("Setting detach on fork mode is not supported");
    }

    public void resize(int columns, int rows) throws DebuggerCommandException, ExecutionException {
    }

    protected void setState(@NotNull TargetState state) {
        TargetState previousState;
        if (state == null) {
            DebuggerDriver.$$$reportNull$$$0(36);
        }
        if ((previousState = this.myStateTransition.getCurrentState()) == TargetState.FINISHED) {
            return;
        }
        this.myStateTransition = new TargetStateTransition(previousState, state);
        if (state == TargetState.RUNNING) {
            this.traceState(new CidrEventSpan("debug", "driver running", null, "<DebuggerDriver>"));
        } else {
            this.traceState(null);
        }
        if (state == TargetState.FINISHED) {
            this.closeOutputReaders();
        }
    }

    protected void handleRunning() {
        this.setState(TargetState.RUNNING);
        this.myHandler.handleRunning();
    }

    protected void handleModulesLoaded(@NotNull List<LLModule> modules) {
        if (modules == null) {
            DebuggerDriver.$$$reportNull$$$0(37);
        }
        this.myHandler.handleModulesLoaded(modules);
    }

    protected void handleModulesUnloaded(@NotNull List<LLModule> modules) {
        if (modules == null) {
            DebuggerDriver.$$$reportNull$$$0(38);
        }
        this.myHandler.handleModulesUnloaded(modules);
    }

    protected void handleBreakpointAdded(@NotNull LLBreakpoint breakpoint) {
        if (breakpoint == null) {
            DebuggerDriver.$$$reportNull$$$0(39);
        }
        this.myHandler.handleBreakpointAdded(breakpoint);
    }

    protected void handleBreakpointRemoved(int breakpointId) {
        this.myHandler.handleBreakpointRemoved(breakpointId);
    }

    protected void handleBreakpointUpdated(@NotNull LLBreakpoint breakpoint) {
        if (breakpoint == null) {
            DebuggerDriver.$$$reportNull$$$0(40);
        }
        this.myHandler.handleBreakpointUpdated(breakpoint);
    }

    protected void handleBreakpointLocationsReplaced(@NotNull int breakpointId, @NotNull List<LLBreakpointLocation> locations) {
        if (locations == null) {
            DebuggerDriver.$$$reportNull$$$0(41);
        }
        this.myHandler.handleBreakpointLocationsReplaced(breakpointId, locations);
    }

    protected void handleBreakpointLocationsUpdated(@NotNull int breakpointId, @NotNull List<LLBreakpointLocation> locations) {
        if (locations == null) {
            DebuggerDriver.$$$reportNull$$$0(42);
        }
        this.myHandler.handleBreakpointLocationsUpdated(breakpointId, locations);
    }

    protected void handleBreakpointLocationsRemoved(@NotNull int breakpointId, @NotNull List<String> locationIds) {
        if (locationIds == null) {
            DebuggerDriver.$$$reportNull$$$0(43);
        }
        this.myHandler.handleBreakpointLocationsRemoved(breakpointId, locationIds);
    }

    protected void handleInterrupted(@NotNull StopPlace stopPlace) {
        if (stopPlace == null) {
            DebuggerDriver.$$$reportNull$$$0(44);
        }
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleInterrupted(stopPlace);
    }

    protected void handleSignal(@NotNull StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
        if (stopPlace == null) {
            DebuggerDriver.$$$reportNull$$$0(45);
        }
        if (signal == null) {
            DebuggerDriver.$$$reportNull$$$0(46);
        }
        if (meaning == null) {
            DebuggerDriver.$$$reportNull$$$0(47);
        }
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleSignal(stopPlace, signal, meaning);
    }

    protected void handleException(@NotNull StopPlace stopPlace, @NotNull Address exceptionAddress, @Nullable String exceptionFile, @Nullable DebuggerSourceFileHash exceptionHash, int exceptionLine, @NotNull String description) {
        if (stopPlace == null) {
            DebuggerDriver.$$$reportNull$$$0(48);
        }
        if (exceptionAddress == null) {
            DebuggerDriver.$$$reportNull$$$0(49);
        }
        if (description == null) {
            DebuggerDriver.$$$reportNull$$$0(50);
        }
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleException(stopPlace, exceptionAddress, exceptionFile, exceptionHash, exceptionLine, description);
    }

    protected void handleBreakpoint(@NotNull StopPlace stopPlace, int breakpointNumber) {
        if (stopPlace == null) {
            DebuggerDriver.$$$reportNull$$$0(51);
        }
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleBreakpoint(stopPlace, breakpointNumber);
    }

    protected void handleWatchpoint(@NotNull StopPlace stopPlace, int watchpointNumber) {
        if (stopPlace == null) {
            DebuggerDriver.$$$reportNull$$$0(52);
        }
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleWatchpoint(stopPlace, watchpointNumber);
    }

    protected void handleWatchpointScope(int watchpointNumber) {
        this.setState(TargetState.SUSPENDED);
        this.myHandler.handleWatchpointScope(watchpointNumber);
    }

    protected void handleTargetOutput(@Nls @NotNull String text, @NotNull Key type) {
        if (text == null) {
            DebuggerDriver.$$$reportNull$$$0(53);
        }
        if (type == null) {
            DebuggerDriver.$$$reportNull$$$0(54);
        }
        DebuggerDriver.logOutputSummary("Target", text, type);
        this.beforeHandleTargetOutput();
        this.myHandler.handleTargetOutput(text, type);
    }

    protected void handleAttached(int pid) {
        this.myHandler.handleAttached(pid);
    }

    protected void handleConnected(@NotNull String connection) {
        if (connection == null) {
            DebuggerDriver.$$$reportNull$$$0(55);
        }
        this.myHandler.handleConnected(connection);
    }

    protected void handleDisconnected() {
        this.myHandler.handleDisconnected();
    }

    protected void handleDebuggerOutput(@Nls @NotNull String text, @NotNull Key type) {
        if (text == null) {
            DebuggerDriver.$$$reportNull$$$0(56);
        }
        if (type == null) {
            DebuggerDriver.$$$reportNull$$$0(57);
        }
        DebuggerDriver.logOutputSummary("Debugger", text, type);
        this.myHandler.handleDebuggerOutput(text, type);
    }

    private static void logOutputSummary(@NonNls @NotNull String description, @NonNls @NotNull String text, @NotNull Key type) {
        if (description == null) {
            DebuggerDriver.$$$reportNull$$$0(58);
        }
        if (text == null) {
            DebuggerDriver.$$$reportNull$$$0(59);
        }
        if (type == null) {
            DebuggerDriver.$$$reportNull$$$0(60);
        }
        if (CidrDebuggerLog.LOG.isTraceEnabled()) {
            int maxLength = 80;
            int length = text.length();
            @NonNls Object shortText = DebuggerDriver.stringify(StringUtil.shortenTextWithEllipsis((String)text, (int)80, (int)0));
            if (length > 80) {
                shortText = (String)shortText + " (" + length + " chars)";
            }
            CidrDebuggerLog.LOG.trace(description + " [" + type + "]: " + (String)shortText);
        }
    }

    protected void handlePrompt() {
        this.handlePrompt(false);
    }

    protected void handlePrompt(boolean inMultiLineCommand) {
        this.handlePrompt(inMultiLineCommand ? 1 : 0);
    }

    protected void handlePrompt(int promptLevel) {
        this.handlePrompt((String)(promptLevel == 0 ? "(" + this.getPromptText() + ") " : StringUtil.repeat((String)"> ", (int)promptLevel)));
    }

    protected abstract String getPromptText();

    protected void handlePrompt(@NotNull String prompt) {
        if (prompt == null) {
            DebuggerDriver.$$$reportNull$$$0(61);
        }
        this.myHandler.handlePrompt(prompt);
    }

    protected void handleTargetTerminated(@NotNull ExitStatus exitStatus) {
        if (exitStatus == null) {
            DebuggerDriver.$$$reportNull$$$0(62);
        }
        this.setState(TargetState.FINISHED);
        this.myHandler.handleTargetTerminated(exitStatus);
    }

    protected void handleDetached() {
        this.setState(TargetState.FINISHED);
        this.myHandler.handleDetached();
    }

    protected void handleExited(int code) {
        this.setState(TargetState.FINISHED);
        this.myHandler.handleExited(code);
    }

    protected void handleSelectedFrameChanged(@NotNull LLThread thread, @NotNull LLFrame frame) {
        if (thread == null) {
            DebuggerDriver.$$$reportNull$$$0(63);
        }
        if (frame == null) {
            DebuggerDriver.$$$reportNull$$$0(64);
        }
        this.myHandler.handleSelectedFrameChanged(thread, frame);
    }

    protected void handleChildProcessCreated(long childPid) {
        this.myHandler.handleChildProcessCreated(childPid);
    }

    protected void handleSymbolsDownloadStarted(@NotNull String caption, @NotNull String details) {
        if (caption == null) {
            DebuggerDriver.$$$reportNull$$$0(65);
        }
        if (details == null) {
            DebuggerDriver.$$$reportNull$$$0(66);
        }
        this.myHandler.handleSymbolsDownloadStarted(caption, details);
    }

    protected void handleSymbolsDownloadProgress(int percent) {
        this.myHandler.handleSymbolsDownloadProgress(percent);
    }

    protected void handleSymbolsDownloadFinished() {
        this.myHandler.handleSymbolsDownloadFinished();
    }

    @TestOnly
    public void waitHandlerProcessed() {
        this.myHandlerProcessor.waitFor();
    }

    @Nullable
    public OutputStream getProcessInput() {
        return null;
    }

    public abstract void checkErrors() throws ExecutionException;

    protected void printTargetCommandLine(@Nullable GeneralCommandLine commandLine) {
        if (commandLine != null) {
            this.handleTargetOutput(commandLine.getCommandLineString() + "\n", ProcessOutputTypes.SYSTEM);
        }
    }

    public void setRedirectOutputToFiles(boolean toRedirect) {
        this.myToRedirect = toRedirect;
    }

    @NotNull
    protected ProcessOutputReaders initReaders(@NotNull HostMachine host, @NotNull GeneralCommandLine targetCommandLine, boolean usePty, boolean emulateTerminal) throws ExecutionException {
        String name;
        if (host == null) {
            DebuggerDriver.$$$reportNull$$$0(67);
        }
        if (targetCommandLine == null) {
            DebuggerDriver.$$$reportNull$$$0(68);
        }
        if ((this.myReaders = new ProcessOutputReaders(host, name = CommandLineUtil.extractPresentableName((String)targetCommandLine.getCommandLineString()), targetCommandLine.getCharset(), usePty, emulateTerminal){

            protected void onTextAvailable(@NlsSafe @NotNull String text, @NotNull Key type) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(1);
                }
                DebuggerDriver.this.handleTargetOutput(text, type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }) == null) {
            DebuggerDriver.$$$reportNull$$$0(69);
        }
        return this.myReaders;
    }

    protected void initTerminalReader(@NotNull GeneralCommandLine targetCommandLine, @NotNull InputStream inputStream) {
        if (targetCommandLine == null) {
            DebuggerDriver.$$$reportNull$$$0(70);
        }
        if (inputStream == null) {
            DebuggerDriver.$$$reportNull$$$0(71);
        }
        final String name = CommandLineUtil.extractPresentableName((String)targetCommandLine.getCommandLineString());
        final Semaphore terminalReadFinished = new Semaphore(0);
        this.myTerminalReadFinished.set(terminalReadFinished);
        new BaseOutputReader(inputStream, targetCommandLine.getCharset(), BaseOutputReader.Options.forTerminalPtyProcess()){
            {
                super(arg0, arg1, arg2);
                this.start("Reading " + name);
            }

            protected void doRun() {
                try {
                    super.doRun();
                }
                finally {
                    terminalReadFinished.release();
                }
            }

            protected void onTextAvailable(@NlsSafe @NotNull String text) {
                if (text == null) {
                    2.$$$reportNull$$$0(0);
                }
                DebuggerDriver.this.handleTargetOutput(text, (Key)ProcessOutputType.STDOUT);
            }

            @NotNull
            protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
                if (runnable == null) {
                    2.$$$reportNull$$$0(1);
                }
                Future future = ApplicationManager.getApplication().executeOnPooledThread(runnable);
                if (future == null) {
                    2.$$$reportNull$$$0(2);
                }
                return future;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "runnable";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "executeOnPooledThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "onTextAvailable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "executeOnPooledThread";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    protected void closeOutputReaders() {
        Semaphore terminalReadFinished;
        ProcessOutputReaders readers = this.myReaders;
        if (readers != null) {
            try {
                if (!readers.waitFor(300L, TimeUnit.MILLISECONDS)) {
                    CidrDebuggerLog.LOG.warn("Closing inferior output readers took too long");
                }
            }
            finally {
                readers.close();
                this.myReaders = null;
            }
        }
        if ((terminalReadFinished = (Semaphore)this.myTerminalReadFinished.getAndSet(null)) != null) {
            try {
                if (!terminalReadFinished.tryAcquire(300L, TimeUnit.MILLISECONDS)) {
                    CidrDebuggerLog.LOG.warn("Wait for terminal output took too long");
                }
            }
            catch (InterruptedException e) {
                CidrDebuggerLog.LOG.warn("Wait for terminal output was interrupted");
            }
        }
    }

    protected static boolean isTargetTerminationSignal(int signal) {
        return 15 == signal || 9 == signal;
    }

    protected static boolean isTargetTerminationSignal(@Nullable String name) {
        return "SIGTERM".equals(name) || "SIGKILL".equals(name);
    }

    public abstract void addSymbolsFile(@NotNull File var1, @Nullable File var2) throws ExecutionException;

    @NotNull
    protected static String format(@NonNls @PrintFormat @NotNull String format, Object ... args) {
        if (format == null) {
            DebuggerDriver.$$$reportNull$$$0(72);
        }
        if (args == null) {
            DebuggerDriver.$$$reportNull$$$0(73);
        }
        String string = String.format(Locale.ROOT, format, args);
        if (string == null) {
            DebuggerDriver.$$$reportNull$$$0(74);
        }
        return string;
    }

    private static int escapedByte(@NotNull String s, int idx, @NotNull ByteArrayOutputStream bs) {
        if (s == null) {
            DebuggerDriver.$$$reportNull$$$0(75);
        }
        if (bs == null) {
            DebuggerDriver.$$$reportNull$$$0(76);
        }
        if (idx + 4 > s.length() || s.charAt(idx) != '\\') {
            return -1;
        }
        try {
            int code = Integer.parseInt(s.substring(idx + 1, idx + 4), 8);
            bs.write(code);
            return idx + 4;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @NotNull
    public static String stringify(@NotNull String s) {
        if (s == null) {
            DebuggerDriver.$$$reportNull$$$0(77);
        }
        StringBuilder buffer = new StringBuilder(s.length() + 2).append('\"');
        StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)"\"", (StringBuilder)buffer);
        String string = buffer.append('\"').toString();
        if (string == null) {
            DebuggerDriver.$$$reportNull$$$0(78);
        }
        return string;
    }

    @NotNull
    public static String unescapeString(@NotNull String s) {
        if (s == null) {
            DebuggerDriver.$$$reportNull$$$0(79);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        boolean escaped = false;
        for (int idx = 0; idx < s.length(); ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case 'e': {
                    buffer.append('\u001b');
                    break;
                }
                case 'a': {
                    buffer.append('\u0007');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                default: {
                    int i = idx - 1;
                    bs.reset();
                    while ((i = DebuggerDriver.escapedByte(s, i, bs)) != -1) {
                        idx = i;
                    }
                    if (bs.size() > 0) {
                        buffer.append(new String(bs.toByteArray(), StandardCharsets.UTF_8));
                        --idx;
                        break;
                    }
                    buffer.append('\\');
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
        String string = buffer.toString();
        if (string == null) {
            DebuggerDriver.$$$reportNull$$$0(80);
        }
        return string;
    }

    @Contract(value="_, !null -> !null")
    public static Address parseAddress(@NotNull String str, Address defaultValue) {
        if (str == null) {
            DebuggerDriver.$$$reportNull$$$0(81);
        }
        try {
            return Address.parseHexString(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @NotNull
    public static Address parseAddress(@NotNull String str) throws ExecutionException {
        Address address;
        if (str == null) {
            DebuggerDriver.$$$reportNull$$$0(82);
        }
        try {
            address = Address.parseHexString(str);
        }
        catch (NumberFormatException e) {
            throw new ExecutionException((Throwable)e);
        }
        if (address == null) {
            DebuggerDriver.$$$reportNull$$$0(83);
        }
        return address;
    }

    @NotNull
    public static Address parseAddressSafe(@NotNull String str) throws DebuggerCommandException {
        Address address;
        if (str == null) {
            DebuggerDriver.$$$reportNull$$$0(84);
        }
        try {
            address = Address.parseHexString(str);
        }
        catch (NumberFormatException e) {
            throw new DebuggerCommandException(e);
        }
        if (address == null) {
            DebuggerDriver.$$$reportNull$$$0(85);
        }
        return address;
    }

    protected static int getTimeoutMs() {
        return Registry.intValue((String)"cidr.debugger.timeout", (int)30000);
    }

    protected static int getLoadTimeoutMs() {
        return Registry.intValue((String)"cidr.debugger.timeout.load", (int)90000);
    }

    protected static int getEvaluationTimeoutMs() {
        return Registry.intValue((String)"cidr.debugger.timeout.evaluate", (int)30000);
    }

    @NlsSafe
    protected static String asNlsSafe(@NlsSafe String s) {
        return s;
    }

    @NotNull
    protected BaseProcessHandler createDebugProcessHandler(@NotNull GeneralCommandLine commandLine, final @NotNull DebuggerDriverConfiguration config) throws ExecutionException {
        if (commandLine == null) {
            DebuggerDriver.$$$reportNull$$$0(86);
        }
        if (config == null) {
            DebuggerDriver.$$$reportNull$$$0(87);
        }
        BaseProcessHandler<?> handler = config.createDebugProcessHandler(commandLine);
        final Process process = handler.getProcess();
        String pidForLogging = DebuggerDriver.getPidForLogging(process);
        final String logPrefix = "[PID " + pidForLogging + " (" + config.getDebugProcessName() + ")]";
        CidrDebuggerLog.LOG.info(logPrefix + " Debugger started: " + commandLine.getCommandLineString());
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (process.isAlive() && willBeDestroyed) {
                    try {
                        if (!DebuggerDriver.this.doExit()) {
                            return;
                        }
                    }
                    catch (ExecutionException e) {
                        CidrDebuggerLog.LOG.warn((Throwable)e);
                        return;
                    }
                    try {
                        process.waitFor(1500L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                String exitCodeString = ProcessTerminatedListener.stringifyExitCode((OS)config.getHostMachine().getOS(), (int)event.getExitCode());
                CidrDebuggerLog.LOG.info(logPrefix + " Debugger exited with code " + exitCodeString);
                if (process.isAlive() && OSProcessHandler.processCanBeKilledByOS((Process)process)) {
                    OSProcessUtil.killProcess((Process)process);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processWillTerminate";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        BaseProcessHandler<?> baseProcessHandler = handler;
        if (baseProcessHandler == null) {
            DebuggerDriver.$$$reportNull$$$0(88);
        }
        return baseProcessHandler;
    }

    @NotNull
    private static String getPidForLogging(Process process) {
        String string;
        try {
            string = Long.toString(process.pid());
        }
        catch (UnsupportedOperationException ignored) {
            return PID_NOT_SUPPORTED;
        }
        if (string == null) {
            DebuggerDriver.$$$reportNull$$$0(89);
        }
        return string;
    }

    private void traceState(@Nullable CidrEventSpan eventSpan) {
        if (this.myStateSpan != null) {
            this.myStateSpan.close();
        }
        this.myStateSpan = eventSpan;
    }

    public boolean supportsMemoryWrite() {
        return false;
    }

    public void writeMemory(@NotNull Address address, byte[] bytes) throws ExecutionException, DebuggerCommandException {
        if (address == null) {
            DebuggerDriver.$$$reportNull$$$0(90);
        }
        throw new UnsupportedOperationException("Memory write is not supported");
    }

    public boolean supportsRegisters() {
        return false;
    }

    @NotNull
    public List<LLValue> getRegisters(@NotNull LLThread thread, @NotNull LLFrame frame) throws ExecutionException, DebuggerCommandException {
        if (thread == null) {
            DebuggerDriver.$$$reportNull$$$0(91);
        }
        if (frame == null) {
            DebuggerDriver.$$$reportNull$$$0(92);
        }
        throw new UnsupportedOperationException("Registers are not supported");
    }

    @NotNull
    public List<LLValue> getRegisters(@NotNull LLThread thread, @NotNull LLFrame frame, @NotNull Set<String> registerNames) throws ExecutionException, DebuggerCommandException {
        if (thread == null) {
            DebuggerDriver.$$$reportNull$$$0(93);
        }
        if (frame == null) {
            DebuggerDriver.$$$reportNull$$$0(94);
        }
        if (registerNames == null) {
            DebuggerDriver.$$$reportNull$$$0(95);
        }
        if (!this.supportsRegisters()) {
            throw new UnsupportedOperationException("Registers are not supported");
        }
        ArrayList<LLValue> result = new ArrayList<LLValue>();
        for (LLValue register : this.getRegisters(thread, frame)) {
            if (!registerNames.isEmpty() && !registerNames.contains(register.getName())) continue;
            result.add(register);
        }
        ArrayList<LLValue> arrayList = result;
        if (arrayList == null) {
            DebuggerDriver.$$$reportNull$$$0(96);
        }
        return arrayList;
    }

    @Nullable
    public String getArchitecture() throws ExecutionException, DebuggerCommandException {
        return null;
    }

    @NotNull
    public List<LLRegisterSet> getRegisterSets() throws ExecutionException, DebuggerCommandException {
        List<LLRegisterSet> list = Collections.emptyList();
        if (list == null) {
            DebuggerDriver.$$$reportNull$$$0(97);
        }
        return list;
    }

    @Nullable
    public String extractRegisterName(@NotNull String expression) {
        if (expression == null) {
            DebuggerDriver.$$$reportNull$$$0(98);
        }
        if (expression.startsWith("$")) {
            for (int i = 1; i < expression.length(); ++i) {
                char c = expression.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '_') continue;
                return null;
            }
            return expression.substring(1);
        }
        return null;
    }

    public void setExpirable(@Nullable Expirable expirable) {
    }

    @Nullable
    public DisasmFlavor getDisasmFlavor() {
        return null;
    }

    public void setDisasmFlavor(@NotNull DisasmFlavor flavor) throws ExecutionException, DebuggerCommandException {
        if (flavor == null) {
            DebuggerDriver.$$$reportNull$$$0(99);
        }
        throw new UnsupportedOperationException("Disassembly flavor change is not supported");
    }

    public boolean supportsCommandCancellation() {
        return false;
    }

    @ApiStatus.Experimental
    @NotNull
    public RawViewSupport getRawViewSupport() {
        return new DisabledRawViewSupport();
    }

    @ApiStatus.Internal
    @TestOnly
    public void setBeforeHandleTargetOutputCallback(@Nullable Runnable callback) {
        this.myBeforeHandleTargetOutputCallback = callback;
    }

    private void beforeHandleTargetOutput() {
        Runnable callback = this.myBeforeHandleTargetOutputCallback;
        if (callback != null) {
            callback.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 8, 10, 14, 17, 23, 27, 29, 69, 74, 78, 80, 83, 85, 88, 89, 96, 97 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: 
            case 14: 
            case 17: 
            case 23: 
            case 27: 
            case 29: 
            case 69: 
            case 74: 
            case 78: 
            case 80: 
            case 83: 
            case 85: 
            case 88: 
            case 89: 
            case 96: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 24: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 63: 
            case 91: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolPattern";
                break;
            }
            case 16: 
            case 19: 
            case 21: 
            case 25: 
            case 64: 
            case 92: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 22: 
            case 26: 
            case 28: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 30: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "address";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locations";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationIds";
                break;
            }
            case 44: 
            case 45: 
            case 48: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopPlace";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signal";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meaning";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionAddress";
                break;
            }
            case 50: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 53: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 54: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prompt";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exitStatus";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caption";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetCommandLine";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 75: 
            case 77: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bs";
                break;
            }
            case 81: 
            case 82: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registerNames";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateTransition";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "addBreakpoint";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrames";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariables";
                break;
            }
            case 23: 
            case 27: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "initReaders";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "format";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "stringify";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeString";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAddress";
                break;
            }
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAddressSafe";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugProcessHandler";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getPidForLogging";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisters";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisterSets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: 
            case 14: 
            case 17: 
            case 23: 
            case 27: 
            case 29: 
            case 69: 
            case 74: 
            case 78: 
            case 80: 
            case 83: 
            case 85: 
            case 88: 
            case 89: 
            case 96: 
            case 97: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resume";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "stepOver";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "stepInto";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "stepOut";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addBreakpoint";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addSymbolicBreakpoint";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFrames";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getVariables";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFrameVariables";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "disassemble";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "executeConsoleCommand";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "freezeThread";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "unfreezeThread";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "freezeOtherThreads";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "unfreezeAllThreads";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "handleModulesLoaded";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "handleModulesUnloaded";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "handleBreakpointAdded";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "handleBreakpointUpdated";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "handleBreakpointLocationsReplaced";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "handleBreakpointLocationsUpdated";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "handleBreakpointLocationsRemoved";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "handleInterrupted";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "handleSignal";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "handleException";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "handleBreakpoint";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "handleWatchpoint";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "handleTargetOutput";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "handleConnected";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "handleDebuggerOutput";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "logOutputSummary";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "handlePrompt";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "handleTargetTerminated";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "handleSelectedFrameChanged";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "handleSymbolsDownloadStarted";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "initReaders";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "initTerminalReader";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "format";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "escapedByte";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "stringify";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "unescapeString";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "parseAddress";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "parseAddressSafe";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "createDebugProcessHandler";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "writeMemory";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getRegisters";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "extractRegisterName";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "setDisasmFlavor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 8, 10, 14, 17, 23, 27, 29, 69, 74, 78, 80, 83, 85, 88, 89, 96, 97 -> new IllegalStateException(string);
        };
    }

    public static class TargetStateTransition {
        private final TargetState myPreviousState;
        private final TargetState myCurrentState;

        public TargetStateTransition(@NotNull TargetState previousState, @NotNull TargetState currentState) {
            if (previousState == null) {
                TargetStateTransition.$$$reportNull$$$0(0);
            }
            if (currentState == null) {
                TargetStateTransition.$$$reportNull$$$0(1);
            }
            this.myPreviousState = previousState;
            this.myCurrentState = currentState;
        }

        @NotNull
        public TargetState getPreviousState() {
            TargetState targetState = this.myPreviousState;
            if (targetState == null) {
                TargetStateTransition.$$$reportNull$$$0(2);
            }
            return targetState;
        }

        @NotNull
        public TargetState getCurrentState() {
            TargetState targetState = this.myCurrentState;
            if (targetState == null) {
                TargetStateTransition.$$$reportNull$$$0(3);
            }
            return targetState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previousState";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentState";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$TargetStateTransition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$TargetStateTransition";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreviousState";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCurrentState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static enum TargetState {
        NOT_READY,
        RUNNING,
        SUSPENDED,
        FINISHING,
        FINISHED;

    }

    public static interface Handler
    extends EventListener {
        default public void handleRunning() {
        }

        default public void handleModulesLoaded(@NotNull List<LLModule> modules) {
            if (modules == null) {
                Handler.$$$reportNull$$$0(0);
            }
        }

        default public void handleModulesUnloaded(@NotNull List<LLModule> modules) {
            if (modules == null) {
                Handler.$$$reportNull$$$0(1);
            }
        }

        default public void handleBreakpointAdded(@NotNull LLBreakpoint breakpoint) {
            if (breakpoint == null) {
                Handler.$$$reportNull$$$0(2);
            }
        }

        default public void handleBreakpointRemoved(int breakpointId) {
        }

        default public void handleBreakpointUpdated(@NotNull LLBreakpoint breakpoint) {
            if (breakpoint == null) {
                Handler.$$$reportNull$$$0(3);
            }
        }

        default public void handleBreakpointLocationsReplaced(int breakpointId, @NotNull List<LLBreakpointLocation> locations) {
            if (locations == null) {
                Handler.$$$reportNull$$$0(4);
            }
        }

        default public void handleBreakpointLocationsUpdated(int breakpointId, @NotNull List<LLBreakpointLocation> locations) {
            if (locations == null) {
                Handler.$$$reportNull$$$0(5);
            }
        }

        default public void handleBreakpointLocationsRemoved(int breakpointId, @NotNull List<String> locationIds) {
            if (locationIds == null) {
                Handler.$$$reportNull$$$0(6);
            }
        }

        default public void handleInterrupted(@NotNull StopPlace stopPlace) {
            if (stopPlace == null) {
                Handler.$$$reportNull$$$0(7);
            }
        }

        default public void handleSignal(@NotNull StopPlace stopPlace, @NotNull String signal, @NotNull String meaning) {
            if (stopPlace == null) {
                Handler.$$$reportNull$$$0(8);
            }
            if (signal == null) {
                Handler.$$$reportNull$$$0(9);
            }
            if (meaning == null) {
                Handler.$$$reportNull$$$0(10);
            }
        }

        default public void handleException(@NotNull StopPlace stopPlace, @NotNull Address exceptionAddress, @Nullable String exceptionFile, @Nullable DebuggerSourceFileHash exceptionHash, int exceptionLine, @NotNull String description) {
            if (stopPlace == null) {
                Handler.$$$reportNull$$$0(11);
            }
            if (exceptionAddress == null) {
                Handler.$$$reportNull$$$0(12);
            }
            if (description == null) {
                Handler.$$$reportNull$$$0(13);
            }
        }

        default public void handleBreakpoint(@NotNull StopPlace stopPlace, int breakpointNumber) {
            if (stopPlace == null) {
                Handler.$$$reportNull$$$0(14);
            }
        }

        default public void handleWatchpoint(@NotNull StopPlace stopPlace, int watchpointNumber) {
            if (stopPlace == null) {
                Handler.$$$reportNull$$$0(15);
            }
        }

        default public void handleWatchpointScope(int watchpointNumber) {
        }

        default public void handleTargetOutput(@NotNull String text, @NotNull Key type) {
            if (text == null) {
                Handler.$$$reportNull$$$0(16);
            }
            if (type == null) {
                Handler.$$$reportNull$$$0(17);
            }
        }

        default public void handleDebuggerOutput(@NotNull String text, @NotNull Key type) {
            if (text == null) {
                Handler.$$$reportNull$$$0(18);
            }
            if (type == null) {
                Handler.$$$reportNull$$$0(19);
            }
        }

        default public void handlePrompt(@NotNull String prompt) {
            if (prompt == null) {
                Handler.$$$reportNull$$$0(20);
            }
        }

        default public void handleTargetTerminated(@NotNull ExitStatus exitStatus) {
            if (exitStatus == null) {
                Handler.$$$reportNull$$$0(21);
            }
        }

        default public void handleExited(int code) {
        }

        default public void handleAttached(int pid) {
        }

        default public void handleDetached() {
        }

        default public void handleConnected(@NotNull String connection) {
            if (connection == null) {
                Handler.$$$reportNull$$$0(22);
            }
        }

        default public void handleDisconnected() {
        }

        default public void handleSelectedFrameChanged(@NotNull LLThread thread, @NotNull LLFrame frame) {
            if (thread == null) {
                Handler.$$$reportNull$$$0(23);
            }
            if (frame == null) {
                Handler.$$$reportNull$$$0(24);
            }
        }

        default public void handleChildProcessCreated(long childPid) {
        }

        default public void handleSymbolsDownloadStarted(@NotNull String caption, @NotNull String details) {
            if (caption == null) {
                Handler.$$$reportNull$$$0(25);
            }
            if (details == null) {
                Handler.$$$reportNull$$$0(26);
            }
        }

        default public void handleSymbolsDownloadProgress(int percent) {
        }

        default public void handleSymbolsDownloadFinished() {
        }

        default public void handleNotification(@NotNull @NlsContexts.NotificationContent String message, @NotNull NotificationType type) {
            if (message == null) {
                Handler.$$$reportNull$$$0(27);
            }
            if (type == null) {
                Handler.$$$reportNull$$$0(28);
            }
        }

        @NotNull
        public static Handler createQueuedHandler(@NotNull Handler handler, @NotNull QueueProcessor<Runnable> queueProcessor) {
            if (handler == null) {
                Handler.$$$reportNull$$$0(29);
            }
            if (queueProcessor == null) {
                Handler.$$$reportNull$$$0(30);
            }
            ClientId clientId = ClientId.getCurrentOrNull();
            Handler handler2 = (Handler)ReflectionUtil.proxy(Handler.class, (proxy, method, args) -> {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)handler, args);
                }
                queueProcessor.add(() -> {
                    try (AccessToken ignored = ClientId.withClientId((ClientId)clientId);){
                        method.invoke((Object)handler, args);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        CidrDebuggerLog.LOG.error((Throwable)e);
                    }
                });
                return null;
            });
            if (handler2 == null) {
                Handler.$$$reportNull$$$0(31);
            }
            return handler2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 31 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modules";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "breakpoint";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "locations";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "locationIds";
                    break;
                }
                case 7: 
                case 8: 
                case 11: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stopPlace";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "signal";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meaning";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptionAddress";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 16: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 17: 
                case 19: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prompt";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exitStatus";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thread";
                    break;
                }
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frame";
                    break;
                }
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caption";
                    break;
                }
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "details";
                    break;
                }
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "queueProcessor";
                    break;
                }
                case 31: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$Handler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$Handler";
                    break;
                }
                case 31: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createQueuedHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "handleModulesLoaded";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "handleModulesUnloaded";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handleBreakpointAdded";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleBreakpointUpdated";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "handleBreakpointLocationsReplaced";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "handleBreakpointLocationsUpdated";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "handleBreakpointLocationsRemoved";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "handleInterrupted";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "handleSignal";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "handleException";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "handleBreakpoint";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "handleWatchpoint";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "handleTargetOutput";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "handleDebuggerOutput";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "handlePrompt";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "handleTargetTerminated";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "handleConnected";
                    break;
                }
                case 23: 
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "handleSelectedFrameChanged";
                    break;
                }
                case 25: 
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "handleSymbolsDownloadStarted";
                    break;
                }
                case 27: 
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "handleNotification";
                    break;
                }
                case 29: 
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "createQueuedHandler";
                    break;
                }
                case 31: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 31 -> new IllegalStateException(string);
            };
        }
    }

    public static class AddBreakpointResult {
        @NotNull
        private final LLBreakpoint myBreakpoint;
        @NotNull
        private final @NotNull List<@NotNull LLBreakpointLocation> myBreakpointLocations;

        public AddBreakpointResult(@NotNull LLBreakpoint breakpoint, @NotNull @NotNull List<@NotNull LLBreakpointLocation> locations) {
            if (breakpoint == null) {
                AddBreakpointResult.$$$reportNull$$$0(0);
            }
            if (locations == null) {
                AddBreakpointResult.$$$reportNull$$$0(1);
            }
            this.myBreakpoint = breakpoint;
            this.myBreakpointLocations = locations;
        }

        @NotNull
        public LLBreakpoint getBreakpoint() {
            LLBreakpoint lLBreakpoint = this.myBreakpoint;
            if (lLBreakpoint == null) {
                AddBreakpointResult.$$$reportNull$$$0(2);
            }
            return lLBreakpoint;
        }

        @NotNull
        public @NotNull List<@NotNull LLBreakpointLocation> getBreakpointLocations() {
            List<LLBreakpointLocation> list = this.myBreakpointLocations;
            if (list == null) {
                AddBreakpointResult.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "breakpoint";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "locations";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$AddBreakpointResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$AddBreakpointResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBreakpoint";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBreakpointLocations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class SymbolicBreakpoint {
        public static final int INVALID_THREAD_ID = 0;
        @NotNull
        private String myPattern = "";
        private boolean myRegexpPattern = false;
        @Nullable
        private String myModule;
        @Nullable
        private String myCondition;
        private long myThreadId = 0L;

        @NotNull
        public String getPattern() {
            String string = this.myPattern;
            if (string == null) {
                SymbolicBreakpoint.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void setPattern(@NotNull String pattern) {
            if (pattern == null) {
                SymbolicBreakpoint.$$$reportNull$$$0(1);
            }
            this.myPattern = pattern;
        }

        public boolean isRegexpPattern() {
            return this.myRegexpPattern;
        }

        public void setRegexpPattern(boolean regexpPattern) {
            this.myRegexpPattern = regexpPattern;
        }

        @Nullable
        public String getModule() {
            return this.myModule;
        }

        public void setModule(@Nullable String module) {
            this.myModule = module;
        }

        @Nullable
        public String getCondition() {
            return this.myCondition;
        }

        public void setCondition(@Nullable String condition) {
            this.myCondition = condition;
        }

        public long getThreadId() {
            return this.myThreadId;
        }

        public void setThreadId(long threadId) {
            this.myThreadId = threadId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$SymbolicBreakpoint";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPattern";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$SymbolicBreakpoint";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setPattern";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class ResultList<T> {
        @NotNull
        public final List<T> list;
        public final boolean hasMore;

        public ResultList(@NotNull List<T> list, boolean hasMore) {
            if (list == null) {
                ResultList.$$$reportNull$$$0(0);
            }
            this.list = list;
            this.hasMore = hasMore;
        }

        @NotNull
        public static <T> ResultList<T> create(@NotNull List<T> list, boolean hasMore) {
            if (list == null) {
                ResultList.$$$reportNull$$$0(1);
            }
            return new ResultList<T>(list, hasMore);
        }

        @NotNull
        public static <T> ResultList<T> empty() {
            return ResultList.create(Collections.emptyList(), false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "list";
            objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$ResultList";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Experimental
    public static class FrameVariables {
        private final List<LLValue> myVariables;
        private final boolean myIsFiltered;

        public FrameVariables(@NotNull List<LLValue> variables, boolean isFiltered) {
            if (variables == null) {
                FrameVariables.$$$reportNull$$$0(0);
            }
            this.myVariables = variables;
            this.myIsFiltered = isFiltered;
        }

        @NotNull
        public List<LLValue> getVariables() {
            List<LLValue> list = this.myVariables;
            if (list == null) {
                FrameVariables.$$$reportNull$$$0(1);
            }
            return list;
        }

        public boolean isFiltered() {
            return this.myIsFiltered;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variables";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$FrameVariables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$FrameVariables";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static interface DebuggerLanguage {
        public String toString();
    }

    public static class StopPlace {
        @NotNull
        public final LLThread thread;
        @NotNull
        public final LLFrame frame;
        @Nullable
        public final LLValue returnValue;

        public StopPlace(@NotNull LLThread thread, @NotNull LLFrame frame) {
            if (thread == null) {
                StopPlace.$$$reportNull$$$0(0);
            }
            if (frame == null) {
                StopPlace.$$$reportNull$$$0(1);
            }
            this(thread, frame, null);
        }

        public StopPlace(@NotNull LLThread thread, @NotNull LLFrame frame, @Nullable LLValue returnValue) {
            if (thread == null) {
                StopPlace.$$$reportNull$$$0(2);
            }
            if (frame == null) {
                StopPlace.$$$reportNull$$$0(3);
            }
            this.thread = thread;
            this.frame = frame;
            this.returnValue = returnValue;
        }

        public String toString() {
            return this.thread + ": " + this.frame;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "thread";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "frame";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StopPlace";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ExitStatus {
        public static final ExitStatus UNKNOWN = new ExitStatus(-1);
        public final int code;
        @Nullable
        public final String description;

        public ExitStatus(int code) {
            this(code, null);
        }

        public ExitStatus(int code, @Nullable String description) {
            this.code = code;
            this.description = description;
        }

        @NotNull
        public static ExitStatus fromSignal(int signalNumber) {
            int exitCode = 128 + signalNumber;
            return new ExitStatus(exitCode);
        }

        public String toString() {
            if (this == UNKNOWN) {
                return "UNKNOWN";
            }
            Object string = Integer.toString(this.code);
            if (this.description != null) {
                string = (String)string + this.description;
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExitStatus status = (ExitStatus)o;
            if (this == UNKNOWN || status == UNKNOWN) {
                return false;
            }
            return this.code == status.code && Objects.equals(this.description, status.description);
        }

        public int hashCode() {
            return Objects.hash(this.code, this.description);
        }
    }

    public static final class DisasmFlavor {
        public static final DisasmFlavor INTEL = new DisasmFlavor("intel");
        public static final DisasmFlavor ATT = new DisasmFlavor("att");
        @Nullable
        private final String myName;

        public DisasmFlavor(@Nullable String name) {
            this.myName = name;
        }

        @Nullable
        public String getName() {
            return this.myName;
        }

        public boolean equals(Object other) {
            return other instanceof DisasmFlavor && Objects.equals(this.myName, ((DisasmFlavor)other).myName);
        }

        public String toString() {
            return this.myName;
        }

        @Contract(value="null->false")
        public static boolean isX86DisasmFlavor(@Nullable DisasmFlavor flavor) {
            return INTEL.equals(flavor) || ATT.equals(flavor);
        }

        @NotNull
        public static DisasmFlavor getX86DisasmFlavor(boolean useIntelSyntax) {
            DisasmFlavor disasmFlavor = useIntelSyntax ? INTEL : ATT;
            if (disasmFlavor == null) {
                DisasmFlavor.$$$reportNull$$$0(0);
            }
            return disasmFlavor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$DisasmFlavor", "getX86DisasmFlavor"));
        }
    }

    public static enum StandardDebuggerLanguage implements DebuggerLanguage
    {
        C("C"),
        C_PLUS_PLUS("C++"),
        OBJC("Objective-C"),
        OBJC_PLUS_PLUS("Objective-C++"),
        SWIFT("Swift"),
        RUST("Rust"),
        FORTRAN("Fortran"),
        ADA("Ada"),
        COBOL("Cobol"),
        PASCAL("Pascal"),
        MODULA("Modula"),
        D("D"),
        OPENCL("OpenCL"),
        GO("Go"),
        HASKELL("Haskell"),
        OCAML("OCaml"),
        JAVA("Java"),
        KOTLIN("Kotlin");

        private final String myName;

        private StandardDebuggerLanguage(String name) {
            if (name == null) {
                StandardDebuggerLanguage.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @Override
        @NotNull
        public String toString() {
            String string = this.myName;
            if (string == null) {
                StandardDebuggerLanguage.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StandardDebuggerLanguage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StandardDebuggerLanguage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static class PathMapping {
        @NotNull
        public final String from;
        @NotNull
        public final String to;

        public PathMapping(@NotNull String from, @NotNull String to) {
            if (from == null) {
                PathMapping.$$$reportNull$$$0(0);
            }
            if (to == null) {
                PathMapping.$$$reportNull$$$0(1);
            }
            this.from = from;
            this.to = to;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "from";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "to";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$PathMapping";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public abstract class Inferior {
        private final int myId;
        private final AtomicBoolean myIsRunning = new AtomicBoolean();

        public Inferior() {
            this(1);
        }

        public Inferior(int id) {
            this.myId = id;
        }

        public int getId() {
            return this.myId;
        }

        @NotNull
        public DebuggerDriver getDriver() {
            DebuggerDriver debuggerDriver = DebuggerDriver.this;
            if (debuggerDriver == null) {
                Inferior.$$$reportNull$$$0(0);
            }
            return debuggerDriver;
        }

        public long start() throws ExecutionException {
            if (!this.myIsRunning.compareAndSet(false, true)) {
                throw new IllegalStateException("started already");
            }
            return this.startImpl();
        }

        public void detach() throws ExecutionException {
            if (!this.myIsRunning.compareAndSet(true, false)) {
                return;
            }
            this.detachImpl();
        }

        public boolean destroy() throws ExecutionException {
            if (!this.myIsRunning.compareAndSet(true, false)) {
                return false;
            }
            DebuggerDriver.this.setState(TargetState.FINISHING);
            return this.destroyImpl();
        }

        protected abstract long startImpl() throws ExecutionException;

        protected abstract void detachImpl() throws ExecutionException;

        protected abstract boolean destroyImpl() throws ExecutionException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$Inferior", "getDriver"));
        }
    }

    public static enum NotificationType {
        INFO,
        WARNING,
        ERROR;

    }

    public static class JumpToLineOutsideCurrentFunctionException
    extends DebuggerCommandException {
        public JumpToLineOutsideCurrentFunctionException(@NotNull String s) {
            if (s == null) {
                JumpToLineOutsideCurrentFunctionException.$$$reportNull$$$0(0);
            }
            super(s);
        }

        public JumpToLineOutsideCurrentFunctionException(@NotNull String s, Throwable throwable) {
            if (s == null) {
                JumpToLineOutsideCurrentFunctionException.$$$reportNull$$$0(1);
            }
            super(s, throwable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$JumpToLineOutsideCurrentFunctionException", "<init>"));
        }
    }

    public static class ShellCommandResult {
        @NotNull
        private final String myOutput;
        private final int myStatus;
        private final int mySignal;

        public ShellCommandResult(@NotNull String output, int status, int signal) {
            if (output == null) {
                ShellCommandResult.$$$reportNull$$$0(0);
            }
            this.myOutput = output;
            this.myStatus = status;
            this.mySignal = signal;
        }

        @NotNull
        public String getOutput() {
            String string = this.myOutput;
            if (string == null) {
                ShellCommandResult.$$$reportNull$$$0(1);
            }
            return string;
        }

        public int getStatus() {
            return this.myStatus;
        }

        public int getSignal() {
            return this.mySignal;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$ShellCommandResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$ShellCommandResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOutput";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

