/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageViewer;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageViewerKt;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageViewerProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J \u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrViewAsImageAction;", "Lcom/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeActionBase;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isEnabled", "", "node", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "perform", "", "nodeName", "", "intellij.cidr.debugger"})
public final class CidrViewAsImageAction
extends XDebuggerTreeActionBase
implements DumbAware {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!super.isEnabled(node, e)) {
            return false;
        }
        XDebugSession xDebugSession = DebuggerUIUtil.getSession((AnActionEvent)e);
        if (xDebugSession == null) {
            return false;
        }
        XDebugSession session = xDebugSession;
        if (!session.isSuspended() || !(session.getDebugProcess() instanceof CidrDebugProcess)) {
            return false;
        }
        XValueContainer xValueContainer = node.getValueContainer();
        Intrinsics.checkNotNullExpressionValue((Object)xValueContainer, (String)"getValueContainer(...)");
        XValue value = (XValue)xValueContainer;
        return CidrImageViewerProvider.Companion.getImageViewer(value) != null;
    }

    protected void perform(@NotNull XValueNodeImpl node, @NotNull String nodeName, @NotNull AnActionEvent e) {
        XDebugSession session;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        XValueContainer xValueContainer = node.getValueContainer();
        Intrinsics.checkNotNullExpressionValue((Object)xValueContainer, (String)"getValueContainer(...)");
        XValue value = (XValue)xValueContainer;
        CidrImageViewer cidrImageViewer = CidrImageViewerProvider.Companion.getImageViewer(value);
        if (cidrImageViewer == null) {
            return;
        }
        CidrImageViewer imageViewer = cidrImageViewer;
        XDebugSession xDebugSession = session = DebuggerUIUtil.getSession((AnActionEvent)e);
        XDebugProcess xDebugProcess = xDebugSession != null ? xDebugSession.getDebugProcess() : null;
        CidrDebugProcess cidrDebugProcess = xDebugProcess instanceof CidrDebugProcess ? (CidrDebugProcess)xDebugProcess : null;
        if (cidrDebugProcess == null) {
            return;
        }
        CidrDebugProcess process = cidrDebugProcess;
        if (!session.isSuspended()) {
            return;
        }
        CidrImageViewerKt.createImageAndShowDialog$default(process, imageViewer, null, 4, null);
    }
}

