/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import com.intellij.xdebugger.impl.actions.XDebuggerSuspendedActionHandler;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrJumpToLineAction;", "Lcom/intellij/xdebugger/impl/actions/XDebuggerActionBase;", "<init>", "()V", "getHandler", "Lcom/intellij/xdebugger/impl/actions/DebuggerActionHandler;", "debuggerSupport", "Lcom/intellij/xdebugger/impl/DebuggerSupport;", "ActionHandler", "intellij.cidr.debugger"})
public final class CidrJumpToLineAction
extends XDebuggerActionBase {
    public CidrJumpToLineAction() {
        this.getTemplatePresentation().setText(CidrDebuggerBundle.message("debug.jumpToLine.text", new Object[0]));
        this.getTemplatePresentation().setDescription(CidrDebuggerBundle.message("debug.jumpToLine.tooltip", new Object[0]));
    }

    @NotNull
    protected DebuggerActionHandler getHandler(@NotNull DebuggerSupport debuggerSupport) {
        Intrinsics.checkNotNullParameter((Object)debuggerSupport, (String)"debuggerSupport");
        return (DebuggerActionHandler)ActionHandler.Companion.getINSTANCE();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrJumpToLineAction$ActionHandler;", "Lcom/intellij/xdebugger/impl/actions/XDebuggerSuspendedActionHandler;", "<init>", "()V", "isEnabled", "", "session", "Lcom/intellij/xdebugger/XDebugSession;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isHidden", "project", "Lcom/intellij/openapi/project/Project;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "perform", "", "getDebugProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "Companion", "intellij.cidr.debugger"})
    private static final class ActionHandler
    extends XDebuggerSuspendedActionHandler {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final ActionHandler INSTANCE = new ActionHandler();

        protected boolean isEnabled(@NotNull XDebugSession session, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            CidrDebugProcess cidrDebugProcess = this.getDebugProcess(session);
            if (cidrDebugProcess == null) {
                return false;
            }
            CidrDebugProcess process = cidrDebugProcess;
            return super.isEnabled(session, dataContext) && process.supportsJumpToLine() && XDebuggerUtilImpl.getCaretPosition((Project)session.getProject(), (DataContext)dataContext) != null;
        }

        public boolean isHidden(@NotNull Project project, @NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
            if (xDebugSession == null) {
                return true;
            }
            XDebugSession session = xDebugSession;
            return this.getDebugProcess(session) == null || super.isHidden(project, event);
        }

        protected void perform(@NotNull XDebugSession session, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            XSourcePosition xSourcePosition = XDebuggerUtilImpl.getCaretPosition((Project)session.getProject(), (DataContext)dataContext);
            if (xSourcePosition == null) {
                return;
            }
            XSourcePosition position = xSourcePosition;
            XDebugProcess xDebugProcess = session.getDebugProcess();
            CidrDebugProcess cidrDebugProcess = xDebugProcess instanceof CidrDebugProcess ? (CidrDebugProcess)xDebugProcess : null;
            if (cidrDebugProcess == null) {
                return;
            }
            CidrDebugProcess process = cidrDebugProcess;
            XStackFrame xStackFrame = session.getCurrentStackFrame();
            CidrStackFrame cidrStackFrame = xStackFrame instanceof CidrStackFrame ? (CidrStackFrame)xStackFrame : null;
            if (cidrStackFrame == null) {
                return;
            }
            CidrStackFrame stackFrame = cidrStackFrame;
            process.jumpToLine(stackFrame.getThread(), position.getFile(), position.getLine());
        }

        private final CidrDebugProcess getDebugProcess(XDebugSession session) {
            XDebugProcess xDebugProcess = session.getDebugProcess();
            return xDebugProcess instanceof CidrDebugProcess ? (CidrDebugProcess)xDebugProcess : null;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrJumpToLineAction$ActionHandler$Companion;", "", "<init>", "()V", "INSTANCE", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrJumpToLineAction$ActionHandler;", "getINSTANCE", "()Lcom/jetbrains/cidr/execution/debugger/actions/CidrJumpToLineAction$ActionHandler;", "intellij.cidr.debugger"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ActionHandler getINSTANCE() {
                return INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

